/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;

@Environment(value=EnvType.CLIENT)
public final class Lightmap {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final String LIGHTMAP_FORMAT1 = "/environment/lightmap%d.png";
    private static final int LIGHTMAP_SIZE = 16;
    private static final int HEIGHT_WITHOUT_NIGHTVISION = 32;
    private static final int HEIGHT_WITH_NIGHTVISION = 64;
    private static final boolean useLightmaps = Config.getBoolean("Custom Colors", "lightmaps", true);
    private static final HashMap<Integer, Lightmap> lightmaps = new HashMap();
    private final int width;
    private final boolean customNightvision;
    private final int[] origMap;
    private final boolean valid;
    private final float[] sunrgb = new float[48];
    private final float[] torchrgb = new float[48];
    private final float[] sunrgbnv = new float[48];
    private final float[] torchrgbnv = new float[48];
    private final float[] rgb = new float[3];

    static void reset() {
        lightmaps.clear();
    }

    public static boolean computeLightmap(bfq renderer, aab world, int[] mapRGB, float partialTick) {
        if (world == null || !useLightmaps) {
            return false;
        }
        Lightmap lightmap = null;
        int worldType = world.t.getWorldType();
        if (lightmaps.containsKey(worldType)) {
            lightmap = lightmaps.get(worldType);
        } else {
            FakeResourceLocation resource = TexturePackAPI.newMCPatcherResourceLocation(String.format(LIGHTMAP_FORMAT1, worldType));
            BufferedImage image = TexturePackAPI.getImage(resource);
            if (image != null) {
                lightmap = new Lightmap(resource, image);
                if (!lightmap.valid) {
                    lightmap = null;
                }
            }
            lightmaps.put(worldType, lightmap);
        }
        return lightmap != null && lightmap.compute(renderer, world, mapRGB, partialTick);
    }

    private Lightmap(FakeResourceLocation resource, BufferedImage image) {
        this.width = image.getWidth();
        int height = image.getHeight();
        this.customNightvision = height == 64;
        this.origMap = new int[this.width * height];
        image.getRGB(0, 0, this.width, height, this.origMap, 0, this.width);
        boolean bl = this.valid = height == 32 || height == 64;
        if (!this.valid) {
            logger.error("%s must be exactly %d or %d pixels high", resource, 32, 64);
        }
    }

    private boolean compute(bfq renderer, aab world, int[] mapRGB, float partialTick) {
        float sun = ColorUtils.clamp(world.q > 0 ? 1.0f : 1.1666666f * (world.b(1.0f) - 0.2f)) * (float)(this.width - 1);
        float torch = ColorUtils.clamp(renderer.e + 0.5f) * (float)(this.width - 1);
        float nightVisionStrength = renderer.getNightVisionStrength(partialTick);
        float gamma = ColorUtils.clamp(Minecraft.x().z.ak);
        for (int i2 = 0; i2 < 16; ++i2) {
            Lightmap.interpolate(this.origMap, i2 * this.width, sun, this.sunrgb, 3 * i2);
            Lightmap.interpolate(this.origMap, (i2 + 16) * this.width, torch, this.torchrgb, 3 * i2);
            if (!this.customNightvision || !(nightVisionStrength > 0.0f)) continue;
            Lightmap.interpolate(this.origMap, (i2 + 32) * this.width, sun, this.sunrgbnv, 3 * i2);
            Lightmap.interpolate(this.origMap, (i2 + 48) * this.width, torch, this.torchrgbnv, 3 * i2);
        }
        for (int s2 = 0; s2 < 16; ++s2) {
            for (int t2 = 0; t2 < 16; ++t2) {
                int k;
                for (k = 0; k < 3; ++k) {
                    this.rgb[k] = ColorUtils.clamp(this.sunrgb[3 * s2 + k] + this.torchrgb[3 * t2 + k]);
                }
                if (nightVisionStrength > 0.0f) {
                    if (this.customNightvision) {
                        for (k = 0; k < 3; ++k) {
                            this.rgb[k] = ColorUtils.clamp((1.0f - nightVisionStrength) * this.rgb[k] + nightVisionStrength * (this.sunrgbnv[3 * s2 + k] + this.torchrgbnv[3 * t2 + k]));
                        }
                    } else {
                        float nightVisionMultiplier = Math.max(Math.max(this.rgb[0], this.rgb[1]), this.rgb[2]);
                        if (nightVisionMultiplier > 0.0f) {
                            nightVisionMultiplier = 1.0f - nightVisionStrength + nightVisionStrength / nightVisionMultiplier;
                            for (int k2 = 0; k2 < 3; ++k2) {
                                this.rgb[k2] = ColorUtils.clamp(this.rgb[k2] * nightVisionMultiplier);
                            }
                        }
                    }
                }
                if (gamma != 0.0f) {
                    for (int k3 = 0; k3 < 3; ++k3) {
                        float tmp = 1.0f - this.rgb[k3];
                        tmp = 1.0f - tmp * tmp * tmp * tmp;
                        this.rgb[k3] = gamma * tmp + (1.0f - gamma) * this.rgb[k3];
                    }
                }
                mapRGB[s2 * 16 + t2] = 0xFF000000 | ColorUtils.float3ToInt(this.rgb);
            }
        }
        return true;
    }

    private static void interpolate(int[] map, int offset1, float x2, float[] rgb, int offset2) {
        int x1;
        int x0 = (int)Math.floor(x2);
        if (x0 == (x1 = (int)Math.ceil(x2))) {
            ColorUtils.intToFloat3(map[offset1 + x0], rgb, offset2);
        } else {
            float xf2 = x2 - (float)x0;
            float xg2 = 1.0f - xf2;
            float[] rgb0 = new float[3];
            float[] rgb1 = new float[3];
            ColorUtils.intToFloat3(map[offset1 + x0], rgb0);
            ColorUtils.intToFloat3(map[offset1 + x1], rgb1);
            for (int i2 = 0; i2 < 3; ++i2) {
                rgb[offset2 + i2] = xg2 * rgb0[i2] + xf2 * rgb1[i2];
            }
        }
    }
}

