/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.ColorizeItem;
import com.prupe.mcpatcher.cc.ColorizeWorld;
import com.prupe.mcpatcher.cc.Lightmap;
import com.prupe.mcpatcher.mal.biome.ColorMap;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Colorizer {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    static final FakeResourceLocation COLOR_PROPERTIES = TexturePackAPI.newMCPatcherResourceLocation("color.properties");
    private static PropertiesFile properties;
    static final boolean usePotionColors;
    static final boolean useParticleColors;
    static final boolean useFogColors;
    static final boolean useCloudType;
    static final boolean useMapColors;
    static final boolean useDyeColors;
    static final boolean useTextColors;
    static final boolean useXPOrbColors;
    static final boolean useEggColors;
    public static final float[] setColor;

    public static void setColorF(int color) {
        ColorUtils.intToFloat3(color, setColor);
    }

    static void setColorF(float[] color) {
        Colorizer.setColor[0] = color[0];
        Colorizer.setColor[1] = color[1];
        Colorizer.setColor[2] = color[2];
    }

    static void init() {
    }

    private static void reset() {
        properties = new PropertiesFile(logger, COLOR_PROPERTIES);
        ColorMap.reset();
        try {
            ColorizeBlock.reset();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        Lightmap.reset();
        ColorizeItem.reset();
        ColorizeWorld.reset();
        ColorizeEntity.reset();
    }

    private static void reloadColorProperties() {
        properties = PropertiesFile.getNonNull(logger, COLOR_PROPERTIES);
        logger.finer("reloading %s", properties);
    }

    static String getStringKey(String[] keys, int index) {
        if (keys != null && index >= 0 && index < keys.length && keys[index] != null) {
            return keys[index];
        }
        return "" + index;
    }

    static void loadIntColor(String key, mk potion) {
        potion.N = Colorizer.loadIntColor(key, potion.N);
    }

    static boolean loadIntColor(String key, int[] color, int index) {
        logger.config("%s=%06x", key, color[index]);
        String value = properties.getString(key, "");
        if (!value.equals("")) {
            try {
                color[index] = Integer.parseInt(value, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static int loadIntColor(String key, int color) {
        logger.config("%s=%06x", key, color);
        return properties.getHex(key, color);
    }

    static void loadFloatColor(String key, float[] color) {
        int intColor = ColorUtils.float3ToInt(color);
        ColorUtils.intToFloat3(Colorizer.loadIntColor(key, intColor), color);
    }

    static Integer loadIntegerColor(String key) {
        int[] tmp = new int[1];
        if (Colorizer.loadIntColor(key, tmp, 0)) {
            return tmp[0];
        }
        return null;
    }

    static float[] loadFloatColor(String key) {
        Integer color = Colorizer.loadIntegerColor(key);
        if (color == null) {
            return null;
        }
        float[] rgb = new float[3];
        ColorUtils.intToFloat3(color, rgb);
        return rgb;
    }

    static {
        usePotionColors = Config.getBoolean("Custom Colors", "potion", true);
        useParticleColors = Config.getBoolean("Custom Colors", "particle", true);
        useFogColors = Config.getBoolean("Custom Colors", "fog", true);
        useCloudType = Config.getBoolean("Custom Colors", "clouds", true);
        useMapColors = Config.getBoolean("Custom Colors", "map", true);
        useDyeColors = Config.getBoolean("Custom Colors", "dye", true);
        useTextColors = Config.getBoolean("Custom Colors", "text", true);
        useXPOrbColors = Config.getBoolean("Custom Colors", "xporb", true);
        useEggColors = Config.getBoolean("Custom Colors", "egg", true);
        setColor = new float[3];
        try {
            Colorizer.reset();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Colors", 2){

            @Override
            public void beforeChange() {
                Colorizer.reset();
            }

            @Override
            public void afterChange() {
                Colorizer.reloadColorProperties();
                ColorMap.reloadColorMapSettings(properties);
                if (useParticleColors) {
                    ColorizeEntity.reloadParticleColors(properties);
                }
                try {
                    ColorizeBlock.reloadAll(properties);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (useFogColors) {
                    ColorizeWorld.reloadFogColors(properties);
                }
                if (usePotionColors) {
                    ColorizeItem.reloadPotionColors(properties);
                }
                if (useCloudType) {
                    ColorizeWorld.reloadCloudType(properties);
                }
                if (useMapColors) {
                    ColorizeItem.reloadMapColors(properties);
                }
                if (useDyeColors) {
                    ColorizeEntity.reloadDyeColors(properties);
                }
                if (useTextColors) {
                    ColorizeWorld.reloadTextColors(properties);
                }
                if (useXPOrbColors) {
                    ColorizeEntity.reloadXPOrbColors(properties);
                }
            }
        });
    }
}

