/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.biome.ColorMap;
import com.prupe.mcpatcher.mal.biome.ColorMapBase;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.biome.IColorMap;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorizeWorld {
    private static final int fogBlendRadius = Config.getInt("Custom Colors", "fogBlendRadius", 7);
    private static final FakeResourceLocation UNDERWATERCOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/underwatercolor.png");
    private static final FakeResourceLocation UNDERLAVACOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/underlavacolor.png");
    private static final FakeResourceLocation FOGCOLOR0 = TexturePackAPI.newMCPatcherResourceLocation("/misc/fogcolor0.png");
    private static final FakeResourceLocation SKYCOLOR0 = TexturePackAPI.newMCPatcherResourceLocation("/misc/skycolor0.png");
    private static final String TEXT_KEY = "text.";
    private static final String TEXT_CODE_KEY = "text.code.";
    private static final int CLOUDS_DEFAULT = -1;
    private static final int CLOUDS_NONE = 0;
    private static final int CLOUDS_FAST = 1;
    private static final int CLOUDS_FANCY = 2;
    private static int cloudType = -1;
    private static mp fogCamera;
    private static final Map<Integer, Integer> textColorMap;
    private static final int[] textCodeColors;
    private static final boolean[] textCodeColorSet;
    private static int signTextColor;
    static IColorMap underwaterColor;
    private static IColorMap underlavaColor;
    private static IColorMap fogColorMap;
    private static IColorMap skyColorMap;
    public static float[] netherFogColor;
    public static float[] endFogColor;
    public static int endSkyColor;

    static void reset() {
        underwaterColor = null;
        underlavaColor = null;
        fogColorMap = null;
        skyColorMap = null;
        netherFogColor = new float[]{0.2f, 0.03f, 0.03f};
        endFogColor = new float[]{0.075f, 0.075f, 0.094f};
        endSkyColor = 0x181818;
        cloudType = -1;
        textColorMap.clear();
        for (int i2 = 0; i2 < textCodeColorSet.length; ++i2) {
            ColorizeWorld.textCodeColorSet[i2] = false;
        }
        signTextColor = 0;
    }

    static void reloadFogColors(PropertiesFile properties) {
        underwaterColor = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, UNDERWATERCOLOR));
        underlavaColor = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, UNDERLAVACOLOR));
        fogColorMap = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, FOGCOLOR0));
        skyColorMap = ColorizeWorld.wrapFogMap(ColorMap.loadFixedColorMap(Colorizer.useFogColors, SKYCOLOR0));
        Colorizer.loadFloatColor("fog.nether", netherFogColor);
        Colorizer.loadFloatColor("fog.end", endFogColor);
        endSkyColor = Colorizer.loadIntColor("sky.end", endSkyColor);
    }

    static IColorMap wrapFogMap(IColorMap map) {
        if (map == null) {
            return null;
        }
        if (fogBlendRadius > 0) {
            map = new ColorMapBase.Blended(map, fogBlendRadius);
        }
        map = new ColorMapBase.Cached(map);
        map = new ColorMapBase.Smoothed(map, 3000.0f);
        map = new ColorMapBase.Outer(map);
        return map;
    }

    static void reloadCloudType(PropertiesFile properties) {
        String value = properties.getString("clouds", "").toLowerCase();
        if (value.equals("fast")) {
            cloudType = 1;
        } else if (value.equals("fancy")) {
            cloudType = 2;
        } else if (value.equals("none")) {
            cloudType = 0;
        }
    }

    static void reloadTextColors(PropertiesFile properties) {
        for (int i2 = 0; i2 < textCodeColors.length; ++i2) {
            ColorizeWorld.textCodeColorSet[i2] = Colorizer.loadIntColor(TEXT_CODE_KEY + i2, textCodeColors, i2);
            if (!textCodeColorSet[i2] || i2 + 16 >= textCodeColors.length) continue;
            ColorizeWorld.textCodeColors[i2 + 16] = (textCodeColors[i2] & 0xFCFCFC) >> 2;
            ColorizeWorld.textCodeColorSet[i2 + 16] = true;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(TEXT_KEY) || key.startsWith(TEXT_CODE_KEY)) continue;
            key = key.substring(TEXT_KEY.length()).trim();
            try {
                int oldColor = key.equals("xpbar") ? 8453920 : (key.equals("boss") ? 0xFF00FF : Integer.parseInt(key, 16));
                int newColor = Integer.parseInt(value, 16);
                textColorMap.put(oldColor, newColor);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        signTextColor = Colorizer.loadIntColor("text.sign", 0);
    }

    public static void setupForFog(mp entity) {
        fogCamera = entity;
    }

    private static boolean computeFogColor(aak blockAccess, IColorMap colorMap) {
        if (colorMap == null || fogCamera == null) {
            return false;
        }
        int i2 = (int)ColorizeWorld.fogCamera.u;
        int j2 = (int)ColorizeWorld.fogCamera.v;
        int k = (int)ColorizeWorld.fogCamera.w;
        Colorizer.setColorF(colorMap.getColorMultiplierF(blockAccess, i2, j2, k));
        return true;
    }

    public static boolean computeFogColor(acn worldProvider, float f2) {
        return worldProvider.getWorldType() == 0 && ColorizeWorld.computeFogColor(worldProvider.a, fogColorMap);
    }

    public static boolean computeSkyColor(aab world, float f2) {
        if (world.t.getWorldType() == 0 && ColorizeWorld.computeFogColor(world, skyColorMap)) {
            ColorizeWorld.computeLightningFlash(world, f2);
            return true;
        }
        return false;
    }

    public static boolean computeUnderwaterColor() {
        return ColorizeWorld.computeFogColor(BiomeAPI.getWorld(), underwaterColor);
    }

    public static boolean computeUnderlavaColor() {
        return ColorizeWorld.computeFogColor(BiomeAPI.getWorld(), underlavaColor);
    }

    private static void computeLightningFlash(aab world, float f2) {
        if (world.q > 0) {
            f2 = 0.45f * ColorUtils.clamp((float)world.q - f2);
            Colorizer.setColor[0] = Colorizer.setColor[0] * (1.0f - f2) + 0.8f * f2;
            Colorizer.setColor[1] = Colorizer.setColor[1] * (1.0f - f2) + 0.8f * f2;
            Colorizer.setColor[2] = Colorizer.setColor[2] * (1.0f - f2) + 0.8f * f2;
        }
    }

    public static boolean drawFancyClouds(boolean fancyGraphics) {
        switch (cloudType) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return fancyGraphics;
    }

    public static int drawFancyClouds(int fancyGraphics) {
        switch (cloudType) {
            case 0: 
            case 1: 
            case 2: {
                return cloudType;
            }
        }
        return fancyGraphics;
    }

    public static int colorizeText(int defaultColor) {
        int high = defaultColor & 0xFF000000;
        Integer newColor = textColorMap.get(defaultColor &= 0xFFFFFF);
        if (newColor == null) {
            return high | defaultColor;
        }
        return high | newColor;
    }

    public static int colorizeText(int defaultColor, int index) {
        if (index < 0 || index >= textCodeColors.length || !textCodeColorSet[index]) {
            return defaultColor;
        }
        return defaultColor & 0xFF000000 | textCodeColors[index];
    }

    public static int colorizeSignText() {
        return signTextColor;
    }

    static {
        textColorMap = new HashMap<Integer, Integer>();
        textCodeColors = new int[32];
        textCodeColorSet = new boolean[32];
        try {
            ColorizeWorld.reset();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }
}

