/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorizeItem {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final Map<Integer, String> entityNamesByID = new HashMap<Integer, String>();
    private static final Map<Integer, Integer> spawnerEggShellColors = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> spawnerEggSpotColors = new HashMap<Integer, Integer>();
    private static int waterBottleColor;
    private static final List<mk> potions;
    private static boolean potionsInitialized;
    private static final String[] MAP_MATERIALS;

    static void reset() {
        spawnerEggShellColors.clear();
        spawnerEggSpotColors.clear();
        if (potionsInitialized && xu.getPotionColorCache() != null) {
            xu.getPotionColorCache().clear();
        }
        potionsInitialized = true;
        waterBottleColor = 3694022;
        for (mk potion : potions) {
            potion.N = potion.origColor;
        }
        for (aih mapColor : aih.a) {
            if (mapColor == null) continue;
            mapColor.p = mapColor.origColorValue;
        }
    }

    static void reloadPotionColors(PropertiesFile properties) {
        for (mk potion : potions) {
            Colorizer.loadIntColor(potion.I, potion);
        }
        int[] temp = new int[]{waterBottleColor};
        Colorizer.loadIntColor("potion.water", temp, 0);
        waterBottleColor = temp[0];
    }

    static void reloadMapColors(PropertiesFile properties) {
        for (int i2 = 0; i2 < aih.a.length; ++i2) {
            if (aih.a[i2] == null) continue;
            int[] rgb = new int[]{aih.a[i2].origColorValue};
            Colorizer.loadIntColor("map." + Colorizer.getStringKey(MAP_MATERIALS, i2), rgb, 0);
            aih.a[i2].p = rgb[0];
        }
    }

    public static void setupSpawnerEgg(String entityName, int entityID, int defaultShellColor, int defaultSpotColor) {
        logger.config("egg.shell.%s=%06x", entityName, defaultShellColor);
        logger.config("egg.spots.%s=%06x", entityName, defaultSpotColor);
        entityNamesByID.put(entityID, entityName);
    }

    public static void setupPotion(mk potion) {
        potion.origColor = potion.N;
        potions.add(potion);
    }

    public static int colorizeSpawnerEgg(int defaultColor, int entityID, int spots) {
        String name;
        Map<Integer, Integer> eggMap;
        if (!Colorizer.useEggColors) {
            return defaultColor;
        }
        Integer value = null;
        Map<Integer, Integer> map = eggMap = spots == 0 ? spawnerEggShellColors : spawnerEggSpotColors;
        if (eggMap.containsKey(entityID)) {
            value = eggMap.get(entityID);
        } else if (entityNamesByID.containsKey(entityID) && (name = entityNamesByID.get(entityID)) != null) {
            int[] tmp = new int[]{defaultColor};
            Colorizer.loadIntColor((spots == 0 ? "egg.shell." : "egg.spots.") + name, tmp, 0);
            eggMap.put(entityID, tmp[0]);
            value = tmp[0];
        }
        return value == null ? defaultColor : value;
    }

    public static int getWaterBottleColor() {
        return waterBottleColor;
    }

    static {
        potions = new ArrayList<mk>();
        MAP_MATERIALS = new String[]{"air", "grass", "sand", "cloth", "tnt", "ice", "iron", "foliage", "snow", "clay", "dirt", "stone", "water", "wood", "quartz", "adobe", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black", "gold", "diamond", "lapis", "emerald", "obsidian", "netherrack"};
        try {
            ColorizeItem.reset();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }
}

