/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.Colorizer;
import com.prupe.mcpatcher.mal.biome.BiomeAPI;
import com.prupe.mcpatcher.mal.biome.ColorMap;
import com.prupe.mcpatcher.mal.biome.ColorMapBase;
import com.prupe.mcpatcher.mal.biome.ColorUtils;
import com.prupe.mcpatcher.mal.biome.IColorMap;
import com.prupe.mcpatcher.mal.block.BlockAPI;
import com.prupe.mcpatcher.mal.block.BlockStateMatcher;
import com.prupe.mcpatcher.mal.block.RenderBlocksUtils;
import com.prupe.mcpatcher.mal.resource.FakeResourceLocation;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ColorizeBlock {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final boolean useWaterColors = Config.getBoolean("Custom Colors", "water", true);
    private static final boolean useTreeColors = Config.getBoolean("Custom Colors", "tree", true);
    private static final boolean useRedstoneColors = Config.getBoolean("Custom Colors", "redstone", true);
    private static final boolean useStemColors = Config.getBoolean("Custom Colors", "stem", true);
    private static final boolean useBlockColors = Config.getBoolean("Custom Colors", "otherBlocks", true);
    static final boolean enableSmoothBiomes = Config.getBoolean("Custom Colors", "smoothBiomes", true);
    static final boolean enableTestColorSmoothing = Config.getBoolean("Custom Colors", "testColorSmoothing", false);
    private static final FakeResourceLocation REDSTONE_COLORS = TexturePackAPI.newMCPatcherResourceLocation("/misc/redstonecolor.png");
    private static final FakeResourceLocation STEM_COLORS = TexturePackAPI.newMCPatcherResourceLocation("/misc/stemcolor.png");
    private static final FakeResourceLocation PUMPKIN_STEM_COLORS = TexturePackAPI.newMCPatcherResourceLocation("/misc/pumpkinstemcolor.png");
    private static final FakeResourceLocation MELON_STEM_COLORS = TexturePackAPI.newMCPatcherResourceLocation("/misc/melonstemcolor.png");
    private static final FakeResourceLocation SWAMPGRASSCOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/swampgrasscolor.png");
    private static final FakeResourceLocation SWAMPFOLIAGECOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/swampfoliagecolor.png");
    private static final FakeResourceLocation DEFAULT_GRASSCOLOR = new FakeResourceLocation("/misc/grasscolor.png");
    private static final FakeResourceLocation DEFAULT_FOLIAGECOLOR = new FakeResourceLocation("/misc/foliagecolor.png");
    private static final FakeResourceLocation PINECOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/pinecolor.png");
    private static final FakeResourceLocation BIRCHCOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/birchcolor.png");
    private static final FakeResourceLocation WATERCOLOR = TexturePackAPI.newMCPatcherResourceLocation("/misc/watercolorX.png");
    private static final String PALETTE_BLOCK_KEY = "palette.block.";
    private static apa waterBlock;
    private static apa staticWaterBlock;
    private static final Map<apa, List<BlockStateMatcher>> blockColorMaps;
    private static IColorMap waterColorMap;
    private static float[][] redstoneColor;
    private static final int blockBlendRadius;
    public static int blockColor;
    public static boolean isSmooth;
    public static float colorRedTopLeft;
    public static float colorRedBottomLeft;
    public static float colorRedBottomRight;
    public static float colorRedTopRight;
    public static float colorGreenTopLeft;
    public static float colorGreenBottomLeft;
    public static float colorGreenBottomRight;
    public static float colorGreenTopRight;
    public static float colorBlueTopLeft;
    public static float colorBlueBottomLeft;
    public static float colorBlueBottomRight;
    public static float colorBlueTopRight;
    private static final int[][][] FACE_VERTICES;

    static void reset() {
        waterBlock = BlockAPI.getFixedBlock("minecraft:flowing_water");
        staticWaterBlock = BlockAPI.getFixedBlock("minecraft:water");
        blockColorMaps.clear();
        waterColorMap = null;
        ColorizeBlock.resetVertexColors();
        redstoneColor = null;
    }

    static void reloadAll(PropertiesFile properties) {
        if (useBlockColors) {
            ColorizeBlock.reloadBlockColors(properties);
        }
        if (useTreeColors) {
            ColorizeBlock.reloadFoliageColors(properties);
        }
        if (useWaterColors) {
            ColorizeBlock.reloadWaterColors(properties);
        }
        if (ColorMap.useSwampColors) {
            ColorizeBlock.reloadSwampColors(properties);
        }
        if (useRedstoneColors) {
            ColorizeBlock.reloadRedstoneColors(properties);
        }
        if (useStemColors) {
            ColorizeBlock.reloadStemColors(properties);
        }
    }

    private static void reloadFoliageColors(PropertiesFile properties) {
        IColorMap colorMap = ColorMap.loadVanillaColorMap(DEFAULT_GRASSCOLOR, SWAMPGRASSCOLOR);
        ColorizeBlock.registerColorMap(colorMap, DEFAULT_GRASSCOLOR, "minecraft:grass:snowy=false minecraft:tallgrass:1,2:type=tall_grass,fern minecraft:double_plant:2,3:variant=double_grass,double_fern");
        colorMap = ColorMap.loadVanillaColorMap(DEFAULT_FOLIAGECOLOR, SWAMPFOLIAGECOLOR);
        ColorizeBlock.registerColorMap(colorMap, DEFAULT_FOLIAGECOLOR, "minecraft:leaves:0,4,8,12:variant=oak minecraft:vine");
        ColorizeBlock.registerColorMap(PINECOLOR, "minecraft:leaves:1,5,9,13:variant=spruce");
        ColorizeBlock.registerColorMap(BIRCHCOLOR, "minecraft:leaves:2,6,10,14:variant=birch");
    }

    private static IColorMap wrapBlockMap(IColorMap map) {
        if (map == null) {
            return null;
        }
        if (blockBlendRadius > 0) {
            map = new ColorMapBase.Blended(map, blockBlendRadius);
        }
        map = new ColorMapBase.Chunked(map);
        map = new ColorMapBase.Outer(map);
        return map;
    }

    private static void reloadWaterColors(PropertiesFile properties) {
        waterColorMap = ColorizeBlock.registerColorMap(WATERCOLOR, "minecraft:flowing_water minecraft:water");
        if (waterColorMap == null) {
            waterColorMap = new ColorMap.Water();
            ColorizeBlock.registerColorMap(waterColorMap, null, "minecraft:flowing_water minecraft:water");
        }
    }

    private static void reloadSwampColors(PropertiesFile properties) {
        int[] lilypadColor = new int[]{133168};
        if (Colorizer.loadIntColor("lilypad", lilypadColor, 0)) {
            ColorMap.Fixed colorMap = new ColorMap.Fixed(lilypadColor[0]);
            ColorizeBlock.registerColorMap(colorMap, Colorizer.COLOR_PROPERTIES, "minecraft:waterlily");
        }
    }

    private static void reloadBlockColors(PropertiesFile properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            FakeResourceLocation resource;
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.startsWith(PALETTE_BLOCK_KEY) || (resource = TexturePackAPI.parseResourceLocation(Colorizer.COLOR_PROPERTIES, key = key.substring(PALETTE_BLOCK_KEY.length()).trim())) == null) continue;
            ColorizeBlock.registerColorMap(resource, value);
        }
        for (FakeResourceLocation resource : ResourceList.getInstance().listResources("/colormap/blocks", ".properties", false)) {
            Properties properties1 = TexturePackAPI.getProperties(resource);
            IColorMap colorMap = ColorMap.loadColorMap(true, resource, properties1);
            ColorizeBlock.registerColorMap(colorMap, resource, MCPatcherUtils.getStringProperty(properties1, "blocks", ColorizeBlock.getDefaultBlockName(resource)));
        }
        ArrayList<FakeResourceLocation> unusedPNGs = new ArrayList<FakeResourceLocation>(ColorMap.unusedPNGs);
        for (FakeResourceLocation resource : unusedPNGs) {
            Properties properties1 = new Properties();
            IColorMap colorMap = ColorMap.loadColorMap(true, resource, properties1);
            ColorizeBlock.registerColorMap(colorMap, resource, ColorizeBlock.getDefaultBlockName(resource));
        }
    }

    private static String getDefaultBlockName(FakeResourceLocation resource) {
        return resource.getNamespace() + ":" + resource.getPath().replaceFirst(".*/", "").replaceFirst("\\.[^.]*$", "");
    }

    private static IColorMap registerColorMap(FakeResourceLocation resource, String idList) {
        IColorMap colorMap = ColorMap.loadColorMap(true, resource, null);
        return ColorizeBlock.registerColorMap(colorMap, resource, idList);
    }

    private static IColorMap registerColorMap(IColorMap colorMap, FakeResourceLocation resource, String idList) {
        if (colorMap == null) {
            return null;
        }
        colorMap = ColorizeBlock.wrapBlockMap(colorMap);
        for (String idString : idList.split("\\s+")) {
            BlockStateMatcher blockMatcher = BlockAPI.createMatcher(new PropertiesFile(logger, resource), idString);
            if (blockMatcher == null) continue;
            List<BlockStateMatcher> maps = blockColorMaps.get(blockMatcher.getBlock());
            if (maps == null) {
                maps = new ArrayList<BlockStateMatcher>();
                blockColorMaps.put(blockMatcher.getBlock(), maps);
            }
            blockMatcher.setData(colorMap);
            maps.add(blockMatcher);
            if (resource == null) continue;
            logger.fine("using %s for block %s, default color %06x", colorMap, blockMatcher, colorMap.getColorMultiplier());
        }
        return colorMap;
    }

    private static void reloadRedstoneColors(PropertiesFile properties) {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(REDSTONE_COLORS));
        if (rgb != null && rgb.length >= 16) {
            redstoneColor = new float[16][];
            for (int i2 = 0; i2 < 16; ++i2) {
                float[] f2 = new float[3];
                ColorUtils.intToFloat3(rgb[i2], f2);
                ColorizeBlock.redstoneColor[i2] = f2;
            }
        }
    }

    private static void reloadStemColors(PropertiesFile properties) {
        FakeResourceLocation resource = TexturePackAPI.hasResource(PUMPKIN_STEM_COLORS) ? PUMPKIN_STEM_COLORS : STEM_COLORS;
        ColorizeBlock.registerMetadataRGB("minecraft:pumpkin_stem", resource, "age", 8);
        resource = TexturePackAPI.hasResource(MELON_STEM_COLORS) ? MELON_STEM_COLORS : STEM_COLORS;
        ColorizeBlock.registerMetadataRGB("minecraft:melon_stem", resource, "age", 8);
    }

    private static void registerMetadataRGB(String blockName, FakeResourceLocation resource, String property, int length) {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(resource));
        if (rgb == null || rgb.length < length) {
            return;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            ColorMap.Fixed colorMap = new ColorMap.Fixed(rgb[i2] & 0xFFFFFF);
            String idList = String.format("%s:%d,%d:%s=%d", blockName, i2, i2 + length & 0xF, property, i2);
            ColorizeBlock.registerColorMap(colorMap, resource, idList);
        }
    }

    static List<BlockStateMatcher> findColorMaps(apa block) {
        return blockColorMaps.get(block);
    }

    static IColorMap getThreadLocal(BlockStateMatcher matcher) {
        IColorMap newMap = (IColorMap)matcher.getThreadData();
        if (newMap == null) {
            IColorMap oldMap = (IColorMap)matcher.getData();
            newMap = oldMap.copy();
            matcher.setThreadData(newMap);
        }
        return newMap;
    }

    private static IColorMap findColorMap(apa block, int metadata) {
        List<BlockStateMatcher> maps = ColorizeBlock.findColorMaps(block);
        if (maps != null) {
            for (BlockStateMatcher matcher : maps) {
                if (!matcher.match(block, metadata)) continue;
                return ColorizeBlock.getThreadLocal(matcher);
            }
        }
        return null;
    }

    private static IColorMap findColorMap(apa block, aak blockAccess, int i2, int j2, int k) {
        List<BlockStateMatcher> maps = ColorizeBlock.findColorMaps(block);
        if (maps != null) {
            for (BlockStateMatcher matcher : maps) {
                if (!matcher.match(blockAccess, i2, j2, k)) continue;
                return ColorizeBlock.getThreadLocal(matcher);
            }
        }
        return null;
    }

    public static boolean colorizeBlock(apa block) {
        return ColorizeBlock.colorizeBlock(block, 16);
    }

    public static boolean colorizeBlock(apa block, int metadata) {
        IColorMap colorMap = ColorizeBlock.findColorMap(block, metadata);
        if (colorMap == null) {
            RenderBlocksUtils.setupColorMultiplier(block, metadata, false);
            return false;
        }
        RenderBlocksUtils.setupColorMultiplier(block, metadata, true);
        blockColor = colorMap.getColorMultiplier();
        return true;
    }

    public static boolean colorizeBlock(apa block, aak blockAccess, int i2, int j2, int k) {
        IColorMap colorMap = ColorizeBlock.findColorMap(block, blockAccess, i2, j2, k);
        return ColorizeBlock.colorizeBlock(block, blockAccess, colorMap, i2, j2, k);
    }

    private static boolean colorizeBlock(apa block, aak blockAccess, IColorMap colorMap, int i2, int j2, int k) {
        if (colorMap == null) {
            return false;
        }
        blockColor = colorMap.getColorMultiplier(blockAccess, i2, j2, k);
        return true;
    }

    public static void computeWaterColor() {
        if (waterColorMap != null) {
            Colorizer.setColorF(waterColorMap.getColorMultiplier());
        }
    }

    public static boolean computeWaterColor(boolean includeBaseColor, int i2, int j2, int k) {
        if (waterColorMap == null) {
            return false;
        }
        Colorizer.setColorF(waterColorMap.getColorMultiplierF(BiomeAPI.getWorld(), i2, j2, k));
        if (includeBaseColor) {
            Colorizer.setColor[0] = Colorizer.setColor[0] * ColorizeEntity.waterBaseColor[0];
            Colorizer.setColor[1] = Colorizer.setColor[1] * ColorizeEntity.waterBaseColor[1];
            Colorizer.setColor[2] = Colorizer.setColor[2] * ColorizeEntity.waterBaseColor[2];
        }
        return true;
    }

    public static void colorizeWaterBlockGL(apa block) {
        if (block == waterBlock || block == staticWaterBlock) {
            float[] waterColor;
            if (waterColorMap == null) {
                waterColor = ColorizeEntity.waterBaseColor;
            } else {
                waterColor = new float[3];
                ColorUtils.intToFloat3(waterColorMap.getColorMultiplier(), waterColor);
            }
            GLAPI.glColor4f(waterColor[0], waterColor[1], waterColor[2], 1.0f);
        }
    }

    public static boolean computeRedstoneWireColor(int current) {
        if (redstoneColor == null) {
            return false;
        }
        System.arraycopy(redstoneColor[current & 0xF], 0, Colorizer.setColor, 0, 3);
        return true;
    }

    public static int colorizeRedstoneWire(aak blockAccess, int i2, int j2, int k, int defaultColor) {
        if (redstoneColor == null) {
            return defaultColor;
        }
        int metadata = Math.max(Math.min(BlockAPI.getMetadataAt(blockAccess, i2, j2, k), 15), 0);
        return ColorUtils.float3ToInt(redstoneColor[metadata]);
    }

    private static float[] getVertexColor(aak blockAccess, IColorMap colorMap, int i2, int j2, int k, int[] offsets) {
        if (enableTestColorSmoothing) {
            int rgb = 0;
            if ((i2 + offsets[0]) % 2 == 0) {
                rgb |= 0xFF0000;
            }
            if ((j2 + offsets[1]) % 2 == 0) {
                rgb |= 0xFF00;
            }
            if ((k + offsets[2]) % 2 == 0) {
                rgb |= 0xFF;
            }
            ColorUtils.intToFloat3(rgb, Colorizer.setColor);
            return Colorizer.setColor;
        }
        return colorMap.getColorMultiplierF(blockAccess, i2 + offsets[0], j2 + offsets[1], k + offsets[2]);
    }

    public static boolean setupBlockSmoothing(bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int face, float topLeft, float bottomLeft, float bottomRight, float topRight) {
        return RenderBlocksUtils.useColorMultiplier(face) && ColorizeBlock.setupBiomeSmoothing(renderBlocks, block, blockAccess, i2, j2, k, face, true, topLeft, bottomLeft, bottomRight, topRight);
    }

    @Deprecated
    public static boolean setupBlockSmoothingGrassSide(bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int face, float topLeft, float bottomLeft, float bottomRight, float topRight) {
        return ColorizeBlock.checkBiomeSmoothing(block, face) && ColorizeBlock.setupBiomeSmoothing(renderBlocks, block, blockAccess, i2, j2, k, face, true, topLeft, bottomLeft, bottomRight, topRight);
    }

    public static boolean setupBlockSmoothing(bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int face) {
        return ColorizeBlock.checkBiomeSmoothing(block, face) && ColorizeBlock.setupBiomeSmoothing(renderBlocks, block, blockAccess, i2, j2, k, face, true, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static boolean checkBiomeSmoothing(apa block, int face) {
        return enableSmoothBiomes && face >= 0 && RenderBlocksUtils.isAmbientOcclusionEnabled() && BlockAPI.getBlockLightValue(block) == 0;
    }

    private static boolean setupBiomeSmoothing(bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int face, boolean useAO, float topLeft, float bottomLeft, float bottomRight, float topRight) {
        if (!ColorizeBlock.setupBlockSmoothing(block, blockAccess, i2, j2, k, face)) {
            return false;
        }
        if (useAO) {
            float aoBase = RenderBlocksUtils.AO_BASE[face % 6];
            topLeft *= aoBase;
            bottomLeft *= aoBase;
            bottomRight *= aoBase;
            topRight *= aoBase;
        }
        renderBlocks.ao = topLeft * colorRedTopLeft;
        renderBlocks.as = topLeft * colorGreenTopLeft;
        renderBlocks.aw = topLeft * colorBlueTopLeft;
        renderBlocks.ap = bottomLeft * colorRedBottomLeft;
        renderBlocks.at = bottomLeft * colorGreenBottomLeft;
        renderBlocks.ax = bottomLeft * colorBlueBottomLeft;
        renderBlocks.aq = bottomRight * colorRedBottomRight;
        renderBlocks.au = bottomRight * colorGreenBottomRight;
        renderBlocks.ay = bottomRight * colorBlueBottomRight;
        renderBlocks.ar = topRight * colorRedTopRight;
        renderBlocks.av = topRight * colorGreenTopRight;
        renderBlocks.az = topRight * colorBlueTopRight;
        return true;
    }

    public static void setupBlockSmoothing(apa block, aak blockAccess, int i2, int j2, int k, int face, float r2, float g2, float b2) {
        if (!ColorizeBlock.setupBlockSmoothing(block, blockAccess, i2, j2, k, face)) {
            ColorizeBlock.setVertexColors(r2, g2, b2);
        }
    }

    private static boolean setupBlockSmoothing(apa block, aak blockAccess, int i2, int j2, int k, int face) {
        if (!ColorizeBlock.checkBiomeSmoothing(block, face)) {
            return false;
        }
        IColorMap colorMap = ColorizeBlock.findColorMap(block, blockAccess, i2, j2, k);
        if (colorMap == null) {
            return false;
        }
        int[][] offsets = FACE_VERTICES[face];
        float[] color = ColorizeBlock.getVertexColor(blockAccess, colorMap, i2, j2, k, offsets[0]);
        colorRedTopLeft = color[0];
        colorGreenTopLeft = color[1];
        colorBlueTopLeft = color[2];
        color = ColorizeBlock.getVertexColor(blockAccess, colorMap, i2, j2, k, offsets[1]);
        colorRedBottomLeft = color[0];
        colorGreenBottomLeft = color[1];
        colorBlueBottomLeft = color[2];
        color = ColorizeBlock.getVertexColor(blockAccess, colorMap, i2, j2, k, offsets[2]);
        colorRedBottomRight = color[0];
        colorGreenBottomRight = color[1];
        colorBlueBottomRight = color[2];
        color = ColorizeBlock.getVertexColor(blockAccess, colorMap, i2, j2, k, offsets[3]);
        colorRedTopRight = color[0];
        colorGreenTopRight = color[1];
        colorBlueTopRight = color[2];
        return true;
    }

    private static void resetVertexColors() {
        ColorizeBlock.setVertexColors(1.0f, 1.0f, 1.0f);
    }

    private static void setVertexColors(float r2, float g2, float b2) {
        colorRedBottomRight = colorRedTopRight = r2;
        colorRedBottomLeft = colorRedTopRight;
        colorRedTopLeft = colorRedTopRight;
        colorGreenBottomRight = colorGreenTopRight = g2;
        colorGreenBottomLeft = colorGreenTopRight;
        colorGreenTopLeft = colorGreenTopRight;
        colorBlueBottomRight = colorBlueTopRight = b2;
        colorBlueBottomLeft = colorBlueTopRight;
        colorBlueTopLeft = colorBlueTopRight;
    }

    static {
        blockColorMaps = new IdentityHashMap<apa, List<BlockStateMatcher>>();
        blockBlendRadius = Config.getInt("Custom Colors", "blockBlendRadius2", 4);
        FACE_VERTICES = new int[][][]{new int[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}}, new int[][]{{1, 1, 1}, {1, 1, 0}, {0, 1, 0}, {0, 1, 1}}, new int[][]{{0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, 0}}, new int[][]{{0, 1, 1}, {0, 0, 1}, {1, 0, 1}, {1, 1, 1}}, new int[][]{{0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {0, 0, 1}}, new int[][]{{1, 0, 1}, {1, 0, 0}, {1, 1, 0}, {1, 1, 1}}, new int[][]{{0, 0, 1}, {0, 0, 0}, {1, 0, 0}, {1, 0, 1}}, new int[][]{{0, 1, 0}, {0, 1, 1}, {1, 1, 1}, {1, 1, 0}}, new int[][]{{0, 1, 0}, {1, 1, 0}, {1, 0, 0}, {0, 0, 0}}, new int[][]{{1, 1, 1}, {0, 1, 1}, {0, 0, 1}, {1, 0, 1}}, new int[][]{{0, 1, 1}, {0, 1, 0}, {0, 0, 0}, {0, 0, 1}}, new int[][]{{1, 1, 0}, {1, 1, 1}, {1, 0, 1}, {1, 0, 0}}};
        try {
            ColorizeBlock.reset();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }
}

