/*
 * Decompiled with CFR 0.152.
 */
package btw.world.util.difficulty;

import btw.world.util.difficulty.Difficulty;
import btw.world.util.difficulty.RelaxedDifficulty;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;

public class Difficulties {
    public static final ArrayList<Difficulty> DIFFICULTY_LIST = new ArrayList();
    public static final Difficulty STANDARD = new Difficulty("standard");
    public static final Difficulty RELAXED = new RelaxedDifficulty("relaxed");

    public static Difficulty getDifficultyFromName(String name) {
        for (Difficulty c2 : DIFFICULTY_LIST) {
            if (!c2.NAME.equals(name)) continue;
            return c2;
        }
        return STANDARD;
    }

    public static String[] getAllDifficultyNames() {
        String[] names = new String[DIFFICULTY_LIST.size()];
        for (int i2 = 0; i2 < DIFFICULTY_LIST.size(); ++i2) {
            names[i2] = Difficulties.DIFFICULTY_LIST.get((int)i2).NAME;
        }
        return names;
    }

    public static ei createDifficultyPacket(MinecraftServer mcServer) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        byte difficulty = (byte)mcServer.b[0].M().getDifficulty().ID;
        try {
            dataStream.writeByte(difficulty);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new dk("BTW|DF", byteStream.toByteArray());
    }
}

