/*
 * Decompiled with CFR 0.152.
 */
package btw.world.util;

import btw.world.util.WorldData;
import btw.world.util.difficulty.Difficulties;
import btw.world.util.difficulty.Difficulty;

public class BTWWorldData
implements WorldData {
    @Override
    public void saveWorldDataToNBT(iz world, bs tag) {
        if (world.getMagneticPointList() != null) {
            tag.a("FCMagneticPoints", (cf)world.getMagneticPointList().saveToNBT());
        }
        if (world.getLocalEnderChestInventory() != null) {
            tag.a("FCEnderItems", (cf)world.getLocalEnderChestInventory().h());
        }
        if (world.getLocalLowPowerEnderChestInventory() != null) {
            tag.a("FCLPEnderItems", (cf)world.getLocalLowPowerEnderChestInventory().h());
        }
        if (world.getAmbientBeaconLocationList() != null) {
            tag.a("FCLootingBeacons", (cf)world.getAmbientBeaconLocationList().saveToNBT());
        }
        if (world.getSpawnLocationList() != null) {
            tag.a("FCSpawnLocations", (cf)world.getSpawnLocationList().saveToNBT());
        }
    }

    @Override
    public void loadWorldDataFromNBT(iz world, bs tag) {
        ca itemList;
        ca nbttaglist1;
        if (tag.b("FCMagneticPoints")) {
            nbttaglist1 = tag.m("FCMagneticPoints");
            world.getMagneticPointList().loadFromNBT(nbttaglist1);
        }
        if (tag.b("FCEnderItems")) {
            itemList = tag.m("FCEnderItems");
            world.getLocalEnderChestInventory().a(itemList);
        }
        if (tag.b("FCLPEnderItems")) {
            itemList = tag.m("FCLPEnderItems");
            world.getLocalLowPowerEnderChestInventory().a(itemList);
        }
        if (tag.b("FCLootingBeacons")) {
            nbttaglist1 = tag.m("FCLootingBeacons");
            world.getAmbientBeaconLocationList().loadFromNBT(nbttaglist1);
        }
        if (tag.b("FCSpawnLocations")) {
            nbttaglist1 = tag.m("FCSpawnLocations");
            world.getSpawnLocationList().loadFromNBT(nbttaglist1);
        }
    }

    @Override
    public void saveGlobalDataToNBT(ajv info, bs tag) {
        if (info.getGlobalEnderChestInventory() != null) {
            tag.a("FCEnderItems", (cf)info.getGlobalEnderChestInventory().h());
        }
        tag.a("FCNetherAccessed", info.hasNetherBeenAccessed());
        tag.a("FCWitherSummoned", info.hasWitherBeenSummoned());
        tag.a("FCEndAccessed", info.hasEndDimensionBeenAccessed());
        tag.a("Difficulty", info.getDifficulty().NAME);
    }

    @Override
    public void loadGlobalDataFromNBT(ajv info, bs tag) {
        if (tag.b("FCEnderItems")) {
            ca nbttaglist1 = tag.m("FCEnderItems");
            info.getGlobalEnderChestInventory().a(nbttaglist1);
        }
        if (tag.b("FCNetherAccessed")) {
            info.setNetherBeenAccessed(tag.n("FCNetherAccessed"));
        }
        if (tag.b("FCWitherSummoned")) {
            info.setWitherHasBeenSummoned(tag.n("FCWitherSummoned"));
        }
        if (tag.b("FCEndAccessed")) {
            info.setEndDimensionHasBeenAccessed(tag.n("FCEndAccessed"));
        }
        if (tag.b("Difficulty")) {
            Difficulty difficulty = Difficulties.getDifficultyFromName(tag.i("Difficulty"));
            if (difficulty == null) {
                difficulty = Difficulties.STANDARD;
            }
            info.setDifficulty(difficulty);
        } else {
            info.setDifficulty(Difficulties.STANDARD);
        }
        info.previouslyRaining = info.p();
        info.previouslyThundering = info.n();
    }

    @Override
    public void createDefaultGlobalData(ajv info) {
        info.setNetherBeenAccessed(false);
        info.setWitherHasBeenSummoned(false);
        info.setEndDimensionHasBeenAccessed(false);
    }

    @Override
    public void copyGlobalData(ajv newInfo, ajv oldInfo) {
        if (oldInfo.getGlobalEnderChestInventory() != null) {
            newInfo.setGlobalEnderChestInventory(oldInfo.getGlobalEnderChestInventory());
        }
        newInfo.setNetherBeenAccessed(oldInfo.hasNetherBeenAccessed());
        newInfo.setWitherHasBeenSummoned(oldInfo.hasWitherBeenSummoned());
        newInfo.setEndDimensionHasBeenAccessed(oldInfo.hasEndDimensionBeenAccessed());
        newInfo.setDifficulty(oldInfo.getDifficulty());
        newInfo.previouslyRaining = oldInfo.p();
        newInfo.previouslyThundering = oldInfo.n();
    }

    @Override
    public String getFilename() {
        return "FCWorld";
    }
}

