/*
 * Decompiled with CFR 0.152.
 */
package btw.world.feature.trees.grower;

import btw.world.feature.trees.grower.AbstractTreeGrower;
import btw.world.feature.trees.grower.TreeGrowers;
import java.util.Random;

public class SwampTreeGrower
extends AbstractTreeGrower {
    public SwampTreeGrower(String name, int minTreeHeight, int maxTreeHeight, TreeGrowers.TreeWoodType woodType) {
        super(name, minTreeHeight, maxTreeHeight, woodType);
    }

    @Override
    public boolean growTree(aab world, Random rand, int x2, int y2, int z2, boolean isWorldGen) {
        int treeHeight = rand.nextInt(this.maxTreeHeight - this.minTreeHeight + 1) + this.minTreeHeight;
        if (isWorldGen) {
            while (world.g(x2, y2 - 1, z2) == aif.h) {
                --y2;
            }
        }
        boolean var7 = true;
        if (y2 >= 1 && y2 + treeHeight + 1 <= 128) {
            for (int j2 = y2; j2 <= y2 + 1 + treeHeight; ++j2) {
                int var9 = 0;
                if (j2 >= y2 + 1 + treeHeight - 2 && isWorldGen) {
                    var9 = 3;
                }
                for (int i2 = x2 - var9; i2 <= x2 + var9 && var7; ++i2) {
                    for (int k = z2 - var9; k <= z2 + var9 && var7; ++k) {
                        if (j2 >= 0 && j2 < 128) {
                            int blockID = world.a(i2, j2, k);
                            apa block = apa.r[blockID];
                            if (block == null || block.isLeafBlock(world, i2, j2, k)) continue;
                            if (blockID != apa.F.cz && blockID != apa.E.cz) {
                                var7 = false;
                                continue;
                            }
                            if (j2 <= y2) continue;
                            var7 = false;
                            continue;
                        }
                        var7 = false;
                    }
                }
            }
            if (!var7) {
                return false;
            }
            int blockID = world.a(x2, y2 - 1, z2);
            apa block = apa.r[blockID];
            if (block != null && block.canSaplingsGrowOnBlock(world, x2, y2 - 1, z2) && y2 < 128 - treeHeight - 1) {
                int j3;
                if (blockID == apa.y.cz || blockID == apa.z.cz) {
                    this.setBlock(world, x2, y2 - 1, z2, apa.z.cz, isWorldGen);
                }
                for (j3 = y2 - 3 + treeHeight; j3 <= y2 + treeHeight; ++j3) {
                    int currentOffsetFromTop = j3 - (y2 + treeHeight);
                    int canopySize = 2 - currentOffsetFromTop / 2;
                    for (int i3 = x2 - canopySize; i3 <= x2 + canopySize; ++i3) {
                        int xDist = i3 - x2;
                        for (int k = z2 - canopySize; k <= z2 + canopySize; ++k) {
                            int zDist = k - z2;
                            int blockIDToReplace = world.a(i3, j3, k);
                            apa blockToReplace = apa.r[blockIDToReplace];
                            if (Math.abs(xDist) == canopySize && Math.abs(zDist) == canopySize && (rand.nextInt(2) == 0 || currentOffsetFromTop == 0) || blockToReplace != null && !blockToReplace.isLeafBlock(world, i3, j3, k) && !blockToReplace.cO.j()) continue;
                            this.setBlockAndMetadata(world, i3, j3, k, this.woodType.leavesBlockID, this.woodType.leavesMetadata, isWorldGen);
                        }
                    }
                }
                for (j3 = 0; j3 < treeHeight; ++j3) {
                    int blockIDAbove = world.a(x2, y2 + j3, z2);
                    apa blockAbove = apa.r[blockIDAbove];
                    if (blockAbove != null && !blockAbove.isLeafBlock(world, x2, y2 + j3, z2) && blockAbove.cO != aif.h) continue;
                    if (j3 == 0) {
                        this.setBlockAndMetadata(world, x2, y2 + j3, z2, this.woodType.stumpBlockID, this.woodType.stumpMetadata, isWorldGen);
                        continue;
                    }
                    this.setBlockAndMetadata(world, x2, y2 + j3, z2, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                }
                for (j3 = y2 - 3 + treeHeight; j3 <= y2 + treeHeight; ++j3) {
                    int var10 = j3 - (y2 + treeHeight);
                    int var11 = 2 - var10 / 2;
                    for (int i4 = x2 - var11; i4 <= x2 + var11; ++i4) {
                        for (int k = z2 - var11; k <= z2 + var11; ++k) {
                            int blockIDForVines = world.a(x2, y2 + j3, z2);
                            apa blockForVines = apa.r[blockIDForVines];
                            if (blockForVines != null && !blockForVines.isLeafBlock(world, x2, y2 + j3, z2)) continue;
                            if (rand.nextInt(4) == 0 && world.a(i4 - 1, j3, k) == 0) {
                                this.generateVines(world, i4 - 1, j3, k, 8, isWorldGen);
                            }
                            if (rand.nextInt(4) == 0 && world.a(i4 + 1, j3, k) == 0) {
                                this.generateVines(world, i4 + 1, j3, k, 2, isWorldGen);
                            }
                            if (rand.nextInt(4) == 0 && world.a(i4, j3, k - 1) == 0) {
                                this.generateVines(world, i4, j3, k - 1, 1, isWorldGen);
                            }
                            if (rand.nextInt(4) != 0 || world.a(i4, j3, k + 1) != 0) continue;
                            this.generateVines(world, i4, j3, k + 1, 4, isWorldGen);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void generateVines(aab par1World, int par2, int par3, int par4, int par5, boolean isWorldGen) {
        this.setBlockAndMetadata(par1World, par2, par3, par4, apa.by.cz, par5, isWorldGen);
        int var6 = 4;
        while (par1World.a(par2, --par3, par4) == 0 && var6 > 0) {
            this.setBlockAndMetadata(par1World, par2, par3, par4, apa.by.cz, par5, isWorldGen);
            --var6;
        }
        return;
    }
}

