/*
 * Decompiled with CFR 0.152.
 */
package btw.world.feature.trees.grower;

import btw.world.feature.trees.grower.AbstractTreeGrower;
import btw.world.feature.trees.grower.TreeGrowers;
import java.util.Random;

public class StandardTreeGrower
extends AbstractTreeGrower {
    protected boolean growVines;
    protected boolean growCocoa;

    public StandardTreeGrower(String name, int minTreeHeight, int maxTreeHeight, TreeGrowers.TreeWoodType woodType) {
        this(name, minTreeHeight, maxTreeHeight, woodType, false, false);
    }

    public StandardTreeGrower(String name, int minTreeHeight, int maxTreeHeight, TreeGrowers.TreeWoodType woodType, boolean growVines, boolean growCocoa) {
        super(name, minTreeHeight, maxTreeHeight, woodType);
        this.growVines = growVines;
        this.growCocoa = growCocoa;
    }

    @Override
    public boolean growTree(aab world, Random rand, int x2, int y2, int z2, boolean isWorldGen) {
        int treeHeight = rand.nextInt(this.maxTreeHeight - this.minTreeHeight + 1) + this.minTreeHeight;
        if (y2 >= 1 && y2 + treeHeight + 1 <= 256) {
            boolean canGrow = this.canTreeGrowHere(world, x2, y2, z2, treeHeight, isWorldGen);
            if (!canGrow) {
                return false;
            }
            int blockIDBelow = world.a(x2, y2 - 1, z2);
            apa blockBelow = apa.r[blockIDBelow];
            if (blockBelow != null && blockBelow.canSaplingsGrowOnBlock(world, x2, y2 - 1, z2) && y2 < 256 - treeHeight - 1) {
                int j2;
                if (blockIDBelow == apa.y.cz || blockIDBelow == apa.z.cz) {
                    this.setBlock(world, x2, y2 - 1, z2, apa.z.cz, isWorldGen);
                }
                int canopyOffsetFromTop = 3;
                for (j2 = y2 - canopyOffsetFromTop + treeHeight; j2 <= y2 + treeHeight; ++j2) {
                    int currentOffsetFromTop = j2 - (y2 + treeHeight);
                    int canopySize = 1 - currentOffsetFromTop / 2;
                    for (int i2 = x2 - canopySize; i2 <= x2 + canopySize; ++i2) {
                        int xDist = i2 - x2;
                        for (int k = z2 - canopySize; k <= z2 + canopySize; ++k) {
                            int blockID;
                            apa block;
                            int zDist = k - z2;
                            if (Math.abs(xDist) == canopySize && Math.abs(zDist) == canopySize && (rand.nextInt(2) == 0 || currentOffsetFromTop == 0) || (block = apa.r[blockID = world.a(i2, j2, k)]) != null && !block.isLeafBlock(world, i2, j2, k) && !block.cO.j()) continue;
                            this.setBlockAndMetadata(world, i2, j2, k, this.woodType.leavesBlockID, this.woodType.leavesMetadata, isWorldGen);
                        }
                    }
                }
                for (j2 = 0; j2 < treeHeight; ++j2) {
                    int blockID = world.a(x2, y2 + j2, z2);
                    apa block = apa.r[blockID];
                    if (block != null && !block.isLeafBlock(world, x2, y2 + j2, z2)) continue;
                    if (j2 == 0) {
                        this.setBlockAndMetadata(world, x2, y2 + j2, z2, this.woodType.stumpBlockID, this.woodType.stumpMetadata, isWorldGen);
                    } else {
                        this.setBlockAndMetadata(world, x2, y2 + j2, z2, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                    }
                    if (!this.growVines || j2 <= 0) continue;
                    this.growVinesForTrunk(world, rand, x2, y2 + j2, z2, isWorldGen);
                }
                if (this.growVines) {
                    this.growVinesForCanopy(world, rand, x2, y2, z2, treeHeight, isWorldGen);
                }
                if (this.growCocoa) {
                    this.growCocoa(world, rand, x2, y2, z2, treeHeight, isWorldGen);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean canTreeGrowHere(aab world, int x2, int y2, int z2, int treeHeight, boolean isWorldGen) {
        for (int j2 = y2; j2 <= y2 + 1 + treeHeight; ++j2) {
            int collisionCheckRadius = 0;
            if (j2 >= y2 + 1 + treeHeight - 2 && isWorldGen) {
                collisionCheckRadius = 2;
            }
            for (int i2 = x2 - collisionCheckRadius; i2 <= x2 + collisionCheckRadius; ++i2) {
                for (int k = z2 - collisionCheckRadius; k <= z2 + collisionCheckRadius; ++k) {
                    if (j2 >= 0 && j2 < 256) {
                        int blockID = world.a(i2, j2, k);
                        apa block = apa.r[blockID];
                        if (block == null || block.isLog(world, i2, j2, k) || block.isLeafBlock(world, i2, j2, k)) continue;
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void growVinesForTrunk(aab world, Random rand, int x2, int y2, int z2, boolean isWorldGen) {
        if (rand.nextInt(3) > 0 && world.c(x2 - 1, y2, z2)) {
            this.setBlockAndMetadata(world, x2 - 1, y2, z2, apa.by.cz, 8, isWorldGen);
        }
        if (rand.nextInt(3) > 0 && world.c(x2 + 1, y2, z2)) {
            this.setBlockAndMetadata(world, x2 + 1, y2, z2, apa.by.cz, 2, isWorldGen);
        }
        if (rand.nextInt(3) > 0 && world.c(x2, y2, z2 - 1)) {
            this.setBlockAndMetadata(world, x2, y2, z2 - 1, apa.by.cz, 1, isWorldGen);
        }
        if (rand.nextInt(3) > 0 && world.c(x2, y2, z2 + 1)) {
            this.setBlockAndMetadata(world, x2, y2, z2 + 1, apa.by.cz, 4, isWorldGen);
        }
    }

    private void growVinesForCanopy(aab world, Random rand, int x2, int y2, int z2, int treeHeight, boolean isWorldGen) {
        for (int j2 = y2 - 3 + treeHeight; j2 <= y2 + treeHeight; ++j2) {
            int currentOffsetFromTop = j2 - (y2 + treeHeight);
            int canopySize = 2 - currentOffsetFromTop / 2;
            for (int i2 = x2 - canopySize; i2 <= x2 + canopySize; ++i2) {
                for (int k = z2 - canopySize; k <= z2 + canopySize; ++k) {
                    int blockID = world.a(i2, j2, k);
                    apa block = apa.r[blockID];
                    if (block == null || !block.isLeafBlock(world, i2, j2, k)) continue;
                    if (rand.nextInt(4) == 0 && world.a(i2 - 1, j2, k) == 0) {
                        this.growVinesOnBlock(world, i2 - 1, j2, k, 8, isWorldGen);
                    }
                    if (rand.nextInt(4) == 0 && world.a(i2 + 1, j2, k) == 0) {
                        this.growVinesOnBlock(world, i2 + 1, j2, k, 2, isWorldGen);
                    }
                    if (rand.nextInt(4) == 0 && world.a(i2, j2, k - 1) == 0) {
                        this.growVinesOnBlock(world, i2, j2, k - 1, 1, isWorldGen);
                    }
                    if (rand.nextInt(4) != 0 || world.a(i2, j2, k + 1) != 0) continue;
                    this.growVinesOnBlock(world, i2, j2, k + 1, 4, isWorldGen);
                }
            }
        }
    }

    private void growVinesOnBlock(aab world, int x2, int y2, int z2, int vineMetadata, boolean isWorldGen) {
        this.setBlockAndMetadata(world, x2, y2, z2, apa.by.cz, vineMetadata, isWorldGen);
        int var6 = 4;
        while (world.a(x2, --y2, z2) == 0 && var6 > 0) {
            this.setBlockAndMetadata(world, x2, y2, z2, apa.by.cz, vineMetadata, isWorldGen);
            --var6;
        }
        return;
    }

    private void growCocoa(aab world, Random rand, int x2, int y2, int z2, int treeHeight, boolean isWorldGen) {
        if (rand.nextInt(5) == 0 && treeHeight > 5) {
            for (int j2 = 0; j2 < 2; ++j2) {
                for (int r2 = 0; r2 < 4; ++r2) {
                    if (rand.nextInt(4 - j2) != 0) continue;
                    int growthStage = rand.nextInt(3);
                    this.setBlockAndMetadata(world, x2 + r.a[r.f[r2]], y2 + treeHeight - 5 + j2, z2 + r.b[r.f[r2]], apa.bT.cz, growthStage << 2 | r2, isWorldGen);
                }
            }
        }
    }
}

