/*
 * Decompiled with CFR 0.152.
 */
package btw.world.feature.trees.grower;

import btw.world.feature.trees.grower.AbstractTreeGrower;
import btw.world.feature.trees.grower.TreeGrowers;
import java.util.Random;

public class JungleTreeGrower
extends AbstractTreeGrower {
    public JungleTreeGrower(String name, int minTreeHeight, int maxTreeHeight, TreeGrowers.TreeWoodType woodType) {
        super(name, minTreeHeight, maxTreeHeight, woodType);
    }

    @Override
    public boolean growTree(aab world, Random rand, int x2, int y2, int z2, boolean isWorldGen) {
        int treeHeight = rand.nextInt(this.maxTreeHeight - this.minTreeHeight) + this.minTreeHeight;
        boolean canGrow = true;
        if (y2 >= 1 && y2 + treeHeight + 1 <= 256) {
            int var12;
            int var11;
            int var10;
            int var8;
            for (var8 = y2; var8 <= y2 + 1 + treeHeight; ++var8) {
                int var9 = 2;
                if (var8 == y2) {
                    var9 = 1;
                }
                if (var8 >= y2 + 1 + treeHeight - 2) {
                    var9 = 2;
                }
                for (var10 = x2 - var9; var10 <= x2 + var9 && canGrow; ++var10) {
                    for (var11 = z2 - var9; var11 <= z2 + var9 && canGrow; ++var11) {
                        if (var8 >= 0 && var8 < 256) {
                            var12 = world.a(var10, var8, var11);
                            apa block = apa.r[var12];
                            if (block == null || block.isLog(world, var10, var8, var11) || block.isLeafBlock(world, var10, var8, var11) || block.cz == apa.y.cz || block.cz == apa.z.cz || block.cO.j()) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            var8 = world.a(x2, y2 - 1, z2);
            apa blockBelow = apa.r[var8];
            if (blockBelow != null && blockBelow.canSaplingsGrowOnBlock(world, x2, y2 - 1, z2) && y2 < 256 - treeHeight - 1) {
                if (var8 == apa.y.cz || var8 == apa.z.cz) {
                    world.f(x2, y2 - 1, z2, apa.z.cz, 0, 2);
                    world.f(x2 + 1, y2 - 1, z2, apa.z.cz, 0, 2);
                    world.f(x2, y2 - 1, z2 + 1, apa.z.cz, 0, 2);
                    world.f(x2 + 1, y2 - 1, z2 + 1, apa.z.cz, 0, 2);
                }
                this.growLeaves(world, x2, z2, y2 + treeHeight, 2, rand, isWorldGen);
                for (int var14 = y2 + treeHeight - 2 - rand.nextInt(4); var14 > y2 + treeHeight / 2; var14 -= 2 + rand.nextInt(4)) {
                    float var15 = rand.nextFloat() * (float)Math.PI * 2.0f;
                    var11 = x2 + (int)(0.5f + kx.b(var15) * 4.0f);
                    var12 = z2 + (int)(0.5f + kx.a(var15) * 4.0f);
                    this.growLeaves(world, var11, var12, var14, 0, rand, isWorldGen);
                    for (int var13 = 0; var13 < 5; ++var13) {
                        var11 = x2 + (int)(1.5f + kx.b(var15) * (float)var13);
                        var12 = z2 + (int)(1.5f + kx.a(var15) * (float)var13);
                        this.setBlockAndMetadata(world, var11, var14 - 3 + var13 / 2, var12, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                    }
                }
                for (var10 = 0; var10 < treeHeight; ++var10) {
                    var11 = world.a(x2, y2 + var10, z2);
                    apa block = apa.r[var11];
                    if (block == null || block.isLeafBlock(world, x2, y2 + var10, z2)) {
                        this.setBlockAndMetadata(world, x2, y2 + var10, z2, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.c(x2 - 1, y2 + var10, z2)) {
                                this.setBlockAndMetadata(world, x2 - 1, y2 + var10, z2, apa.by.cz, 8, isWorldGen);
                            }
                            if (rand.nextInt(3) > 0 && world.c(x2, y2 + var10, z2 - 1)) {
                                this.setBlockAndMetadata(world, x2, y2 + var10, z2 - 1, apa.by.cz, 1, isWorldGen);
                            }
                        }
                    }
                    if (var10 >= treeHeight - 1) continue;
                    var11 = world.a(x2 + 1, y2 + var10, z2);
                    block = apa.r[var11];
                    if (block == null || block.isLeafBlock(world, x2 + 1, y2 + var10, z2)) {
                        this.setBlockAndMetadata(world, x2 + 1, y2 + var10, z2, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.c(x2 + 2, y2 + var10, z2)) {
                                this.setBlockAndMetadata(world, x2 + 2, y2 + var10, z2, apa.by.cz, 2, isWorldGen);
                            }
                            if (rand.nextInt(3) > 0 && world.c(x2 + 1, y2 + var10, z2 - 1)) {
                                this.setBlockAndMetadata(world, x2 + 1, y2 + var10, z2 - 1, apa.by.cz, 1, isWorldGen);
                            }
                        }
                    }
                    if ((block = apa.r[var11 = world.a(x2 + 1, y2 + var10, z2 + 1)]) == null || block.isLeafBlock(world, x2 + 1, y2 + var10, z2 + 1)) {
                        this.setBlockAndMetadata(world, x2 + 1, y2 + var10, z2 + 1, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                        if (var10 > 0) {
                            if (rand.nextInt(3) > 0 && world.c(x2 + 2, y2 + var10, z2 + 1)) {
                                this.setBlockAndMetadata(world, x2 + 2, y2 + var10, z2 + 1, apa.by.cz, 2, isWorldGen);
                            }
                            if (rand.nextInt(3) > 0 && world.c(x2 + 1, y2 + var10, z2 + 2)) {
                                this.setBlockAndMetadata(world, x2 + 1, y2 + var10, z2 + 2, apa.by.cz, 4, isWorldGen);
                            }
                        }
                    }
                    if ((block = apa.r[var11 = world.a(x2, y2 + var10, z2 + 1)]) != null && !block.isLeafBlock(world, x2, y2 + var10, z2 + 1)) continue;
                    this.setBlockAndMetadata(world, x2, y2 + var10, z2 + 1, this.woodType.woodBlockID, this.woodType.woodMetadata, isWorldGen);
                    if (var10 <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.c(x2 - 1, y2 + var10, z2 + 1)) {
                        this.setBlockAndMetadata(world, x2 - 1, y2 + var10, z2 + 1, apa.by.cz, 8, isWorldGen);
                    }
                    if (rand.nextInt(3) <= 0 || !world.c(x2, y2 + var10, z2 + 2)) continue;
                    this.setBlockAndMetadata(world, x2, y2 + var10, z2 + 2, apa.by.cz, 4, isWorldGen);
                }
                this.attemptToPlaceStump(world, x2, y2, z2, isWorldGen);
                this.attemptToPlaceStump(world, x2, y2, z2 + 1, isWorldGen);
                this.attemptToPlaceStump(world, x2 + 1, y2, z2, isWorldGen);
                this.attemptToPlaceStump(world, x2 + 1, y2, z2 + 1, isWorldGen);
                return true;
            }
            return false;
        }
        return false;
    }

    private void attemptToPlaceStump(aab world, int x2, int y2, int z2, boolean isWorldGen) {
        int iTrunkBlockId = world.a(x2, y2, z2);
        if (iTrunkBlockId == this.woodType.woodBlockID) {
            this.setBlockAndMetadata(world, x2, y2, z2, this.woodType.stumpBlockID, this.woodType.stumpMetadata, isWorldGen);
        }
    }

    private void growLeaves(aab world, int x2, int y2, int z2, int par5, Random rand, boolean isWorldGen) {
        int var7 = 2;
        for (int k = z2 - var7; k <= z2; ++k) {
            int zDist = k - z2;
            int var10 = par5 + 1 - zDist;
            for (int i2 = x2 - var10; i2 <= x2 + var10 + 1; ++i2) {
                int xDist = i2 - x2;
                for (int j2 = y2 - var10; j2 <= y2 + var10 + 1; ++j2) {
                    int var15;
                    apa block;
                    int yDist = j2 - y2;
                    if (xDist < 0 && yDist < 0 && xDist * xDist + yDist * yDist > var10 * var10 || (xDist > 0 || yDist > 0) && xDist * xDist + yDist * yDist > (var10 + 1) * (var10 + 1) || rand.nextInt(4) == 0 && xDist * xDist + yDist * yDist > (var10 - 1) * (var10 - 1) || (block = apa.r[var15 = world.a(i2, k, j2)]) != null && !block.isLeafBlock(world, i2, k, j2)) continue;
                    this.setBlockAndMetadata(world, i2, k, j2, this.woodType.leavesBlockID, this.woodType.leavesMetadata, isWorldGen);
                }
            }
        }
    }
}

