/*
 * Decompiled with CFR 0.152.
 */
package btw.world.chunk;

import btw.world.chunk.ChunkTracker;
import java.util.ArrayList;
import java.util.List;

class ChunkTrackerEntry {
    private final ChunkTracker chunkTracker;
    public final zu coord;
    private final List<jc> playersWatching = new ArrayList<jc>();
    private short[] locationsRequiringClientUpdate = new short[64];
    private int numLocationsRequiringClientUpdate = 0;
    private int verticalChunksToUpdatePlayersBitfield;

    public ChunkTrackerEntry(ChunkTracker chunkTracker, int iChunkX, int iChunkZ) {
        this.chunkTracker = chunkTracker;
        this.coord = new zu(iChunkX, iChunkZ);
        chunkTracker.worldServer.b.c(iChunkX, iChunkZ);
    }

    public void addPlayerWatching(jc player) {
        if (this.playersWatching.contains(player)) {
            throw new IllegalStateException("Failed to add player. " + player + " already is in chunk " + this.coord.a + ", " + this.coord.b);
        }
        this.playersWatching.add(player);
        player.chunksToBeSentToClient.add(this.coord);
    }

    public boolean requiresClientUpdate() {
        return this.numLocationsRequiringClientUpdate > 0;
    }

    public void removePlayerWatching(jc player) {
        if (this.playersWatching.contains(player)) {
            player.a.sendPacket(new dt(this.chunkTracker.worldServer.e(this.coord.a, this.coord.b), true, 0));
            this.playersWatching.remove(player);
            player.chunksToBeSentToClient.remove(this.coord);
            if (this.playersWatching.isEmpty()) {
                this.chunkTracker.removeChunkFromTracker(this);
            }
        }
    }

    private short getBitEncodingForLocalPos(int iLocalX, int iLocalY, int iLocalZ) {
        return (short)(iLocalX << 12 | iLocalZ << 8 | iLocalY);
    }

    public void flagBlockForUpdate(int iLocalX, int iLocalY, int iLocalZ) {
        this.verticalChunksToUpdatePlayersBitfield |= 1 << (iLocalY >> 4);
        if (this.numLocationsRequiringClientUpdate < 64) {
            short sBitCode = this.getBitEncodingForLocalPos(iLocalX, iLocalY, iLocalZ);
            for (int iTempIndex = 0; iTempIndex < this.numLocationsRequiringClientUpdate; ++iTempIndex) {
                if (this.locationsRequiringClientUpdate[iTempIndex] != sBitCode) continue;
                return;
            }
            this.locationsRequiringClientUpdate[this.numLocationsRequiringClientUpdate++] = sBitCode;
        }
    }

    private void sendToPlayersWatchingNotWaitingFullChunk(ei packet) {
        for (int iTempCount = 0; iTempCount < this.playersWatching.size(); ++iTempCount) {
            jc tempPlayer = this.playersWatching.get(iTempCount);
            if (tempPlayer.chunksToBeSentToClient.contains(this.coord)) continue;
            tempPlayer.a.sendPacket(packet);
        }
    }

    public void sendUpdatesToWatchingPlayers() {
        if (this.numLocationsRequiringClientUpdate != 0) {
            int iOffsetX = this.coord.a * 16;
            int iOffsetZ = this.coord.b * 16;
            if (this.numLocationsRequiringClientUpdate == 1) {
                int iBlockX = iOffsetX + (this.locationsRequiringClientUpdate[0] >> 12 & 0xF);
                int iBlockY = this.locationsRequiringClientUpdate[0] & 0xFF;
                int iBlockZ = iOffsetZ + (this.locationsRequiringClientUpdate[0] >> 8 & 0xF);
                this.sendToPlayersWatchingNotWaitingFullChunk((ei)new fp(iBlockX, iBlockY, iBlockZ, (aab)this.chunkTracker.worldServer));
                if (this.chunkTracker.worldServer.d(iBlockX, iBlockY, iBlockZ)) {
                    this.sendTileEntityToPlayersWatchingChunk(this.chunkTracker.worldServer.r(iBlockX, iBlockY, iBlockZ));
                }
            } else if (this.numLocationsRequiringClientUpdate == 64) {
                this.sendToPlayersWatchingNotWaitingFullChunk(new dt(this.chunkTracker.worldServer.e(this.coord.a, this.coord.b), false, this.verticalChunksToUpdatePlayersBitfield));
                for (int iTempVerticalChunk = 0; iTempVerticalChunk < 16; ++iTempVerticalChunk) {
                    if ((this.verticalChunksToUpdatePlayersBitfield & 1 << iTempVerticalChunk) == 0) continue;
                    int iTempY = iTempVerticalChunk << 4;
                    List tempTileEntities = this.chunkTracker.worldServer.c(iOffsetX, iTempY, iOffsetZ, iOffsetX + 16, iTempY + 16, iOffsetZ + 16);
                    for (int iTempCount = 0; iTempCount < tempTileEntities.size(); ++iTempCount) {
                        this.sendTileEntityToPlayersWatchingChunk((aqp)tempTileEntities.get(iTempCount));
                    }
                }
            } else {
                this.sendToPlayersWatchingNotWaitingFullChunk((ei)new cx(this.coord.a, this.coord.b, this.locationsRequiringClientUpdate, this.numLocationsRequiringClientUpdate, (aab)this.chunkTracker.worldServer));
                for (int iTempIndex = 0; iTempIndex < this.numLocationsRequiringClientUpdate; ++iTempIndex) {
                    int iBlockX = iOffsetX + (this.locationsRequiringClientUpdate[iTempIndex] >> 12 & 0xF);
                    int iBlockY = this.locationsRequiringClientUpdate[iTempIndex] & 0xFF;
                    int iBlockZ = iOffsetZ + (this.locationsRequiringClientUpdate[iTempIndex] >> 8 & 0xF);
                    if (!this.chunkTracker.worldServer.d(iBlockX, iBlockY, iBlockZ)) continue;
                    this.sendTileEntityToPlayersWatchingChunk(this.chunkTracker.worldServer.r(iBlockX, iBlockY, iBlockZ));
                }
            }
            this.numLocationsRequiringClientUpdate = 0;
            this.verticalChunksToUpdatePlayersBitfield = 0;
        }
    }

    private void sendTileEntityToPlayersWatchingChunk(aqp tileEntity) {
        ei packet = tileEntity.m();
        if (packet != null) {
            this.sendToPlayersWatchingNotWaitingFullChunk(packet);
        }
    }

    public zu getChunkLocation() {
        return this.coord;
    }

    public List getPlayersInChunk() {
        return this.playersWatching;
    }
}

