/*
 * Decompiled with CFR 0.152.
 */
package btw.world.chunk;

import btw.world.chunk.ChunkTrackerEntry;
import java.util.LinkedList;

public class ChunkTracker {
    public final iz worldServer;
    private final LinkedList<jc> playersTracked = new LinkedList();
    public final kv trackerEntriesMap = new kv();
    private final LinkedList<ChunkTrackerEntry> entriesRequiringClientUpdate = new LinkedList();
    private final int chunkViewDistance;
    private final int[][] offsetsXZ = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public ChunkTracker(iz world, int iChunkViewDistance) {
        if (iChunkViewDistance > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (iChunkViewDistance < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.chunkViewDistance = iChunkViewDistance;
        this.worldServer = world;
    }

    public void update() {
        acn provider;
        if (!this.entriesRequiringClientUpdate.isEmpty()) {
            for (ChunkTrackerEntry tempEntry : this.entriesRequiringClientUpdate) {
                tempEntry.sendUpdatesToWatchingPlayers();
            }
            this.entriesRequiringClientUpdate.clear();
        }
        if (this.playersTracked.isEmpty() && !(provider = this.worldServer.t).e()) {
            this.worldServer.b.a();
        }
    }

    public void flagBlockForClientUpdate(int i2, int j2, int k) {
        int iChunkX = i2 >> 4;
        int iChunkZ = k >> 4;
        ChunkTrackerEntry entry = this.getTrackerEntry(iChunkX, iChunkZ);
        if (entry != null) {
            if (!entry.requiresClientUpdate()) {
                this.entriesRequiringClientUpdate.add(entry);
            }
            entry.flagBlockForUpdate(i2 & 0xF, j2, k & 0xF);
        }
    }

    public void addPlayer(jc player) {
        int iPlayerChunkX = kx.c(player.u / 16.0);
        int iPlayerChunkZ = kx.c(player.w / 16.0);
        player.d = player.u;
        player.e = player.w;
        for (int iTempChunkX = iPlayerChunkX - this.chunkViewDistance; iTempChunkX <= iPlayerChunkX + this.chunkViewDistance; ++iTempChunkX) {
            for (int iTempChunkZ = iPlayerChunkZ - this.chunkViewDistance; iTempChunkZ <= iPlayerChunkZ + this.chunkViewDistance; ++iTempChunkZ) {
                this.getOrCreateTrackerEntry(iTempChunkX, iTempChunkZ).addPlayerWatching(player);
            }
        }
        this.playersTracked.add(player);
        this.filterChunksToBeSentToClient(player);
    }

    public void updateMovingPlayer(jc player) {
        double dDeltaManagedX = player.u - player.d;
        double dDeltaManagedZ = player.w - player.e;
        double dDistManagedSq = dDeltaManagedX * dDeltaManagedX + dDeltaManagedZ * dDeltaManagedZ;
        if (dDistManagedSq >= 64.0) {
            int iPlayerChunkX = kx.c(player.u / 16.0);
            int iPlayerChunkZ = kx.c(player.w / 16.0);
            int iManagedChunkX = kx.c(player.d / 16.0);
            int iManagedChunkZ = kx.c(player.e / 16.0);
            if (iManagedChunkX != iPlayerChunkX || iManagedChunkZ != iPlayerChunkZ) {
                ChunkTrackerEntry tempEntry;
                int iTempChunkZ;
                int iTempChunkX;
                for (iTempChunkX = iPlayerChunkX - this.chunkViewDistance; iTempChunkX <= iPlayerChunkX + this.chunkViewDistance; ++iTempChunkX) {
                    for (iTempChunkZ = iPlayerChunkZ - this.chunkViewDistance; iTempChunkZ <= iPlayerChunkZ + this.chunkViewDistance; ++iTempChunkZ) {
                        if (this.areWithinAxisDistance(iTempChunkX, iTempChunkZ, iManagedChunkX, iManagedChunkZ, this.chunkViewDistance)) continue;
                        tempEntry = this.getOrCreateTrackerEntry(iTempChunkX, iTempChunkZ);
                        tempEntry.addPlayerWatching(player);
                    }
                }
                for (iTempChunkX = iManagedChunkX - this.chunkViewDistance; iTempChunkX <= iManagedChunkX + this.chunkViewDistance; ++iTempChunkX) {
                    for (iTempChunkZ = iManagedChunkZ - this.chunkViewDistance; iTempChunkZ <= iManagedChunkZ + this.chunkViewDistance; ++iTempChunkZ) {
                        if (this.areWithinAxisDistance(iTempChunkX, iTempChunkZ, iPlayerChunkX, iPlayerChunkZ, this.chunkViewDistance) || (tempEntry = this.getTrackerEntry(iTempChunkX, iTempChunkZ)) == null) continue;
                        tempEntry.removePlayerWatching(player);
                    }
                }
                this.filterChunksToBeSentToClient(player);
                player.d = player.u;
                player.e = player.w;
            }
        }
    }

    public void removeChunkFromTracker(ChunkTrackerEntry entry) {
        zu coord = entry.coord;
        long lKey = this.computeTrackerEntryKey(coord.a, coord.b);
        this.trackerEntriesMap.d(lKey);
        if (entry.requiresClientUpdate()) {
            this.entriesRequiringClientUpdate.remove(this);
        }
        this.worldServer.b.b(coord.a, coord.b);
    }

    public void filterChunksToBeSentToClient(jc player) {
        int iPlayerChunkZ;
        LinkedList<zu> oldChunksList = player.chunksToBeSentToClient;
        player.chunksToBeSentToClient = new LinkedList();
        int iPlayerChunkX = kx.c(player.u / 16.0);
        ChunkTrackerEntry playerChunkEntry = this.getOrCreateTrackerEntry(iPlayerChunkX, iPlayerChunkZ = kx.c(player.w / 16.0));
        if (oldChunksList.contains(playerChunkEntry.getChunkLocation())) {
            player.chunksToBeSentToClient.add(playerChunkEntry.getChunkLocation());
        }
        for (int iTempDist = 1; iTempDist <= this.chunkViewDistance; ++iTempDist) {
            int iRunningChunkX = iPlayerChunkX - iTempDist;
            int iRunningChunkZ = iPlayerChunkZ - iTempDist;
            for (int iRunningSide = 0; iRunningSide < 4; ++iRunningSide) {
                int iSideWidth = iTempDist * 2 + 1;
                int iSideOffsetX = this.offsetsXZ[iRunningSide][0];
                int iSideOffsetZ = this.offsetsXZ[iRunningSide][1];
                for (int iTempCount = 0; iTempCount < iSideWidth - 1; ++iTempCount) {
                    ChunkTrackerEntry tempEntry = this.getOrCreateTrackerEntry(iRunningChunkX, iRunningChunkZ);
                    if (oldChunksList.contains(tempEntry.getChunkLocation())) {
                        player.chunksToBeSentToClient.add(tempEntry.getChunkLocation());
                    }
                    iRunningChunkX += iSideOffsetX;
                    iRunningChunkZ += iSideOffsetZ;
                }
            }
        }
    }

    public void removePlayer(jc player) {
        int iPlayerChunkX = kx.c(player.d / 16.0);
        int iPlayerChunkZ = kx.c(player.e / 16.0);
        for (int iTempChunkX = iPlayerChunkX - this.chunkViewDistance; iTempChunkX <= iPlayerChunkX + this.chunkViewDistance; ++iTempChunkX) {
            for (int iTempChunkZ = iPlayerChunkZ - this.chunkViewDistance; iTempChunkZ <= iPlayerChunkZ + this.chunkViewDistance; ++iTempChunkZ) {
                ChunkTrackerEntry tempEntry = this.getTrackerEntry(iTempChunkX, iTempChunkZ);
                if (tempEntry == null) continue;
                tempEntry.removePlayerWatching(player);
            }
        }
        this.playersTracked.remove(player);
    }

    public boolean isChunkWatchedByPlayerAndSentToClient(jc player, int iChunkX, int iChunkZ) {
        ChunkTrackerEntry entry = this.getTrackerEntry(iChunkX, iChunkZ);
        return entry != null && entry.getPlayersInChunk().contains(player) && !player.chunksToBeSentToClient.contains(entry.getChunkLocation());
    }

    private boolean areWithinAxisDistance(int iX1, int iZ1, int iX2, int iZ2, int iAxisDist) {
        int iDeltaX = iX1 - iX2;
        int iDeltaZ = iZ1 - iZ2;
        if (iDeltaX >= -iAxisDist && iDeltaX <= iAxisDist) {
            return iDeltaZ >= -iAxisDist && iDeltaZ <= iAxisDist;
        }
        return false;
    }

    public static int getFurthestViewableBlock(int iChunkViewDistance) {
        return iChunkViewDistance * 16 - 16;
    }

    public boolean isChunkBeingWatched(int iChunkX, int iChunkZ) {
        return this.getTrackerEntry(iChunkX, iChunkZ) != null;
    }

    private long computeTrackerEntryKey(int iChunkX, int iChunkZ) {
        return (long)iChunkX + Integer.MAX_VALUE | (long)iChunkZ + Integer.MAX_VALUE << 32;
    }

    private ChunkTrackerEntry getTrackerEntry(int iChunkX, int iChunkZ) {
        long lKey = this.computeTrackerEntryKey(iChunkX, iChunkZ);
        return (ChunkTrackerEntry)this.trackerEntriesMap.a(lKey);
    }

    private ChunkTrackerEntry getOrCreateTrackerEntry(int iChunkX, int iChunkZ) {
        ChunkTrackerEntry entry = this.getTrackerEntry(iChunkX, iChunkZ);
        if (entry == null) {
            entry = new ChunkTrackerEntry(this, iChunkX, iChunkZ);
            this.trackerEntriesMap.a(this.computeTrackerEntryKey(iChunkX, iChunkZ), entry);
        }
        return entry;
    }
}

