/*
 * Decompiled with CFR 0.152.
 */
package btw.util.status;

import btw.util.status.BTWStatusCategory;
import btw.util.status.StatusCategory;
import btw.util.status.StatusEffect;
import btw.util.status.StatusEffectBuilder;
import java.util.HashMap;
import java.util.Map;

public class PlayerStatusEffects {
    public static Map<StatusCategory, Map<Integer, StatusEffect>> STATUS_EFFECT_LIST = new HashMap<StatusCategory, Map<Integer, StatusEffect>>();
    public static final StatusEffect GLOOM = PlayerStatusEffects.createGloomEffect(1, "gloom").build();
    public static final StatusEffect DREAD = PlayerStatusEffects.createGloomEffect(2, "dread").build();
    public static final StatusEffect TERROR = PlayerStatusEffects.createGloomEffect(3, "terror").build();
    public static final int HUNGER_SCALAR = 6;
    public static final int HUNGER_EFFECT_START = 24;
    public static final StatusEffect PECKISH = PlayerStatusEffects.createHungerEffect(1, 1.0f, "peckish").build();
    public static final StatusEffect HUNGRY = PlayerStatusEffects.createHungerEffect(2, 0.75f, "hungry").build();
    public static final StatusEffect FAMISHED = PlayerStatusEffects.createHungerEffect(3, 0.5f, "famished").setPreventsJumping().build();
    public static final StatusEffect EMACIATED = PlayerStatusEffects.createHungerEffect(4, 0.25f, "emaciated").setPreventsJumping().build();
    public static final StatusEffect STARVING = PlayerStatusEffects.createHungerEffect(5, 0.25f, "starving").setPreventsJumping().setPotionEffect(mk.k.c(), 0).build();
    public static final int HEALTH_SCALAR = 2;
    public static final int HEALTH_EFFECT_START = 10;
    public static final StatusEffect HURT = PlayerStatusEffects.createHealthEffect(1, 1.0f, "hurt").build();
    public static final StatusEffect INJURED = PlayerStatusEffects.createHealthEffect(2, 0.75f, "injured").build();
    public static final StatusEffect WOUNDED = PlayerStatusEffects.createHealthEffect(3, 0.5f, "wounded").build();
    public static final StatusEffect CRIPPLED = PlayerStatusEffects.createHealthEffect(4, 0.25f, "crippled").setPreventsJumping().build();
    public static final StatusEffect DYING = PlayerStatusEffects.createHealthEffect(5, 0.25f, "dying").setPreventsJumping().setPotionEffect(mk.q.c(), 0).build();
    public static final int FAT_SCALAR = 2;
    public static final int FAT_EFFECT_START = 12;
    public static final StatusEffect PLUMP = PlayerStatusEffects.createFatEffect(1, 1.0f, "plump").build();
    public static final StatusEffect CHUBBY = PlayerStatusEffects.createFatEffect(2, 0.75f, "chubby").build();
    public static final StatusEffect FAT = PlayerStatusEffects.createFatEffect(3, 0.5f, "fat").build();
    public static final StatusEffect OBESE = PlayerStatusEffects.createFatEffect(4, 0.25f, "obese").setPreventsJumping().build();

    private static StatusEffectBuilder createGloomEffect(int level, String name) {
        return new StatusEffectBuilder(level, BTWStatusCategory.GLOOM).setEffectivenessMultiplier(0.5f).setAffectsMiningSpeed().setAffectsMovement().setEffectsMultiplicative().setUnlocalizedName(BTWStatusCategory.GLOOM.getName(), name).setEvaluator(player -> player.getGloomLevel() == level);
    }

    private static StatusEffectBuilder createHungerEffect(int level, float effectivenessMultiplier, String name) {
        return PlayerStatusEffects.createExhaustionEffect(level, BTWStatusCategory.HUNGER, effectivenessMultiplier, name).setEvaluator(player -> {
            if (player.ce.d) {
                return false;
            }
            int hungerStart = 24 - player.q.getDifficulty().getStatusEffectOffset();
            int maxHunger = hungerStart - player.q.getDifficulty().getStatusEffectStageGap() * 6 * (level - 1);
            int minHunger = hungerStart - player.q.getDifficulty().getStatusEffectStageGap() * 6 * level;
            int hungerLevel = player.bN.a();
            return maxHunger >= hungerLevel && minHunger < hungerLevel;
        });
    }

    private static StatusEffectBuilder createHealthEffect(int level, float effectivenessMultiplier, String name) {
        return PlayerStatusEffects.createExhaustionEffect(level, BTWStatusCategory.HEALTH, effectivenessMultiplier, name).setEvaluator(player -> {
            if (player.ce.d) {
                return false;
            }
            int healthStart = 10 - player.q.getDifficulty().getStatusEffectOffset();
            int maxHealth = healthStart - player.q.getDifficulty().getStatusEffectStageGap() * 2 * (level - 1);
            int minHealth = healthStart - player.q.getDifficulty().getStatusEffectStageGap() * 2 * level;
            int healthLevel = player.aX();
            return maxHealth >= healthLevel && minHealth < healthLevel;
        });
    }

    private static StatusEffectBuilder createFatEffect(int level, float effectivenessMultiplier, String name) {
        return PlayerStatusEffects.createExhaustionEffect(level, BTWStatusCategory.FAT, effectivenessMultiplier, name).setEvaluator(player -> {
            if (player.ce.d) {
                return false;
            }
            float fatStart = 12 + player.q.getDifficulty().getStatusEffectOffset();
            float maxFat = fatStart + (float)(player.q.getDifficulty().getStatusEffectStageGap() * 2 * (level - 1));
            float minFat = fatStart + (float)(player.q.getDifficulty().getStatusEffectStageGap() * 2 * level);
            float fatLevel = player.bN.e();
            return maxFat >= fatLevel && minFat < fatLevel;
        });
    }

    private static StatusEffectBuilder createExhaustionEffect(int level, StatusCategory category, float effectivenessMultiplier, String name) {
        return new StatusEffectBuilder(level, category).setEffectivenessMultiplier(effectivenessMultiplier).setAffectsAttackDamage().setAffectsMiningSpeed().setAffectsMovement().setPreventsSprinting().setUnlocalizedName(category.getName(), name);
    }
}

