/*
 * Decompiled with CFR 0.152.
 */
package btw.util.hardcorespawn;

import btw.util.hardcorespawn.SpawnLocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpawnLocationList {
    public List spawnLocations = new ArrayList();

    public void loadFromNBT(ca tagList) {
        this.spawnLocations.clear();
        for (int iTempCount = 0; iTempCount < tagList.c(); ++iTempCount) {
            bs tempCompound = (bs)tagList.b(iTempCount);
            SpawnLocation newPoint = new SpawnLocation(tempCompound);
            this.spawnLocations.add(newPoint);
        }
    }

    public ca saveToNBT() {
        ca tagList = new ca("SpawnLocations");
        Iterator tempIterator = this.spawnLocations.iterator();
        while (tempIterator.hasNext()) {
            bs tempTagCompound = new bs();
            SpawnLocation tempPoint = (SpawnLocation)tempIterator.next();
            tempPoint.writeToNBT(tempTagCompound);
            tagList.a((cf)tempTagCompound);
        }
        return tagList;
    }

    public void addPoint(int iIPos, int iJPos, int iKPos, long lSpawnTime) {
        SpawnLocation newPoint = new SpawnLocation(iIPos, iJPos, iKPos, lSpawnTime);
        this.spawnLocations.add(newPoint);
    }

    public SpawnLocation getClosestSpawnLocationForPosition(double dXPos, double dZPos) {
        SpawnLocation closestLocation = null;
        double dClosestDistSq = 0.0;
        for (SpawnLocation tempPoint : this.spawnLocations) {
            double dDeltaI = (double)tempPoint.posX - dXPos;
            double dDeltaK = (double)tempPoint.posZ - dZPos;
            double dTempDistSq = dDeltaI * dDeltaI + dDeltaK * dDeltaK;
            if (closestLocation != null && !(dTempDistSq < dClosestDistSq)) continue;
            closestLocation = tempPoint;
            dClosestDistSq = dTempDistSq;
        }
        return closestLocation;
    }

    public SpawnLocation getMostRecentSpawnLocation() {
        SpawnLocation mostRecent = null;
        for (SpawnLocation tempPoint : this.spawnLocations) {
            if (mostRecent != null && tempPoint.spawnTime <= mostRecent.spawnTime) continue;
            mostRecent = tempPoint;
        }
        return mostRecent;
    }

    public boolean doesListContainPoint(int iIPos, int iJPos, int iKPos, long lSpawnTime) {
        for (SpawnLocation tempPoint : this.spawnLocations) {
            if (tempPoint.posX != iIPos || tempPoint.posZ != iKPos || tempPoint.posY != iJPos || tempPoint.spawnTime != lSpawnTime) continue;
            return true;
        }
        return false;
    }

    public void addPointIfNotAlreadyPresent(int iIPos, int iJPos, int iKPos, long lSpawnTime) {
        if (!this.doesListContainPoint(iIPos, iJPos, iKPos, lSpawnTime)) {
            this.addPoint(iIPos, iJPos, iKPos, lSpawnTime);
        }
    }
}

