/*
 * Decompiled with CFR 0.152.
 */
package btw.util.hardcorespawn;

import btw.BTWMod;
import btw.util.hardcorespawn.SpawnLocation;
import btw.world.util.WorldUtils;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;

public class HardcoreSpawnUtils {
    public static final int HARDCORE_SPAWN_TIME_BETWEEN_REASSIGNMENTS = 10800;
    private static final double BASE_RADIUS = 2000.0;
    private static final double BASE_EXCLUSION_RADIUS = 1000.0;
    private static final double RAPID_RESPAWN_RADIUS = 100.0;
    private static final double ABANDONED_VILLAGE_RADIUS = 2250.0;
    private static final double PARTIALLY_ABADONED_VILLAGE_RADIUS = 3000.0;
    private static final double LOOTED_TEMPLE_RADIUS = 2250.0;
    private static final double LARGE_BIOMES_MULTIPLIER = 4.0;
    private static final int SPAWN_ATTEMPT_COUNT = 20;
    public static ArrayList<aav> blacklistedBiomes = new ArrayList();

    public static double getPlayerSpawnRadius(aab world) {
        return 2000.0 * HardcoreSpawnUtils.getWorldTypeRadiusMultiplier(world) * HardcoreSpawnUtils.getGameProgressRadiusMultiplier(world);
    }

    public static double getPlayerSpawnExclusionRadius(aab world) {
        return 1000.0 * HardcoreSpawnUtils.getWorldTypeRadiusMultiplier(world);
    }

    public static double getPlayerMultipleRespawnRadius() {
        return 100.0;
    }

    public static double getAbandonedVillageRadius(aab world) {
        return 2250.0 * HardcoreSpawnUtils.getWorldTypeRadiusMultiplier(world) * HardcoreSpawnUtils.getWorldDifficultyRadiusMultiplier(world);
    }

    public static double getPartiallyAbandonedVillageRadius(aab world) {
        return 3000.0 * HardcoreSpawnUtils.getWorldTypeRadiusMultiplier(world) * HardcoreSpawnUtils.getWorldDifficultyRadiusMultiplier(world);
    }

    public static double getLootedTempleRadius(aab world) {
        return 2250.0 * HardcoreSpawnUtils.getWorldTypeRadiusMultiplier(world) * HardcoreSpawnUtils.getWorldDifficultyRadiusMultiplier(world);
    }

    public static double getWorldTypeRadiusMultiplier(aab world) {
        if (world.x.u() == aal.d && BTWMod.increaseLargeBiomeHCS) {
            return 4.0;
        }
        return 1.0;
    }

    public static double getWorldDifficultyRadiusMultiplier(aab world) {
        return world.x.getDifficulty().getAbandonmentRangeMultiplier();
    }

    public static double getGameProgressRadiusMultiplier(aab world) {
        if (!world.x.getDifficulty().shouldHCSRangeIncrease()) {
            return 1.0;
        }
        if (WorldUtils.gameProgressHasEndDimensionBeenAccessedServerOnly()) {
            return 2.5;
        }
        if (WorldUtils.gameProgressHasWitherBeenSummonedServerOnly()) {
            return 2.0;
        }
        if (WorldUtils.gameProgressHasNetherBeenAccessedServerOnly()) {
            return 1.5;
        }
        return 1.0;
    }

    public static void handleHardcoreSpawn(MinecraftServer server, jc oldPlayer, jc newPlayer) {
        long lDeltaTime;
        SpawnLocation recentLocation;
        iz newWorld = server.a(newPlayer.ar);
        if (oldPlayer.j) {
            HardcoreSpawnUtils.returnPlayerToOriginalSpawn(newWorld, newPlayer);
            return;
        }
        long overworldTime = WorldUtils.getOverworldTimeServerOnly();
        long timeOfLastPlayerSpawnAssignment = oldPlayer.timeOfLastSpawnAssignment;
        long deltaTimeSinceLastRespawnAssignment = overworldTime - timeOfLastPlayerSpawnAssignment;
        boolean softRespawn = false;
        if (timeOfLastPlayerSpawnAssignment > 0L && deltaTimeSinceLastRespawnAssignment >= 0L && deltaTimeSinceLastRespawnAssignment < 10800L) {
            softRespawn = true;
            newPlayer.aS = 10;
            int foodLevel = oldPlayer.bN.a();
            if ((foodLevel -= 6) < 24) {
                foodLevel = 24;
            }
            newPlayer.bN.a(foodLevel);
        }
        if (!softRespawn) {
            int deathCountForItemDestruction = newWorld.getDifficulty().getDeathCountBeforeItemDestruction();
            if (deathCountForItemDestruction > -1 && newPlayer.deathCount >= deathCountForItemDestruction) {
                newPlayer.a(bp.a().a("message.death.itemsDestroyed"));
            }
            ++newPlayer.deathCount;
            newPlayer.lastDeathDimension = oldPlayer.ar;
            newPlayer.lastDeathLocationX = kx.c(oldPlayer.u);
            newPlayer.lastDeathLocationY = kx.c(oldPlayer.E.b);
            newPlayer.lastDeathLocationZ = kx.c(oldPlayer.w);
        }
        if ((!WorldUtils.gameProgressHasNetherBeenAccessedServerOnly() || BTWMod.alwaysSpawnTogether) && (recentLocation = newWorld.getSpawnLocationList().getMostRecentSpawnLocation()) != null && (lDeltaTime = overworldTime - recentLocation.spawnTime) > 0L && lDeltaTime < 10800L && HardcoreSpawnUtils.assignPlayerToOldSpawnPosWithVariance(newWorld, newPlayer, new t(recentLocation.posX, recentLocation.posY, recentLocation.posZ), recentLocation.spawnTime)) {
            return;
        }
        t oldSpawnPos = oldPlayer.hardcoreSpawnChunk;
        if (!(oldSpawnPos != null && softRespawn && HardcoreSpawnUtils.assignPlayerToOldSpawnPosWithVariance(newWorld, newPlayer, oldSpawnPos, timeOfLastPlayerSpawnAssignment) || HardcoreSpawnUtils.assignNewHardcoreSpawnLocation(newWorld, server, newPlayer))) {
            HardcoreSpawnUtils.returnPlayerToOriginalSpawn(newWorld, newPlayer);
            return;
        }
        t newSpawnPos = newPlayer.hardcoreSpawnChunk;
        if (newSpawnPos != null) {
            newWorld.getSpawnLocationList().addPointIfNotAlreadyPresent(newSpawnPos.a, newSpawnPos.b, newSpawnPos.c, newPlayer.timeOfLastSpawnAssignment);
        }
    }

    public static boolean assignNewHardcoreSpawnLocation(aab world, MinecraftServer server, jc player) {
        boolean locationFound = false;
        boolean blacklistedLocationFound = false;
        double spawnRadius = HardcoreSpawnUtils.getPlayerSpawnRadius(world);
        double exclusionRadius = HardcoreSpawnUtils.getPlayerSpawnExclusionRadius(world);
        double spawnDeltaRadius = spawnRadius - exclusionRadius;
        double exclusionRadiusSq = exclusionRadius * exclusionRadius;
        double deltaSquaredRadii = spawnRadius * spawnRadius - exclusionRadiusSq;
        for (int attempts = 0; attempts < 20; ++attempts) {
            t newSpawnPos;
            aif targetMaterial;
            double spawnDistance = Math.sqrt(world.s.nextDouble() * deltaSquaredRadii + exclusionRadiusSq);
            double spawnYaw = world.s.nextDouble() * Math.PI * 2.0;
            double xOffset = -Math.sin(spawnYaw) * spawnDistance;
            double zOffset = Math.cos(spawnYaw) * spawnDistance;
            int newSpawnX = kx.c(xOffset) + world.x.c();
            int newSpawnZ = kx.c(zOffset) + world.x.e();
            int newSpawnY = world.i(newSpawnX, newSpawnZ);
            aav respawnBiome = world.a(newSpawnX, newSpawnZ);
            if (blacklistedLocationFound) continue;
            boolean isBiomeBlacklisted = blacklistedBiomes.contains(respawnBiome);
            if (newSpawnY < world.t.i() || (targetMaterial = world.g(newSpawnX, newSpawnY, newSpawnZ)) != null && targetMaterial.d()) continue;
            player.b((double)newSpawnX + 0.5, (double)newSpawnY + 1.5, (double)newSpawnZ + 0.5, world.s.nextFloat() * 360.0f, 0.0f);
            HardcoreSpawnUtils.bumpPlayerPosUpwardsUntilValidSpawnReached(player);
            long overworldTime = WorldUtils.getOverworldTimeServerOnly();
            if (BTWMod.isSinglePlayerNonLan() || MinecraftServer.D().y() == 0) {
                overworldTime = (overworldTime / 24000L + 1L) * 24000L;
                for (int i2 = 0; i2 < MinecraftServer.D().b.length; ++i2) {
                    iz tempServer = MinecraftServer.D().b[i2];
                    tempServer.b(overworldTime);
                    if (!tempServer.x.n()) continue;
                    tempServer.x.a(false);
                    server.ad().a((ei)new dp(8, 0));
                }
            }
            player.timeOfLastSpawnAssignment = overworldTime;
            player.hardcoreSpawnChunk = newSpawnPos = new t(kx.c(player.u), kx.c(player.v), kx.c(player.w));
            if (isBiomeBlacklisted) {
                blacklistedLocationFound = true;
                continue;
            }
            locationFound = true;
            break;
        }
        return locationFound || blacklistedLocationFound;
    }

    private static boolean assignPlayerToOldSpawnPosWithVariance(aab world, jc player, t spawnPos, long timeOfLastPlayerSpawnAssignment) {
        for (int i2 = 0; i2 < 20; ++i2) {
            aif targetMaterial;
            int newSpawnZ;
            double spawnDistance = Math.sqrt(world.s.nextDouble()) * HardcoreSpawnUtils.getPlayerMultipleRespawnRadius();
            double spawnYaw = world.s.nextDouble() * Math.PI * 2.0;
            double xOffset = -Math.sin(spawnYaw) * spawnDistance;
            double zOffset = Math.cos(spawnYaw) * spawnDistance;
            int newSpawnX = kx.c(xOffset) + spawnPos.a;
            int newSpawnY = world.i(newSpawnX, newSpawnZ = kx.c(zOffset) + spawnPos.c);
            if (newSpawnY < world.t.i() || (targetMaterial = world.g(newSpawnX, newSpawnY, newSpawnZ)) != null && targetMaterial.d()) continue;
            player.b((double)newSpawnX + 0.5, (double)newSpawnY + 1.5, (double)newSpawnZ + 0.5, world.s.nextFloat() * 360.0f, 0.0f);
            HardcoreSpawnUtils.bumpPlayerPosUpwardsUntilValidSpawnReached(player);
            player.timeOfLastSpawnAssignment = timeOfLastPlayerSpawnAssignment;
            player.hardcoreSpawnChunk = spawnPos;
            return true;
        }
        return HardcoreSpawnUtils.assignPlayerToOldSpawnPos(world, player, spawnPos, timeOfLastPlayerSpawnAssignment);
    }

    private static boolean assignPlayerToOldSpawnPos(aab world, jc player, t spawnPos, long timeOfLastPlayerSpawnAssignment) {
        int spawnX = kx.c((double)spawnPos.a);
        int spawnY = kx.c((double)spawnPos.c);
        int spawnZ = world.i(spawnX, spawnY);
        player.b((float)spawnX + 0.5f, (float)spawnZ + 1.5f, (float)spawnY + 0.5f, world.s.nextFloat() * 360.0f, 0.0f);
        aif targetMaterial = world.g(spawnX, spawnZ + 1, spawnY);
        if (HardcoreSpawnUtils.offsetPlayerPositionUntilValidSpawn(world, player)) {
            t newSpawnPos;
            HardcoreSpawnUtils.bumpPlayerPosUpwardsUntilValidSpawnReached(player);
            player.timeOfLastSpawnAssignment = timeOfLastPlayerSpawnAssignment;
            player.hardcoreSpawnChunk = newSpawnPos = new t(kx.c(player.u), kx.c(player.v), kx.c(player.w));
            return true;
        }
        return false;
    }

    private static boolean offsetPlayerPositionUntilValidSpawn(aab world, jc player) {
        int spawnX = kx.c(player.u);
        int spawnZ = kx.c(player.w);
        for (int i2 = 0; i2 < 20; ++i2) {
            int spawnY = world.i(spawnX, spawnZ);
            aif targetMaterial = world.g(spawnX, spawnY, spawnZ);
            if (targetMaterial == null || !targetMaterial.d()) {
                player.b((double)spawnX + 0.5, player.v, (double)spawnZ + 0.5, player.A, player.B);
                return true;
            }
            spawnX += world.s.nextInt(11) - 5;
            spawnZ += world.s.nextInt(11) - 5;
        }
        return false;
    }

    private static void returnPlayerToOriginalSpawn(aab world, jc player) {
        t spawnPos = world.J();
        int spawnX = spawnPos.a;
        int spawnY = spawnPos.b;
        int spawnZ = spawnPos.c;
        if (!world.t.f && world.M().r() != aaj.d) {
            spawnY = world.i(spawnX += world.s.nextInt(20) - 10, spawnZ);
            spawnZ += world.s.nextInt(20) - 10;
        }
        player.b((double)spawnX + 0.5, (double)spawnY + 1.5, (double)spawnZ + 0.5, 0.0f, 0.0f);
        HardcoreSpawnUtils.bumpPlayerPosUpwardsUntilValidSpawnReached(player);
        player.timeOfLastSpawnAssignment = 0L;
        player.hardcoreSpawnChunk = null;
    }

    private static void bumpPlayerPosUpwardsUntilValidSpawnReached(jc player) {
        while (!(player.v <= 0.0)) {
            player.b(player.u, player.v, player.w, player.A, player.B);
            if (player.q.a((mp)player, player.E).isEmpty()) break;
            player.v += 1.0;
        }
    }

    public static boolean isInLootedTempleRadius(aab world, int x2, int z2) {
        double lootedRadius;
        int spawnZ;
        double deltaZ;
        int spawnX = world.M().c();
        double deltaX = spawnX - x2;
        double distSqFromSpawn = deltaX * deltaX + (deltaZ = (double)((spawnZ = world.M().e()) - z2)) * deltaZ;
        return distSqFromSpawn < (lootedRadius = HardcoreSpawnUtils.getLootedTempleRadius(world)) * lootedRadius;
    }

    static {
        blacklistedBiomes.add(aav.w);
        blacklistedBiomes.add(aav.x);
        blacklistedBiomes.add(aav.b);
        blacklistedBiomes.add(aav.l);
        blacklistedBiomes.add(aav.i);
    }
}

