/*
 * Decompiled with CFR 0.152.
 */
package btw.util;

import btw.block.BTWBlocks;
import btw.block.util.BlockState;
import btw.world.util.BlockPos;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Schematic {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    private Map<Integer, BlockState> blockMap;
    private List<bs> entities;
    private List<bs> tileEntities;

    private Schematic() {
    }

    public Schematic(bs tag) {
        this.loadFromNBT(tag);
    }

    public void loadFromNBT(bs tag) {
        this.sizeX = tag.d("Width");
        this.sizeY = tag.d("Height");
        this.sizeZ = tag.d("Length");
        byte[] blockIDs = tag.j("Blocks");
        byte[] blockIDAdd = tag.j("AddBlocks");
        byte[] metadata = tag.j("Data");
        this.processBlockData(blockIDs, blockIDAdd, metadata);
        bs entityTag = tag.l("Entities");
        this.processEntityData(entityTag);
        bs tileEntityTag = tag.l("TileEntities");
        this.processTileEntityData(tileEntityTag);
    }

    protected void processBlockData(byte[] blockIDs, byte[] blockIDsAdd, byte[] metadata) {
        int i2;
        int size = blockIDs.length;
        int[] blockIDsFull = new int[size];
        for (i2 = 0; i2 < size; ++i2) {
            byte blockIDAdd = blockIDsAdd[i2 / 2];
            blockIDAdd = i2 % 2 == 0 ? (byte)(blockIDAdd >> 4) : (byte)(blockIDAdd & 0xF);
            blockIDsFull[i2] = blockIDAdd << 8 + blockIDs[i2];
        }
        for (i2 = 0; i2 < size; ++i2) {
            this.blockMap.put(i2, new BlockState(blockIDsFull[i2], metadata[i2]));
        }
    }

    protected void putBlockAtCoords(int x2, int y2, int z2, BlockState blockState) {
        this.blockMap.put(this.getIndexForCoords(x2, y2, z2), blockState);
    }

    protected void processEntityData(bs tag) {
        Collection entityTags = tag.c();
        for (bs entity : entityTags) {
            this.entities.add(entity);
        }
    }

    protected void processTileEntityData(bs tag) {
        Collection tileEntityTags = tag.c();
        for (bs tileEntity : tileEntityTags) {
            this.tileEntities.add(tileEntity);
        }
    }

    public void addSchematicToWorld(aab world, int x2, int y2, int z2) {
        for (int index : this.blockMap.keySet()) {
            BlockPos pos = this.getCoordsForIndex(index);
            int i2 = x2 + pos.x;
            int j2 = y2 + pos.y;
            int k = z2 + pos.z;
            BlockState blockState = this.blockMap.get(index);
            int id = blockState.id;
            int metadata = blockState.metadata;
            if (id == 0) continue;
            if (id == BTWBlocks.structureVoid.cz) {
                id = 0;
            }
            world.setBlockAndMetadata(i2, j2, k, id, metadata);
        }
        for (bs tag : this.entities) {
            mv.a(tag, world);
        }
        for (bs tag : this.tileEntities) {
            aqp.c(tag);
        }
    }

    public Schematic copy() {
        Schematic schematic = new Schematic();
        schematic.sizeX = this.sizeX;
        schematic.sizeY = this.sizeY;
        schematic.sizeZ = this.sizeZ;
        HashMap<Integer, BlockState> newBlockMap = new HashMap<Integer, BlockState>();
        for (Map.Entry<Integer, BlockState> entry : this.blockMap.entrySet()) {
            newBlockMap.put(entry.getKey(), entry.getValue());
        }
        schematic.blockMap = newBlockMap;
        Collections.copy(schematic.entities, this.entities);
        Collections.copy(schematic.tileEntities, this.tileEntities);
        return schematic;
    }

    public void rotate(boolean clockwise) {
        this.rotate(clockwise, 1);
    }

    public void rotate(boolean clockwise, int count) {
    }

    public void mirror(boolean useXPlane) {
    }

    protected int getIndexForCoords(int x2, int y2, int z2) {
        return (y2 * this.sizeZ + z2) * this.sizeX + x2;
    }

    protected BlockPos getCoordsForIndex(int index) {
        int x2 = index % this.sizeX;
        int z2 = (index /= this.sizeX) % this.sizeZ;
        int y2 = index /= this.sizeZ;
        return new BlockPos(x2, y2, z2);
    }

    public BlockState getBlockAtCoords(int x2, int y2, int z2) {
        return this.blockMap.get(this.getIndexForCoords(x2, y2, z2));
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }
}

