/*
 * Decompiled with CFR 0.152.
 */
package btw.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static boolean hasCheckedForObfuscation = false;
    private static boolean isObfuscated = false;
    public static Map<Class, Class> boxedToPrimitiveTypeMap = new HashMap<Class, Class>();

    public static boolean isObfuscated() {
        if (hasCheckedForObfuscation) {
            return isObfuscated;
        }
        hasCheckedForObfuscation = true;
        return false;
    }

    public static void setObfuscated(boolean isObfuscated) {
        ReflectionUtils.isObfuscated = isObfuscated;
        hasCheckedForObfuscation = true;
    }

    public static Class<?> getPrimitiveFromBoxedClass(Class<?> type) {
        if (boxedToPrimitiveTypeMap.containsKey(type)) {
            return boxedToPrimitiveTypeMap.get(type);
        }
        return null;
    }

    public static Constructor findMatchingConstructor(Class<?> classForSearch, Class[] parameterTypes) {
        Constructor<?>[] constructors = classForSearch.getDeclaredConstructors();
        Constructor<?> constructorToUse = null;
        for (Constructor<?> c2 : constructors) {
            boolean constructorMatches = true;
            Class<?>[] cParamTypes = c2.getParameterTypes();
            if (cParamTypes.length == parameterTypes.length) {
                for (int j2 = 0; j2 < cParamTypes.length; ++j2) {
                    if (ReflectionUtils.doesParameterTypeSatisfyConstructorType(parameterTypes[j2], cParamTypes[j2])) continue;
                    constructorMatches = false;
                    break;
                }
            } else {
                constructorMatches = false;
            }
            if (!constructorMatches) continue;
            constructorToUse = c2;
            break;
        }
        return constructorToUse;
    }

    private static boolean doesParameterTypeSatisfyConstructorType(Class<?> parameterType, Class<?> constructorType) {
        if (parameterType.isPrimitive() && constructorType.isPrimitive()) {
            int pSize = ReflectionUtils.getPrimitiveSize(parameterType);
            int cSize = ReflectionUtils.getPrimitiveSize(constructorType);
            if (constructorType == Boolean.TYPE) {
                return parameterType.equals(Boolean.TYPE);
            }
            if (!ReflectionUtils.isFloatingPoint(constructorType) && ReflectionUtils.isFloatingPoint(parameterType)) {
                return false;
            }
            return pSize <= cSize;
        }
        return constructorType.isAssignableFrom(parameterType);
    }

    private static int getPrimitiveSize(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            throw new IllegalArgumentException("Expected a primitive but was passed " + primitive.getSimpleName());
        }
        if (primitive == Byte.TYPE || primitive == Character.TYPE) {
            return 8;
        }
        if (primitive == Short.TYPE) {
            return 16;
        }
        if (primitive == Integer.TYPE || primitive == Float.TYPE) {
            return 32;
        }
        return 64;
    }

    private static boolean isFloatingPoint(Class<?> primitive) {
        return primitive == Float.TYPE || primitive == Double.TYPE;
    }

    public static Class getClassByName(String name) {
        Class<?> c2 = null;
        try {
            c2 = ReflectionUtils.isObfuscated() ? Class.forName("net.minecraft.src." + name) : Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        return c2;
    }

    static {
        boxedToPrimitiveTypeMap.put(Byte.class, Byte.TYPE);
        boxedToPrimitiveTypeMap.put(Short.class, Short.TYPE);
        boxedToPrimitiveTypeMap.put(Integer.class, Integer.TYPE);
        boxedToPrimitiveTypeMap.put(Long.class, Long.TYPE);
        boxedToPrimitiveTypeMap.put(Float.class, Float.TYPE);
        boxedToPrimitiveTypeMap.put(Double.class, Double.TYPE);
        boxedToPrimitiveTypeMap.put(Character.class, Character.TYPE);
        boxedToPrimitiveTypeMap.put(Boolean.class, Boolean.TYPE);
    }
}

