/*
 * Decompiled with CFR 0.152.
 */
package btw.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.Spliterators;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RandomSelector<T> {
    private final T[] elements;
    private final ToIntFunction<Random> selection;

    public static <T> RandomSelector<T> uniform(Collection<T> elements) throws IllegalArgumentException {
        Objects.requireNonNull(elements, "collection must not be null");
        final int size = elements.size();
        Object[] els = elements.toArray(new Object[size]);
        return new RandomSelector<Object>(els, new ToIntFunction<Random>(){

            @Override
            public int applyAsInt(Random r2) {
                return r2.nextInt(size);
            }
        });
    }

    public static <T> RandomSelector<T> weighted(Collection<T> elements, ToDoubleFunction<? super T> weighter) throws IllegalArgumentException {
        int i2;
        Objects.requireNonNull(elements, "elements must not be null");
        Objects.requireNonNull(weighter, "weighter must not be null");
        int size = elements.size();
        Object[] elementArray = elements.toArray(new Object[size]);
        double totalWeight = 0.0;
        double[] discreteProbabilities = new double[size];
        for (i2 = 0; i2 < size; ++i2) {
            double weight;
            discreteProbabilities[i2] = weight = weighter.applyAsDouble(elementArray[i2]);
            totalWeight += weight;
        }
        i2 = 0;
        while (i2 < size) {
            int n = i2++;
            discreteProbabilities[n] = discreteProbabilities[n] / totalWeight;
        }
        return new RandomSelector<Object>(elementArray, new RandomWeightedSelection(discreteProbabilities));
    }

    RandomSelector(T[] elements, ToIntFunction<Random> selection) {
        this.elements = elements;
        this.selection = selection;
    }

    public T next(Random random) {
        return this.elements[this.selection.applyAsInt(random)];
    }

    public Stream<T> stream(Random random) {
        Objects.requireNonNull(random, "random must not be null");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new BaseIterator(random), 1040), false);
    }

    private static class RandomWeightedSelection
    implements ToIntFunction<Random> {
        private final double[] probabilities;
        private final int[] alias;

        RandomWeightedSelection(double[] probabilities) {
            int size = probabilities.length;
            double average = 1.0 / (double)size;
            int[] small = new int[size];
            int smallSize = 0;
            int[] large = new int[size];
            int largeSize = 0;
            for (int i2 = 0; i2 < size; ++i2) {
                if (probabilities[i2] < average) {
                    small[smallSize++] = i2;
                    continue;
                }
                large[largeSize++] = i2;
            }
            double[] pr2 = new double[size];
            int[] al = new int[size];
            this.probabilities = pr2;
            this.alias = al;
            while (largeSize != 0 && smallSize != 0) {
                int less = small[--smallSize];
                int more = large[--largeSize];
                pr2[less] = probabilities[less] * (double)size;
                al[less] = more;
                int n = more;
                probabilities[n] = probabilities[n] + (probabilities[less] - average);
                if (probabilities[more] < average) {
                    small[smallSize++] = more;
                    continue;
                }
                large[largeSize++] = more;
            }
            while (smallSize != 0) {
                pr2[small[--smallSize]] = 1.0;
            }
            while (largeSize != 0) {
                pr2[large[--largeSize]] = 1.0;
            }
        }

        @Override
        public int applyAsInt(Random random) {
            int column = random.nextInt(this.probabilities.length);
            return random.nextDouble() < this.probabilities[column] ? column : this.alias[column];
        }
    }

    private class BaseIterator
    implements Iterator<T> {
        private final Random random;

        BaseIterator(Random random) {
            this.random = random;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            return RandomSelector.this.next(this.random);
        }
    }
}

