/*
 * Decompiled with CFR 0.152.
 */
package btw.util;

import btw.block.util.RayTraceUtils;
import btw.util.PrimitiveGeometric;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

public class PrimitiveQuad
extends PrimitiveGeometric {
    private arc[] vertices = new arc[4];
    private float minUFrac = 0.0f;
    private float minVFrac = 0.0f;
    private float maxUFrac = 1.0f;
    private float maxVFrac = 1.0f;
    private int iconIndex = 0;
    private static final double MIND_THE_GAP = 1.0E-4;

    public PrimitiveQuad(arc vertex1, arc vertex2, arc vertex3, arc vertex4) {
        this.vertices[0] = vertex1;
        this.vertices[1] = vertex2;
        this.vertices[2] = vertex3;
        this.vertices[3] = vertex4;
    }

    @Override
    public void rotateAroundYToFacing(int iFacing) {
        this.vertices[0].rotateAsBlockPosAroundJToFacing(iFacing);
        this.vertices[1].rotateAsBlockPosAroundJToFacing(iFacing);
        this.vertices[2].rotateAsBlockPosAroundJToFacing(iFacing);
        this.vertices[3].rotateAsBlockPosAroundJToFacing(iFacing);
    }

    @Override
    public void tiltToFacingAlongY(int iFacing) {
        this.vertices[0].tiltAsBlockPosToFacingAlongJ(iFacing);
        this.vertices[1].tiltAsBlockPosToFacingAlongJ(iFacing);
        this.vertices[2].tiltAsBlockPosToFacingAlongJ(iFacing);
        this.vertices[3].tiltAsBlockPosToFacingAlongJ(iFacing);
    }

    @Override
    public void translate(double dDeltaX, double dDeltaY, double dDeltaZ) {
        this.vertices[0].c(dDeltaX, dDeltaY, dDeltaZ);
        this.vertices[1].c(dDeltaX, dDeltaY, dDeltaZ);
        this.vertices[2].c(dDeltaX, dDeltaY, dDeltaZ);
        this.vertices[3].c(dDeltaX, dDeltaY, dDeltaZ);
    }

    @Override
    public void addToRayTrace(RayTraceUtils rayTrace) {
        rayTrace.addQuadWithLocalCoordsToIntersectionList(this, this.vertices[0]);
    }

    @Override
    public PrimitiveQuad makeTemporaryCopy() {
        PrimitiveQuad newQuad = new PrimitiveQuad(arc.createVectorHelper(this.vertices[0]), arc.createVectorHelper(this.vertices[1]), arc.createVectorHelper(this.vertices[2]), arc.createVectorHelper(this.vertices[3]));
        newQuad.setUVFractions(this.minUFrac, this.minVFrac, this.maxUFrac, this.maxVFrac);
        newQuad.setIconIndex(this.iconIndex);
        return newQuad;
    }

    public boolean isPointOnPlaneWithinBounds(arc point) {
        arc minBounds = arc.createVectorHelper(this.vertices[0]);
        arc maxBounds = arc.createVectorHelper(this.vertices[0]);
        this.computeBounds(minBounds, maxBounds);
        return (maxBounds.c - minBounds.c < 1.0E-4 || point.c >= minBounds.c && point.c <= maxBounds.c) && (maxBounds.d - minBounds.d < 1.0E-4 || point.d >= minBounds.d && point.d <= maxBounds.d) && (maxBounds.e - minBounds.e < 1.0E-4 || point.e >= minBounds.e && point.e <= maxBounds.e);
    }

    public void computeBounds(arc min, arc max) {
        for (int iTempCount = 1; iTempCount <= 3; ++iTempCount) {
            arc tempPoint = this.vertices[iTempCount];
            if (tempPoint.c < min.c) {
                min.c = tempPoint.c;
            } else if (tempPoint.c > max.c) {
                max.c = tempPoint.c;
            }
            if (tempPoint.d < min.d) {
                min.d = tempPoint.d;
            } else if (tempPoint.d > max.d) {
                max.d = tempPoint.d;
            }
            if (tempPoint.e < min.e) {
                min.e = tempPoint.e;
                continue;
            }
            if (!(tempPoint.e > max.e)) continue;
            max.e = tempPoint.e;
        }
    }

    public arc computeNormal() {
        arc vec1 = this.vertices[0].subtractFrom(this.vertices[1]);
        arc vec2 = this.vertices[0].subtractFrom(this.vertices[3]);
        return vec1.c(vec2);
    }

    public PrimitiveQuad setUVFractions(float fMinUFrac, float fMinVFrac, float fMaxVFrac, float fMaxUFrac) {
        this.minUFrac = fMinUFrac;
        this.minVFrac = fMinVFrac;
        this.maxVFrac = fMaxVFrac;
        this.maxUFrac = fMaxUFrac;
        return this;
    }

    public PrimitiveQuad setIconIndex(int iIconIndex) {
        this.iconIndex = iIconIndex;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    private void addVertices(int i2, int j2, int k, lx icon) {
        double dUDelta = icon.f() - icon.e();
        double dVDelta = icon.h() - icon.g();
        double dMinU = (double)icon.e() + dUDelta * (double)this.minUFrac;
        double dMinV = (double)icon.g() + dVDelta * (double)this.minVFrac;
        double dMaxU = (double)icon.e() + dUDelta * (double)this.maxUFrac;
        double dMaxV = (double)icon.g() + dVDelta * (double)this.maxVFrac;
        bgd.a.a((double)i2 + this.vertices[0].c, (double)j2 + this.vertices[0].d, (double)k + this.vertices[0].e, dMinU, dMinV);
        bgd.a.a((double)i2 + this.vertices[1].c, (double)j2 + this.vertices[1].d, (double)k + this.vertices[1].e, dMinU, dMaxV);
        bgd.a.a((double)i2 + this.vertices[2].c, (double)j2 + this.vertices[2].d, (double)k + this.vertices[2].e, dMaxU, dMaxV);
        bgd.a.a((double)i2 + this.vertices[3].c, (double)j2 + this.vertices[3].d, (double)k + this.vertices[3].e, dMaxU, dMinV);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlock(bgf renderBlocks, apa block, int i2, int j2, int k) {
        lx icon = block.getIconByIndex(this.iconIndex);
        bgd.a.c(block.e(renderBlocks.a, i2, j2, k));
        bgd.a.a(1.0f, 1.0f, 1.0f);
        this.addVertices(i2, j2, k, icon);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockWithColorMultiplier(bgf renderBlocks, apa block, int i2, int j2, int k, float fRed, float fGreen, float fBlue) {
        lx icon = block.getIconByIndex(this.iconIndex);
        bgd.a.c(block.e(renderBlocks.a, i2, j2, k));
        bgd.a.a(fRed, fGreen, fBlue);
        this.addVertices(i2, j2, k, icon);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockWithTexture(bgf renderBlocks, apa block, int i2, int j2, int k, lx icon) {
        bgd.a.c(block.e(renderBlocks.a, i2, j2, k));
        bgd.a.a(1.0f, 1.0f, 1.0f);
        this.addVertices(i2, j2, k, icon);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean renderAsBlockFullBrightWithTexture(bgf renderBlocks, apa block, int i2, int j2, int k, lx icon) {
        bgd.a.c(renderBlocks.a.h(i2, j2, k, 15));
        bgd.a.a(1.0f, 1.0f, 1.0f);
        this.addVertices(i2, j2, k, icon);
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderAsItemBlock(bgf renderBlocks, apa block, int iItemDamage) {
        bgd tessellator = bgd.a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.b();
        arc normal = this.computeNormal().a();
        tessellator.b((float)normal.c, (float)normal.d, (float)normal.e);
        lx icon = block.getIconByIndex(this.iconIndex);
        double dUDelta = icon.f() - icon.e();
        double dVDelta = icon.h() - icon.g();
        double dMinU = (double)icon.e() + dUDelta * (double)this.minUFrac;
        double dMinV = (double)icon.g() + dVDelta * (double)this.minVFrac;
        double dMaxU = (double)icon.e() + dUDelta * (double)this.maxUFrac;
        double dMaxV = (double)icon.g() + dVDelta * (double)this.maxVFrac;
        tessellator.a(this.vertices[0].c, this.vertices[0].d, this.vertices[0].e, dMinU, dMinV);
        tessellator.a(this.vertices[1].c, this.vertices[1].d, this.vertices[1].e, dMinU, dMaxV);
        tessellator.a(this.vertices[2].c, this.vertices[2].d, this.vertices[2].e, dMaxU, dMaxV);
        tessellator.a(this.vertices[3].c, this.vertices[3].d, this.vertices[3].e, dMaxU, dMinV);
        tessellator.a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderAsFallingBlock(bgf renderBlocks, apa block, int i2, int j2, int k, int iMetadata) {
        this.renderAsBlock(renderBlocks, block, i2, j2, k);
    }
}

