/*
 * Decompiled with CFR 0.152.
 */
package btw.util;

import btw.block.BTWBlocks;
import btw.block.FluidSource;
import btw.block.blocks.ScrewPumpBlock;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.List;

public class MiscUtils {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TICKS_PER_MINUTE = 1200;
    public static final int TICKS_PER_GAME_DAY = 24000;

    public static int convertPlacingEntityOrientationToBlockFacingReversed(ng entityLiving) {
        float pitch = entityLiving.B;
        if (pitch > 60.0f) {
            if (entityLiving.isUsingSpecialKey()) {
                return 0;
            }
            return 1;
        }
        if (pitch < -60.0f) {
            if (entityLiving.isUsingSpecialKey()) {
                return 1;
            }
            return 0;
        }
        return MiscUtils.convertOrientationToFlatBlockFacingReversed(entityLiving);
    }

    public static int convertOrientationToFlatBlockFacingReversed(ng entityLiving) {
        int l2 = kx.c((double)(entityLiving.A * 4.0f / 360.0f) + 0.5) & 3;
        int iFacing = l2 == 0 ? 2 : (l2 == 1 ? 5 : (l2 == 2 ? 3 : 4));
        if (entityLiving.isUsingSpecialKey()) {
            iFacing = s.a[iFacing];
        }
        return iFacing;
    }

    public static int convertOrientationToFlatBlockFacing(ng entityLiving) {
        int l2 = kx.c((double)(entityLiving.A * 4.0f / 360.0f) + 0.5) & 3;
        int iFacing = l2 == 0 ? 3 : (l2 == 1 ? 4 : (l2 == 2 ? 2 : 5));
        if (entityLiving.isUsingSpecialKey()) {
            iFacing = s.a[iFacing];
        }
        return iFacing;
    }

    public static boolean isIKInColdBiome(aab world, int i2, int k) {
        aav biomegenbase = world.a(i2, k);
        float f2 = biomegenbase.j();
        return !(f2 > 0.15f);
    }

    public static void positionAllNonPlayerMoveableEntitiesOutsideOfLocation(aab world, int i2, int j2, int k) {
        List list = world.b(null, aqx.a().a(i2, j2, k, (double)i2 + 1.0, (double)j2 + 1.0, (double)k + 1.0));
        if (list != null && list.size() > 0) {
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                mp entity = (mp)list.get(listIndex);
                if (!entity.L() && !(entity instanceof rh) || entity instanceof sq) continue;
                MiscUtils.positionEntityOutsideOfLocation(world, entity, i2, j2, k);
            }
        }
    }

    private static void positionEntityOutsideOfLocation(aab world, mp entity, int i2, int j2, int k) {
        double minPosX = i2;
        double minPosY = j2;
        double minPosZ = k;
        double maxPosX = i2 + 1;
        double maxPosY = j2 + 1;
        double maxPosZ = k + 1;
        boolean xOverlap = false;
        boolean yOverlap = false;
        boolean zOverlap = false;
        double xOffset = 0.0;
        double yOffset = 0.0;
        double zOffset = 0.0;
        if (entity.E.a <= maxPosX && entity.E.d >= minPosX) {
            xOverlap = true;
            xOffset = Math.abs(maxPosX - entity.E.a) < Math.abs(minPosX - entity.E.d) ? maxPosX - entity.E.a + 0.01 : minPosX - entity.E.d - 0.01;
        }
        if (entity.E.b <= maxPosY && entity.E.e >= minPosY) {
            yOverlap = true;
            yOffset = Math.abs(maxPosY - entity.E.b) < Math.abs(minPosY - entity.E.e) ? maxPosY - entity.E.b + 0.01 : minPosY - entity.E.e - 0.01;
        }
        if (entity.E.c <= maxPosZ && entity.E.f >= minPosZ) {
            zOverlap = true;
            zOffset = Math.abs(maxPosZ - entity.E.c) < Math.abs(minPosZ - entity.E.f) ? maxPosZ - entity.E.c + 0.01 : minPosZ - entity.E.f - 0.01;
        }
        double entityX = entity.u;
        double entityY = entity.v;
        double entityZ = entity.w;
        if (xOverlap && Math.abs(xOffset) < 0.2 && (!yOverlap || Math.abs(xOffset) < Math.abs(yOffset)) && (!zOverlap || Math.abs(xOffset) < Math.abs(zOffset))) {
            entityX += xOffset;
        } else if (yOverlap && Math.abs(yOffset) < 0.2 && (!zOverlap || Math.abs(yOffset) < Math.abs(zOffset))) {
            entityY += yOffset;
        } else if (zOverlap && Math.abs(zOffset) < 0.2) {
            entityZ += zOffset;
        }
        entity.b(entityX, entityY, entityZ);
        if (entity instanceof jc) {
            jc player = (jc)entity;
            WorldUtils.sendPacketToPlayer(player.a, (ei)new eg(entityX, entityY + (double)1.62f, entityY, entityZ, player.A, player.B, false));
        }
    }

    public static void serverPositionAllPlayerEntitiesOutsideOfLocation(aab world, int i2, int j2, int k) {
        List list = world.a(jc.class, aqx.a().a(i2, j2, k, (double)i2 + 1.0, (double)j2 + 1.0, (double)k + 1.0));
        if (list != null && list.size() > 0) {
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                jc player = (jc)list.get(listIndex);
                MiscUtils.serverPositionPlayerEntityOutsideOfLocation(world, player, i2, j2, k);
            }
        }
    }

    private static void serverPositionPlayerEntityOutsideOfLocation(aab world, jc player, int i2, int j2, int k) {
        double minPosX = i2;
        double minPosY = j2;
        double minPosZ = k;
        double maxPosX = i2 + 1;
        double maxPosY = j2 + 1;
        double maxPosZ = k + 1;
        boolean xOverlap = false;
        boolean yOverlap = false;
        boolean zOverlap = false;
        double xOffset = 0.0;
        double yOffset = 0.0;
        double zOffset = 0.0;
        if (player.E.a <= maxPosX && player.E.d >= minPosX) {
            xOverlap = true;
            xOffset = Math.abs(maxPosX - player.E.a) < Math.abs(minPosX - player.E.d) ? maxPosX - player.E.a + 0.01 : minPosX - player.E.d - 0.01;
        }
        if (player.E.b <= maxPosY && player.E.e >= minPosY) {
            yOverlap = true;
            yOffset = Math.abs(maxPosY - player.E.b) < Math.abs(minPosY - player.E.e) ? maxPosY - player.E.b + 0.01 : minPosY - player.E.e - 0.01;
        }
        if (player.E.c <= maxPosZ && player.E.f >= minPosZ) {
            zOverlap = true;
            zOffset = Math.abs(maxPosZ - player.E.c) < Math.abs(minPosZ - player.E.f) ? maxPosZ - player.E.c + 0.01 : minPosZ - player.E.f - 0.01;
        }
        double entityX = player.u;
        double entityY = player.v;
        double entityZ = player.w;
        if (xOverlap && Math.abs(xOffset) < 0.2 && (!yOverlap || Math.abs(xOffset) < Math.abs(yOffset)) && (!zOverlap || Math.abs(xOffset) < Math.abs(zOffset))) {
            entityX += xOffset;
        } else if (yOverlap && Math.abs(yOffset) < 0.2 && (!zOverlap || Math.abs(yOffset) < Math.abs(zOffset))) {
            entityY += yOffset;
        } else if (zOverlap && Math.abs(zOffset) < 0.2) {
            entityZ += zOffset;
        }
        player.b(entityX, entityY, entityZ);
        WorldUtils.sendPacketToPlayer(player.a, (ei)new eg(entityX, entityY + (double)1.62f, entityY, entityZ, player.A, player.B, false));
    }

    public static void playPlaceSoundForBlock(aab world, int i2, int j2, int k) {
        int iTargetBlockID = world.a(i2, j2, k);
        apa targetBlock = apa.r[iTargetBlockID];
        if (targetBlock != null) {
            world.a((float)i2 + 0.5f, (double)((float)j2 + 0.5f), (double)((float)k + 0.5f), targetBlock.cM.b(), (targetBlock.cM.getPlaceVolume() + 1.0f) / 2.0f, targetBlock.cM.getPlacePitch() * 0.8f);
        }
    }

    public static boolean isCreatureWearingBreedingHarness(nr creature) {
        if (creature instanceof qh) {
            qh animal = (qh)creature;
            return animal.getWearingBreedingHarness();
        }
        return false;
    }

    public static boolean standardRotateAroundY(apa block, aab world, int i2, int j2, int k, boolean bReverse) {
        int iMetadata = world.h(i2, j2, k);
        int iNewMetadata = MiscUtils.standardRotateMetadataAroundY(block, iMetadata, bReverse);
        if (iNewMetadata != iMetadata) {
            world.setBlockMetadataWithNotify(i2, j2, k, iNewMetadata);
            world.g(i2, j2, k, i2, j2, k);
            return true;
        }
        return false;
    }

    public static int standardRotateMetadataAroundY(apa block, int iMetadata, boolean bReverse) {
        int iFacing = block.getFacing(iMetadata);
        int iNewFacing = apa.rotateFacingAroundY(iFacing, bReverse);
        iMetadata = block.setFacing(iMetadata, iNewFacing);
        return iMetadata;
    }

    public static arc convertBlockFacingToVector(int iFacing) {
        arc vector = arc.a(0.0, 0.0, 0.0);
        switch (iFacing) {
            case 0: {
                vector.d += -1.0;
                break;
            }
            case 1: {
                vector.d += 1.0;
                break;
            }
            case 2: {
                vector.e -= 1.0;
                break;
            }
            case 3: {
                vector.e += 1.0;
                break;
            }
            case 4: {
                vector.c -= 1.0;
                break;
            }
            default: {
                vector.c += 1.0;
            }
        }
        return vector;
    }

    public static void placeNonPersistentWater(aab world, int i2, int j2, int k) {
        world.setBlockAndMetadataWithNotify(i2, j2, k, apa.E.cz, 1);
        MiscUtils.flowWaterIntoBlockIfPossible(world, i2 + 1, j2, k, 2);
        MiscUtils.flowWaterIntoBlockIfPossible(world, i2 - 1, j2, k, 2);
        MiscUtils.flowWaterIntoBlockIfPossible(world, i2, j2, k + 1, 2);
        MiscUtils.flowWaterIntoBlockIfPossible(world, i2, j2, k - 1, 2);
    }

    public static void placeNonPersistentWaterMinorSpread(aab world, int i2, int j2, int k) {
        int iSpread = 5;
        world.setBlockAndMetadataWithNotify(i2, j2, k, apa.E.cz, iSpread);
        MiscUtils.flowWaterIntoBlockSafe(world, i2 + 1, j2, k, iSpread + 1);
        MiscUtils.flowWaterIntoBlockSafe(world, i2 - 1, j2, k, iSpread + 1);
        MiscUtils.flowWaterIntoBlockSafe(world, i2, j2, k + 1, iSpread + 1);
        MiscUtils.flowWaterIntoBlockSafe(world, i2, j2, k - 1, iSpread + 1);
    }

    public static void flowWaterIntoBlockSafe(aab world, int i2, int j2, int k, int iDecayLevel) {
        if (world.c(i2, j2, k)) {
            MiscUtils.flowWaterIntoBlockIfPossible(world, i2, j2, k, iDecayLevel);
        }
    }

    public static void flowWaterIntoBlockIfPossible(aab world, int i2, int j2, int k, int iDecayLevel) {
        if (MiscUtils.canWaterDisplaceBlock(world, i2, j2, k)) {
            int iTargetBlockID = world.a(i2, j2, k);
            if (iTargetBlockID > 0) {
                apa.r[iTargetBlockID].onFluidFlowIntoBlock(world, i2, j2, k, apa.E);
            }
            world.setBlockAndMetadataWithNotify(i2, j2, k, apa.E.cz, iDecayLevel);
        }
    }

    public static boolean canWaterDisplaceBlock(aab world, int i2, int j2, int k) {
        aif material = world.g(i2, j2, k);
        if (material == apa.E.cO) {
            return false;
        }
        if (material == aif.i) {
            return false;
        }
        apa block = apa.r[world.a(i2, j2, k)];
        return block == null || !block.getPreventsFluidFlow(world, i2, j2, k, apa.E);
    }

    public static ara getMovingObjectPositionFromPlayerHitWaterAndLava(aab par1World, sq par2EntityPlayer, boolean par3) {
        float f2 = 1.0f;
        float f1 = par2EntityPlayer.D + (par2EntityPlayer.B - par2EntityPlayer.D) * f2;
        float f22 = par2EntityPlayer.C + (par2EntityPlayer.A - par2EntityPlayer.C) * f2;
        double d2 = par2EntityPlayer.r + (par2EntityPlayer.u - par2EntityPlayer.r) * (double)f2;
        double d1 = par2EntityPlayer.s + (par2EntityPlayer.v - par2EntityPlayer.s) * (double)f2 + 1.62 - (double)par2EntityPlayer.N;
        double d22 = par2EntityPlayer.t + (par2EntityPlayer.w - par2EntityPlayer.t) * (double)f2;
        arc vec3 = par1World.U().a(d2, d1, d22);
        float f3 = kx.b(-f22 * 0.01745329f - (float)Math.PI);
        float f4 = kx.a(-f22 * 0.01745329f - (float)Math.PI);
        float f5 = -kx.b(-f1 * 0.01745329f);
        float f6 = kx.a(-f1 * 0.01745329f);
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double d3 = 5.0;
        arc vec3_1 = vec3.c((double)f7 * d3, (double)f8 * d3, (double)f9 * d3);
        return WorldUtils.rayTraceBlocksAlwaysHitWaterAndLava(par1World, vec3, vec3_1, par3, !par3);
    }

    public static ara getMovingObjectPositionFromPlayerHitWaterAndLavaAndFire(aab par1World, sq par2EntityPlayer, boolean par3) {
        float f2 = 1.0f;
        float f1 = par2EntityPlayer.D + (par2EntityPlayer.B - par2EntityPlayer.D) * f2;
        float f22 = par2EntityPlayer.C + (par2EntityPlayer.A - par2EntityPlayer.C) * f2;
        double d2 = par2EntityPlayer.r + (par2EntityPlayer.u - par2EntityPlayer.r) * (double)f2;
        double d1 = par2EntityPlayer.s + (par2EntityPlayer.v - par2EntityPlayer.s) * (double)f2 + 1.62 - (double)par2EntityPlayer.N;
        double d22 = par2EntityPlayer.t + (par2EntityPlayer.w - par2EntityPlayer.t) * (double)f2;
        arc vec3 = par1World.U().a(d2, d1, d22);
        float f3 = kx.b(-f22 * 0.01745329f - (float)Math.PI);
        float f4 = kx.a(-f22 * 0.01745329f - (float)Math.PI);
        float f5 = -kx.b(-f1 * 0.01745329f);
        float f6 = kx.a(-f1 * 0.01745329f);
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double d3 = 5.0;
        arc vec3_1 = vec3.c((double)f7 * d3, (double)f8 * d3, (double)f9 * d3);
        return WorldUtils.rayTraceBlocksAlwaysHitWaterAndLavaAndFire(par1World, vec3, vec3_1, par3, !par3);
    }

    public static ara rayTraceWithBox(aab world, int i2, int j2, int k, arc boxMin, arc boxMax, arc startRay, arc endRay) {
        startRay = startRay.c(-i2, -j2, -k);
        endRay = endRay.c(-i2, -j2, -k);
        arc vec3 = startRay.b(endRay, boxMin.c);
        arc vec3_1 = startRay.b(endRay, boxMax.c);
        arc vec3_2 = startRay.c(endRay, boxMin.d);
        arc vec3_3 = startRay.c(endRay, boxMax.d);
        arc vec3_4 = startRay.d(endRay, boxMin.e);
        arc vec3_5 = startRay.d(endRay, boxMax.e);
        if (!MiscUtils.isVecInsideYZBounds(vec3, boxMin, boxMax)) {
            vec3 = null;
        }
        if (!MiscUtils.isVecInsideYZBounds(vec3_1, boxMin, boxMax)) {
            vec3_1 = null;
        }
        if (!MiscUtils.isVecInsideXZBounds(vec3_2, boxMin, boxMax)) {
            vec3_2 = null;
        }
        if (!MiscUtils.isVecInsideXZBounds(vec3_3, boxMin, boxMax)) {
            vec3_3 = null;
        }
        if (!MiscUtils.isVecInsideXYBounds(vec3_4, boxMin, boxMax)) {
            vec3_4 = null;
        }
        if (!MiscUtils.isVecInsideXYBounds(vec3_5, boxMin, boxMax)) {
            vec3_5 = null;
        }
        arc vec3_6 = null;
        if (vec3 != null && (vec3_6 == null || startRay.e(vec3) < startRay.e(vec3_6))) {
            vec3_6 = vec3;
        }
        if (vec3_1 != null && (vec3_6 == null || startRay.e(vec3_1) < startRay.e(vec3_6))) {
            vec3_6 = vec3_1;
        }
        if (vec3_2 != null && (vec3_6 == null || startRay.e(vec3_2) < startRay.e(vec3_6))) {
            vec3_6 = vec3_2;
        }
        if (vec3_3 != null && (vec3_6 == null || startRay.e(vec3_3) < startRay.e(vec3_6))) {
            vec3_6 = vec3_3;
        }
        if (vec3_4 != null && (vec3_6 == null || startRay.e(vec3_4) < startRay.e(vec3_6))) {
            vec3_6 = vec3_4;
        }
        if (vec3_5 != null && (vec3_6 == null || startRay.e(vec3_5) < startRay.e(vec3_6))) {
            vec3_6 = vec3_5;
        }
        if (vec3_6 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3_6 == vec3) {
            byte0 = 4;
        }
        if (vec3_6 == vec3_1) {
            byte0 = 5;
        }
        if (vec3_6 == vec3_2) {
            byte0 = 0;
        }
        if (vec3_6 == vec3_3) {
            byte0 = 1;
        }
        if (vec3_6 == vec3_4) {
            byte0 = 2;
        }
        if (vec3_6 == vec3_5) {
            byte0 = 3;
        }
        return new ara(i2, j2, k, byte0, vec3_6.c(i2, j2, k));
    }

    public static boolean isVecInsideYZBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.d >= min.d && par1Vec3.d <= max.d && par1Vec3.e >= min.e && par1Vec3.e <= max.e;
    }

    public static boolean isVecInsideXZBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.c >= min.c && par1Vec3.c <= max.c && par1Vec3.e >= min.e && par1Vec3.e <= max.e;
    }

    public static boolean isVecInsideXYBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.c >= min.c && par1Vec3.c <= max.c && par1Vec3.d >= min.d && par1Vec3.d <= max.d;
    }

    public static boolean doesWaterHaveValidSource(aab world, int i2, int j2, int k, int iDistanceToCheck) {
        return MiscUtils.doesWaterHaveValidSourceRecursive(world, i2, j2, k, i2, j2, k, iDistanceToCheck);
    }

    private static boolean doesWaterHaveValidSourceRecursive(aab world, int i2, int j2, int k, int startI, int startJ, int startK, int iDistanceToCheck) {
        BlockPos targetPos;
        FluidSource targetBlock;
        if (iDistanceToCheck <= 0) {
            return true;
        }
        if (!world.e(i2 - 1, 64, k - 1, i2 + 1, 64, k + 1)) {
            return true;
        }
        int iThisBlockHeight = world.h(i2, j2, k);
        if (iThisBlockHeight == 0) {
            return true;
        }
        if (iThisBlockHeight >= 8) {
            BlockPos targetPos2 = new BlockPos(i2, j2, k);
            targetPos2.addFacingAsOffset(1);
            int iTargetBlockID = world.a(targetPos2.x, targetPos2.y, targetPos2.z);
            if (iTargetBlockID == apa.E.cz || iTargetBlockID == apa.F.cz) {
                if (MiscUtils.doesWaterHaveValidSourceWithSourceCheck(world, targetPos2.x, targetPos2.y, targetPos2.z, startI, startJ, startK, iDistanceToCheck - 1)) {
                    return true;
                }
                for (int iFacing = 2; iFacing < 6; ++iFacing) {
                    targetPos2 = new BlockPos(i2, j2, k);
                    targetPos2.addFacingAsOffset(iFacing);
                    iTargetBlockID = world.a(targetPos2.x, targetPos2.y, targetPos2.z);
                    if (iTargetBlockID != apa.E.cz && iTargetBlockID != apa.F.cz) continue;
                    int iTargetHeight = world.h(targetPos2.x, targetPos2.y, targetPos2.z);
                    boolean bTargetIsHigher = false;
                    if (iTargetHeight != 0) continue;
                    return true;
                }
            }
            return false;
        }
        int iDownBlockID = world.a(i2, j2 - 1, k);
        if (BTWBlocks.potentialFluidSources[iDownBlockID] && (targetBlock = (FluidSource)((Object)apa.r[iDownBlockID])).isSourceToFluidBlockAtFacing(world, i2, j2 - 1, k, 1) >= 0) {
            if (iDownBlockID == BTWBlocks.screwPump.cz) {
                if (j2 - 1 < startJ) {
                    return true;
                }
                targetPos = new BlockPos(i2, j2 - 1, k);
                int iTargetFacing = ((ScrewPumpBlock)BTWBlocks.screwPump).getFacing(world, targetPos.x, targetPos.y, targetPos.z);
                targetPos.addFacingAsOffset(iTargetFacing);
                if (MiscUtils.doesWaterHaveValidSourceWithSourceCheck(world, targetPos.x, targetPos.y, targetPos.z, startI, startJ, startK, iDistanceToCheck - 1)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        for (int iFacing = 2; iFacing < 6; ++iFacing) {
            FluidSource targetBlock2;
            targetPos = new BlockPos(i2, j2, k);
            targetPos.addFacingAsOffset(iFacing);
            int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
            if (iTargetBlockID == apa.E.cz || iTargetBlockID == apa.F.cz) {
                int iTargetHeight = world.h(targetPos.x, targetPos.y, targetPos.z);
                boolean bTargetIsHigher = false;
                if (iTargetHeight >= 8) {
                    bTargetIsHigher = true;
                } else if (iTargetHeight < iThisBlockHeight) {
                    bTargetIsHigher = true;
                }
                if (!bTargetIsHigher || !MiscUtils.doesWaterHaveValidSourceWithSourceCheck(world, targetPos.x, targetPos.y, targetPos.z, startI, startJ, startK, iDistanceToCheck - 1)) continue;
                return true;
            }
            if (!BTWBlocks.potentialFluidSources[iTargetBlockID] || (targetBlock2 = (FluidSource)((Object)apa.r[iTargetBlockID])).isSourceToFluidBlockAtFacing(world, targetPos.x, targetPos.y, targetPos.z, apa.getOppositeFacing(iFacing)) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean doesWaterHaveValidSourceWithSourceCheck(aab world, int i2, int j2, int k, int startI, int startJ, int startK, int iDistanceToCheck) {
        if (i2 == startI && j2 == startJ && k == startK) {
            return false;
        }
        return MiscUtils.doesWaterHaveValidSourceRecursive(world, i2, j2, k, startI, startJ, startK, iDistanceToCheck);
    }
}

