/*
 * Decompiled with CFR 0.152.
 */
package btw.network.packet;

import btw.BTWMod;
import btw.client.network.packet.handler.BTWDifficultyPacketHandler;
import btw.client.network.packet.handler.BTWOptionsPacketHandler;
import btw.client.network.packet.handler.CustomEntityPacketHandler;
import btw.client.network.packet.handler.CustomItemEntityHandler;
import btw.client.network.packet.handler.EntityEventPacketHandler;
import btw.client.network.packet.handler.GuiPacketHandler;
import btw.entity.CanvasEntity;
import btw.entity.DynamiteEntity;
import btw.entity.MiningChargeEntity;
import btw.entity.SoulSandEntity;
import btw.entity.SpiderWebEntity;
import btw.entity.UrnEntity;
import btw.entity.mechanical.platform.BlockLiftedByPlatformEntity;
import btw.entity.mechanical.source.VerticalWindMillEntity;
import btw.entity.mechanical.source.WaterWheelEntity;
import btw.entity.mechanical.source.WindMillEntity;
import btw.network.packet.PlayerSyncPacket;
import btw.network.packet.StartBlockHarvestPacket;
import btw.network.packet.TimerSpeedPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.server.MinecraftServer;

public class BTWPacketManager {
    public static final String SPAWN_CUSTOM_ENTITY_PACKET_CHANNEL = "BTW|SE";
    public static final String CUSTOM_ENTITY_EVENT_PACKET_CHANNEL = "BTW|EV";
    public static final String BTW_OPTIONS_PACKET_CHANNEL = "BTW|OP";
    public static final String BTW_DIFFICULTY_PACKET_CHANNEL = "BTW|DF";
    public static final String CUSTOM_INTERFACE_PACKET_CHANNEL = "BTW|OI";
    public static final int CANVAS_SPAWN_PACKET_ID = 0;
    public static final int WIND_MILL_SPAWN_PACKET_ID = 1;
    public static final int WATER_WHEEL_SPAWN_PACKET_ID = 2;
    public static final int MINING_CHARGE_SPAWN_PACKET_ID = 3;
    public static final int BLOOD_WOOD_SAPLING_ITEM_SPAWN_PACKET_ID = 4;
    public static final int FLOATING_ITEM_SPAWN_PACKET_ID = 5;
    public static final int DYNAMITE_SPAWN_PACKET_ID = 6;
    public static final int URN_SPAWN_PACKET_ID = 7;
    public static final int BLOCK_LIFTED_BY_PLATFORM_SPAWN_PACKET_ID = 8;
    public static final int VERTICAL_WIND_MILL_SPAWN_PACKET_ID = 9;
    public static final int SPIDER_WEB_SPAWN_PACKET_ID = 10;
    public static final int SOUL_SAND_SPAWN_PACKET_ID = 11;

    public static void initPacketInfo() {
        if (!MinecraftServer.getIsServer()) {
            BTWMod.instance.registerPacketHandler(SPAWN_CUSTOM_ENTITY_PACKET_CHANNEL, new CustomEntityPacketHandler());
            BTWMod.instance.registerPacketHandler(CUSTOM_ENTITY_EVENT_PACKET_CHANNEL, new EntityEventPacketHandler());
            BTWMod.instance.registerPacketHandler(BTW_OPTIONS_PACKET_CHANNEL, new BTWOptionsPacketHandler());
            BTWMod.instance.registerPacketHandler(BTW_DIFFICULTY_PACKET_CHANNEL, new BTWDifficultyPacketHandler());
            BTWMod.instance.registerPacketHandler(CUSTOM_INTERFACE_PACKET_CHANNEL, new GuiPacketHandler());
            BTWPacketManager.initEntitySpawnEntries();
        }
        ei.a(166, false, true, StartBlockHarvestPacket.class);
        ei.a(21, true, true, PlayerSyncPacket.class);
        ei.a(167, true, false, TimerSpeedPacket.class);
    }

    @Environment(value=EnvType.CLIENT)
    private static void initEntitySpawnEntries() {
        CustomEntityPacketHandler.entryMap.put(0, (world, dataStream, packet) -> {
            int x2 = dataStream.readInt();
            int y2 = dataStream.readInt();
            int z2 = dataStream.readInt();
            int direction = dataStream.readInt();
            int artNum = dataStream.readInt();
            return mv.createEntityOfType(CanvasEntity.class, world, x2, y2, z2, direction, artNum);
        });
        CustomEntityPacketHandler.entryMap.put(1, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            boolean isXAligned = dataStream.readByte() > 0;
            WindMillEntity entityWindMill = (WindMillEntity)mv.createEntityOfType(WindMillEntity.class, world, x2, y2, z2, isXAligned);
            entityWindMill.setRotationSpeedScaled(dataStream.readInt());
            entityWindMill.setBladeColor(0, dataStream.readByte());
            entityWindMill.setBladeColor(1, dataStream.readByte());
            entityWindMill.setBladeColor(2, dataStream.readByte());
            entityWindMill.setBladeColor(3, dataStream.readByte());
            return entityWindMill;
        });
        CustomEntityPacketHandler.entryMap.put(2, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            boolean isXAligned = dataStream.readByte() > 0;
            WaterWheelEntity entityWaterWheel = (WaterWheelEntity)mv.createEntityOfType(WaterWheelEntity.class, world, x2, y2, z2, isXAligned);
            entityWaterWheel.setRotationSpeedScaled(dataStream.readInt());
            return entityWaterWheel;
        });
        CustomEntityPacketHandler.entryMap.put(3, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            byte facing = dataStream.readByte();
            byte fuse = dataStream.readByte();
            boolean isAttachedToBlock = dataStream.readByte() > 0;
            return mv.createEntityOfType(MiningChargeEntity.class, world, x2, y2, z2, facing, fuse, isAttachedToBlock);
        });
        CustomEntityPacketHandler.entryMap.put(4, new CustomItemEntityHandler(4));
        CustomEntityPacketHandler.entryMap.put(5, new CustomItemEntityHandler(5));
        CustomEntityPacketHandler.entryMap.put(6, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            int itemID = dataStream.readInt();
            int fuse = dataStream.readInt();
            double motionX = (double)dataStream.readByte() * 128.0;
            double motionY = (double)dataStream.readByte() * 128.0;
            double motionZ = (double)dataStream.readByte() * 128.0;
            DynamiteEntity dynamite = (DynamiteEntity)mv.createEntityOfType(DynamiteEntity.class, world, x2, y2, z2, itemID);
            dynamite.fuse = fuse;
            dynamite.x = motionX;
            dynamite.y = motionY;
            dynamite.z = motionZ;
            dynamite.cx = (int)(x2 * 32.0);
            dynamite.cy = (int)(y2 * 32.0);
            dynamite.cz = (int)(z2 * 32.0);
            return dynamite;
        });
        CustomEntityPacketHandler.entryMap.put(7, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            int itemID = dataStream.readInt();
            double motionX = (double)dataStream.readByte() * 128.0;
            double motionY = (double)dataStream.readByte() * 128.0;
            double motionZ = (double)dataStream.readByte() * 128.0;
            mp entityToSpawn = mv.createEntityOfType(UrnEntity.class, world, x2, y2, z2, itemID);
            entityToSpawn.x = motionX;
            entityToSpawn.y = motionY;
            entityToSpawn.z = motionZ;
            entityToSpawn.cx = (int)(x2 * 32.0);
            entityToSpawn.cy = (int)(y2 * 32.0);
            entityToSpawn.cz = (int)(z2 * 32.0);
            return entityToSpawn;
        });
        CustomEntityPacketHandler.entryMap.put(8, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            int blockID = dataStream.readInt();
            int metadata = dataStream.readInt();
            return mv.createEntityOfType(BlockLiftedByPlatformEntity.class, world, x2, y2, z2, blockID, metadata);
        });
        CustomEntityPacketHandler.entryMap.put(9, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            VerticalWindMillEntity entityWindMill = (VerticalWindMillEntity)mv.createEntityOfType(VerticalWindMillEntity.class, world, x2, y2, z2);
            entityWindMill.setRotationSpeedScaled(dataStream.readInt());
            entityWindMill.setBladeColor(0, dataStream.readByte());
            entityWindMill.setBladeColor(1, dataStream.readByte());
            entityWindMill.setBladeColor(2, dataStream.readByte());
            entityWindMill.setBladeColor(3, dataStream.readByte());
            entityWindMill.setBladeColor(4, dataStream.readByte());
            entityWindMill.setBladeColor(5, dataStream.readByte());
            entityWindMill.setBladeColor(6, dataStream.readByte());
            entityWindMill.setBladeColor(7, dataStream.readByte());
            return entityWindMill;
        });
        CustomEntityPacketHandler.entryMap.put(10, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            double motionX = (double)dataStream.readByte() * 128.0;
            double motionY = (double)dataStream.readByte() * 128.0;
            double motionZ = (double)dataStream.readByte() * 128.0;
            mp entityToSpawn = mv.createEntityOfType(SpiderWebEntity.class, world, x2, y2, z2);
            entityToSpawn.x = motionX;
            entityToSpawn.y = motionY;
            entityToSpawn.z = motionZ;
            entityToSpawn.cx = (int)(x2 * 32.0);
            entityToSpawn.cy = (int)(y2 * 32.0);
            entityToSpawn.cz = (int)(z2 * 32.0);
            world.playSound(x2, y2, z2, "mob.slime.attack", 1.0f, (world.s.nextFloat() - world.s.nextFloat()) * 0.2f + 0.6f);
            return entityToSpawn;
        });
        CustomEntityPacketHandler.entryMap.put(11, (world, dataStream, packet) -> {
            double x2 = (double)dataStream.readInt() / 32.0;
            double y2 = (double)dataStream.readInt() / 32.0;
            double z2 = (double)dataStream.readInt() / 32.0;
            double motionX = (double)dataStream.readByte() * 128.0;
            double motionY = (double)dataStream.readByte() * 128.0;
            double motionZ = (double)dataStream.readByte() * 128.0;
            mp entityToSpawn = mv.createEntityOfType(SoulSandEntity.class, world, x2, y2, z2);
            entityToSpawn.x = motionX;
            entityToSpawn.y = motionY;
            entityToSpawn.z = motionZ;
            entityToSpawn.cx = (int)(x2 * 32.0);
            entityToSpawn.cy = (int)(y2 * 32.0);
            entityToSpawn.cz = (int)(z2 * 32.0);
            world.playSound(x2, y2, z2, "dig.sand", 1.0f, 1.0f + (world.s.nextFloat() - world.s.nextFloat()) * 0.2f);
            return entityToSpawn;
        });
    }
}

