/*
 * Decompiled with CFR 0.152.
 */
package btw.item.util;

import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;

public class ItemUtils {
    public static void ejectStackWithRandomOffset(aab world, int i2, int j2, int k, wm stack) {
        float xOffset = world.s.nextFloat() * 0.7f + 0.15f;
        float yOffset = world.s.nextFloat() * 0.2f + 0.1f;
        float zOffset = world.s.nextFloat() * 0.7f + 0.15f;
        ItemUtils.ejectStackWithRandomVelocity(world, (float)i2 + xOffset, (float)j2 + yOffset, (float)k + zOffset, stack);
    }

    public static void ejectSingleItemWithRandomOffset(aab world, int i2, int j2, int k, int iShiftedItemIndex, int iDamage) {
        wm itemStack = new wm(iShiftedItemIndex, 1, iDamage);
        ItemUtils.ejectStackWithRandomOffset(world, i2, j2, k, itemStack);
    }

    public static void ejectStackWithRandomVelocity(aab world, double xPos, double yPos, double zPos, wm stack) {
        rh entityitem = (rh)mv.createEntityOfType(rh.class, world, xPos, yPos, zPos, stack);
        float velocityFactor = 0.05f;
        entityitem.x = (float)world.s.nextGaussian() * velocityFactor;
        entityitem.y = (float)world.s.nextGaussian() * velocityFactor + 0.2f;
        entityitem.z = (float)world.s.nextGaussian() * velocityFactor;
        entityitem.b = 10;
        world.d(entityitem);
    }

    public static void ejectSingleItemWithRandomVelocity(aab world, float xPos, float yPos, float zPos, int iShiftedItemIndex, int iDamage) {
        wm itemStack = new wm(iShiftedItemIndex, 1, iDamage);
        ItemUtils.ejectStackWithRandomVelocity(world, xPos, yPos, zPos, itemStack);
    }

    public static void dropStackAsIfBlockHarvested(aab world, int i2, int j2, int k, wm stack) {
        float f1 = 0.7f;
        double d2 = (double)(world.s.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.s.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d22 = (double)(world.s.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        rh entityitem = (rh)mv.createEntityOfType(rh.class, world, (double)i2 + d2, (double)j2 + d1, (double)k + d22, stack);
        entityitem.b = 10;
        world.d(entityitem);
    }

    public static void dropSingleItemAsIfBlockHarvested(aab world, int i2, int j2, int k, int iShiftedItemIndex, int iDamage) {
        wm itemStack = new wm(iShiftedItemIndex, 1, iDamage);
        ItemUtils.dropStackAsIfBlockHarvested(world, i2, j2, k, itemStack);
    }

    public static void ejectStackAroundBlock(aab world, int i2, int j2, int k, wm stack) {
        int iTempFacing = world.s.nextInt(6);
        BlockPos targetPos = new BlockPos(i2, j2, k);
        BlockPos tempPos = new BlockPos();
        for (int iTempFacingCount = 0; iTempFacingCount < 6; ++iTempFacingCount) {
            tempPos.set(i2, j2, k);
            tempPos.addFacingAsOffset(iTempFacing);
            if (WorldUtils.isReplaceableBlock(world, tempPos.x, tempPos.y, tempPos.z)) {
                targetPos.set(tempPos);
                break;
            }
            if (++iTempFacing < 6) continue;
            iTempFacing = 0;
        }
        ItemUtils.dropStackAsIfBlockHarvested(world, targetPos.x, targetPos.y, targetPos.z, stack);
    }

    public static void ejectStackFromBlockTowardsFacing(aab world, int i2, int j2, int k, wm stack, int iFacing) {
        arc ejectPos = arc.a(world.s.nextDouble() * 0.7 + 0.15, 1.2 + world.s.nextDouble() * 0.1, world.s.nextDouble() * 0.7 + 0.15);
        ejectPos.tiltAsBlockPosToFacingAlongJ(iFacing);
        rh entity = (rh)mv.createEntityOfType(rh.class, world, (double)i2 + ejectPos.c, (double)j2 + ejectPos.d, (double)k + ejectPos.e, stack);
        if (iFacing < 2) {
            entity.x = world.s.nextDouble() * 0.1 - 0.05;
            entity.z = world.s.nextDouble() * 0.1 - 0.05;
            entity.y = iFacing == 0 ? 0.0 : 0.2;
        } else {
            arc ejectVel = arc.a(world.s.nextDouble() * 0.1 - 0.05, 0.2, world.s.nextDouble() * -0.05 - 0.05);
            ejectVel.rotateAsVectorAroundJToFacing(iFacing);
            entity.x = ejectVel.c;
            entity.y = ejectVel.d;
            entity.z = ejectVel.e;
        }
        entity.b = 10;
        world.d(entity);
    }

    public static void givePlayerStackOrEjectFromTowardsFacing(sq player, wm stack, int i2, int j2, int k, int iFacing) {
        if (player.bK.a(stack)) {
            player.q.a((mp)player, "random.pop", 0.2f, ((player.ab.nextFloat() - player.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else if (!player.q.I) {
            ItemUtils.ejectStackFromBlockTowardsFacing(player.q, i2, j2, k, stack, iFacing);
        }
    }

    public static void givePlayerStackOrEjectFavorEmptyHand(sq player, wm stack, int i2, int j2, int k) {
        if (player.addStackToCurrentHeldStackIfEmpty(stack)) {
            player.q.a((mp)player, "random.pop", 0.2f, ((player.ab.nextFloat() - player.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else {
            ItemUtils.givePlayerStackOrEject(player, stack, i2, j2, k);
        }
    }

    public static void givePlayerStackOrEject(sq player, wm stack, int i2, int j2, int k) {
        if (player.bK.a(stack)) {
            player.q.a((mp)player, "random.pop", 0.2f, ((player.ab.nextFloat() - player.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else if (!player.q.I) {
            ItemUtils.ejectStackWithRandomOffset(player.q, i2, j2, k, stack);
        }
    }

    public static void givePlayerStackOrEject(sq player, wm stack) {
        if (player.bK.a(stack)) {
            player.q.a((mp)player, "random.pop", 0.2f, ((player.ab.nextFloat() - player.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else if (!player.q.I) {
            ItemUtils.ejectStackWithRandomVelocity(player.q, player.u, player.v, player.w, stack);
        }
    }
}

