/*
 * Decompiled with CFR 0.152.
 */
package btw.item.items;

import btw.crafting.util.FurnaceBurnTime;
import btw.item.items.FireStarterItem;
import btw.world.util.WorldUtils;
import java.util.Random;

public class FireStarterItemPrimitive
extends FireStarterItem {
    private final float baseChance;
    private final float maxChance;
    private final float chanceIncreasePerUse;
    private static final float CHANCE_DECAY_PER_TICK = 2.5E-4f;
    private static final long DELAY_BEFORE_DECAY = 40L;

    public FireStarterItemPrimitive(int iItemID, int iMaxUses, float fExhaustionPerUse, float fBaseChance, float fMaxChance, float fChanceIncreasePerUse) {
        super(iItemID, iMaxUses, fExhaustionPerUse);
        this.baseChance = fBaseChance;
        this.maxChance = fMaxChance;
        this.chanceIncreasePerUse = fChanceIncreasePerUse;
        this.setBuoyant();
        this.setfurnaceburntime(FurnaceBurnTime.SHAFT);
    }

    @Override
    protected boolean checkChanceOfStart(wm stack, Random rand) {
        boolean bReturnValue = false;
        float fChance = stack.getAccumulatedChance(this.baseChance);
        long lCurrentTime = WorldUtils.getOverworldTimeServerOnly();
        long lLastTime = stack.getTimeOfLastUse();
        if (lLastTime > 0L) {
            if (lCurrentTime > lLastTime) {
                long lDecayTime = lCurrentTime - lLastTime - 40L;
                if (lDecayTime > 0L && (fChance -= (float)lDecayTime * 2.5E-4f) < this.baseChance) {
                    fChance = this.baseChance;
                }
            } else if (lCurrentTime < lLastTime) {
                fChance = this.baseChance;
            }
        }
        if (rand.nextFloat() <= fChance) {
            bReturnValue = true;
        }
        if ((fChance += this.chanceIncreasePerUse) > this.maxChance) {
            fChance = this.maxChance;
        }
        stack.setAccumulatedChance(fChance);
        stack.setTimeOfLastUse(lCurrentTime);
        return bReturnValue;
    }

    @Override
    protected void performUseEffects(sq player) {
        player.a("random.eat", 0.5f + 0.5f * (float)player.ab.nextInt(2), player.ab.nextFloat() * 0.25f + 1.75f);
        if (player.q.I) {
            for (int var3 = 0; var3 < 5; ++var3) {
                arc var4 = player.q.U().a(((double)player.ab.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                var4.a(-player.B * (float)Math.PI / 180.0f);
                var4.b(-player.A * (float)Math.PI / 180.0f);
                arc var5 = player.q.U().a(((double)player.ab.nextFloat() - 0.5) * 0.3, (double)(-player.ab.nextFloat()) * 0.6 - 0.3, 0.6);
                var5.a(-player.B * (float)Math.PI / 180.0f);
                var5.b(-player.A * (float)Math.PI / 180.0f);
                var5 = var5.c(player.u, player.v + (double)player.e(), player.w);
                player.q.a("iconcrack_" + this.cp, var5.c, var5.d, var5.e, var4.c, var4.d + 0.05, var4.e);
            }
        }
    }

    @Override
    protected boolean attemptToLightBlock(wm stack, aab world, int i2, int j2, int k, int iFacing) {
        if (super.attemptToLightBlock(stack, world, i2, j2, k, iFacing)) {
            stack.setAccumulatedChance(this.baseChance);
            return true;
        }
        return false;
    }
}

