/*
 * Decompiled with CFR 0.152.
 */
package btw.inventory.util;

import btw.block.BTWBlocks;
import btw.world.util.BlockPos;
import java.util.ArrayList;
import java.util.Random;

public class InventoryUtils {
    public static final int IGNORE_METADATA = Short.MAX_VALUE;

    public static void clearInventoryContents(lt inventory) {
        for (int iSlot = 0; iSlot < inventory.j_(); ++iSlot) {
            wm itemstack = inventory.a(iSlot);
            if (itemstack == null) continue;
            inventory.a(iSlot, null);
        }
    }

    public static void ejectInventoryContents(aab world, int i2, int j2, int k, lt inventory) {
        if (inventory != null) {
            for (int l2 = 0; l2 < inventory.j_(); ++l2) {
                wm itemstack = inventory.a(l2);
                if (itemstack == null) continue;
                float f2 = world.s.nextFloat() * 0.7f + 0.15f;
                float f1 = world.s.nextFloat() * 0.7f + 0.15f;
                float f22 = world.s.nextFloat() * 0.7f + 0.15f;
                while (itemstack.a > 0) {
                    int i1 = world.s.nextInt(21) + 10;
                    if (i1 > itemstack.a) {
                        i1 = itemstack.a;
                    }
                    itemstack.a -= i1;
                    rh entityitem = (rh)mv.createEntityOfType(rh.class, world, (float)i2 + f2, (float)j2 + f1, (float)k + f22, new wm(itemstack.c, i1, itemstack.k()));
                    float f3 = 0.05f;
                    entityitem.x = (float)world.s.nextGaussian() * f3;
                    entityitem.y = (float)world.s.nextGaussian() * f3 + 0.2f;
                    entityitem.z = (float)world.s.nextGaussian() * f3;
                    InventoryUtils.copyEnchantments(entityitem.d(), itemstack);
                    world.d(entityitem);
                }
            }
        }
    }

    public static void copyEnchantments(wm destStack, wm sourceStack) {
        if (sourceStack.p()) {
            destStack.d((bs)sourceStack.q().b());
        }
    }

    public static wm decreaseStackSize(lt inventory, int iSlot, int iAmount) {
        if (inventory.a(iSlot) != null) {
            if (inventory.a((int)iSlot).a <= iAmount) {
                wm itemstack = inventory.a(iSlot);
                inventory.a(iSlot, null);
                return itemstack;
            }
            wm splitStack = inventory.a(iSlot).a(iAmount);
            if (inventory.a((int)iSlot).a == 0) {
                inventory.a(iSlot, null);
            } else {
                inventory.k_();
            }
            return splitStack;
        }
        return null;
    }

    public static int getNumOccupiedStacks(lt inventory) {
        return InventoryUtils.getNumOccupiedStacksInRange(inventory, 0, inventory.j_() - 1);
    }

    public static int getNumOccupiedStacksInRange(lt inventory, int iMinSlot, int iMaxSlot) {
        int iCount = 0;
        for (int iTempSlot = iMinSlot; iTempSlot <= iMaxSlot; ++iTempSlot) {
            if (inventory.a(iTempSlot) == null) continue;
            ++iCount;
        }
        return iCount;
    }

    public static int getRandomOccupiedStackInRange(lt inventory, Random rand, int iMinSlot, int iMaxSlot) {
        int iNumStacks = InventoryUtils.getNumOccupiedStacksInRange(inventory, iMinSlot, iMaxSlot);
        if (iNumStacks > 0) {
            int iRandomStackNum = rand.nextInt(iNumStacks) + 1;
            int iStackCount = 0;
            for (int iTempSlot = iMinSlot; iTempSlot <= iMaxSlot; ++iTempSlot) {
                if (inventory.a(iTempSlot) == null || ++iStackCount < iRandomStackNum) continue;
                return iTempSlot;
            }
        }
        return -1;
    }

    public static int getFirstOccupiedStack(lt inventory) {
        for (int iTempSlot = 0; iTempSlot < inventory.j_(); ++iTempSlot) {
            if (inventory.a(iTempSlot) == null) continue;
            return iTempSlot;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(lt inventory, int iItemID) {
        for (int i2 = 0; i2 < inventory.j_(); ++i2) {
            if (inventory.a(i2) == null || inventory.a((int)i2).b().cp != iItemID) continue;
            return i2;
        }
        return -1;
    }

    public static ArrayList<Integer> getAllOccupiedStacksOfItem(lt inventory, int itemID) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inventory.j_(); ++i2) {
            if (inventory.a(i2) == null || inventory.a((int)i2).b().cp != itemID) continue;
            slots.add(i2);
        }
        return slots;
    }

    public static int getFirstOccupiedStackNotOfItem(lt inventory, int iNotItemID) {
        for (int iTempSlot = 0; iTempSlot < inventory.j_(); ++iTempSlot) {
            if (inventory.a(iTempSlot) == null || inventory.a((int)iTempSlot).b().cp == iNotItemID) continue;
            return iTempSlot;
        }
        return -1;
    }

    public static int getFirstEmptyStack(lt inventory) {
        return InventoryUtils.getFirstEmptyStackInSlotRange(inventory, 0, inventory.j_() - 1);
    }

    public static int getFirstEmptyStackInSlotRange(lt inventory, int iMinSlotIndex, int iMaxSlotIndex) {
        for (int iTempSlot = iMinSlotIndex; iTempSlot <= iMaxSlotIndex; ++iTempSlot) {
            if (inventory.a(iTempSlot) != null) continue;
            return iTempSlot;
        }
        return -1;
    }

    public static int countItemsInInventory(lt inventory, int iItemID, int iItemDamage) {
        return InventoryUtils.countItemsInInventory(inventory, iItemID, iItemDamage, false);
    }

    public static int countItemsInInventory(lt inventory, int iItemID, int iItemDamage, boolean bMetaDataExclusive) {
        int itemCount = 0;
        for (int i2 = 0; i2 < inventory.j_(); ++i2) {
            wm tempStack = inventory.a(i2);
            if (tempStack == null || tempStack.b().cp != iItemID || iItemDamage != Short.MAX_VALUE && (bMetaDataExclusive || tempStack.k() != iItemDamage) && (!bMetaDataExclusive || tempStack.k() == iItemDamage)) continue;
            itemCount += inventory.a((int)i2).a;
        }
        return itemCount;
    }

    public static boolean consumeItemsInInventory(lt inventory, int iShiftedItemIndex, int iItemDamage, int iItemCount) {
        return InventoryUtils.consumeItemsInInventory(inventory, iShiftedItemIndex, iItemDamage, iItemCount, false);
    }

    public static boolean consumeItemsInInventory(lt inventory, int iShiftedItemIndex, int iItemDamage, int iItemCount, boolean bMetaDataExclusive) {
        for (int iSlot = 0; iSlot < inventory.j_(); ++iSlot) {
            wm tempItemStack = inventory.a(iSlot);
            if (tempItemStack == null) continue;
            wk tempItem = tempItemStack.b();
            if (tempItem.cp != iShiftedItemIndex || iItemDamage != Short.MAX_VALUE && (bMetaDataExclusive || tempItemStack.k() != iItemDamage) && (!bMetaDataExclusive || tempItemStack.k() == iItemDamage)) continue;
            if (tempItemStack.a >= iItemCount) {
                InventoryUtils.decreaseStackSize(inventory, iSlot, iItemCount);
                return true;
            }
            iItemCount -= tempItemStack.a;
            inventory.a(iSlot, null);
        }
        return false;
    }

    public static boolean addSingleItemToInventory(lt inventory, int iItemShiftedIndex, int itemDamage) {
        wm itemStack = new wm(iItemShiftedIndex, 1, itemDamage);
        return InventoryUtils.addItemStackToInventory(inventory, itemStack);
    }

    public static boolean addItemStackToInventory(lt inventory, wm stack) {
        return InventoryUtils.addItemStackToInventoryInSlotRange(inventory, stack, 0, inventory.j_() - 1);
    }

    public static boolean addItemStackToInventoryInSlotRange(lt inventory, wm itemstack, int iMinSlotIndex, int iMaxSlotIndex) {
        if (!itemstack.i() && InventoryUtils.attemptToMergeWithExistingStacksInSlotRange(inventory, itemstack, iMinSlotIndex, iMaxSlotIndex)) {
            return true;
        }
        return InventoryUtils.attemptToPlaceInEmptySlotInSlotRange(inventory, itemstack, iMinSlotIndex, iMaxSlotIndex);
    }

    public static int getMaxNumberOfItemsForTransferInRange(lt inventory, wm itemStack, int countLimit, int minSlotIndex, int maxSlotIndex) {
        int totalSlotCount = maxSlotIndex - minSlotIndex + 1;
        int maximumEmptySlotCount = totalSlotCount - InventoryUtils.getNumOccupiedStacksInRange(inventory, minSlotIndex, maxSlotIndex);
        int maxItemsForEmptySlots = maximumEmptySlotCount * itemStack.e();
        if (maxItemsForEmptySlots >= countLimit) {
            return countLimit;
        }
        int itemCountToMerge = countLimit - maxItemsForEmptySlots;
        ArrayList<Integer> slotsAvailableToMerge = InventoryUtils.getAllOccupiedStacksOfItem(inventory, itemStack.c);
        int availableItems = 0;
        for (int slotIndex : slotsAvailableToMerge) {
            wm slotStack = inventory.a(slotIndex);
            availableItems += slotStack.e() - slotStack.a;
        }
        if (availableItems >= itemCountToMerge) {
            return countLimit;
        }
        return countLimit - (itemCountToMerge - availableItems);
    }

    public static boolean addItemStackToChest(apy chest, wm itemstack) {
        aab world = chest.k;
        for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
            apy secondChest;
            BlockPos secondChestPos = new BlockPos(chest.l, chest.m, chest.n);
            secondChestPos.addFacingAsOffset(iTempFacing);
            int iSecondBlockID = world.a(secondChestPos.x, secondChestPos.y, secondChestPos.z);
            if (iSecondBlockID != apa.ay.cz && iSecondBlockID != BTWBlocks.chest.cz || (secondChest = (apy)world.r(secondChestPos.x, secondChestPos.y, secondChestPos.z)) == null) continue;
            if (chest.l < secondChest.l || chest.n < secondChest.n) {
                return InventoryUtils.addItemStackToDoubleInventory((lt)chest, (lt)secondChest, itemstack);
            }
            return InventoryUtils.addItemStackToDoubleInventory((lt)secondChest, (lt)chest, itemstack);
        }
        return InventoryUtils.addItemStackToInventory((lt)chest, itemstack);
    }

    private static boolean canStacksMerge(wm sourceStack, wm destStack, int iInventoryStackSizeLimit) {
        return destStack != null && destStack.c == sourceStack.c && destStack.f() && destStack.a < destStack.e() && destStack.a < iInventoryStackSizeLimit && (!destStack.h() || destStack.k() == sourceStack.k()) && wm.a(destStack, sourceStack);
    }

    private static int findSlotToMergeItemStackInSlotRange(lt inventory, wm itemStack, int iMinSlotIndex, int iMaxSlotIndex) {
        int iInventoryStackLimit = inventory.d();
        for (int i2 = iMinSlotIndex; i2 <= iMaxSlotIndex; ++i2) {
            wm tempStack = inventory.a(i2);
            if (!InventoryUtils.canStacksMerge(itemStack, tempStack, iInventoryStackLimit)) continue;
            return i2;
        }
        return -1;
    }

    private static boolean attemptToMergeWithExistingStacks(lt inventory, wm stack) {
        return InventoryUtils.attemptToMergeWithExistingStacksInSlotRange(inventory, stack, 0, inventory.j_() - 1);
    }

    private static boolean attemptToMergeWithExistingStacksInSlotRange(lt inventory, wm stack, int iMinSlotIndex, int iMaxSlotIndex) {
        int iMergeSlot = InventoryUtils.findSlotToMergeItemStackInSlotRange(inventory, stack, iMinSlotIndex, iMaxSlotIndex);
        while (iMergeSlot >= 0) {
            int iNumItemsToStore = stack.a;
            wm tempStack = inventory.a(iMergeSlot);
            if (iNumItemsToStore > tempStack.e() - tempStack.a) {
                iNumItemsToStore = tempStack.e() - tempStack.a;
            }
            if (iNumItemsToStore > inventory.d() - tempStack.a) {
                iNumItemsToStore = inventory.d() - tempStack.a;
            }
            if (iNumItemsToStore == 0) {
                return false;
            }
            stack.a -= iNumItemsToStore;
            tempStack.a += iNumItemsToStore;
            inventory.a(iMergeSlot, tempStack);
            if (stack.a <= 0) {
                return true;
            }
            iMergeSlot = InventoryUtils.findSlotToMergeItemStackInSlotRange(inventory, stack, iMinSlotIndex, iMaxSlotIndex);
        }
        return false;
    }

    private static boolean attemptToPlaceInEmptySlot(lt inventory, wm stack) {
        return InventoryUtils.attemptToPlaceInEmptySlotInSlotRange(inventory, stack, 0, inventory.j_() - 1);
    }

    private static boolean attemptToPlaceInEmptySlotInSlotRange(lt inventory, wm stack, int iMinSlotIndex, int iMaxSlotIndex) {
        int iItemID = stack.c;
        int iItemDamage = stack.k();
        int iEmptySlot = InventoryUtils.getFirstEmptyStackInSlotRange(inventory, iMinSlotIndex, iMaxSlotIndex);
        while (iEmptySlot >= 0) {
            int iNumItemsToStore = stack.a;
            if (iNumItemsToStore > inventory.d()) {
                iNumItemsToStore = inventory.d();
            }
            wm newStack = new wm(iItemID, iNumItemsToStore, iItemDamage);
            InventoryUtils.copyEnchantments(newStack, stack);
            inventory.a(iEmptySlot, newStack);
            stack.a -= iNumItemsToStore;
            if (stack.a <= 0) {
                return true;
            }
            iEmptySlot = InventoryUtils.getFirstEmptyStackInSlotRange(inventory, iMinSlotIndex, iMaxSlotIndex);
        }
        return false;
    }

    private static boolean addItemStackToDoubleInventory(lt primaryInventory, lt secondaryInventory, wm stack) {
        if (!stack.i()) {
            if (InventoryUtils.attemptToMergeWithExistingStacks(primaryInventory, stack)) {
                return true;
            }
            if (InventoryUtils.attemptToMergeWithExistingStacks(secondaryInventory, stack)) {
                return true;
            }
        }
        if (InventoryUtils.attemptToPlaceInEmptySlot(primaryInventory, stack)) {
            return true;
        }
        return InventoryUtils.attemptToPlaceInEmptySlot(secondaryInventory, stack);
    }
}

