/*
 * Decompiled with CFR 0.152.
 */
package btw.inventory.container;

import btw.block.BTWBlocks;
import btw.inventory.inventories.InfernalEnchanterInventory;
import btw.item.BTWItems;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class InfernalEnchanterContainer
extends tj {
    public lt tableInventory;
    private aab localWorld;
    private int blockX;
    private int blockY;
    private int blockZ;
    private static final double MAX_INTERACTION_DISTANCE = 8.0;
    private static final double MAX_INTERACTION_DISTANCE_SQ = 64.0;
    private static final int SLOT_SCREEN_WIDTH = 18;
    private static final int SLOT_SCREEN_HEIGHT = 18;
    private static final int SCROLL_SLOT_SCREEN_POS_X = 17;
    private static final int SCROLL_SLOT_SCREEN_POS_Y = 37;
    private static final int ITEM_SLOT_SCREEN_POS_X = 17;
    private static final int ITEM_SLOT_SCREEN_POS_Y = 75;
    private static final int PLAYER_INVENTORY_SCREEN_POS_X = 8;
    private static final int PLAYER_INVENTORY_SCREEN_POS_Y = 129;
    private static final int PLAYER_HOTBAR_SCREEN_POS_Y = 187;
    private static final int HORIZONTAL_BOOK_SHELF_CHECK_DISTANCE = 8;
    private static final int VERTICAL_POSITIVE_BOOK_SHELF_CHECK_DISTANCE = 8;
    private static final int VERTICAL_NEGATIVE_BOOK_SHELF_CHECK_DISTANCE = 8;
    public static final int MAX_ENCHANTMENT_POWER_LEVEL = 5;
    public int[] currentEnchantmentLevels;
    public int maxSurroundingBookshelfLevel;
    public int lastMaxSurroundingBookshelfLevel;
    public long nameSeed;
    Random rand;

    public InfernalEnchanterContainer(so playerInventory, aab world, int i2, int j2, int k) {
        this.localWorld = world;
        this.blockX = i2;
        this.blockY = j2;
        this.blockZ = k;
        this.rand = new Random();
        this.nameSeed = this.rand.nextLong();
        this.tableInventory = new InfernalEnchanterInventory(this, "fcInfernalEnchanterInv", 2);
        this.currentEnchantmentLevels = new int[5];
        this.resetEnchantingLevels();
        this.maxSurroundingBookshelfLevel = 0;
        this.lastMaxSurroundingBookshelfLevel = 0;
        this.a(new ul(this.tableInventory, 0, 17, 37));
        this.a(new ul(this.tableInventory, 1, 17, 75));
        for (int tempSlotY = 0; tempSlotY < 3; ++tempSlotY) {
            for (int tempSlotX = 0; tempSlotX < 9; ++tempSlotX) {
                this.a(new ul(playerInventory, tempSlotX + tempSlotY * 9 + 9, 8 + tempSlotX * 18, 129 + tempSlotY * 18));
            }
        }
        for (int tempSlotX = 0; tempSlotX < 9; ++tempSlotX) {
            this.a(new ul(playerInventory, tempSlotX, 8 + tempSlotX * 18, 187));
        }
        if (world != null && !world.I) {
            this.checkForSurroundingBookshelves();
        }
    }

    @Override
    public void a(lt inventory) {
        if (inventory == this.tableInventory) {
            this.nameSeed = this.rand.nextLong();
            this.resetEnchantingLevels();
            this.computeCurrentEnchantmentLevels();
            if (this.localWorld != null && !this.localWorld.I) {
                this.b();
            }
        }
    }

    @Override
    public void b(sq player) {
        super.b(player);
        if (this.localWorld == null || this.localWorld.I) {
            return;
        }
        for (int i2 = 0; i2 < this.tableInventory.j_(); ++i2) {
            wm itemstack = this.tableInventory.a(i2);
            if (itemstack == null) continue;
            player.c(itemstack);
        }
    }

    @Override
    public boolean a(sq entityplayer) {
        if (this.localWorld == null || this.localWorld.I) {
            return true;
        }
        if (this.localWorld.a(this.blockX, this.blockY, this.blockZ) != BTWBlocks.infernalEnchanter.cz) {
            return false;
        }
        return entityplayer.e((double)this.blockX + 0.5, (double)this.blockY + 0.5, (double)this.blockZ + 0.5) <= 64.0;
    }

    @Override
    public wm b(sq player, int iSlotIndex) {
        wm clickedStack = null;
        ul slot = (ul)this.c.get(iSlotIndex);
        if (slot != null && slot.d()) {
            wm processedStack = slot.c();
            clickedStack = processedStack.m();
            if (iSlotIndex <= 1 ? !this.a(processedStack, 2, 38, true) : (processedStack.b().cp == BTWItems.arcaneScroll.cp ? !this.a(processedStack, 0, 1, false) : (this.getMaximumEnchantmentCost(processedStack) > 0 ? !this.a(processedStack, 1, 2, false) : (iSlotIndex >= 2 && iSlotIndex < 29 ? !this.a(processedStack, 29, 38, false) : iSlotIndex >= 29 && iSlotIndex < 38 && !this.a(processedStack, 2, 29, false))))) {
                return null;
            }
            if (processedStack.a == 0) {
                slot.c(null);
            } else {
                slot.e();
            }
            if (processedStack.a != clickedStack.a) {
                slot.a(player, processedStack);
                if (this.localWorld != null && !this.localWorld.I) {
                    this.b();
                }
            } else {
                return null;
            }
        }
        return clickedStack;
    }

    private void checkForSurroundingBookshelves() {
        int iBookshelfCount = 0;
        for (int iTempI = this.blockX - 8; iTempI <= this.blockX + 8; ++iTempI) {
            for (int iTempJ = this.blockY - 8; iTempJ <= this.blockY + 8; ++iTempJ) {
                for (int iTempK = this.blockZ - 8; iTempK <= this.blockZ + 8; ++iTempK) {
                    if (!this.isValidBookshelf(iTempI, iTempJ, iTempK)) continue;
                    ++iBookshelfCount;
                }
            }
        }
        this.maxSurroundingBookshelfLevel = iBookshelfCount;
    }

    private boolean isValidBookshelf(int i2, int j2, int k) {
        int iBlockID = this.localWorld.a(i2, j2, k);
        return iBlockID == apa.ar.cz && (this.localWorld.c(i2 + 1, j2, k) || this.localWorld.c(i2 - 1, j2, k) || this.localWorld.c(i2, j2, k + 1) || this.localWorld.c(i2, j2, k - 1));
    }

    private void setCurrentEnchantingLevels(int iMaxPowerLevel, int iCostMultiplier, int iMaxBaseCostForItem) {
        this.resetEnchantingLevels();
        if (iMaxPowerLevel == 1) {
            this.currentEnchantmentLevels[0] = 30;
        } else if (iMaxPowerLevel == 2) {
            this.currentEnchantmentLevels[0] = 15;
            this.currentEnchantmentLevels[1] = 30;
        } else if (iMaxPowerLevel == 3) {
            this.currentEnchantmentLevels[0] = 10;
            this.currentEnchantmentLevels[1] = 20;
            this.currentEnchantmentLevels[2] = 30;
        } else if (iMaxPowerLevel == 4) {
            this.currentEnchantmentLevels[0] = 8;
            this.currentEnchantmentLevels[1] = 15;
            this.currentEnchantmentLevels[2] = 23;
            this.currentEnchantmentLevels[3] = 30;
        } else if (iMaxPowerLevel == 5) {
            this.currentEnchantmentLevels[0] = 6;
            this.currentEnchantmentLevels[1] = 12;
            this.currentEnchantmentLevels[2] = 18;
            this.currentEnchantmentLevels[3] = 24;
            this.currentEnchantmentLevels[4] = 30;
        }
        int iCostIncrement = (iCostMultiplier - 1) * 30;
        for (int iTemp = 0; iTemp < 5; ++iTemp) {
            if (this.currentEnchantmentLevels[iTemp] <= 0) continue;
            if (iMaxBaseCostForItem < this.currentEnchantmentLevels[iTemp]) {
                this.currentEnchantmentLevels[iTemp] = 0;
                continue;
            }
            int n = iTemp;
            this.currentEnchantmentLevels[n] = this.currentEnchantmentLevels[n] + iCostIncrement;
        }
    }

    private void resetEnchantingLevels() {
        for (int iTemp = 0; iTemp < 5; ++iTemp) {
            this.currentEnchantmentLevels[iTemp] = 0;
        }
    }

    private void computeCurrentEnchantmentLevels() {
        int iMaxEnchantmentCost;
        wm itemToEnchantStack;
        wm scrollStack = this.tableInventory.a(0);
        if (scrollStack != null && scrollStack.b().cp == BTWItems.arcaneScroll.cp && (itemToEnchantStack = this.tableInventory.a(1)) != null && (iMaxEnchantmentCost = this.getMaximumEnchantmentCost(itemToEnchantStack)) > 0) {
            int iEnchantmentIndex = scrollStack.k();
            if (iEnchantmentIndex >= yz.b.length || yz.b[iEnchantmentIndex] == null) {
                return;
            }
            if (this.isEnchantmentAppropriateForItem(iEnchantmentIndex, itemToEnchantStack) && !this.doesEnchantmentConflictWithExistingOnes(iEnchantmentIndex, itemToEnchantStack)) {
                int iMaxNumberOfItemEnchants = this.getMaximumNumberOfEnchantments(itemToEnchantStack);
                int iCurrentNumberOfItemEnchants = 0;
                ca enchantmentTagList = itemToEnchantStack.r();
                if (enchantmentTagList != null) {
                    iCurrentNumberOfItemEnchants = itemToEnchantStack.r().c();
                }
                if (iCurrentNumberOfItemEnchants < iMaxNumberOfItemEnchants) {
                    this.setCurrentEnchantingLevels(this.getMaxEnchantmentPowerLevel(iEnchantmentIndex, itemToEnchantStack), iCurrentNumberOfItemEnchants + 1, this.getMaximumEnchantmentCost(itemToEnchantStack));
                }
            }
        }
    }

    private int getMaximumEnchantmentCost(wm itemStack) {
        return itemStack.b().getInfernalMaxEnchantmentCost();
    }

    private int getMaximumNumberOfEnchantments(wm itemStack) {
        return itemStack.b().getInfernalMaxNumEnchants();
    }

    private boolean isEnchantmentAppropriateForItem(int iEnchantmentIndex, wm itemStack) {
        return yz.b[iEnchantmentIndex].a(itemStack);
    }

    private boolean doesEnchantmentConflictWithExistingOnes(int iEnchantmentIndex, wm itemStack) {
        ca enchantmentTagList = itemStack.r();
        if (enchantmentTagList != null) {
            int iCurrentNumberOfItemEnchants = itemStack.r().c();
            for (int iTemp = 0; iTemp < iCurrentNumberOfItemEnchants; ++iTemp) {
                short iTempEnchantmentIndex = ((bs)enchantmentTagList.b(iTemp)).d("id");
                if (iTempEnchantmentIndex == iEnchantmentIndex) {
                    return true;
                }
                if ((iEnchantmentIndex != yz.s.z || iTempEnchantmentIndex != yz.u.z) && (iEnchantmentIndex != yz.u.z || iTempEnchantmentIndex != yz.s.z)) continue;
                return true;
            }
        }
        return false;
    }

    private int getMaxEnchantmentPowerLevel(int iEnchantmentIndex, wm itemStack) {
        if (iEnchantmentIndex == yz.i.z && itemStack.b().cp == BTWItems.plateHelmet.cp) {
            return 5;
        }
        return yz.b[iEnchantmentIndex].b();
    }

    @Override
    public boolean a(sq player, int iButtonIndex) {
        if (this.localWorld == null || this.localWorld.I) {
            return true;
        }
        int iButtonEnchantmentLevel = this.currentEnchantmentLevels[iButtonIndex];
        if (iButtonEnchantmentLevel > 0) {
            wm itemToEnchantStack;
            wm scrollStack;
            boolean bPlayerCapable;
            boolean bl = bPlayerCapable = iButtonEnchantmentLevel <= player.cf && iButtonEnchantmentLevel <= this.maxSurroundingBookshelfLevel;
            if (bPlayerCapable && (scrollStack = this.tableInventory.a(0)) != null && scrollStack.b().cp == BTWItems.arcaneScroll.cp && (itemToEnchantStack = this.tableInventory.a(1)) != null) {
                int iEnchantmentIndex = scrollStack.k();
                if (iEnchantmentIndex >= yz.b.length || yz.b[iEnchantmentIndex] == null) {
                    return false;
                }
                itemToEnchantStack.a(yz.b[iEnchantmentIndex], iButtonIndex + 1);
                player.a(-iButtonEnchantmentLevel);
                this.tableInventory.a(0, 1);
                this.a(this.tableInventory);
                this.localWorld.a((mp)player, "ambient.weather.thunder", 1.0f, this.localWorld.s.nextFloat() * 0.4f + 0.8f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void a(tp craftingInterface) {
        super.a(craftingInterface);
        craftingInterface.a((tj)this, 0, this.maxSurroundingBookshelfLevel);
    }

    @Override
    public void b() {
        super.b();
        for (tp icrafting : this.e) {
            if (this.lastMaxSurroundingBookshelfLevel == this.maxSurroundingBookshelfLevel) continue;
            icrafting.a((tj)this, 0, this.maxSurroundingBookshelfLevel);
        }
        this.lastMaxSurroundingBookshelfLevel = this.maxSurroundingBookshelfLevel;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void b(int iVariableIndex, int iValue) {
        if (iVariableIndex == 0) {
            this.maxSurroundingBookshelfLevel = iValue;
        }
    }
}

