/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mob.villager;

import btw.entity.mob.WitchEntity;
import btw.entity.mob.WolfEntity;
import btw.entity.mob.ZombieEntity;
import btw.entity.mob.behavior.VillagerBreedBehavior;
import btw.entity.mob.villager.BlacksmithVillagerEntity;
import btw.entity.mob.villager.ButcherVillagerEntity;
import btw.entity.mob.villager.FarmerVillagerEntity;
import btw.entity.mob.villager.LibrarianVillagerEntity;
import btw.entity.mob.villager.PriestVillagerEntity;
import btw.item.BTWItems;
import btw.util.RandomSelector;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public abstract class VillagerEntity
extends sm {
    protected static final int IN_LOVE_DATA_WATCHER_ID = 22;
    protected static final int TRADE_LEVEL_DATA_WATCHER_ID = 23;
    protected static final int TRADE_EXPERIENCE_DATA_WATCHER_ID = 25;
    protected static final int DIRTY_PEASANT_DATA_WATCHER_ID = 26;
    protected int aiFullTickCountdown;
    protected int updateTradesCountdown;
    public static final int PROFESSION_ID_FARMER = 0;
    public static final int PROFESSION_ID_LIBRARIAN = 1;
    public static final int PROFESSION_ID_PRIEST = 2;
    public static final int PROFESSION_ID_BLACKSMITH = 3;
    public static final int PROFESSION_ID_BUTCHER = 4;
    public static final int CASTE_ID_PEASANT = 0;
    public static final int CASTE_ID_MANUFACTURER = 1;
    public static final int CASTE_ID_ERUDITE = 2;
    public static Map<Integer, Class> professionMap = new HashMap<Integer, Class>();
    public static Map<Integer, ArrayList<Integer>> casteMap = new HashMap<Integer, ArrayList<Integer>>();
    public static Map<Integer, Set<WeightedMerchantEntry>> tradeByProfessionList = new HashMap<Integer, Set<WeightedMerchantEntry>>();
    public static Map<Integer, Map<Integer, WeightedMerchantEntry>> levelUpTradeByProfessionList = new HashMap<Integer, Map<Integer, WeightedMerchantEntry>>();
    public static Map<Integer, WeightedMerchantEntry> defaultTradeByProfessionList = new HashMap<Integer, WeightedMerchantEntry>();
    public static Map<Integer, Map<WeightedMerchantEntry, TradeEffect>> tradeEffectRegistry = new HashMap<Integer, Map<WeightedMerchantEntry, TradeEffect>>();
    public static Map<Integer, Map<Integer, TradeEffect>> levelUpEffectRegistry = new HashMap<Integer, Map<Integer, TradeEffect>>();
    public static TradeEffect defaultLevelUpEffect;
    public static int[] xpPerLevel;

    public VillagerEntity(aab world) {
        this(world, 0);
    }

    public VillagerEntity(aab world, int iProfession) {
        super(world, iProfession);
        this.bo.removeAllTasksOfClass(oa.class);
        this.bo.a(1, (om)new oa((nr)this, ZombieEntity.class, 8.0f, 0.3f, 0.35f));
        this.bo.a(1, (om)new oa((nr)this, WolfEntity.class, 8.0f, 0.3f, 0.35f));
        this.bo.removeAllTasksOfClass(ot.class);
        this.bo.a(1, new VillagerBreedBehavior(this));
        this.bo.a(2, new pn(this, 0.3f, wk.o.cp, false));
        this.be = 50;
        this.updateTradesCountdown = 0;
        this.aiFullTickCountdown = 0;
    }

    @Override
    protected void bp() {
        --this.aiFullTickCountdown;
        if (this.aiFullTickCountdown <= 0) {
            this.aiFullTickCountdown = 70 + this.ab.nextInt(50);
            this.q.A.a(kx.c(this.u), kx.c(this.v), kx.c(this.w));
            this.d = this.q.A.a(kx.c(this.u), kx.c(this.v), kx.c(this.w), 32);
            if (this.d == null) {
                this.aO();
            } else {
                t var1 = this.d.a();
                this.b(var1.a, var1.b, var1.c, (int)((float)this.d.b() * 0.6f));
            }
        }
        if (!this.p()) {
            if (this.getCurrentTradeLevel() == 0) {
                this.setTradeLevel(1);
                this.i = null;
                this.updateTradesCountdown = 0;
                this.checkForNewTrades(1);
            } else if (this.updateTradesCountdown > 0) {
                if (this.i == null) {
                    this.i = new zr();
                }
                --this.updateTradesCountdown;
                if (this.updateTradesCountdown <= 0) {
                    Iterator tradeListIterator = this.i.iterator();
                    while (tradeListIterator.hasNext()) {
                        zq tempRecipe = (zq)tradeListIterator.next();
                        if (!tempRecipe.g()) continue;
                        tradeListIterator.remove();
                    }
                    int desiredNumTrades = this.getCurrentMaxNumTrades();
                    if (this.i.size() < desiredNumTrades) {
                        this.checkForNewTrades(desiredNumTrades - this.i.size());
                        this.q.a((mp)this, (byte)14);
                        this.d(new ml(mk.l.H, 200, 0));
                    }
                }
            } else {
                this.updateTradesCountdown = 600 + this.ab.nextInt(600);
            }
        }
    }

    @Override
    public boolean a_(sq player) {
        if (this.customInteract(player)) {
            return true;
        }
        if (this.getInLove() > 0) {
            return this.entityAgeableInteract(player);
        }
        return super.a_(player);
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(22, new Integer(0));
        this.ah.a(23, new Integer(0));
        this.ah.a(25, new Integer(0));
        this.ah.a(26, new Integer(0));
    }

    @Override
    public void b(bs tag) {
        super.b(tag);
        tag.a("FCInLove", this.getInLove());
        tag.a("FCTradeLevel", this.getCurrentTradeLevel());
        tag.a("FCTradeXP", this.getCurrentTradeXP());
        tag.a("FCDirty", this.getDirtyPeasant());
    }

    @Override
    public void a(bs tag) {
        super.a(tag);
        if (tag.b("FCInLove")) {
            this.setInLove(tag.e("FCInLove"));
        }
        if (tag.b("FCTradeLevel")) {
            this.setTradeLevel(tag.e("FCTradeLevel"));
        }
        if (tag.b("FCTradeXP")) {
            this.setTradeExperience(tag.e("FCTradeXP"));
        }
        if (tag.b("FCDirty")) {
            this.setDirtyPeasant(tag.e("FCDirty"));
        }
        this.checkForInvalidTrades();
    }

    @Override
    public void c(ng attackingEntity) {
        this.e = attackingEntity;
        if (attackingEntity != null) {
            this.f = 100;
            if (this.d != null) {
                this.d.a(attackingEntity);
            }
            if (this.R()) {
                this.q.a((mp)this, (byte)13);
            }
        } else {
            this.f = 0;
        }
    }

    @Override
    public void a(zq recipe) {
        recipe.f();
        this.updateTradesCountdown = 10;
        this.playEffectsForTrade(recipe);
        if (recipe.tradeLevel < 0) {
            int tradeLevel = this.getCurrentTradeLevel();
            if (tradeLevel < 5 && this.getCurrentTradeXP() == this.getCurrentTradeMaxXP() && this.getCurrentTradeLevel() == -recipe.tradeLevel) {
                this.setTradeLevel(++tradeLevel);
                this.setTradeExperience(0);
                this.playEffectsForLevelUp(recipe);
            }
        } else if (recipe.tradeLevel >= this.getCurrentTradeLevel() && !recipe.isMandatory()) {
            int maxXP;
            int currentXP = this.getCurrentTradeXP() + 1;
            if (currentXP > (maxXP = this.getCurrentTradeMaxXP())) {
                currentXP = maxXP;
            }
            this.setTradeExperience(currentXP);
        }
    }

    @Override
    public zr b(sq player) {
        if (this.i == null) {
            this.checkForNewTrades(1);
        }
        return this.i;
    }

    @Override
    public void bJ() {
        this.s(this.getProfessionFromClass());
    }

    @Override
    public void c() {
        super.c();
        if (!this.q.I) {
            if (this.R()) {
                this.checkForLooseMilk();
            }
        } else {
            this.updateStatusParticles();
        }
    }

    @Override
    protected void a(boolean bKilledByPlayer, int iLootingModifier) {
        if (!this.hasHeadCrabbedSquid()) {
            int iDropItemID = BTWItems.rawMysteryMeat.cp;
            if (this.ae()) {
                iDropItemID = this.q.getDifficulty().shouldBurningMobsDropCookedMeat() ? BTWItems.cookedMysteryMeat.cp : BTWItems.burnedMeat.cp;
            }
            int iNumDropped = this.ab.nextInt(3) + 1 + this.ab.nextInt(1 + iLootingModifier);
            for (int iTempCount = 0; iTempCount < iNumDropped; ++iTempCount) {
                this.b(iDropItemID, 1);
            }
        }
    }

    @Override
    public float aY() {
        float fPitch = super.aY();
        if (this.isPossessed() || this.m() == 2 && this.getCurrentTradeLevel() == 5) {
            fPitch *= 0.6f;
        }
        return fPitch;
    }

    @Override
    public boolean getCanCreatureTypeBePossessed() {
        return true;
    }

    @Override
    public void onFullPossession() {
        this.q.e(2260, kx.c(this.u), kx.c(this.v), kx.c(this.w), 0);
        this.w();
        WitchEntity entityWitch = (WitchEntity)mv.createEntityOfType(WitchEntity.class, this.q);
        entityWitch.b(this.u, this.v, this.w, this.A, this.B);
        entityWitch.ay = this.ay;
        entityWitch.setPersistent(true);
        this.q.d(entityWitch);
    }

    @Override
    public boolean isValidZombieSecondaryTarget(sj zombie) {
        return true;
    }

    @Override
    public boolean isSecondaryTargetForSquid() {
        return true;
    }

    @Override
    public double W() {
        return this.P;
    }

    public VillagerEntity func_90012_b(mm otherParent) {
        VillagerEntity child = VillagerEntity.createVillager(this.q);
        child.bJ();
        return child;
    }

    public static VillagerEntity createVillager(aab world) {
        return VillagerEntity.createVillagerFromProfession(world, 0);
    }

    public static VillagerEntity createVillagerFromProfession(aab world, int profession) {
        Class<? extends mp> villagerClass = professionMap.get(profession);
        try {
            villagerClass = mv.getRegisteredReplacement(villagerClass);
            VillagerEntity villager = (VillagerEntity)villagerClass.getConstructor(aab.class).newInstance(world);
            villager.s(profession);
            return villager;
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
        catch (NoSuchMethodException e6) {
            e6.printStackTrace();
        }
        catch (SecurityException e7) {
            e7.printStackTrace();
        }
        return null;
    }

    public VillagerEntity spawnBabyVillagerWithProfession(mm otherParent, int profession) {
        VillagerEntity child = VillagerEntity.createVillagerFromProfession(this.q, profession);
        child.bJ();
        return child;
    }

    public int getProfessionFromClass() {
        for (int id : professionMap.keySet()) {
            if (!this.getClass().isAssignableFrom(professionMap.get(id))) continue;
            return id;
        }
        return 0;
    }

    public static int getCasteFromProfession(int professionID) {
        for (int caste : casteMap.keySet()) {
            if (!casteMap.get(caste).contains(professionID)) continue;
            return caste;
        }
        return -1;
    }

    protected void checkForNewTrades(int availableTrades) {
        if (availableTrades > 0) {
            if (this.getCurrentTradeMaxXP() == this.getCurrentTradeXP() && this.checkForLevelUpTrade() && --availableTrades <= 0) {
                return;
            }
            zr recipeList = new zr();
            if ((availableTrades = this.checkForProfessionMandatoryTrades(recipeList, availableTrades, this.getCurrentTradeLevel())) > 0) {
                this.checkForProfessionTrades(recipeList, availableTrades);
            }
            if (recipeList.isEmpty()) {
                recipeList.add(this.getProfessionDefaultTrade());
            } else {
                Collections.shuffle(recipeList);
            }
            if (this.i == null) {
                this.i = new zr();
            }
            for (int i2 = 0; i2 < recipeList.size(); ++i2) {
                this.i.a((zq)recipeList.get(i2));
            }
        }
    }

    protected void checkForProfessionTrades(zr recipeList, int availableTrades) {
        HashSet<WeightedMerchantEntry> tradeList = new HashSet<WeightedMerchantEntry>();
        for (WeightedMerchantEntry entry : tradeByProfessionList.get(this.getProfessionFromClass())) {
            if (entry.level > this.getCurrentTradeLevel() || entry.isMandatory() || !entry.canBeAdded(this)) continue;
            tradeList.add(entry);
        }
        int maxAttempts = 50;
        for (int currentAttempts = 0; availableTrades > 0 && currentAttempts < maxAttempts; ++currentAttempts) {
            zq recipe = this.getRandomTradeFromAdjustedWeight(tradeList);
            if (this.doesRecipeListAlreadyContainRecipe(recipe)) continue;
            recipeList.add(recipe);
            --availableTrades;
        }
    }

    protected int checkForProfessionMandatoryTrades(zr recipeList, int availableTrades, int level) {
        Set<WeightedMerchantEntry> entries = tradeByProfessionList.get(this.getProfessionFromClass());
        if (entries != null) {
            for (WeightedMerchantEntry entry : entries) {
                zq recipe;
                if (entry.level > level || availableTrades <= 0 || !entry.isMandatory() || this.doesRecipeListAlreadyContainRecipe(recipe = entry.generateRecipe(this.ab))) continue;
                recipeList.add(recipe);
                --availableTrades;
            }
        }
        return availableTrades;
    }

    private boolean checkForLevelUpTrade() {
        if (this.getCurrentTradeLevel() >= 5) {
            return false;
        }
        zq recipe = this.getProfessionLevelUpTrade(this.getCurrentTradeLevel());
        if (recipe != null && !this.doesRecipeListAlreadyContainRecipe(recipe)) {
            this.i.add(recipe);
            return true;
        }
        return false;
    }

    protected zq getProfessionLevelUpTrade(int level) {
        WeightedMerchantEntry entry = levelUpTradeByProfessionList.get(this.getProfessionFromClass()).get(level);
        if (entry == null) {
            throw new RuntimeException("Level up entry for profession " + this.getProfessionFromClass() + " on level " + this.getCurrentTradeLevel() + " was missing!");
        }
        return entry.generateRecipe(this.ab);
    }

    protected boolean doesRecipeListAlreadyContainRecipe(zq recipe) {
        if (this.i != null) {
            for (int i2 = 0; i2 < this.i.size(); ++i2) {
                zq recipeForCompare = (zq)this.i.get(i2);
                if (!recipe.a(recipeForCompare)) continue;
                return true;
            }
        }
        return false;
    }

    protected zq getProfessionDefaultTrade() {
        return defaultTradeByProfessionList.get(this.getProfessionFromClass()).generateRecipe(this.ab);
    }

    protected zq getRandomTradeFromAdjustedWeight(Set<WeightedMerchantEntry> tradeList) {
        final int villagerTradeLevel = this.getCurrentTradeLevel();
        ToDoubleFunction<WeightedMerchantEntry> weighter = new ToDoubleFunction<WeightedMerchantEntry>(){

            @Override
            public double applyAsDouble(WeightedMerchantEntry entry) {
                return entry.weight * (float)entry.level / (float)villagerTradeLevel;
            }
        };
        RandomSelector<WeightedMerchantEntry> selector = RandomSelector.weighted(tradeList, weighter);
        return selector.next(this.ab).generateRecipe(this.ab);
    }

    public int getCurrentMaxNumTrades() {
        int numMandatoryTrades = 0;
        for (WeightedMerchantEntry entry : tradeByProfessionList.get(this.getProfessionFromClass())) {
            if (entry.level > this.getCurrentTradeLevel() || !entry.isMandatory()) continue;
            ++numMandatoryTrades;
        }
        return this.getCurrentTradeLevel() + numMandatoryTrades;
    }

    private void checkForInvalidTrades() {
        if (this.i != null) {
            Iterator iterator = this.i.iterator();
            while (iterator.hasNext()) {
                zq trade = (zq)iterator.next();
                if (!this.isInvalidProfessionTrade(trade)) continue;
                iterator.remove();
            }
        }
    }

    protected boolean isInvalidProfessionTrade(zq trade) {
        try {
            for (WeightedMerchantEntry entry : tradeByProfessionList.get(this.getProfessionFromClass())) {
                if (!entry.matchesMerchantRecipe(trade)) continue;
                return trade.a().a > trade.a().e() || trade.c() && trade.b().a > trade.b().e() || trade.d().a > trade.d().e();
            }
            for (int i2 = 1; i2 < 5; ++i2) {
                WeightedMerchantEntry entry;
                entry = levelUpTradeByProfessionList.get(this.getProfessionFromClass()).get(i2);
                if (!entry.matchesMerchantRecipe(trade)) continue;
                return trade.a().a > trade.a().e() || trade.c() && trade.b().a > trade.b().e() || trade.d().a > trade.d().e();
            }
            return true;
        }
        catch (NullPointerException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static WeightedMerchantEntry addTradeToBuySingleItem(int profession, int itemID, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToBuySingleItem(profession, itemID, 0, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToBuySingleItem(int profession, int itemID, int itemMetadata, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToBuy(profession, itemID, itemMetadata, 1, 1, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToBuyMultipleItems(int profession, int itemID, int minItemCount, int maxItemCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToBuyMultipleItems(profession, itemID, 0, minItemCount, maxItemCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToBuyMultipleItems(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToBuy(profession, itemID, itemMetadata, minItemCount, maxItemCount, 1, 1, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToBuy(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        WeightedMerchantRecipeEntry entry = new WeightedMerchantRecipeEntry(itemID, itemMetadata, minItemCount, maxItemCount, wk.bI.cp, 0, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
        return VillagerEntity.addCustomTrade(profession, entry);
    }

    public static WeightedMerchantEntry addTradeToSellSingleItem(int profession, int itemID, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToSellSingleItem(profession, itemID, 0, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToSellSingleItem(int profession, int itemID, int itemMetadata, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToSell(profession, itemID, itemMetadata, 1, 1, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToSellMultipleItems(int profession, int itemID, int minItemCount, int maxItemCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToSellMultipleItems(profession, itemID, 0, minItemCount, maxItemCount, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToSellMultipleItems(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, float weight, int tradeLevel) {
        return VillagerEntity.addTradeToSell(profession, itemID, itemMetadata, minItemCount, maxItemCount, 1, 1, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addTradeToSell(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        WeightedMerchantRecipeEntry entry = new WeightedMerchantRecipeEntry(wk.bI.cp, 0, minEmeraldCount, maxEmeraldCount, itemID, itemMetadata, minItemCount, maxItemCount, weight, tradeLevel);
        return VillagerEntity.addCustomTrade(profession, entry);
    }

    public static WeightedMerchantEntry addArcaneScrollTrade(int profession, int enchantmentID, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        return VillagerEntity.addItemConversionTrade(profession, wk.aL.cp, 0, minEmeraldCount, maxEmeraldCount, BTWItems.arcaneScroll.cp, enchantmentID, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addSkullconversionTrade(int profession, int inputSkullType, int minEmeralds, int maxEmeralds, int resultSkullType, float weight, int tradeLevel) {
        return VillagerEntity.addItemConversionTrade(profession, wk.bR.cp, inputSkullType, minEmeralds, maxEmeralds, wk.bR.cp, resultSkullType, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addItemConversionTrade(int profession, int itemID, int minEmeralds, int maxEmeralds, int resultID, float weight, int tradeLevel) {
        return VillagerEntity.addItemConversionTrade(profession, itemID, 0, minEmeralds, maxEmeralds, resultID, 0, weight, tradeLevel);
    }

    public static WeightedMerchantEntry addItemConversionTrade(int profession, int itemID, int itemMetadata, int minEmeraldCount, int maxEmeraldCount, int resultID, int resultMetadata, float weight, int tradeLevel) {
        WeightedMerchantRecipeEntry entry = new WeightedMerchantRecipeEntry(itemID, itemMetadata, 1, 1, wk.bI.cp, 0, minEmeraldCount, maxEmeraldCount, resultID, resultMetadata, 1, 1, weight, tradeLevel);
        return VillagerEntity.addCustomTrade(profession, entry);
    }

    public static WeightedMerchantEntry addEnchantmentTrade(int profession, int itemID, int minEmeraldCount, int maxEmeraldCount, float weight, int tradeLevel) {
        WeightMerchantEnchantmentEntry entry = new WeightMerchantEnchantmentEntry(itemID, minEmeraldCount, maxEmeraldCount, weight, tradeLevel);
        return VillagerEntity.addCustomTrade(profession, entry);
    }

    public static WeightedMerchantEntry addComplexTrade(int profession, int input1ID, int input1Metadata, int input1MinCount, int input1MaxCount, int input2ID, int input2Metadata, int input2MinCount, int input2MaxCount, int resultID, int resultMetadata, int resultMinCount, int resultMaxCount, float weight, int tradeLevel) {
        WeightedMerchantRecipeEntry entry = new WeightedMerchantRecipeEntry(input1ID, input1Metadata, input1MinCount, input1MaxCount, input2ID, input2Metadata, input2MinCount, input2MaxCount, resultID, resultMetadata, resultMinCount, resultMaxCount, weight, tradeLevel);
        return VillagerEntity.addCustomTrade(profession, entry);
    }

    public static WeightedMerchantEntry addCustomTrade(int profession, WeightedMerchantEntry entry) {
        Map<Integer, Set<WeightedMerchantEntry>> tradeList = tradeByProfessionList;
        Set<WeightedMerchantEntry> tradeEntryList = tradeList.get(profession);
        if (tradeEntryList == null) {
            tradeEntryList = new HashSet<WeightedMerchantEntry>();
            tradeList.put(profession, tradeEntryList);
        }
        tradeEntryList.add(entry);
        return entry;
    }

    public static void addLevelUpTradeToBuySingleItem(int profession, int itemID, int minEmeraldCount, int maxEmeraldCount, int tradeLevel) {
        VillagerEntity.addLevelUpTradeToBuySingleItem(profession, itemID, 0, minEmeraldCount, maxEmeraldCount, tradeLevel);
    }

    public static void addLevelUpTradeToBuySingleItem(int profession, int itemID, int itemMetadata, int minEmeraldCount, int maxEmeraldCount, int tradeLevel) {
        VillagerEntity.addLevelUpTradeToBuy(profession, itemID, itemMetadata, 1, 1, minEmeraldCount, maxEmeraldCount, tradeLevel);
    }

    public static void addLevelUpTradeToBuyMultipleItems(int profession, int itemID, int minItemCount, int maxItemCount, int tradeLevel) {
        VillagerEntity.addLevelUpTradeToBuyMultipleItems(profession, itemID, 0, minItemCount, maxItemCount, tradeLevel);
    }

    public static void addLevelUpTradeToBuyMultipleItems(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, int tradeLevel) {
        VillagerEntity.addLevelUpTradeToBuy(profession, itemID, itemMetadata, minItemCount, maxItemCount, 1, 1, tradeLevel);
    }

    public static void addLevelUpTradeToBuy(int profession, int itemID, int itemMetadata, int minItemCount, int maxItemCount, int minEmeraldCount, int maxEmeraldCount, int tradeLevel) {
        WeightedMerchantRecipeEntry entry = new WeightedMerchantRecipeEntry(itemID, itemMetadata, minItemCount, maxItemCount, wk.bI.cp, 0, minEmeraldCount, maxEmeraldCount, 1.0f, tradeLevel);
        VillagerEntity.addCustomLevelUpTrade(profession, entry);
    }

    public static void addCustomLevelUpTrade(int profession, WeightedMerchantEntry entry) {
        Map<Integer, WeightedMerchantEntry> tradeEntryList = levelUpTradeByProfessionList.get(profession);
        if (tradeEntryList == null) {
            tradeEntryList = new HashMap<Integer, WeightedMerchantEntry>();
            levelUpTradeByProfessionList.put(profession, tradeEntryList);
        }
        int tradeLevel = entry.level;
        entry.level *= -1;
        if (tradeEntryList.containsKey(tradeLevel)) {
            throw new RuntimeException("Profession id " + profession + "already has a level up trade assigned for level " + tradeLevel);
        }
        tradeEntryList.put(tradeLevel, entry);
    }

    public static boolean removeLevelUpTrade(int profession, int level) {
        WeightedMerchantEntry entry;
        Map<Integer, WeightedMerchantEntry> tradeEntryList = levelUpTradeByProfessionList.get(profession);
        if (tradeEntryList != null && (entry = tradeEntryList.get(level)) != null) {
            tradeEntryList.remove(level);
        }
        return false;
    }

    public static boolean removeTradeToBuy(int profession, int itemID, int itemMetadata) {
        return VillagerEntity.removeComplexTrade(profession, itemID, itemMetadata, 0, 0, wk.bI.cp, 0);
    }

    public static boolean removeTradeToSell(int profession, int itemID, int itemMetadata) {
        return VillagerEntity.removeComplexTrade(profession, wk.bI.cp, 0, 0, 0, itemID, itemMetadata);
    }

    public static boolean removeComplexTrade(int profession, int item1ID, int item1Metadata, int item2ID, int item2Metadata, int resultID, int resultMetadata) {
        WeightedMerchantRecipeEntry entryToRemove = new WeightedMerchantRecipeEntry(item1ID, item1Metadata, 1, 1, item2ID, item2Metadata, 1, 1, resultID, resultMetadata, 1, 1, 1.0f, 1);
        return VillagerEntity.removeCustomTrade(profession, entryToRemove);
    }

    public static boolean removeEnchantmentTrade(int profession, int itemID) {
        WeightMerchantEnchantmentEntry entryToRemove = new WeightMerchantEnchantmentEntry(itemID, 1, 1, 1.0f, 1);
        return VillagerEntity.removeCustomTrade(profession, entryToRemove);
    }

    public static boolean removeCustomTrade(int profession, WeightedMerchantEntry entryToRemove) {
        for (WeightedMerchantEntry entry : tradeByProfessionList.get(profession)) {
            if (!entry.equals(entryToRemove)) continue;
            tradeByProfessionList.get(profession).remove(entry);
            return true;
        }
        for (int i2 = 1; i2 < 5; ++i2) {
            WeightedMerchantEntry entry;
            entry = levelUpTradeByProfessionList.get(profession).get(i2);
            if (!entry.equals(entryToRemove)) continue;
            levelUpTradeByProfessionList.get(profession).put(i2, null);
            return true;
        }
        return false;
    }

    public void playEffectsForTrade(zq trade) {
        Map<WeightedMerchantEntry, TradeEffect> effectRegistry = tradeEffectRegistry.get(this.getProfessionFromClass());
        if (effectRegistry != null) {
            for (WeightedMerchantEntry entry : effectRegistry.keySet()) {
                if (!entry.matchesMerchantRecipe(trade)) continue;
                effectRegistry.get(entry).playEffect(this);
            }
        }
    }

    public static void registerEffectForTrade(int profession, WeightedMerchantEntry entry, TradeEffect effect) {
        Map<WeightedMerchantEntry, TradeEffect> effectRegistry = tradeEffectRegistry.get(profession);
        if (effectRegistry == null) {
            effectRegistry = new HashMap<WeightedMerchantEntry, TradeEffect>();
            tradeEffectRegistry.put(profession, effectRegistry);
        }
        effectRegistry.put(entry, effect);
    }

    public static boolean removeEffectForTrade(int profession, WeightedMerchantEntry entry, TradeEffect effect) {
        Map<WeightedMerchantEntry, TradeEffect> effectRegistry = tradeEffectRegistry.get(profession);
        if (effectRegistry != null && effectRegistry.containsKey(entry)) {
            effectRegistry.remove(entry);
            return true;
        }
        return false;
    }

    public void playEffectsForLevelUp(zq trade) {
        TradeEffect effect;
        Map<Integer, TradeEffect> effectRegistry = levelUpEffectRegistry.get(this.getProfessionFromClass());
        if (effectRegistry != null && (effect = effectRegistry.get(-trade.tradeLevel)) != null) {
            effect.playEffect(this);
            return;
        }
        defaultLevelUpEffect.playEffect(this);
    }

    public static void registerEffectForLevelUp(int profession, int level, TradeEffect effect) {
        Map<Integer, TradeEffect> effectRegistry = levelUpEffectRegistry.get(profession);
        if (effectRegistry == null) {
            effectRegistry = new HashMap<Integer, TradeEffect>();
            levelUpEffectRegistry.put(profession, effectRegistry);
        }
        effectRegistry.put(level, effect);
    }

    public static boolean removeEffectForLevelUp(int profession, int level) {
        Map<Integer, TradeEffect> effectRegistry = levelUpEffectRegistry.get(profession);
        if (effectRegistry != null && effectRegistry.containsKey(level)) {
            effectRegistry.remove(level);
            return true;
        }
        return false;
    }

    protected boolean customInteract(sq player) {
        wm heldStack = player.bK.h();
        if (heldStack != null && heldStack.b().cp == wk.o.cp && this.b() == 0 && this.getInLove() == 0 && !this.isPossessed()) {
            if (!player.ce.d) {
                --heldStack.a;
                if (heldStack.a <= 0) {
                    player.bK.a(player.bK.c, null);
                }
            }
            this.q.a(this, "random.classic_hurt", 1.0f, this.aY() * 2.0f);
            this.setInLove(1);
            this.a_ = null;
            return true;
        }
        if (heldStack != null && heldStack.c == BTWItems.nameTag.cp) {
            BTWItems.nameTag.a(heldStack, this);
        }
        return false;
    }

    protected void updateStatusParticles() {
        this.spawnCustomParticles();
        if (this.getInLove() > 0) {
            this.generateRandomParticles("heart");
        }
    }

    protected void spawnCustomParticles() {
    }

    protected void generateRandomParticles(String sParticle) {
        for (int iTempCount = 0; iTempCount < 5; ++iTempCount) {
            double dVelX = this.ab.nextGaussian() * 0.02;
            double dVelY = this.ab.nextGaussian() * 0.02;
            double dVelZ = this.ab.nextGaussian() * 0.02;
            this.q.a(sParticle, this.u + (double)(this.ab.nextFloat() * this.O * 2.0f) - (double)this.O, this.v + 1.0 + (double)(this.ab.nextFloat() * this.P), this.w + (double)(this.ab.nextFloat() * this.O * 2.0f) - (double)this.O, dVelX, dVelY, dVelZ);
        }
    }

    public void checkForLooseMilk() {
        List collisionList = this.q.a(rh.class, aqx.a().a(this.u - 1.0, this.v - 1.0, this.w - 1.0, this.u + 1.0, this.v + 1.0, this.w + 1.0));
        if (!collisionList.isEmpty()) {
            for (int listIndex = 0; listIndex < collisionList.size(); ++listIndex) {
                rh entityItem = (rh)collisionList.get(listIndex);
                if (entityItem.b > 0 || entityItem.M) continue;
                int iTempItemID = entityItem.d().c;
                wk tempItem = wk.f[iTempItemID];
                if (tempItem.cp != wk.aH.cp) continue;
                entityItem.w();
                entityItem = (rh)mv.createEntityOfType(rh.class, this.q, this.u, this.v - (double)0.3f + (double)this.e(), this.w, new wm(wk.aH, 1, 0));
                float f1 = 0.2f;
                entityItem.x = -kx.a(this.A / 180.0f * 3.141593f) * kx.b(this.B / 180.0f * 3.141593f) * f1;
                entityItem.z = kx.b(this.A / 180.0f * 3.141593f) * kx.b(this.B / 180.0f * 3.141593f) * f1;
                entityItem.y = -kx.a(this.B / 180.0f * 3.141593f) * f1 + 0.2f;
                f1 = 0.02f;
                float f3 = this.ab.nextFloat() * 3.141593f * 2.0f;
                entityItem.x += Math.cos(f3) * (double)(f1 *= this.ab.nextFloat());
                entityItem.y += 0.25;
                entityItem.z += Math.sin(f3) * (double)f1;
                entityItem.b = 10;
                this.q.d(entityItem);
                int iFXI = kx.c(entityItem.u);
                int iFXJ = kx.c(entityItem.v);
                int iFXK = kx.c(entityItem.w);
                int iExtraData = 0;
                if (this.isPossessed() || this.m() == 2 && this.getCurrentTradeLevel() == 5) {
                    iExtraData = 1;
                }
                this.q.e(2265, iFXI, iFXJ, iFXK, iExtraData);
            }
        }
    }

    public int getInLove() {
        return this.ah.c(22);
    }

    public void setInLove(int iInLove) {
        this.ah.b(22, iInLove);
    }

    @Override
    public int getCurrentTradeLevel() {
        return this.ah.c(23);
    }

    public void setTradeLevel(int iTradeLevel) {
        this.ah.b(23, iTradeLevel);
    }

    @Override
    public int getCurrentTradeXP() {
        return this.ah.c(25);
    }

    public void setTradeExperience(int iTradeExperience) {
        this.ah.b(25, iTradeExperience);
    }

    public int getDirtyPeasant() {
        return 0;
    }

    @Override
    public int getCurrentTradeMaxXP() {
        return xpPerLevel[this.getCurrentTradeLevel()];
    }

    public void setDirtyPeasant(int iDirtyPeasant) {
    }

    protected void scheduleImmediateTradelistRefresh() {
        this.updateTradesCountdown = 1;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(byte bUpdateType) {
        super.a(bUpdateType);
        if (bUpdateType == 14) {
            this.q.playSound(this.u, this.v, this.w, "random.pop", 0.25f, ((this.ab.nextFloat() - this.ab.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    static {
        xpPerLevel = new int[]{0, 5, 7, 10, 15, 20};
        professionMap.put(0, FarmerVillagerEntity.class);
        professionMap.put(1, LibrarianVillagerEntity.class);
        professionMap.put(2, PriestVillagerEntity.class);
        professionMap.put(3, BlacksmithVillagerEntity.class);
        professionMap.put(4, ButcherVillagerEntity.class);
        casteMap.put(0, new ArrayList());
        casteMap.put(1, new ArrayList());
        casteMap.put(2, new ArrayList());
        casteMap.get(0).add(0);
        casteMap.get(1).add(3);
        casteMap.get(1).add(4);
        casteMap.get(2).add(1);
        casteMap.get(2).add(2);
        defaultLevelUpEffect = new TradeEffect(){

            @Override
            public void playEffect(VillagerEntity villager) {
                villager.q.a(villager, "random.levelup", 0.5f + villager.ab.nextFloat() * 0.25f, 1.5f);
            }
        };
    }

    public static abstract class WeightedMerchantEntry {
        public final float weight;
        public int level;
        private boolean isMandatory;
        private TradeConditional conditional;

        public WeightedMerchantEntry(float weight, int level) {
            this.weight = weight;
            this.level = level;
            this.isMandatory = false;
        }

        public abstract boolean equals(WeightedMerchantEntry var1);

        public abstract zq generateRecipe(Random var1);

        public abstract boolean matchesMerchantRecipe(zq var1);

        public void setDefault(int profession) {
            defaultTradeByProfessionList.put(profession, this);
        }

        public WeightedMerchantEntry registerEffectForTrade(int profession, TradeEffect effect) {
            VillagerEntity.registerEffectForTrade(profession, this, effect);
            return this;
        }

        public boolean isMandatory() {
            return this.isMandatory;
        }

        public WeightedMerchantEntry setMandatory() {
            this.isMandatory = true;
            return this;
        }

        public WeightedMerchantEntry setConditional(TradeConditional conditional) {
            this.conditional = conditional;
            return this;
        }

        public boolean canBeAdded(VillagerEntity villager) {
            return this.conditional == null || this.conditional.shouldAddTrade(villager);
        }
    }

    public static class WeightedMerchantRecipeEntry
    extends WeightedMerchantEntry {
        public final int input1ID;
        public final int input1Metadata;
        public final int input1MinCount;
        public final int input1MaxCount;
        public final int input2ID;
        public final int input2Metadata;
        public final int input2MinCount;
        public final int input2MaxCount;
        public final int resultID;
        public final int resultMetadata;
        public final int resultMinCount;
        public final int resultMaxCount;
        private boolean randomizeMeta1 = false;
        private int[] randomMetas1;
        private boolean randomizeMeta2 = false;
        private int[] randomMetas2;
        private boolean randomizeMetaResult = false;
        private int[] randomMetasResult;

        public WeightedMerchantRecipeEntry(int input1ID, int input1Metadata, int input1MinCount, int input1MaxCount, int input2ID, int input2Metadata, int input2MinCount, int input2MaxCount, int resultID, int resultMetadata, int resultMinCount, int resultMaxCount, float weight, int level) {
            super(weight, level);
            this.input1ID = input1ID;
            this.input1Metadata = input1Metadata;
            this.input1MinCount = input1MinCount;
            this.input1MaxCount = input1MaxCount;
            this.input2ID = input2ID;
            this.input2Metadata = input2Metadata;
            this.input2MinCount = input2MinCount;
            this.input2MaxCount = input2MaxCount;
            this.resultID = resultID;
            this.resultMetadata = resultMetadata;
            this.resultMinCount = resultMinCount;
            this.resultMaxCount = resultMaxCount;
        }

        public WeightedMerchantRecipeEntry(int inputID, int inputMetadata, int inputMinCount, int inputMaxCount, int resultID, int resultMetadata, int resultMinCount, int resultMaxCount, float weight, int level) {
            super(weight, level);
            this.input1ID = inputID;
            this.input1Metadata = inputMetadata;
            this.input1MinCount = inputMinCount;
            this.input1MaxCount = inputMaxCount;
            this.input2ID = 0;
            this.input2Metadata = 0;
            this.input2MinCount = 0;
            this.input2MaxCount = 0;
            this.resultID = resultID;
            this.resultMetadata = resultMetadata;
            this.resultMinCount = resultMinCount;
            this.resultMaxCount = resultMaxCount;
        }

        @Override
        public boolean equals(WeightedMerchantEntry entry) {
            if (entry instanceof WeightedMerchantRecipeEntry) {
                WeightedMerchantRecipeEntry recipeEntry = (WeightedMerchantRecipeEntry)entry;
                return this.input1ID == recipeEntry.input1ID && this.input1Metadata == recipeEntry.input1Metadata && this.input2ID == recipeEntry.input2ID && this.input2Metadata == recipeEntry.input2Metadata && this.resultID == recipeEntry.resultID && this.resultMetadata == recipeEntry.resultMetadata;
            }
            return false;
        }

        @Override
        public zq generateRecipe(Random rand) {
            int count1 = kx.a(rand, this.input1MinCount, this.input1MaxCount);
            int count2 = kx.a(rand, this.input2MinCount, this.input2MaxCount);
            int countResult = kx.a(rand, this.resultMinCount, this.resultMaxCount);
            int meta1 = this.input1Metadata;
            int meta2 = this.input2Metadata;
            int metaResult = this.resultMetadata;
            if (this.randomizeMeta1) {
                meta1 = this.randomMetas1[rand.nextInt(this.randomMetas1.length)];
            }
            if (this.randomizeMeta2) {
                meta2 = this.randomMetas2[rand.nextInt(this.randomMetas2.length)];
            }
            if (this.randomizeMetaResult) {
                metaResult = this.randomMetasResult[rand.nextInt(this.randomMetasResult.length)];
            }
            wm input1 = new wm(wk.f[this.input1ID], count1, meta1);
            wm input2 = null;
            if (this.input2ID != 0) {
                input2 = new wm(wk.f[this.input2ID], count2, meta2);
            }
            wm result = new wm(wk.f[this.resultID], countResult, metaResult);
            zq trade = new zq(input1, input2, result, this.level);
            if (this.isMandatory()) {
                trade.setMandatory();
            }
            return trade;
        }

        public WeightedMerchantEntry setRandomMetas(int[] randomMetas, int slot) {
            switch (slot) {
                case 0: {
                    this.randomizeMeta1 = true;
                    this.randomMetas1 = randomMetas;
                    break;
                }
                case 1: {
                    this.randomizeMeta2 = true;
                    this.randomMetas2 = randomMetas;
                    break;
                }
                case 2: {
                    this.randomizeMetaResult = true;
                    this.randomMetasResult = randomMetas;
                }
            }
            return this;
        }

        @Override
        public boolean matchesMerchantRecipe(zq trade) {
            return !(trade.a().c != this.input1ID || trade.a().k() != this.input1Metadata && !this.randomizeMeta1 || trade.c() && (trade.b().c != this.input2ID || trade.b().k() != this.input2Metadata && !this.randomizeMeta2) || trade.d().c != this.resultID || trade.d().k() != this.resultMetadata && !this.randomizeMetaResult);
        }
    }

    public static class WeightMerchantEnchantmentEntry
    extends WeightedMerchantEntry {
        public final int itemID;
        public final int minEmeraldCount;
        public final int maxEmeraldCount;

        public WeightMerchantEnchantmentEntry(int itemID, int minEmeraldCount, int maxEmeraldCount, float weight, int level) {
            super(weight, level);
            this.itemID = itemID;
            this.minEmeraldCount = minEmeraldCount;
            this.maxEmeraldCount = maxEmeraldCount;
        }

        @Override
        public boolean equals(WeightedMerchantEntry entry) {
            return entry instanceof WeightMerchantEnchantmentEntry && this.itemID == ((WeightMerchantEnchantmentEntry)entry).itemID;
        }

        @Override
        public zq generateRecipe(Random rand) {
            int cost = kx.a(rand, this.minEmeraldCount, this.maxEmeraldCount);
            wm input = new wm(wk.f[this.itemID]);
            wm emeralds = new wm(wk.bI, cost);
            wm result = zb.a(rand, input.m(), 5 + rand.nextInt(15));
            zq trade = new zq(input, emeralds, result, this.level);
            if (this.isMandatory()) {
                trade.setMandatory();
            }
            return trade;
        }

        @Override
        public boolean matchesMerchantRecipe(zq trade) {
            return trade.a().c == this.itemID && (!trade.c() || trade.b().c == wk.bI.cp) && trade.d().c == this.itemID;
        }
    }

    public static interface TradeEffect {
        public void playEffect(VillagerEntity var1);
    }

    public static interface TradeConditional {
        public boolean shouldAddTrade(VillagerEntity var1);
    }
}

