/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mob;

import btw.block.BTWBlocks;
import btw.block.blocks.BlockDispenserBlock;
import btw.block.tileentity.dispenser.BlockDispenserTileEntity;
import btw.entity.mob.ChickenEntity;
import btw.entity.mob.CowEntity;
import btw.entity.mob.DireWolfEntity;
import btw.entity.mob.PigEntity;
import btw.entity.mob.SheepEntity;
import btw.entity.mob.behavior.MoveToLooseFoodBehavior;
import btw.entity.mob.behavior.MultiTemptBehavior;
import btw.entity.mob.behavior.PanicOnHeadCrabBehavior;
import btw.entity.mob.behavior.SimpleWanderBehavior;
import btw.entity.mob.behavior.SittingWolfHowlBehavior;
import btw.entity.mob.behavior.WildWolfTargetIfHungryBehavior;
import btw.entity.mob.behavior.WildWolfTargetIfStarvingBehavior;
import btw.entity.mob.behavior.WildWolfTargetIfStarvingOrHostileBehavior;
import btw.entity.mob.behavior.WolfHowlBehavior;
import btw.entity.mob.villager.VillagerEntity;
import btw.inventory.util.InventoryUtils;
import btw.item.BTWItems;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class WolfEntity
extends qu {
    private static final int IS_ENGAGED_IN_POSSESSION_ATTEMPT_DATA_WATCHER_ID = 26;
    private static final float MOVE_SPEED_AGGRESSIVE = 0.45f;
    private static final float MOVE_SPEED_PASSIVE = 0.3f;
    public int howlingCountdown = 0;
    public int heardHowlCountdown = 0;
    public int infectionCountdown = -1;
    private static final int MINIMUM_INFECTION_TIME = 12000;
    private static final int INFECTION_TIME_VARIANCE = 12000;
    private float possessionHeadRotation = 0.0f;
    private boolean isDoingHeadSpin = false;
    private boolean hasHeadSpunOnThisPossessionAttempt = false;
    private int possessionAttemptCountdown = 0;
    private static final int CHANCE_OF_POSSESSION_ATTEMPT = 12000;
    private static final int POSSESSION_ATTEMPT_TIME = 200;
    protected static final int HUNGER_COUNT_VARIANCE = 1200;

    public WolfEntity(aab world) {
        super(world);
        this.bI = 0.45f;
        this.bo.removeAllTasks();
        this.bo.a(1, (om)new oj((ng)this));
        this.bo.a(2, new PanicOnHeadCrabBehavior(this, 0.45f));
        this.bo.a(3, this.d);
        this.bo.a(4, (om)new oq((ng)this, 0.4f));
        this.bo.a(5, new ou(this, 0.3f, true));
        this.bo.a(6, new ok(this, 0.3f, 10.0f, 2.0f));
        this.bo.a(7, new oe(this, 0.3f));
        this.bo.a(7, new MultiTemptBehavior(this, 0.3f));
        this.bo.a(8, new WolfHowlBehavior(this));
        this.bo.a(8, new SittingWolfHowlBehavior(this));
        this.bo.a(9, new MoveToLooseFoodBehavior(this, 0.3f));
        this.bo.a(10, new SimpleWanderBehavior(this, 0.3f));
        this.bo.a(11, (om)new oc((qu)this, 8.0f));
        this.bo.a(12, (om)new or((ng)this, sq.class, 8.0f));
        this.bo.a(13, (om)new pf((ng)this));
        this.bp.removeAllTasks();
        this.bp.a(1, (om)new pu(this));
        this.bp.a(2, (om)new pv(this));
        this.bp.a(3, (om)new pq(this, true));
        this.bp.a(4, (om)new WildWolfTargetIfStarvingOrHostileBehavior(this, VillagerEntity.class, 16.0f, 0, false));
        this.bp.a(4, (om)new WildWolfTargetIfStarvingOrHostileBehavior(this, sq.class, 16.0f, 0, false));
        this.bp.a(4, (om)new WildWolfTargetIfHungryBehavior(this, ChickenEntity.class, 16.0f, 0, false));
        this.bp.a(4, (om)new WildWolfTargetIfHungryBehavior(this, SheepEntity.class, 16.0f, 0, false));
        this.bp.a(4, (om)new WildWolfTargetIfHungryBehavior(this, PigEntity.class, 16.0f, 0, false));
        this.bp.a(4, (om)new WildWolfTargetIfStarvingBehavior(this, CowEntity.class, 16.0f, 0, false));
    }

    @Override
    public void b(ng target) {
        this.entityLivingSetAttackTarget(target);
    }

    @Override
    public void c(ng target) {
        super.c(target);
        if (!this.m()) {
            if (target instanceof sq) {
                this.l(true);
            }
            this.b(target);
        }
    }

    @Override
    public void a(ng entityKilled) {
        if (entityKilled instanceof sq) {
            int breedableWolf = 0;
            int maxWolvesFed = 4;
            if (this.isReadyToEatBreedingItem()) {
                this.onEatBreedingItem();
                ++breedableWolf;
            }
            List nearbyEntityList = this.q.b((mp)this, this.E.b(16.0, 8.0, 16.0));
            Iterator nearbyEntityIterator = nearbyEntityList.iterator();
            while (nearbyEntityIterator.hasNext() && breedableWolf <= maxWolvesFed) {
                WolfEntity nearbyWolf;
                mp nearbyEntity = (mp)nearbyEntityIterator.next();
                if (!(nearbyEntity instanceof WolfEntity) || !(nearbyWolf = (WolfEntity)nearbyEntity).isReadyToEatBreedingItem()) continue;
                nearbyWolf.onEatBreedingItem();
                ++breedableWolf;
            }
        }
    }

    @Override
    public int aW() {
        return 20;
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(26, new Byte(0));
        this.resetHungerCountdown();
    }

    @Override
    public void b(bs tag) {
        super.b(tag);
        tag.a("fcInfection", this.infectionCountdown);
    }

    @Override
    public void a(bs tag) {
        super.a(tag);
        if (tag.b("bIsFed")) {
            boolean bIsFed = tag.n("bIsFed");
            if (bIsFed) {
                this.setHungerLevel(0);
            } else {
                this.setHungerLevel(1);
            }
        }
        if (tag.b("fcInfection")) {
            this.infectionCountdown = tag.e("fcInfection");
        }
    }

    @Override
    protected boolean bm() {
        return false;
    }

    @Override
    protected String bb() {
        if (this.isWildAndHostile()) {
            return "mob.wolf.growl";
        }
        if (this.ab.nextInt(3) == 0) {
            if (this.m() && (this.ah.c(18) < 10 || !this.isFullyFed())) {
                if (this.isStarving()) {
                    return "mob.wolf.growl";
                }
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    @Override
    protected int be() {
        if (!this.q.I) {
            if (this.ae()) {
                if (this.q.getDifficulty().shouldBurningMobsDropCookedMeat()) {
                    this.b(BTWItems.cookedWolfChop.cp, 1);
                } else {
                    this.b(BTWItems.burnedMeat.cp, 1);
                }
            } else {
                return BTWItems.rawWolfChop.cp;
            }
        }
        return -1;
    }

    @Override
    public void c() {
        super.c();
        if (this.q.I) {
            this.howlingCountdown = Math.max(0, this.howlingCountdown - 1);
        } else {
            this.heardHowlCountdown = Math.max(0, this.heardHowlCountdown - 1);
            if (this.infectionCountdown > 0) {
                --this.infectionCountdown;
                if (this.infectionCountdown <= 0) {
                    this.transformToDire();
                    return;
                }
            }
        }
    }

    @Override
    public boolean a(mg source, int iDamageAmount) {
        if (!this.aq() && !this.q.I && !this.m() && source.i() instanceof sq) {
            this.l(true);
        }
        return super.a(source, iDamageAmount);
    }

    @Override
    public int getMeleeAttackStrength(mp target) {
        return 4;
    }

    @Override
    public boolean m(mp target) {
        return this.meleeAttack(target);
    }

    @Override
    public boolean a_(sq player) {
        wm playerStack = player.bK.h();
        if (playerStack != null) {
            if (playerStack.c == BTWItems.rawWolfChop.cp || playerStack.c == BTWItems.cookedWolfChop.cp) {
                this.q.a(this, "mob.wolf.growl", this.ba(), (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 1.0f);
                this.l(true);
                this.j(false);
                this.a("");
                this.b(player);
                return true;
            }
            if (this.attemptUseStackOn(player, playerStack)) {
                if (!player.ce.d) {
                    --playerStack.a;
                    if (playerStack.a <= 0) {
                        player.bK.a(player.bK.c, null);
                    }
                }
                return true;
            }
        }
        if (this.entityAnimalInteract(player)) {
            return true;
        }
        if (!(this.q.I || !this.m() || !player.bS.equalsIgnoreCase(this.o()) || playerStack != null && this.isEdibleItem(playerStack) && this.c(playerStack))) {
            this.d.a(!this.n());
            this.bG = false;
            this.a((aji)null);
        }
        return false;
    }

    @Override
    public boolean getCanBeHeadCrabbed(boolean bSquidInWater) {
        return !bSquidInWater && this.n == null && this.R() && !this.h_();
    }

    @Override
    public double W() {
        return (double)this.P * 1.2;
    }

    @Override
    public boolean c(wm stack) {
        return stack != null && (stack.c == BTWItems.rawMysteryMeat.cp || stack.c == BTWItems.cookedMysteryMeat.cp);
    }

    @Override
    public void l(boolean bAngry) {
        super.l(bAngry);
        if (bAngry) {
            this.k(false);
        }
    }

    @Override
    public boolean isReadyToEatLooseFood() {
        return !this.isFullyFed();
    }

    @Override
    public boolean isReadyToEatLooseItem(wm stack) {
        wk tempItem = stack.b();
        if (this.c(stack) && this.isReadyToEatBreedingItem()) {
            return true;
        }
        return this.isReadyToEatLooseFood() && tempItem.isWolfFood() && (tempItem.cp != wk.bn.cp || this.isStarving());
    }

    @Override
    public boolean attemptToEatLooseItem(wm stack) {
        if (this.isReadyToEatLooseItem(stack)) {
            this.onEat(stack.b());
            return true;
        }
        return false;
    }

    @Override
    public boolean isEdibleItem(wm stack) {
        return stack.b().isWolfFood();
    }

    @Override
    public boolean attemptToBeHandFedItem(wm stack) {
        if (this.ah.c(18) < 20 || !this.isFullyFed() || this.c(stack) && this.isReadyToEatBreedingItem()) {
            this.onEat(stack.b());
            return true;
        }
        return false;
    }

    @Override
    public void onNearbyPlayerBlockAddOrRemove(sq player) {
    }

    @Override
    protected void onNearbyPlayerStartles(sq player) {
        if (!this.m() && this.aJ() == null) {
            this.b(player);
        }
    }

    @Override
    public boolean getCanCreatureTypeBePossessed() {
        return true;
    }

    @Override
    protected void handlePossession() {
        super.handlePossession();
        if (this.isFullyPossessed()) {
            if (this.isEngagedInPossessionAttempt()) {
                if (!this.hasHeadSpunOnThisPossessionAttempt) {
                    this.hasHeadSpunOnThisPossessionAttempt = true;
                    this.isDoingHeadSpin = true;
                    if (!this.q.I) {
                        this.a("portal.portal", 3.0f, this.ab.nextFloat() * 0.1f + 0.75f);
                    }
                }
                if (!this.q.I) {
                    --this.possessionAttemptCountdown;
                    if (this.possessionAttemptCountdown <= 0) {
                        this.setEngagedInPossessionAttempt(false);
                        this.attemptToPossessNearbyCreature(16.0, false);
                    }
                }
            } else {
                this.hasHeadSpunOnThisPossessionAttempt = false;
                if (!this.q.I && this.ab.nextInt(12000) == 0) {
                    this.setEngagedInPossessionAttempt(true);
                    this.possessionAttemptCountdown = 200;
                }
            }
            this.updateHeadSpin();
        }
    }

    @Override
    public void onNearbyAnimalAttacked(qh attackedAnimal, ng attackSource) {
    }

    @Override
    public void notifyOfWolfHowl(mp sourceEntity) {
        double dDeltaZ;
        double dDeltaX;
        double dDistSq;
        if (!this.isLivingDead && (dDistSq = (dDeltaX = this.u - sourceEntity.u) * dDeltaX + (dDeltaZ = this.w - sourceEntity.w) * dDeltaZ) < 102400.0 && this != sourceEntity) {
            this.heardHowlCountdown = 95;
        }
    }

    public WolfEntity spawnBabyAnimal(mm parent) {
        return (WolfEntity)mv.createEntityOfType(WolfEntity.class, this.q);
    }

    @Override
    public boolean isSubjectToHunger() {
        return !this.isPossessed();
    }

    @Override
    public void updateHungerState() {
        super.updateHungerState();
        this.updateShitState();
    }

    @Override
    public void onStarvingCountExpired() {
        super.onStarvingCountExpired();
        if (this.R() && !this.isFullyPossessed() && this.q.getDifficulty().canAnimalsStarve()) {
            this.l(true);
            this.j(false);
            this.a("");
        }
    }

    @Override
    public void resetHungerCountdown() {
        this.hungerCountdown = 24000 + (this.ab.nextInt(2400) - 1200);
    }

    @Override
    public float getHungerSpeedModifier() {
        return 1.0f;
    }

    @Override
    public boolean isTooHungryToGrow() {
        return !this.isFullyFed();
    }

    @Override
    public boolean isTooHungryToHeal() {
        return true;
    }

    @Override
    public int getItemFoodValue(wm stack) {
        return 0;
    }

    @Override
    public boolean a(qh par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!(par1EntityAnimal instanceof qu)) {
            return false;
        }
        WolfEntity partner = (WolfEntity)par1EntityAnimal;
        return !partner.n() && this.r() && partner.r();
    }

    public boolean isEngagedInPossessionAttempt() {
        return this.ah.a(26) > 0;
    }

    public void setEngagedInPossessionAttempt(boolean bIsEngaged) {
        Byte tempByte = 0;
        if (bIsEngaged) {
            tempByte = 1;
        }
        this.ah.b(26, (byte)tempByte);
    }

    private void updateShitState() {
        if (this.isFullyFed()) {
            int chanceOfShitting = 1;
            if (this.isDarkEnoughToAffectShitting()) {
                chanceOfShitting *= 2;
            }
            if (this.q.s.nextInt(24000) < chanceOfShitting && !this.isPossessed()) {
                this.attemptToShit();
            }
        }
    }

    private boolean attemptUseStackOn(sq player, wm playerStack) {
        if (this.m()) {
            int iNewColor;
            if (playerStack.c == wk.aX.cp) {
                int iNewColor2 = alp.g_(playerStack.k());
                if (iNewColor2 != this.bX()) {
                    this.s(iNewColor2);
                    return true;
                }
            } else if (playerStack.c == BTWItems.dung.cp && (iNewColor = 12) != this.bX()) {
                this.s(iNewColor);
                if (!this.q.I) {
                    this.q.e(2266, kx.c(this.u), kx.c(this.v), kx.c(this.w), 0);
                }
                return true;
            }
        } else if (playerStack.c == wk.aY.cp && !this.isWildAndHostile()) {
            if (!this.q.I) {
                if (this.ab.nextInt(3) == 0) {
                    this.j(true);
                    this.a((aji)null);
                    this.b((ng)null);
                    this.d.a(true);
                    this.b(20);
                    this.a(player.bS);
                    this.i(true);
                    this.q.a((mp)this, (byte)7);
                } else {
                    this.i(false);
                    this.q.a((mp)this, (byte)6);
                }
            }
            return true;
        }
        return false;
    }

    private void onEat(wk food) {
        this.j(food.getWolfHealAmount());
        int iHungerLevel = this.getHungerLevel();
        if (iHungerLevel > 0) {
            this.setHungerLevel(iHungerLevel - 1);
        }
        this.resetHungerCountdown();
        if (!this.q.I) {
            this.q.e(2284, kx.c(this.u), (int)(this.v + (double)this.P), kx.c(this.w), 0);
        }
        if (food.cp == BTWItems.rawMysteryMeat.cp || food.cp == BTWItems.cookedMysteryMeat.cp) {
            this.onEatBreedingItem();
        }
        if (food.cp == wk.bn.cp) {
            this.onRottenFleshEaten();
        } else if (food.cp == BTWItems.chocolate.cp) {
            this.onChocolateEaten();
        }
    }

    @Override
    public void onEatBreedingItem() {
        this.l(false);
        super.onEatBreedingItem();
    }

    private void onChocolateEaten() {
        if (!this.q.I) {
            this.d(new ml(mk.v.H, 800, 0));
            this.q.a((mp)this, (byte)11);
        }
    }

    private void onRottenFleshEaten() {
        if (this.infectionCountdown < 0) {
            this.infectionCountdown = 12000 + this.ab.nextInt(12000);
        }
    }

    public boolean isDarkEnoughToAffectShitting() {
        int k;
        int j2;
        int i2 = kx.c(this.u);
        int lightValue = this.q.n(i2, j2 = kx.c(this.v), k = kx.c(this.w));
        return lightValue <= 5;
    }

    public boolean attemptToShit() {
        int shitPosK;
        int shitPosJ;
        float poopVectorX = kx.a(this.aA / 180.0f * (float)Math.PI);
        float poopVectorZ = -kx.b(this.aA / 180.0f * (float)Math.PI);
        double shitPosX = this.u + (double)poopVectorX;
        double shitPosY = this.v + 0.25;
        double shitPosZ = this.w + (double)poopVectorZ;
        int shitPosI = kx.c(shitPosX);
        if (!this.isPathToBlockOpenToShitting(shitPosI, shitPosJ = kx.c(shitPosY), shitPosK = kx.c(shitPosZ))) {
            return false;
        }
        rh entityitem = (rh)mv.createEntityOfType(rh.class, this.q, shitPosX, shitPosY, shitPosZ, new wm(BTWItems.dung));
        float velocityFactor = 0.05f;
        entityitem.x = poopVectorX * 10.0f * velocityFactor;
        entityitem.z = poopVectorZ * 10.0f * velocityFactor;
        entityitem.y = (float)this.q.s.nextGaussian() * velocityFactor + 0.2f;
        entityitem.b = 10;
        this.q.d(entityitem);
        this.q.a(this, "random.explode", 0.2f, 1.25f);
        this.q.a(this, "mob.wolf.growl", this.ba(), (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 1.0f);
        for (int counter = 0; counter < 5; ++counter) {
            double smokeX = this.u + (double)(poopVectorX * 0.5f) + this.q.s.nextDouble() * 0.25;
            double smokeY = this.v + this.q.s.nextDouble() * 0.5 + 0.25;
            double smokeZ = this.w + (double)(poopVectorZ * 0.5f) + this.q.s.nextDouble() * 0.25;
            this.q.a("smoke", smokeX, smokeY, smokeZ, 0.0, 0.0, 0.0);
        }
        return true;
    }

    private boolean isPathToBlockOpenToShitting(int i2, int j2, int k) {
        if (!this.isBlockOpenToShitting(i2, j2, k)) {
            return false;
        }
        int wolfI = kx.c(this.u);
        int wolfK = kx.c(this.w);
        int deltaI = i2 - wolfI;
        int deltaK = k - wolfK;
        return deltaI == 0 || deltaK == 0 || this.isBlockOpenToShitting(wolfI, j2, k) || this.isBlockOpenToShitting(i2, j2, wolfK);
    }

    private boolean isBlockOpenToShitting(int i2, int j2, int k) {
        apa block = apa.r[this.q.a(i2, j2, k)];
        if (block != null && (block == apa.E || block == apa.F || block == apa.G || block == apa.H || block == apa.av || block.cO.j() || block == BTWBlocks.detectorLogic || block == BTWBlocks.glowingDetectorLogic || block == BTWBlocks.stokedFire)) {
            block = null;
        }
        return block == null;
    }

    private void transformToDire() {
        int iFXI = kx.c(this.u);
        int iFXJ = kx.c(this.v) + 1;
        int iFXK = kx.c(this.w);
        this.q.d(2257, iFXI, iFXJ, iFXK, 0);
        this.w();
        DireWolfEntity direWolf = new DireWolfEntity(this.q);
        direWolf.b(this.u, this.v, this.w, this.A, this.B);
        direWolf.ay = this.ay;
        this.q.d(direWolf);
    }

    public boolean isWildAndHostile() {
        if (!this.m()) {
            int iMoonPhase;
            if (this.isStarving() || this.bW()) {
                return true;
            }
            int iTimeOfDay = (int)(this.q.x.g() % 24000L);
            if (iTimeOfDay > 13500 && iTimeOfDay < 22500 && (iMoonPhase = this.q.w()) == 0 && this.q.x.g() > 24000L) {
                return true;
            }
        }
        return false;
    }

    public boolean isWildAndHungry() {
        return !this.m() && !this.isFullyFed();
    }

    public boolean isWildAndStarving() {
        return !this.m() && this.isStarving();
    }

    @Override
    public float getGrazeHeadVerticalOffset(float par1) {
        if (this.howlingCountdown > 0) {
            float fTiltFraction = 1.0f;
            if (this.howlingCountdown < 5) {
                fTiltFraction = (float)this.howlingCountdown / 5.0f;
            } else if (this.howlingCountdown > 70) {
                fTiltFraction = (float)(81 - this.howlingCountdown) / 10.0f;
            }
            if (!this.n()) {
                return fTiltFraction * -0.5f;
            }
            return fTiltFraction * -0.25f;
        }
        return 0.0f;
    }

    @Override
    public float getGrazeHeadRotation(float par1) {
        if (this.howlingCountdown > 0) {
            float fTiltFraction = 1.0f;
            if (this.howlingCountdown < 5) {
                fTiltFraction = (float)this.howlingCountdown / 5.0f;
            } else if (this.howlingCountdown > 70) {
                fTiltFraction = (float)(81 - this.howlingCountdown) / 10.0f;
            }
            return fTiltFraction * -0.62831855f;
        }
        return this.B / 57.295776f;
    }

    public boolean areEyesGlowing() {
        return this.isDoingHeadSpin;
    }

    public float getPossessionHeadRotation() {
        return this.possessionHeadRotation * 2.0f * (float)Math.PI;
    }

    private void updateHeadSpin() {
        if (this.isDoingHeadSpin) {
            this.possessionHeadRotation += 0.008f;
            if (this.possessionHeadRotation >= 1.0f) {
                this.possessionHeadRotation = 0.0f;
                this.isDoingHeadSpin = false;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String N() {
        if (this.m()) {
            if (this.isStarving()) {
                return "/btwmodtex/fcWolf_tame_starving.png";
            }
            return "/mob/wolf_tame.png";
        }
        if (this.bW()) {
            return "/mob/wolf_angry.png";
        }
        if (this.isStarving() || this.hasAttackTarget()) {
            return "/btwmodtex/fcWolf_wild_starving.png";
        }
        return this.aH;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(byte bUpdateType) {
        if (bUpdateType == 10) {
            this.howlingCountdown = 80;
        } else if (bUpdateType == 11) {
            this.d(new ml(mk.v.H, 800, 0));
        } else {
            super.a(bUpdateType);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float bV() {
        if (this.isWildAndHostile()) {
            return 1.5393804f;
        }
        if (this.m()) {
            return (0.55f - (float)(20 - this.ah.c(18)) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean onBlockDispenserConsume(BlockDispenserBlock blockDispenser, BlockDispenserTileEntity tileEntity) {
        this.q.e(2239, (int)this.u, (int)this.v, (int)this.w, 0);
        this.w();
        InventoryUtils.addSingleItemToInventory(tileEntity, BTWBlocks.companionCube.cz, 0);
        for (int tempCount = 0; tempCount < 2; ++tempCount) {
            blockDispenser.spitOutItem(this.q, tileEntity.l, tileEntity.m, tileEntity.n, new wm(wk.L));
        }
        return true;
    }
}

