/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mob;

import btw.entity.mob.GhastEntity;
import btw.entity.util.ClosestEntitySelectionCriteria;
import btw.inventory.util.InventoryUtils;
import btw.item.BTWItems;
import btw.world.util.WorldUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;

public class SquidEntity
extends qt {
    public static final float BRIGHTNESS_AGGRESSION_THRESHOLD = 0.1f;
    private static final float SAFE_ATTACK_DEPTH = 0.5f;
    private static final int SAFE_ATTACK_DEPTH_TEST_MAXIMUM = 1;
    private static final float SAFE_PASSIVE_DEPTH = 3.0f;
    private static final int SAFE_PASSIVE_DEPTH_TEST_MAXIMUM = 4;
    private static final double AGGRESSION_RANGE = 16.0;
    private static final int CHANCE_OF_LOSING_ATTACK_TARGET_IN_LIGHT = 400;
    private static final int TENTACLE_ATTACK_TICKS_TO_COOLDOWN = 100;
    private static final double TENTACLE_ATTACK_RANGE = 6.0;
    public static final int TENTACLE_ATTACK_DURATION = 20;
    private static final double TENTACLE_ATTACK_TIP_COLLISION_WIDTH = 0.2;
    private static final double TENTACLE_ATTACK_TIP_COLLISION_HALF_WIDTH = 0.1;
    private int tentacleAttackCooldownTimer = 100;
    public int tentacleAttackInProgressCounter = -1;
    private double tentacleAttackTargetX = 0.0;
    private double tentacleAttackTargetY = 0.0;
    private double tentacleAttackTargetZ = 0.0;
    private static final int HEAD_CRAB_DAMAGE_INITIAL_DELAY = 40;
    private static final int HEAD_CRAB_DAMAGE_PERIOD = 40;
    private int headCrabDamageCounter = 40;
    public float squidPitch = 0.0f;
    public float prevSquidPitch = 0.0f;
    public float squidYaw = 0.0f;
    public float prevSquidYaw = 0.0f;
    private float squidYawSpeed = 0.0f;
    public float tentacleAngle = 0.0f;
    public float prevTentacleAngle = 0.0f;
    private float tentacleAnimProgress = 0.0f;
    private float prevTentacleAnimProgress = 0.0f;
    private float tentacleAnimSpeed = 0.0f;
    private float randomMotionSpeed = 0.0f;
    private float randomMotionVecX = 0.0f;
    private float randomMotionVecY = 0.0f;
    private float randomMotionVecZ = 0.0f;
    private mp entityToNotReCrab = null;
    private int reCrabEntityCountdown = 0;
    private static final int RE_CRAB_ENTITY_TICKS = 5;
    private static final float POSSESSED_LEAP_DEPTH = 0.5f;
    private static final int POSSESSED_LEAP_COUNTDOWN_DURATION = 200;
    private static final int POSSESSED_LEAP_PROPULSION_DURATION = 10;
    private int possessedLeapCountdown = 0;
    private int possessedLeapPropulsionCountdown = 0;
    private final float possessedLeapGhastConversionChance = 0.25f;
    private float possessedLeapGhastConversionDiceRoll = 1.0f;
    private static final int SQUID_POSSESSION_MAX_COUNT = 50;

    public SquidEntity(aab world) {
        super(world);
        this.aH = "/mob/squid.png";
        this.a(0.95f, 0.95f);
        this.tentacleAnimSpeed = 1.0f / (this.ab.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    public int aW() {
        return 20;
    }

    @Override
    protected String bb() {
        return null;
    }

    @Override
    protected String bc() {
        return null;
    }

    @Override
    protected String bd() {
        return null;
    }

    @Override
    protected float ba() {
        return 0.4f;
    }

    @Override
    protected int be() {
        return 0;
    }

    @Override
    protected void a(boolean bKilledByPlayer, int iLootingModifier) {
        int iNumInkSacks = this.ab.nextInt(3 + iLootingModifier) + 1;
        for (int iTempInkSack = 0; iTempInkSack < iNumInkSacks; ++iTempInkSack) {
            this.a(new wm(wk.aX, 1, 0), 0.0f);
        }
        if (this.ab.nextInt(8) - iLootingModifier <= 0) {
            this.b(BTWItems.mysteriousGland.cp, 1);
        }
    }

    @Override
    public void c() {
        super.c();
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevTentacleAnimProgress = this.tentacleAnimProgress;
        this.prevTentacleAngle = this.tentacleAngle;
        this.updateTentacleAttack();
        if (!this.R()) {
            if (!this.q.I) {
                this.x = 0.0;
                if (this.G()) {
                    this.y -= 0.02;
                    this.y *= 0.8;
                } else {
                    this.y -= 0.08;
                    this.y *= (double)0.98f;
                }
                this.z = 0.0;
            }
            return;
        }
        this.tentacleAnimProgress += this.tentacleAnimSpeed;
        if (this.tentacleAnimProgress > (float)Math.PI * 2) {
            this.tentacleAnimProgress -= (float)Math.PI * 2;
            if (this.ab.nextInt(10) == 0) {
                this.tentacleAnimSpeed = 1.0f / (this.ab.nextFloat() + 1.0f) * 0.2f;
            }
        }
        if (this.o != null && !this.o.R()) {
            this.a((mp)null);
            if (!this.q.I) {
                this.q.e(2226, kx.c(this.u), kx.c(this.v), kx.c(this.w), 0);
            }
        }
        if (!this.ae && this.ak() % 100 == 0 && (this.isPossessed() || this.isHeadCrab() || this.isBeingRainedOn())) {
            this.g(300);
        }
        if (this.isHeadCrab()) {
            this.updateHeadCrab();
            return;
        }
        if (this.G()) {
            if (this.tentacleAnimProgress < (float)Math.PI) {
                float var1 = this.tentacleAnimProgress / (float)Math.PI;
                this.tentacleAngle = kx.a(var1 * var1 * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)var1 > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.squidYawSpeed = 1.0f;
                } else {
                    this.squidYawSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.randomMotionSpeed *= 0.9f;
                this.squidYawSpeed *= 0.99f;
            }
            if (!this.q.I) {
                this.x = this.randomMotionVecX * this.randomMotionSpeed;
                this.y = this.randomMotionVecY * this.randomMotionSpeed;
                this.z = this.randomMotionVecZ * this.randomMotionSpeed;
                if (this.possessedLeapPropulsionCountdown > 0) {
                    this.y = 1.0;
                }
            }
            if (this.possessedLeapPropulsionCountdown > 0) {
                --this.possessedLeapPropulsionCountdown;
            }
            if (this.tentacleAttackInProgressCounter >= 0) {
                this.orientToTentacleAttackPoint();
            } else if (this.a_ != null) {
                this.orientToEntity(this.a_);
            } else {
                this.orientToMotion();
            }
        } else {
            this.possessedLeapPropulsionCountdown = 0;
            this.tentacleAngle = kx.e(kx.a(this.tentacleAnimProgress)) * (float)Math.PI * 0.25f;
            if (!this.q.I) {
                this.x = 0.0;
                this.y -= 0.08;
                this.y *= (double)0.98f;
                this.z = 0.0;
            }
            if (this.tentacleAttackInProgressCounter >= 0) {
                this.orientToTentacleAttackPoint();
            } else {
                this.squidPitch = this.y > 0.5 ? 0.0f : (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
            }
        }
    }

    @Override
    public void e(float par1, float par2) {
        this.d(this.x, this.y, this.z);
    }

    @Override
    protected void bq() {
        boolean bIsInDarkness;
        --this.tentacleAttackCooldownTimer;
        this.checkForHeadCrab();
        if (this.isHeadCrab()) {
            this.updateHeadCrabActionState();
            return;
        }
        float fNaturalLightLevel = this.c(1.0f);
        boolean bl = bIsInDarkness = fNaturalLightLevel < 0.1f;
        if (!this.q.v()) {
            bIsInDarkness = true;
        }
        if (this.a_ == null) {
            mp targetEntity;
            if (bIsInDarkness && (targetEntity = this.findClosestValidAttackTargetWithinRange(16.0)) != null) {
                this.b(targetEntity);
            }
        } else if (bIsInDarkness || this.ab.nextInt(400) != 0) {
            if (!this.a_.isValidOngoingAttackTargetForSquid() || (double)this.d(this.a_) > 16.0 || this.q.v() && this.a_.c(1.0f) > 0.1f && this.ab.nextInt(400) == 0) {
                this.b((mp)null);
            }
        } else {
            this.b((mp)null);
        }
        if (this.a_ != null) {
            double dDeltaZ;
            double dDeltaX = this.a_.u - this.u;
            double dDeltaY = this.a_.v + (double)this.a_.e() - (this.v + (double)(this.P / 2.0f));
            double dDistSqToTarget = dDeltaX * dDeltaX + dDeltaY * dDeltaY + (dDeltaZ = this.a_.w - this.w) * dDeltaZ;
            if (dDistSqToTarget > 0.25) {
                double dDistToTarget = kx.a(dDistSqToTarget);
                double dUnitVectorToTargetX = dDeltaX / dDistToTarget;
                double dUnitVectorToTargetY = dDeltaY / dDistToTarget;
                double dUnitVectorToTargetZ = dDeltaZ / dDistToTarget;
                this.randomMotionVecX = (float)(dUnitVectorToTargetX * 0.4);
                this.randomMotionVecY = (float)(dUnitVectorToTargetY * 0.4);
                this.randomMotionVecZ = (float)(dUnitVectorToTargetZ * 0.4);
                if (!this.isFullyPossessed()) {
                    float fDeltaSafeDepth;
                    float fDepth = this.getDepthBeneathSurface(1.0f);
                    if (fDepth < 0.5f) {
                        if (this.randomMotionVecY > -0.1f) {
                            this.randomMotionVecY = -0.1f;
                        }
                    } else if (this.randomMotionVecY > 0.0f && this.randomMotionVecY > (fDeltaSafeDepth = fDepth - 0.5f)) {
                        this.randomMotionVecY = fDeltaSafeDepth;
                    }
                }
                if (this.ae && (!this.a_.ae || this.a_.o != null) && this.tentacleAttackInProgressCounter < 0 && this.tentacleAttackCooldownTimer <= 0 && this.ab.nextInt(20) == 0) {
                    this.attemptTentacleAttackOnTarget();
                }
            } else {
                this.randomMotionVecZ = 0.0f;
                this.randomMotionVecY = 0.0f;
                this.randomMotionVecX = 0.0f;
            }
        } else if (this.ab.nextInt(50) == 0 || !this.ae || this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f) {
            float fFlatHeading = this.ab.nextFloat() * (float)Math.PI * 2.0f;
            this.randomMotionVecZ = kx.a(fFlatHeading) * 0.2f;
            this.randomMotionVecX = kx.b(fFlatHeading) * 0.2f;
            float fDepth = this.getDepthBeneathSurface(4.0f);
            if (this.isFullyPossessed() && this.ae) {
                this.randomMotionVecY = 0.1f;
                if (fDepth < 0.5f && this.possessedLeapCountdown <= 0) {
                    this.possessedLeap();
                }
            } else if (fDepth >= 3.0f) {
                if (fNaturalLightLevel < 0.1f) {
                    int iSkylightSubtracted = this.q.j;
                    this.randomMotionVecY = !this.q.v() ? 0.1f : this.ab.nextFloat() * 0.15f - 0.1f;
                } else {
                    this.randomMotionVecY = -0.1f;
                }
            } else {
                this.randomMotionVecY = -0.1f;
            }
        }
        ++this.bC;
        this.bn();
    }

    @Override
    protected double minDistFromPlayerForDespawn() {
        return 144.0;
    }

    @Override
    protected boolean bm() {
        return !this.isHeadCrab();
    }

    @Override
    public boolean bv() {
        int k;
        int j2;
        int i2 = kx.c(this.u);
        if (!(this.isBlockSurroundedByWater(i2, j2 = kx.c(this.v), k = kx.c(this.w)) || this.isBlockSurroundedByWater(i2 + 1, j2, k) || this.isBlockSurroundedByWater(i2 - 1, j2, k) || this.isBlockSurroundedByWater(i2, j2 + 1, k) || this.isBlockSurroundedByWater(i2, j2 - 1, k) || this.isBlockSurroundedByWater(i2, j2, k + 1) || this.isBlockSurroundedByWater(i2, j2, k - 1))) {
            return false;
        }
        int iLightLevel = this.q.n(i2, j2, k);
        if (iLightLevel > 1) {
            return false;
        }
        return super.bv();
    }

    @Override
    public boolean a(mg damageSource, int iDamageAmount) {
        if (this.isHeadCrab()) {
            if (damageSource == mg.d) {
                return false;
            }
        } else {
            if (this.isPossessed() && damageSource == mg.h) {
                return false;
            }
            if (super.a(damageSource, iDamageAmount)) {
                mp attackingEntity;
                if (!this.q.I && (attackingEntity = damageSource.i()) != null && attackingEntity != this) {
                    this.b(attackingEntity);
                }
                return true;
            }
            return false;
        }
        return super.a(damageSource, iDamageAmount);
    }

    @Override
    protected void a(int par1, int par2, int par3, int par4) {
    }

    @Override
    public void checkForScrollDrop() {
        if (this.ab.nextInt(250) == 0) {
            wm itemstack = new wm(BTWItems.arcaneScroll, 1, yz.i.z);
            this.a(itemstack, 0.0f);
        }
    }

    @Override
    public aqx getVisualBoundingBox() {
        if (this.tentacleAttackInProgressCounter >= 0) {
            double dExpandByAmount = 6.25;
            return this.E.b(dExpandByAmount, dExpandByAmount, dExpandByAmount);
        }
        return this.E;
    }

    @Override
    public void b(mp targetEntity) {
        if (!this.q.I && targetEntity != this.a_) {
            this.a_ = targetEntity;
            this.transmitAttackTargetToClients();
        } else {
            this.a_ = targetEntity;
        }
    }

    @Override
    public boolean getCanCreatureTypeBePossessed() {
        return true;
    }

    @Override
    public boolean getCanCreatureBePossessedFromDistance(boolean bPersistentSpirit) {
        return bPersistentSpirit || this.q.getNumEntitiesThatApplyToSquidPossessionCap() < 50;
    }

    @Override
    public boolean onPossessedRidingEntityDeath() {
        if (this.R() && !this.isPossessed()) {
            this.initiatePossession();
            return true;
        }
        return false;
    }

    @Override
    public void initiatePossession() {
        super.initiatePossession();
        this.setPersistent(true);
    }

    @Override
    protected void handlePossession() {
        super.handlePossession();
        if (this.possessedLeapCountdown > 0) {
            --this.possessedLeapCountdown;
        }
        if (!this.q.I && this.isFullyPossessed()) {
            if (this.o == null && !this.ae && !this.F) {
                if (this.possessedLeapGhastConversionDiceRoll <= 0.25f && this.y <= 0.0) {
                    GhastEntity ghast = (GhastEntity)((Object)mv.createEntityOfType(GhastEntity.class, this.q));
                    ghast.b(this.u, this.v, this.w, this.A, 0.0f);
                    if (this.q.a(ghast.E, this) && this.q.a((mp)this, ghast.E).isEmpty() && !this.q.d(ghast.E)) {
                        this.q.e(2273, kx.c(this.u), kx.c(this.v), kx.c(this.w), 0);
                        this.w();
                        ghast.setPersistent(true);
                        this.q.d((mp)((Object)ghast));
                    }
                }
            } else if (!this.ae || this.y <= 0.0) {
                this.possessedLeapGhastConversionDiceRoll = 1.0f;
            }
        }
    }

    @Override
    public boolean doesEntityApplyToSquidPossessionCap() {
        return this.R() && this.getIsPersistent();
    }

    @Override
    public boolean isValidZombieSecondaryTarget(sj zombie) {
        return !this.ae && this.o == null && zombie.n == null;
    }

    @Override
    public boolean attractsLightning() {
        return false;
    }

    @Override
    public float e() {
        return this.P * 0.5f;
    }

    private void updateHeadCrabActionState() {
        mp sharedTarget = this.o.getHeadCrabSharedAttackTarget();
        if (sharedTarget == this) {
            sharedTarget = null;
        }
        this.b(sharedTarget);
        if (this.a_ != null && this.tentacleAttackInProgressCounter < 0 && this.tentacleAttackCooldownTimer <= 0 && this.ab.nextInt(20) == 0) {
            this.attemptTentacleAttackOnTarget();
        }
        if (this.isFullyPossessed() && this.possessedLeapCountdown <= 0 && !this.ae && this.ab.nextInt(100) == 0) {
            this.a((mp)null);
            this.possessedLeap();
        }
    }

    private void orientToMotion() {
        float fMotionVectorFlatLength = kx.a(this.x * this.x + this.z * this.z);
        this.A = this.ay = this.interpolateAngle(this.ay, -((float)Math.atan2(this.x, this.z)) * 180.0f / (float)Math.PI, 1.0f);
        this.squidPitch += (-((float)Math.atan2(fMotionVectorFlatLength, this.y)) * 180.0f / (float)Math.PI - this.squidPitch) * 0.1f;
        this.squidYaw += (float)Math.PI * this.squidYawSpeed * 1.5f;
    }

    private void orientToEntity(mp entity) {
        double dDeltaX = entity.u - this.u;
        double dDeltaY = entity.v + (double)entity.e() - (this.v + (double)(this.P / 2.0f));
        double dDeltaZ = entity.w - this.w;
        double dFlatDist = kx.a(dDeltaX * dDeltaX + dDeltaZ * dDeltaZ);
        this.A = this.ay = this.interpolateAngle(this.ay, -((float)Math.atan2(dDeltaX, dDeltaZ)) * 180.0f / (float)Math.PI, 1.0f);
        this.squidPitch = this.interpolateAngle(this.squidPitch, -((float)(Math.atan2(dFlatDist, dDeltaY) * 180.0 / Math.PI)), 10.0f);
        this.squidYaw += (float)Math.PI * this.squidYawSpeed * 1.5f;
    }

    private void orientToTentacleAttackPoint() {
        double dDeltaX = this.tentacleAttackTargetX - this.u;
        double dDeltaY = this.tentacleAttackTargetY - (this.v + (double)(this.P / 2.0f));
        double dDeltaZ = this.tentacleAttackTargetZ - this.w;
        double dFlatDist = kx.a(dDeltaX * dDeltaX + dDeltaZ * dDeltaZ);
        this.A = this.ay = this.interpolateAngle(this.ay, -((float)Math.atan2(dDeltaX, dDeltaZ)) * 180.0f / (float)Math.PI, 50.0f);
        this.squidPitch = this.interpolateAngle(this.squidPitch, -((float)(Math.atan2(dFlatDist, dDeltaY) * 180.0 / Math.PI - 150.0)), 50.0f);
        this.squidYaw = this.interpolateAngle(this.squidYaw, 0.0f, 50.0f);
    }

    private mp findClosestValidAttackTargetWithinRange(double dRange) {
        mp targetEntity = null;
        double dClosestDistSq = dRange * dRange;
        for (int iPlayerCount = 0; iPlayerCount < this.q.h.size(); ++iPlayerCount) {
            double dDeltaZ;
            double dDeltaY;
            double dDeltaX;
            double dDistSq;
            sq tempPlayer = (sq)this.q.h.get(iPlayerCount);
            if (tempPlayer.ce.a || !tempPlayer.R() || !((dDistSq = (dDeltaX = tempPlayer.u - this.u) * dDeltaX + (dDeltaY = tempPlayer.v - this.v) * dDeltaY + (dDeltaZ = tempPlayer.w - this.w) * dDeltaZ) < dClosestDistSq) || this.q.v() && !(tempPlayer.c(1.0f) < 0.1f) || !tempPlayer.ae && (!this.n(tempPlayer) || !this.q.getDifficulty().shouldSquidsAttackDryPlayers()) || tempPlayer.o != null && !this.q.getDifficulty().shouldSquidsAttackDryPlayers()) continue;
            targetEntity = tempPlayer;
            dClosestDistSq = dDistSq;
        }
        if ((this.q.x.g() + (long)this.k & 0x1FL) == 0L && targetEntity == null) {
            targetEntity = this.q.getClosestEntityMatchingCriteriaWithinRange(this.u, this.v, this.w, dRange, ClosestEntitySelectionCriteria.secondarySquidTarget);
        }
        return targetEntity;
    }

    private void checkForHeadCrab() {
        if (this.R()) {
            if (this.o == null) {
                if (this.y < 0.5) {
                    if (this.reCrabEntityCountdown > 0) {
                        --this.reCrabEntityCountdown;
                    } else {
                        this.entityToNotReCrab = null;
                    }
                    ng target = this.getValidHeadCrabTargetInRange();
                    if (target != null) {
                        this.a((mp)target);
                        this.a("mob.slime.attack", 1.0f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 1.0f);
                        this.headCrabDamageCounter = 40;
                        target.onHeadCrabbedBySquid(this);
                    }
                }
            } else {
                this.entityToNotReCrab = this.o;
                this.reCrabEntityCountdown = 5;
            }
        }
    }

    private ng getValidHeadCrabTargetInRange() {
        double dRange = 0.25;
        if (!this.G()) {
            dRange = 0.5;
        }
        List entityList = this.q.a(ng.class, this.E.b(dRange, dRange, dRange));
        for (ng tempEntity : entityList) {
            if (!tempEntity.getCanBeHeadCrabbed(this.G()) || tempEntity == this.entityToNotReCrab || !this.n(tempEntity)) continue;
            return tempEntity;
        }
        return null;
    }

    private void updateHeadCrab() {
        this.tentacleAnimSpeed = 0.2f;
        this.squidPitch = 0.0f;
        float fSinTentacle = kx.a(this.tentacleAnimProgress);
        this.tentacleAngle = kx.e(kx.a(fSinTentacle)) * (float)Math.PI * 0.25f;
        if (!this.q.I) {
            --this.headCrabDamageCounter;
            if (this.headCrabDamageCounter <= 0) {
                if (!this.o.isImmuneToHeadCrabDamage()) {
                    mg squidSource = mg.a(this);
                    squidSource.j();
                    this.o.a(squidSource, 1);
                }
                this.headCrabDamageCounter = 40;
            }
            if (this.o.o != null) {
                this.o.a(this.o.o);
                if (this.o.o != null) {
                    this.o.o.n = null;
                    this.o.o = null;
                }
            }
        } else {
            float fPrevSinTentacle = kx.a(this.prevTentacleAnimProgress);
            if (fPrevSinTentacle <= 0.0f && fSinTentacle > 0.0f || fPrevSinTentacle > 0.0f && fSinTentacle <= 0.0f) {
                if (!this.o.isImmuneToHeadCrabDamage()) {
                    this.q.playSound(this.u, this.v, this.w, "random.eat", 1.0f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.8f);
                    this.q.playSound(this.u, this.v, this.w, "mob.slime.big", 0.5f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.7f);
                } else {
                    this.q.playSound(this.u, this.v, this.w, "mob.slime.big", 0.025f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.7f);
                }
            }
            if (this.o instanceof ng) {
                ng ridingCreature = (ng)this.o;
                this.squidYaw = -ridingCreature.aA;
                this.prevSquidYaw = -ridingCreature.aB;
                this.ay = 0.0f;
                this.A = 0.0f;
            }
        }
    }

    private void attemptTentacleAttackOnTarget() {
        double dDeltaX = this.a_.u - this.u;
        double dDeltaY = this.a_.v + (double)(this.a_.P / 2.0f) - (this.v + (double)(this.P / 2.0f));
        double dDeltaZ = this.a_.w - this.w;
        double dDistSqToTarget = dDeltaX * dDeltaX + dDeltaY * dDeltaY + dDeltaZ * dDeltaZ;
        if (dDistSqToTarget < 36.0) {
            if (!this.canEntityCenterOfMassBeSeen(this.a_)) {
                if (this.n(this.a_)) {
                    dDeltaY = this.a_.v + (double)this.a_.e() - (this.v + (double)(this.P / 2.0f));
                    dDistSqToTarget = dDeltaX * dDeltaX + dDeltaY * dDeltaY + dDeltaZ * dDeltaZ;
                } else {
                    return;
                }
            }
            double dDistToTarget = kx.a(dDistSqToTarget);
            double dUnitVectorToTargetX = dDeltaX / dDistToTarget;
            double dUnitVectorToTargetY = dDeltaY / dDistToTarget;
            double dUnitVectorToTargetZ = dDeltaZ / dDistToTarget;
            this.launchTentacleAttackInDirection(dUnitVectorToTargetX, dUnitVectorToTargetY, dUnitVectorToTargetZ);
        }
    }

    private void launchTentacleAttackInDirection(double dUnitVectorToTargetX, double dUnitVectorToTargetY, double dUnitVectorToTargetZ) {
        this.tentacleAttackInProgressCounter = 0;
        this.tentacleAttackCooldownTimer = 100;
        this.tentacleAttackTargetX = this.u + dUnitVectorToTargetX * 6.0;
        this.tentacleAttackTargetY = this.v + (double)(this.P / 2.0f) + dUnitVectorToTargetY * 6.0;
        this.tentacleAttackTargetZ = this.w + dUnitVectorToTargetZ * 6.0;
        this.transmitTentacleAttackToClients();
    }

    private void transmitTentacleAttackToClients() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeInt(this.k);
            dataStream.writeByte(1);
            dataStream.writeInt(kx.c(this.tentacleAttackTargetX * 32.0));
            dataStream.writeInt(kx.c(this.tentacleAttackTargetY * 32.0));
            dataStream.writeInt(kx.c(this.tentacleAttackTargetZ * 32.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dk packet = new dk("BTW|EV", byteStream.toByteArray());
        WorldUtils.sendPacketToAllPlayersTrackingEntity((iz)this.q, this, (ei)packet);
    }

    public void onClientNotifiedOfTentacleAttack(double dTargetX, double dTargetY, double dTargetZ) {
        this.tentacleAttackInProgressCounter = 0;
        this.tentacleAttackTargetX = dTargetX;
        this.tentacleAttackTargetY = dTargetY;
        this.tentacleAttackTargetZ = dTargetZ;
        this.q.playSound(this.u, this.v, this.w, "random.bow", 1.0f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.5f);
        this.q.playSound(this.u, this.v, this.w, "mob.slime.big", 1.0f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.5f);
        if (this.ae) {
            int iParticleCount;
            for (iParticleCount = 0; iParticleCount < 150; ++iParticleCount) {
                this.q.a("bubble", this.u + this.ab.nextDouble() * 2.0 - 1.0, this.v + this.ab.nextDouble(), this.w + this.ab.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0);
            }
            for (iParticleCount = 0; iParticleCount < 10; ++iParticleCount) {
                this.q.a("splash", this.u + this.ab.nextDouble() * 2.0 - 1.0, this.v + (double)this.P, this.w + this.ab.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0);
            }
            this.q.playSound(this.u, this.v, this.w, "liquid.splash", 1.0f, 1.0f + (this.ab.nextFloat() - this.ab.nextFloat()) * 0.4f);
        }
    }

    private void updateTentacleAttack() {
        if (this.tentacleAttackInProgressCounter >= 0) {
            ++this.tentacleAttackInProgressCounter;
            if (this.tentacleAttackInProgressCounter >= 20) {
                this.tentacleAttackInProgressCounter = -1;
            } else if (this.tentacleAttackInProgressCounter <= 10) {
                arc tentacleTip = this.computeTentacleAttackTip(this.tentacleAttackInProgressCounter);
                aqx tipBox = aqx.a().a(tentacleTip.c - 0.1, tentacleTip.d - 0.1, tentacleTip.e - 0.1, tentacleTip.c + 0.1, tentacleTip.d + 0.1, tentacleTip.e + 0.1);
                List potentialCollisionList = this.q.a(ng.class, tipBox);
                if (!potentialCollisionList.isEmpty()) {
                    for (ng tempEntity : potentialCollisionList) {
                        if (tempEntity instanceof SquidEntity || tempEntity == this.o) continue;
                        this.retractTentacleAttackOnCollision();
                        if (this.q.I) break;
                        this.tentacleAttackFlingTarget(tempEntity, true);
                        break;
                    }
                }
            }
        }
    }

    private void retractTentacleAttackOnCollision() {
        int iTurningPoint = 10;
        if (this.tentacleAttackInProgressCounter < iTurningPoint) {
            this.tentacleAttackInProgressCounter = iTurningPoint + (iTurningPoint - this.tentacleAttackInProgressCounter);
        }
    }

    public arc computeTentacleAttackTip(float fAttackProgressTick) {
        double dAttackProgressSin = this.getAttackProgressSin(fAttackProgressTick);
        double dDeltaX = this.tentacleAttackTargetX - this.u;
        double dDeltaY = this.tentacleAttackTargetY - (this.v + (double)(this.P / 2.0f));
        double dDeltaZ = this.tentacleAttackTargetZ - this.w;
        double dTipOffsetX = dDeltaX * dAttackProgressSin;
        double dTipOffsetY = dDeltaY * dAttackProgressSin;
        double dTipOffsetZ = dDeltaZ * dAttackProgressSin;
        return arc.a(this.u + dTipOffsetX, this.v + (double)(this.P / 2.0f) + dTipOffsetY, this.w + dTipOffsetZ);
    }

    public double getAttackProgressSin(float fAttackProgressTick) {
        double dAttackProgress = fAttackProgressTick / 20.0f;
        return kx.a((float)(dAttackProgress * Math.PI));
    }

    private void tentacleAttackFlingTarget(mp targetEntity, boolean bPrimary) {
        mp secondaryTargetEntity = null;
        if (targetEntity.o != null) {
            secondaryTargetEntity = targetEntity.o;
            targetEntity.a((mp)null);
        }
        if (bPrimary) {
            int iFXI = kx.c(targetEntity.u);
            int iFXJ = kx.c(targetEntity.v) + 1;
            int iFXK = kx.c(targetEntity.w);
            this.q.e(2262, iFXI, iFXJ, iFXK, 0);
        }
        double dVelocityX = targetEntity.x;
        double dVelocityZ = targetEntity.z;
        double dDeltaX = targetEntity.u - this.u;
        double dDeltaZ = targetEntity.w - this.w;
        double dFlatDistToTargetSq = dDeltaX * dDeltaX + dDeltaZ * dDeltaZ;
        if (dFlatDistToTargetSq > 0.1) {
            double dFlatDistToTarget = kx.a(dFlatDistToTargetSq);
            dVelocityX += (double)((float)(-dDeltaX / dFlatDistToTarget) * 1.0f);
            dVelocityZ += (double)((float)(-dDeltaZ / dFlatDistToTarget) * 1.0f);
        }
        if (targetEntity instanceof sq && ((sq)targetEntity).bk()) {
            sq blockingPlayer = (sq)targetEntity;
            wm blockItemStack = blockingPlayer.bK.a[blockingPlayer.bK.c];
            if (blockItemStack != null) {
                wm flingStack = new wm(blockItemStack.c, blockItemStack.a, blockItemStack.k());
                InventoryUtils.copyEnchantments(flingStack, blockItemStack);
                double dItemXPos = targetEntity.u;
                double dItemYPos = targetEntity.v + 1.0;
                double dItemZPos = targetEntity.w;
                rh entityitem = (rh)mv.createEntityOfType(rh.class, this.q, dItemXPos, dItemYPos, dItemZPos, flingStack);
                double dVelocityY = targetEntity.y + 0.5;
                entityitem.x = dVelocityX;
                entityitem.y = dVelocityY;
                entityitem.z = dVelocityZ;
                entityitem.b = 10;
                this.q.d(entityitem);
                blockItemStack.a = 0;
            }
        } else {
            targetEntity.an = true;
            double dVelocityY = targetEntity.y + 0.75;
            targetEntity.x = dVelocityX *= this.ab.nextDouble() * 0.2 + 0.9;
            targetEntity.y = dVelocityY;
            targetEntity.z = dVelocityZ *= this.ab.nextDouble() * 0.2 + 0.9;
            this.capFlingMotionOfEntity(targetEntity);
            targetEntity.J();
        }
        targetEntity.onFlungBySquidTentacle(this);
        if (secondaryTargetEntity != null) {
            this.tentacleAttackFlingTarget(secondaryTargetEntity, false);
        }
    }

    private void capFlingMotionOfEntity(mp targetEntity) {
        if (targetEntity.y > 0.75) {
            targetEntity.y = 0.75;
        }
        if (targetEntity.x > 1.0) {
            targetEntity.x = 1.0;
        } else if (targetEntity.x < -1.0) {
            targetEntity.x = -1.0;
        }
        if (targetEntity.z > 1.0) {
            targetEntity.z = 1.0;
        } else if (targetEntity.z < -1.0) {
            targetEntity.z = -1.0;
        }
    }

    public boolean isHeadCrab() {
        return this.o != null && this.o instanceof ng;
    }

    private boolean isBlockSurroundedByWater(int i2, int j2, int k) {
        for (int iTempJ = j2 - 1; iTempJ <= j2 + 1; ++iTempJ) {
            for (int iTempI = i2 - 1; iTempI <= i2 + 1; ++iTempI) {
                for (int iTempK = k - 1; iTempK <= k + 1; ++iTempK) {
                    int iTempBlockID = this.q.a(iTempI, iTempJ, iTempK);
                    if (iTempBlockID == apa.E.cz || iTempBlockID == apa.F.cz) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public float getDepthBeneathSurface(float fMaxDepthToConsider) {
        float fDepth = -1.0f;
        int iPosI = kx.c(this.u);
        int iPosJ = (int)this.v;
        int iPosK = kx.c(this.w);
        int iTempBlockID = this.q.a(iPosI, iPosJ, iPosK);
        int iTempBlockAboveID = this.q.a(iPosI, iPosJ + 1, iPosK);
        if (iTempBlockID == apa.F.cz || iTempBlockID == apa.E.cz || iTempBlockAboveID == apa.F.cz || iTempBlockAboveID == apa.E.cz) {
            fDepth = 0.0f;
            fDepth = (float)((double)fDepth + (this.v - (double)iPosJ));
            int iJOffset = 1;
            while (fDepth < fMaxDepthToConsider) {
                iTempBlockID = this.q.a(iPosI, iPosJ + iJOffset, iPosK);
                if (iTempBlockID == apa.F.cz || iTempBlockID == apa.E.cz) {
                    fDepth += 1.0f;
                } else {
                    if (fDepth != 0.0f || !(this.v > 32.0)) break;
                    break;
                }
                ++iJOffset;
            }
        }
        return fDepth;
    }

    private float interpolateAngle(float fStartAngle, float fDestAngle, float fMaxIncrement) {
        float fDelta = kx.g(fDestAngle - fStartAngle);
        if (fDelta > fMaxIncrement) {
            fDelta = fMaxIncrement;
        } else if (fDelta < -fMaxIncrement) {
            fDelta = -fMaxIncrement;
        }
        return fStartAngle + fDelta;
    }

    private void possessedLeap() {
        this.y = 1.0;
        this.an = true;
        this.possessedLeapCountdown = 200;
        this.possessedLeapGhastConversionDiceRoll = this.ab.nextFloat();
        if (this.ae) {
            this.possessedLeapPropulsionCountdown = 10;
            this.a("liquid.splash", 1.0f, this.ab.nextFloat() * 0.1f + 0.5f);
        } else {
            this.possessedLeapPropulsionCountdown = 0;
            this.a("mob.slime.big", 1.0f, this.ab.nextFloat() * 0.1f + 0.5f);
        }
    }

    private aqx getGhastConversionCollisionBoxFromPool() {
        double dWidthOffset = this.O / 16.0f;
        return aqx.a().a(this.E.a + dWidthOffset, this.E.e, this.E.c + dWidthOffset, this.E.d - dWidthOffset, this.E.e + (double)0.1f, this.E.f - dWidthOffset);
    }
}

