/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mob;

import btw.block.blocks.BlockDispenserBlock;
import btw.block.tileentity.dispenser.BlockDispenserTileEntity;
import btw.entity.mob.WolfEntity;
import btw.entity.mob.behavior.AnimalFleeBehavior;
import btw.entity.mob.behavior.GrazeBehavior;
import btw.entity.mob.behavior.MoveToGrazeBehavior;
import btw.entity.mob.behavior.MoveToLooseFoodBehavior;
import btw.entity.mob.behavior.MultiTemptBehavior;
import btw.entity.mob.behavior.SimpleWanderBehavior;
import btw.inventory.util.InventoryUtils;
import btw.item.BTWItems;
import btw.item.items.ShearsItem;
import btw.util.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class SheepEntity
extends qo {
    private static final int FULL_WOOL_ACCUMULATION_COUNT = 24000;
    private int woolAccumulationCount = 0;
    private int originalWoolColorWatcherID = 20;
    private static ArrayList<ColorBlendEntry> colorBlendList = new ArrayList();

    public SheepEntity(aab world) {
        super(world);
        this.aH = "/btwmodtex/fcSheep.png";
        this.bo.removeAllTasks();
        this.bo.a(0, (om)new oj((ng)this));
        this.bo.a(1, new AnimalFleeBehavior(this, 0.38f));
        this.bo.a(2, new oe(this, 0.23f));
        this.bo.a(3, new MultiTemptBehavior(this, 0.25f));
        this.bo.a(4, new GrazeBehavior(this));
        this.bo.a(5, new MoveToLooseFoodBehavior(this, 0.23f));
        this.bo.a(6, new MoveToGrazeBehavior(this, 0.23f));
        this.bo.a(7, new ol(this, 0.25f));
        this.bo.a(8, new SimpleWanderBehavior(this, 0.25f));
        this.bo.a(9, (om)new or((ng)this, sq.class, 6.0f));
        this.bo.a(10, (om)new pf((ng)this));
    }

    @Override
    public boolean bh() {
        return !this.getWearingBreedingHarness();
    }

    @Override
    protected void a(boolean bKilledByPlayer, int iLootingModifier) {
        if (!this.n() && this.isFullyFed()) {
            this.a(new wm(BTWItems.wool.cp, 1, alp.c(this.m())), 0.0f);
        }
        this.dropMutton(iLootingModifier);
    }

    @Override
    public boolean a_(sq player) {
        wm stack = player.bK.h();
        if (stack != null && stack.b() instanceof ShearsItem && !this.n() && !this.h_()) {
            if (!this.q.I) {
                this.i(true);
                int iNumItems = 1 + this.ab.nextInt(3);
                for (int iTempCount = 0; iTempCount < iNumItems; ++iTempCount) {
                    rh tempItem = this.a(new wm(BTWItems.wool.cp, 1, alp.c(this.m())), 1.0f);
                    tempItem.y += (double)(this.ab.nextFloat() * 0.05f);
                    tempItem.x += (double)((this.ab.nextFloat() - this.ab.nextFloat()) * 0.1f);
                    tempItem.z += (double)((this.ab.nextFloat() - this.ab.nextFloat()) * 0.1f);
                }
            }
            stack.a(1, (ng)player);
            this.a("mob.sheep.shear", 1.0f, 1.0f);
            this.a(mg.j, 0);
            if (stack.a <= 0) {
                player.bK.a[player.bK.c] = null;
            }
        }
        return this.entityAnimalInteract(player);
    }

    @Override
    protected int be() {
        return BTWItems.wool.cp;
    }

    @Override
    public void b(bs tag) {
        super.b(tag);
        tag.a("fcOrgClr", (byte)this.getOriginalFleeceColor());
        tag.a("fcWoolCount", this.woolAccumulationCount);
    }

    @Override
    public void a(bs tag) {
        super.a(tag);
        if (tag.b("fcOrgClr")) {
            this.setOriginalFleeceColor(tag.c("fcOrgClr"));
        }
        if (tag.b("fcWoolCount")) {
            this.woolAccumulationCount = tag.e("fcWoolCount");
        }
    }

    @Override
    public boolean getCanCreatureTypeBePossessed() {
        return true;
    }

    @Override
    protected void modSpecificOnLivingUpdate() {
        super.modSpecificOnLivingUpdate();
        if (!(this.isLivingDead || !this.isFullyPossessed() || this.n() || this.G() || this.I())) {
            this.y = this.v < 125.0 ? (this.y += 0.08341) : (this.y += 0.0725);
            if (!this.F && !this.G && this.q.t.h == 0 && this.v > 100.0 && !this.checkForWolfBomb() && !this.n() && this.x > (double)-0.012f) {
                this.x -= 0.005;
            }
        }
    }

    @Override
    protected void a(float par1) {
        if (!this.isFullyPossessed() || this.n()) {
            super.a(par1);
        }
    }

    @Override
    public double W() {
        return this.P;
    }

    @Override
    public boolean c(wm stack) {
        return stack.c == wk.bU.cp;
    }

    @Override
    public boolean isValidZombieSecondaryTarget(sj zombie) {
        return true;
    }

    @Override
    public void bJ() {
        this.initHungerWithVariance();
        int iFleeceColor = SheepEntity.a(this.q.s);
        if (iFleeceColor == 0) {
            int iDiceRoll = this.q.s.nextInt(500);
            if (iDiceRoll == 0) {
                iFleeceColor = 3;
            } else if (iDiceRoll == 1) {
                iFleeceColor = 5;
            }
        }
        this.s(iFleeceColor);
    }

    @Override
    public void s(int iColor) {
        super.s(iColor);
        this.setOriginalFleeceColor(iColor);
    }

    @Override
    public mm a(mm parent) {
        return this.spawnHardcoreBaby(parent);
    }

    @Override
    public boolean isSubjectToHunger() {
        return true;
    }

    @Override
    public int getFoodValueMultiplier() {
        return 3;
    }

    @Override
    public void onBecomeFamished() {
        super.onBecomeFamished();
        if (!this.n()) {
            this.i(true);
        }
        this.woolAccumulationCount = 0;
    }

    @Override
    public void updateHungerState() {
        if (this.n() && this.isFullyFed() && !this.h_() && !this.getWearingBreedingHarness()) {
            --this.hungerCountdown;
            ++this.woolAccumulationCount;
            if (this.woolAccumulationCount >= 24000) {
                this.s(this.getOriginalFleeceColor());
                this.i(false);
                this.woolAccumulationCount = 0;
                this.q.e(2261, kx.c(this.u), (int)this.v + 1, kx.c(this.w), 0);
            }
        }
        super.updateHungerState();
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(20, new Byte(0));
    }

    public int getOriginalFleeceColor() {
        return this.ah.a(this.originalWoolColorWatcherID) & 0xF;
    }

    public void setOriginalFleeceColor(int originalColor) {
        byte byte0 = this.ah.a(this.originalWoolColorWatcherID);
        this.ah.b(this.originalWoolColorWatcherID, (byte)(byte0 & 0xF0 | originalColor & 0xF));
    }

    public void setSuperficialFleeceColor(int par1) {
        byte byte0 = this.ah.a(16);
        this.ah.b(16, (byte)(byte0 & 0xF0 | par1 & 0xF));
    }

    public SheepEntity spawnHardcoreBaby(mm parentAnimal) {
        SheepEntity parentSheep = (SheepEntity)parentAnimal;
        SheepEntity babySheep = (SheepEntity)mv.createEntityOfType(SheepEntity.class, this.q);
        int iMutationChance = this.ab.nextInt(100);
        if (iMutationChance == 0) {
            int iBabyColor = this.getMutantColor(this, parentSheep);
            babySheep.s(iBabyColor);
        } else if (iMutationChance <= 3) {
            int iBabyColor = 15;
            babySheep.s(iBabyColor);
        } else if (iMutationChance <= 23) {
            int iBabyColor = this.blendParentColors(this, parentSheep);
            babySheep.s(iBabyColor);
        } else if (this.ab.nextBoolean()) {
            babySheep.s(this.getOriginalFleeceColor());
        } else {
            babySheep.s(parentSheep.getOriginalFleeceColor());
        }
        return babySheep;
    }

    public int blendParentColors(SheepEntity papa, SheepEntity mama) {
        int mamaItemColor;
        int papaItemColor = alp.g_(papa.getOriginalFleeceColor());
        ColorBlendEntry blendEntry = ColorBlendEntry.getCachedEntry(papaItemColor, mamaItemColor = alp.g_(mama.getOriginalFleeceColor()));
        if (blendEntry != null) {
            if (blendEntry == ColorBlendEntry.getCachedEntry(ColorUtils.BLACK.colorID, ColorUtils.WHITE.colorID)) {
                return this.ab.nextBoolean() ? alp.g_(ColorUtils.GRAY.colorID) : alp.g_(ColorUtils.LIGHT_GRAY.colorID);
            }
            return blendEntry.getOutputColor();
        }
        return this.ab.nextBoolean() ? alp.g_(papaItemColor) : alp.g_(mamaItemColor);
    }

    public int getMutantColor(SheepEntity papa, SheepEntity mama) {
        int iRandomFactor = this.ab.nextInt(3);
        switch (iRandomFactor) {
            case 0: {
                return 3;
            }
            case 1: {
                return 5;
            }
        }
        return 6;
    }

    private void dropMutton(int iLootingModifier) {
        if (!this.hasHeadCrabbedSquid() && !this.isStarving()) {
            int iNumDropped = this.ab.nextInt(2) + 1 + this.ab.nextInt(1 + iLootingModifier);
            if (this.isFamished()) {
                iNumDropped /= 2;
            }
            for (int iTempCount = 0; iTempCount < iNumDropped; ++iTempCount) {
                if (this.ae()) {
                    if (this.q.getDifficulty().shouldBurningMobsDropCookedMeat()) {
                        this.b(BTWItems.cookedMutton.cp, 1);
                        continue;
                    }
                    this.b(BTWItems.burnedMeat.cp, 1);
                    continue;
                }
                this.b(BTWItems.rawMutton.cp, 1);
            }
        }
    }

    private boolean checkForWolfBomb() {
        if (!this.q.I && this.q.x.g() % 20L == 0L) {
            int iTopBlockID;
            apa topBlock;
            int iSheepK;
            int iTopBlockJ;
            int iSheepI = kx.c(this.u);
            int iSheepJ = kx.c(this.v);
            if (iSheepJ - (iTopBlockJ = this.q.h(iSheepI, iSheepK = kx.c(this.w)) - 1) >= 16 && (topBlock = apa.r[iTopBlockID = this.q.a(iSheepI, iTopBlockJ, iSheepK)]) != null && !topBlock.cO.d() && this.isPossessableWolfWithinRangeOfBlock(iSheepI, iTopBlockJ, iSheepK, 8)) {
                this.initiateWolfBomb();
                this.q.a(this, this.bd(), this.ba(), (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 1.0f);
                this.q.a(this, "mob.slime.attack", this.ba(), (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.6f);
                return true;
            }
        }
        return false;
    }

    private boolean isPossessableWolfWithinRangeOfBlock(int i2, int j2, int k, int iRange) {
        aqx possessionBox = aqx.a().a(i2 - iRange, j2 - iRange, k - iRange, i2 + 1 + iRange, j2 + 1 + iRange, k + 1 + iRange);
        List wolvesInBox = this.q.a(WolfEntity.class, possessionBox);
        for (WolfEntity tempWolf : wolvesInBox) {
            if (tempWolf.isLivingDead || tempWolf.isPossessed()) continue;
            return true;
        }
        return false;
    }

    private void initiateWolfBomb() {
        this.i(true);
        int iItemCount = 1 + this.ab.nextInt(3);
        for (int iTempCount = 0; iTempCount < iItemCount; ++iTempCount) {
            rh tempStack = this.a(new wm(BTWItems.wool.cp, 1, alp.c(this.m())), 1.0f);
            tempStack.y += (double)(this.ab.nextFloat() * 0.05f);
            tempStack.x += (double)((this.ab.nextFloat() - this.ab.nextFloat()) * 0.1f);
            tempStack.z += (double)((this.ab.nextFloat() - this.ab.nextFloat()) * 0.1f);
        }
    }

    protected boolean isTooHungryToProduceWool() {
        return this.hungerCountdown < 18000;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(byte bUpdateType) {
        if (bUpdateType == 10) {
            this.grazeProgressCounter = this.getGrazeDuration();
        } else {
            super.a(bUpdateType);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String N() {
        if (this.getWearingBreedingHarness()) {
            return "/btwmodtex/fc_mr_sheep.png";
        }
        int iHungerLevel = this.getHungerLevel();
        if (iHungerLevel == 1) {
            return "/btwmodtex/fcSheepFamished.png";
        }
        if (iHungerLevel == 2) {
            return "/btwmodtex/fcSheepStarving.png";
        }
        return super.N();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float j(float fPartialTick) {
        return this.getGrazeHeadVerticalOffset(fPartialTick);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float k(float fPartialTick) {
        return this.getGrazeHeadRotation(fPartialTick);
    }

    @Override
    public boolean onBlockDispenserConsume(BlockDispenserBlock blockDispenser, BlockDispenserTileEntity tileEntity) {
        if (!this.n() && !this.h_()) {
            this.i(true);
            InventoryUtils.addSingleItemToInventory(tileEntity, BTWItems.wool.cp, alp.c(this.m()));
            this.a(mg.j, 0);
            for (int tempCount = 0; tempCount < 2; ++tempCount) {
                blockDispenser.spitOutItem(this.q, tileEntity.l, tileEntity.m, tileEntity.n, new wm(wk.L));
            }
            return true;
        }
        return false;
    }

    static {
        try {
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.WHITE.colorID, ColorUtils.GRAY.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.LIGHT_GRAY.colorID, ColorUtils.GRAY.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.GRAY.colorID, ColorUtils.WHITE.colorID, ColorUtils.LIGHT_GRAY.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.LIGHT_BLUE.colorID, ColorUtils.BLUE.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.LIME.colorID, ColorUtils.GREEN.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.PINK.colorID, ColorUtils.RED.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLUE.colorID, ColorUtils.PINK.colorID, ColorUtils.MAGENTA.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.RED.colorID, ColorUtils.LIGHT_BLUE.colorID, ColorUtils.MAGENTA.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLACK.colorID, ColorUtils.MAGENTA.colorID, ColorUtils.PURPLE.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.RED.colorID, ColorUtils.BLUE.colorID, ColorUtils.PURPLE.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.BLUE.colorID, ColorUtils.GREEN.colorID, ColorUtils.CYAN.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.RED.colorID, ColorUtils.GREEN.colorID, ColorUtils.YELLOW.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.CYAN.colorID, ColorUtils.RED.colorID, ColorUtils.BROWN.colorID));
            colorBlendList.add(new ColorBlendEntry(ColorUtils.YELLOW.colorID, ColorUtils.RED.colorID, ColorUtils.ORANGE.colorID));
        }
        catch (InstanceAlreadyExistsException e2) {
            e2.printStackTrace();
        }
    }

    public static class ColorBlendEntry {
        private final int color1;
        private final int color2;
        private final int outputColor;
        private static Map<Integer, ColorBlendEntry> entryCache = new HashMap<Integer, ColorBlendEntry>();

        public ColorBlendEntry(int color1, int color2, int outputColor) throws InstanceAlreadyExistsException {
            if (color1 > color2) {
                int tempColor = color1;
                color1 = color2;
                color2 = tempColor;
            }
            this.color1 = color1;
            this.color2 = color2;
            this.outputColor = outputColor;
            int index = (color1 & 0xF) << 4 | color2 & 0xF;
            if (entryCache.get(index) != null) {
                throw new InstanceAlreadyExistsException("Cannot make more than one instance of an entry per color pair");
            }
            entryCache.put(index, this);
        }

        public int getOutputColor() {
            return alp.g_(this.outputColor);
        }

        public static ColorBlendEntry getCachedEntry(int color1, int color2) {
            if (color1 > color2) {
                int tempColor = color1;
                color1 = color2;
                color2 = tempColor;
            }
            int index = (color1 & 0xF) << 4 | color2 & 0xF;
            return entryCache.get(index);
        }
    }
}

