/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mob;

import btw.entity.mob.BatEntity;
import btw.entity.mob.CaveSpiderEntity;
import btw.entity.mob.SquidEntity;
import btw.entity.mob.behavior.AnimalFleeBehavior;
import btw.entity.mob.behavior.GrazeBehavior;
import btw.entity.mob.behavior.MoveToGrazeBehavior;
import btw.entity.mob.behavior.MoveToLooseFoodBehavior;
import btw.entity.mob.behavior.MultiTemptBehavior;
import btw.entity.mob.behavior.SimpleWanderBehavior;
import btw.item.BTWItems;
import btw.world.util.WorldUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class CowEntity
extends qj {
    protected static final int GOT_MILK_DATA_WATCHER_ID = 26;
    private static final int FULL_MILK_ACCUMULATION_COUNT = 24000;
    private static final int KICK_ATTACK_TICKS_TO_COOLDOWN = 40;
    private static final double KICK_ATTACK_RANGE = 1.75;
    public static final int KICK_ATTACK_DURATION = 20;
    public static final double KICK_ATTACK_TIP_COLLISION_WIDTH = 2.75;
    public static final double KICK_ATTACK_TIP_COLLISION_HALF_WIDTH = 1.375;
    public static final double KICK_ATTACK_TIP_COLLISION_HEIGHT = 2.0;
    public static final double KICK_ATTACK_TIP_COLLISION_HALF_HEIGHT = 1.0;
    private int milkAccumulationCount = 0;
    private int kickAttackCooldownTimer = 40;
    public int kickAttackInProgressCounter = -1;
    public int kickAttackLegUsed = 0;

    public CowEntity(aab world) {
        super(world);
        this.bo.removeAllTasks();
        this.bo.a(0, (om)new oj((ng)this));
        this.bo.a(1, new AnimalFleeBehavior(this, 0.38f));
        this.bo.a(2, new oe(this, 0.2f));
        this.bo.a(3, new MultiTemptBehavior(this, 0.25f));
        this.bo.a(4, new GrazeBehavior(this));
        this.bo.a(5, new MoveToLooseFoodBehavior(this, 0.2f));
        this.bo.a(6, new MoveToGrazeBehavior(this, 0.2f));
        this.bo.a(7, new ol(this, 0.25f));
        this.bo.a(8, new SimpleWanderBehavior(this, 0.25f));
        this.bo.a(9, (om)new or((ng)this, sq.class, 6.0f));
        this.bo.a(10, (om)new pf((ng)this));
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(26, new Byte(0));
    }

    @Override
    public void b(bs par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("fcGotMilk", this.gotMilk());
        par1NBTTagCompound.a("fcMilkCount", this.milkAccumulationCount);
    }

    @Override
    public void a(bs par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        if (par1NBTTagCompound.b("fcGotMilk")) {
            this.setGotMilk(par1NBTTagCompound.n("fcGotMilk"));
        }
        if (par1NBTTagCompound.b("fcMilkCount")) {
            this.milkAccumulationCount = par1NBTTagCompound.e("fcMilkCount");
        }
    }

    @Override
    public boolean bh() {
        return !this.getWearingBreedingHarness();
    }

    @Override
    public int aW() {
        return 15;
    }

    @Override
    public void c() {
        this.updateKickAttack();
        super.c();
    }

    @Override
    protected void a(boolean bKilledByPlayer, int iLootingModifier) {
        if (!this.isStarving()) {
            int iTempCount;
            int iNumDrops = this.ab.nextInt(3) + this.ab.nextInt(1 + iLootingModifier) + 1;
            if (this.isFamished()) {
                iNumDrops /= 2;
            }
            for (iTempCount = 0; iTempCount < iNumDrops; ++iTempCount) {
                this.b(wk.aG.cp, 1);
            }
            if (!this.hasHeadCrabbedSquid()) {
                iNumDrops = this.ab.nextInt(3) + 1 + this.ab.nextInt(1 + iLootingModifier);
                if (this.isFamished()) {
                    iNumDrops /= 2;
                }
                for (iTempCount = 0; iTempCount < iNumDrops; ++iTempCount) {
                    if (this.ae()) {
                        if (this.q.getDifficulty().shouldBurningMobsDropCookedMeat()) {
                            this.b(wk.bk.cp, 1);
                            continue;
                        }
                        this.b(BTWItems.burnedMeat.cp, 1);
                        continue;
                    }
                    this.b(wk.bj.cp, 1);
                }
            }
        }
    }

    @Override
    public boolean c(wm stack) {
        return stack.c == wk.ba.cp;
    }

    @Override
    public boolean a_(sq player) {
        wm stack = player.bK.h();
        if (stack != null && stack.c == wk.ax.cp) {
            if (this.gotMilk()) {
                --stack.a;
                if (stack.a <= 0) {
                    player.bK.a(player.bK.c, new wm(wk.aH));
                } else if (!player.bK.a(new wm(wk.aH))) {
                    player.c(new wm(wk.aH.cp, 1, 0));
                }
                this.a(mg.j, 0);
                if (!this.q.I) {
                    this.setGotMilk(false);
                    this.q.e(2254, kx.c(this.u), (int)this.v, kx.c(this.w), 0);
                }
            } else if (this.q.getDifficulty().canMilkingStartleCows()) {
                this.a(mg.a(player), 0);
            }
            return true;
        }
        return this.entityAnimalInteract(player);
    }

    @Override
    public void onGrazeBlock(int i2, int j2, int k) {
        super.onGrazeBlock(i2, j2, k);
        if (!this.getWearingBreedingHarness()) {
            this.checkForGrazeSideEffects(i2, j2, k);
        }
    }

    @Override
    public boolean isSubjectToHunger() {
        return true;
    }

    @Override
    public void onBecomeFamished() {
        super.onBecomeFamished();
        if (this.gotMilk()) {
            this.setGotMilk(false);
        }
        this.milkAccumulationCount = 0;
    }

    @Override
    public boolean canGrazeMycelium() {
        return true;
    }

    @Override
    public double W() {
        return (double)this.P * 1.2;
    }

    @Override
    public boolean getCanCreatureTypeBePossessed() {
        return true;
    }

    @Override
    protected void giveBirthAtTargetLocation(qh targetMate, double dChildX, double dChildY, double dChildZ) {
        if ((this.isFullyPossessed() || targetMate.isFullyPossessed()) && this.ab.nextInt(8) != 0) {
            if (this.q.t.h != 1 && this.q.s.nextInt(2) == 0) {
                this.birthMutant(targetMate, dChildX, dChildY, dChildZ);
            } else {
                this.stillBirth(targetMate, dChildX, dChildY, dChildZ);
            }
        } else {
            super.giveBirthAtTargetLocation(targetMate, dChildX, dChildY, dChildZ);
        }
    }

    @Override
    public void bJ() {
        this.initHungerWithVariance();
        if (!this.h_()) {
            this.milkAccumulationCount = this.q.s.nextInt(30001);
            if (this.milkAccumulationCount >= 24000) {
                this.milkAccumulationCount = 0;
                this.setGotMilk(true);
            }
        }
    }

    @Override
    public boolean isValidZombieSecondaryTarget(sj zombie) {
        return true;
    }

    public CowEntity spawnBabyAnimal(mm parent) {
        return (CowEntity)mv.createEntityOfType(CowEntity.class, this.q);
    }

    @Override
    protected String bb() {
        if (!this.isStarving()) {
            return "mob.cow.say";
        }
        return "mob.cow.hurt";
    }

    @Override
    public void updateHungerState() {
        if (!this.gotMilk() && this.isFullyFed() && !this.h_() && !this.getWearingBreedingHarness()) {
            --this.hungerCountdown;
            ++this.milkAccumulationCount;
            if (this.milkAccumulationCount >= 24000) {
                this.setGotMilk(true);
                this.milkAccumulationCount = 0;
                this.q.e(2253, kx.c(this.u), (int)this.v + 1, kx.c(this.w), 0);
            }
        }
        super.updateHungerState();
    }

    @Override
    public float knockbackMagnitude() {
        return 0.3f;
    }

    public void checkForGrazeSideEffects(int i2, int j2, int k) {
        int iTargetBlockID = this.q.a(i2, j2, k);
        if (iTargetBlockID == apa.bC.cz) {
            this.convertToMooshroom();
        }
    }

    public void convertToMooshroom() {
        int iFXI = kx.c(this.u);
        int iFXJ = kx.c(this.v) + 1;
        int iFXK = kx.c(this.w);
        int iExtendedFXData = 0;
        if (this.h_()) {
            iExtendedFXData = 1;
        }
        this.q.e(2255, iFXI, iFXJ, iFXK, iExtendedFXData);
        this.w();
        CowEntity entityMooshroom = (CowEntity)mv.createEntityOfType(ql.class, this.q);
        entityMooshroom.b(this.u, this.v, this.w, this.A, this.B);
        entityMooshroom.b(this.aX());
        entityMooshroom.ay = this.ay;
        entityMooshroom.a(this.b());
        this.q.d(entityMooshroom);
    }

    public boolean gotMilk() {
        byte bGotMilk = this.ah.a(26);
        return bGotMilk != 0;
    }

    protected void setGotMilk(boolean bGotMilk) {
        byte byteValue = 0;
        if (bGotMilk) {
            byteValue = 1;
        }
        this.ah.b(26, byteValue);
    }

    private void updateKickAttack() {
        if (this.kickAttackInProgressCounter >= 0) {
            ++this.kickAttackInProgressCounter;
            if (this.kickAttackInProgressCounter >= 20) {
                this.kickAttackInProgressCounter = -1;
            }
        } else if (!this.q.I) {
            --this.kickAttackCooldownTimer;
            if (this.R() && !this.h_() && !this.getWearingBreedingHarness() && this.kickAttackCooldownTimer <= 0 && (this.ae() || this.aF() != null)) {
                arc kickCenter = this.computeKickAttackCenter();
                aqx tipBox = aqx.a().a(kickCenter.c - 1.375, kickCenter.d - 1.0, kickCenter.e - 1.375, kickCenter.c + 1.375, kickCenter.d + 1.0, kickCenter.e + 1.375);
                List potentialCollisionList = this.q.a(ng.class, tipBox);
                if (!potentialCollisionList.isEmpty()) {
                    boolean bAttackLaunched = false;
                    arc lineOfSightOrigin = arc.a(this.u, this.v + (double)(this.P / 2.0f), this.w);
                    for (ng tempEntity : potentialCollisionList) {
                        if (tempEntity instanceof CowEntity || !tempEntity.R() || tempEntity.o == this || !this.canEntityBeSeenForAttackToCenterOfMass(tempEntity, lineOfSightOrigin)) continue;
                        bAttackLaunched = true;
                        this.kickAttackHitTarget(tempEntity);
                    }
                    if (bAttackLaunched) {
                        this.launchKickAttack();
                    }
                }
            }
        }
    }

    public boolean canEntityBeSeenForAttackToCenterOfMass(mp entity, arc attackOrigin) {
        return this.q.a(attackOrigin, this.q.U().a(entity.u, entity.v + (double)(entity.P / 2.0f), entity.w), false, true) == null;
    }

    public arc computeKickAttackCenter() {
        float fAttackAngle = kx.g(this.A + 180.0f);
        double dPosX = (double)(-kx.a(fAttackAngle / 180.0f * (float)Math.PI)) * 1.75;
        double dPosY = this.P / 2.0f;
        double dPosZ = (double)kx.b(fAttackAngle / 180.0f * (float)Math.PI) * 1.75;
        return arc.a(dPosX += this.u, dPosY += this.v, dPosZ += this.w);
    }

    private void launchKickAttack() {
        this.kickAttackInProgressCounter = 0;
        this.kickAttackCooldownTimer = 40;
        this.transmitKickAttackToClients();
    }

    private void transmitKickAttackToClients() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeInt(this.k);
            dataStream.writeByte(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dk packet = new dk("BTW|EV", byteStream.toByteArray());
        WorldUtils.sendPacketToAllPlayersTrackingEntity((iz)this.q, this, (ei)packet);
    }

    public void onClientNotifiedOfKickAttack() {
        this.kickAttackInProgressCounter = 0;
        this.kickAttackLegUsed = this.ab.nextInt(2);
        this.q.playSound(this.u, this.v, this.w, "random.bow", 1.0f, (this.ab.nextFloat() - this.ab.nextFloat()) * 0.2f + 0.5f);
    }

    private void kickAttackHitTarget(mp hitEntity) {
        mg cowSource = mg.a(this);
        int kickDamage = 7;
        if (hitEntity instanceof sq) {
            kickDamage = (int)((float)kickDamage * this.q.getDifficulty().getCowKickStrengthMultiplier());
        }
        if (hitEntity.a(cowSource, kickDamage)) {
            if (this.ae() && this.ab.nextFloat() < 0.6f) {
                hitEntity.d(4);
            }
            hitEntity.onKickedByCow(this);
        }
    }

    private boolean birthMutant(qh targetMate, double dChildX, double dChildY, double dChildZ) {
        int iRandomFactor = this.ab.nextInt(20);
        if (iRandomFactor == 0) {
            CaveSpiderEntity childEntity = (CaveSpiderEntity)mv.createEntityOfType(CaveSpiderEntity.class, this.q);
            if (childEntity != null) {
                childEntity.b(dChildX, dChildY, dChildZ, this.A, this.B);
                this.q.d(childEntity);
            }
        } else if (iRandomFactor < 4) {
            for (int iTempCount = 0; iTempCount < 10; ++iTempCount) {
                BatEntity childEntity = (BatEntity)((Object)mv.createEntityOfType(BatEntity.class, this.q));
                if (childEntity == null) continue;
                childEntity.b(dChildX, dChildY, dChildZ, this.A, this.B);
                this.q.d((mp)((Object)childEntity));
            }
        } else if (iRandomFactor < 7) {
            for (int iTempCount = 0; iTempCount < 5; ++iTempCount) {
                se childEntity = (se)mv.createEntityOfType(se.class, this.q);
                if (childEntity == null) continue;
                childEntity.b(dChildX, dChildY, dChildZ, this.A, this.B);
                this.q.d(childEntity);
            }
        } else {
            SquidEntity childEntity = (SquidEntity)mv.createEntityOfType(SquidEntity.class, this.q);
            if (childEntity != null) {
                childEntity.b(dChildX, dChildY, dChildZ, this.A, this.B);
                this.q.d(childEntity);
            }
        }
        return true;
    }

    protected void stillBirth(qh targetMate, double dChildX, double dChildY, double dChildZ) {
        mm childEntity = this.a((mm)targetMate);
        if (childEntity != null) {
            childEntity.a(-childEntity.getTicksForChildToGrow());
            childEntity.b(dChildX, dChildY, dChildZ, this.A, this.B);
            this.q.d(childEntity);
            childEntity.a(mg.j, 20);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String N() {
        if (this.getWearingBreedingHarness()) {
            return "/btwmodtex/fc_mr_cow.png";
        }
        int iHungerLevel = this.getHungerLevel();
        if (iHungerLevel == 1) {
            return "/btwmodtex/fcCowFamished.png";
        }
        if (iHungerLevel == 2) {
            return "/btwmodtex/fcCowStarving.png";
        }
        return super.N();
    }
}

