/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mechanical.source;

import btw.block.BTWBlocks;
import btw.block.blocks.AxleBlock;
import btw.block.util.MechPowerUtils;
import btw.entity.mechanical.source.MechanicalPowerSourceEntityHorizontal;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class WindMillEntity
extends MechanicalPowerSourceEntityHorizontal {
    public static final float HEIGHT = 12.8f;
    public static final float WIDTH = 12.8f;
    public static final float DEPTH = 0.8f;
    private static final int MAX_DAMAGE = 160;
    private static final float ROTATION_PER_TICK = -0.12f;
    private static final float ROTATION_PER_TICK_IN_STORM = -2.0f;
    private static final float ROTATION_PER_TICK_IN_HELL = -0.07f;
    private static final int TICKS_PER_FULL_UPDATE = 20;
    private static final int UPDATES_TO_OVERPOWER = 30;
    private static final int BLADE_COLOR_0_DATA_WATCHER_ID = 23;
    private static final int BLADE_COLOR_1_DATA_WATCHER_ID = 24;
    private static final int BLADE_COLOR_2_DATA_WATCHER_ID = 25;
    private static final int BLADE_COLOR_3_DATA_WATCHER_ID = 26;
    private int currentBladeColoringIndex;
    protected int overpowerTimer;
    private boolean legacyWindMill;

    public WindMillEntity(aab world) {
        super(world);
        this.currentBladeColoringIndex = 0;
        this.legacyWindMill = false;
    }

    public WindMillEntity(aab world, double x2, double y2, double z2, boolean bIAligned) {
        super(world, x2, y2, z2, bIAligned);
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(23, new Byte(0));
        this.ah.a(24, new Byte(0));
        this.ah.a(25, new Byte(0));
        this.ah.a(26, new Byte(0));
    }

    public int getBladeColor(int iBladeIndex) {
        return this.ah.a(23 + iBladeIndex);
    }

    public void setBladeColor(int iBladeIndex, int iColor) {
        this.ah.b(23 + iBladeIndex, (byte)iColor);
    }

    @Override
    protected void b(bs nbttagcompound) {
        nbttagcompound.a("bWindMillIAligned", this.alignedToX);
        nbttagcompound.a("fRotation", this.rotation);
        nbttagcompound.a("bProvidingPower", this.providingPower);
        nbttagcompound.a("iOverpowerTimer", this.overpowerTimer);
        nbttagcompound.a("iBladeColors0", this.getBladeColor(0));
        nbttagcompound.a("iBladeColors1", this.getBladeColor(1));
        nbttagcompound.a("iBladeColors2", this.getBladeColor(2));
        nbttagcompound.a("iBladeColors3", this.getBladeColor(3));
        nbttagcompound.a("fcLegacy", this.legacyWindMill);
    }

    @Override
    protected void a(bs nbttagcompound) {
        this.alignedToX = nbttagcompound.n("bWindMillIAligned");
        this.rotation = nbttagcompound.g("fRotation");
        this.providingPower = nbttagcompound.n("bProvidingPower");
        this.overpowerTimer = nbttagcompound.e("iOverpowerTimer");
        this.setBladeColor(0, nbttagcompound.e("iBladeColors0"));
        this.setBladeColor(1, nbttagcompound.e("iBladeColors1"));
        this.setBladeColor(2, nbttagcompound.e("iBladeColors2"));
        this.setBladeColor(3, nbttagcompound.e("iBladeColors3"));
        this.legacyWindMill = nbttagcompound.b("fcLegacy") ? nbttagcompound.n("fcLegacy") : true;
        this.initBoundingBox();
    }

    @Override
    public boolean a_(sq player) {
        wm itemstack = player.bK.h();
        if (itemstack != null && (itemstack.c == wk.aX.cp || itemstack.c == BTWItems.dung.cp)) {
            if (!this.q.I) {
                int iColor = 0;
                iColor = itemstack.c == wk.aX.cp ? alp.g_(itemstack.k()) : 12;
                this.setBladeColor(this.currentBladeColoringIndex, iColor);
                ++this.currentBladeColoringIndex;
                if (this.currentBladeColoringIndex >= 4) {
                    this.currentBladeColoringIndex = 0;
                }
            }
            --itemstack.a;
            if (itemstack.a == 0) {
                player.bK.a(player.bK.c, null);
            }
            return true;
        }
        return super.a_(player);
    }

    @Override
    public void a(re par1EntityLightningBolt) {
        if (this.q.N().b("doFireTick") && this.q.getDifficulty().shouldLightningStartFires()) {
            this.w();
        }
    }

    @Override
    public float getWidth() {
        return 12.8f;
    }

    @Override
    public float getHeight() {
        return 12.8f;
    }

    @Override
    public float getDepth() {
        return 0.8f;
    }

    @Override
    public int getMaxDamage() {
        return 160;
    }

    @Override
    public int getTicksPerFullUpdate() {
        return 20;
    }

    @Override
    protected void onFullUpdateServer() {
        super.onFullUpdateServer();
        if (this.overpowerTimer >= 0) {
            if (this.overpowerTimer > 0) {
                --this.overpowerTimer;
            }
            if (this.overpowerTimer <= 0) {
                int iCenterI = kx.c(this.u);
                int iCenterJ = kx.c(this.v);
                int iCenterK = kx.c(this.w);
                ((AxleBlock)BTWBlocks.axle).overpower(this.q, iCenterI, iCenterJ, iCenterK);
            }
        }
    }

    @Override
    public void destroyWithDrop() {
        if (!this.q.I && !this.M) {
            this.a(BTWItems.windMill.cp, 1, 0.0f);
            this.w();
        }
    }

    @Override
    public boolean validateAreaAroundDevice() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        return WindMillEntity.windMillValidateAreaAroundBlock(this.q, iCenterI, iCenterJ, iCenterK, this.alignedToX);
    }

    @Override
    public float computeRotation() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        float fRotationAmount = 0.0f;
        if (this.q.t.h == -1) {
            if (this.legacyWindMill) {
                fRotationAmount = -0.07f;
            }
            this.overpowerTimer = -1;
        } else if (this.q.t.h != 1 && this.q.l(iCenterI, iCenterJ, iCenterK)) {
            if (this.q.O() && this.q.isPrecipitatingAtPos(iCenterI, iCenterK)) {
                fRotationAmount = -2.0f;
                if (this.overpowerTimer < 0) {
                    this.overpowerTimer = 30;
                }
            } else {
                fRotationAmount = -0.12f;
                this.overpowerTimer = -1;
            }
        } else {
            this.overpowerTimer = -1;
        }
        return fRotationAmount;
    }

    @Override
    protected void onClientRotationOctantChange() {
        int iCenterK;
        int iCenterJ;
        int iCenterI;
        int iCenterBlockID;
        float fSpeed = this.getRotationSpeed();
        if (fSpeed < -0.12f && (iCenterBlockID = this.q.a(iCenterI = kx.c(this.u), iCenterJ = kx.c(this.v), iCenterK = kx.c(this.w))) == BTWBlocks.axlePowerSource.cz) {
            int iAxleAlignment = ((AxleBlock)BTWBlocks.axlePowerSource).getAxisAlignment(this.q, iCenterI, iCenterJ, iCenterK);
            this.clientNotifyGearboxOfOverpoweredOctantChangeInDirection(iCenterI, iCenterJ, iCenterK, iAxleAlignment << 1);
            this.clientNotifyGearboxOfOverpoweredOctantChangeInDirection(iCenterI, iCenterJ, iCenterK, (iAxleAlignment << 1) + 1);
        }
    }

    @Override
    public ei getSpawnPacketForThisEntity() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            int bIAligned = 0;
            if (this.alignedToX) {
                bIAligned = 1;
            }
            dataStream.writeInt(1);
            dataStream.writeInt(this.k);
            dataStream.writeInt(kx.c(this.u * 32.0));
            dataStream.writeInt(kx.c(this.v * 32.0));
            dataStream.writeInt(kx.c(this.w * 32.0));
            dataStream.writeByte(bIAligned);
            dataStream.writeInt(this.getRotationSpeedScaled());
            dataStream.writeByte((byte)this.getBladeColor(0));
            dataStream.writeByte((byte)this.getBladeColor(1));
            dataStream.writeByte((byte)this.getBladeColor(2));
            dataStream.writeByte((byte)this.getBladeColor(3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new dk("BTW|SE", byteStream.toByteArray());
    }

    protected void clientNotifyGearboxOfOverpoweredOctantChangeInDirection(int iCenterI, int iCenterJ, int iCenterK, int iFacing) {
        BlockPos tempPos = new BlockPos(iCenterI, iCenterJ, iCenterK);
        for (int iTempCount = 0; iTempCount < 10; ++iTempCount) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = this.q.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID == BTWBlocks.axle.cz || iTempBlockID == BTWBlocks.axlePowerSource.cz) {
                if (!((AxleBlock)apa.r[iTempBlockID]).isAxleOrientedTowardsFacing(this.q, tempPos.x, tempPos.y, tempPos.z, iFacing)) break;
                continue;
            }
            if (!MechPowerUtils.isPoweredGearBox(this.q, tempPos.x, tempPos.y, tempPos.z)) break;
            this.q.playSound((double)tempPos.x + 0.5, (double)tempPos.y + 0.5, (double)tempPos.z + 0.5, "random.chestclosed", 1.5f, this.q.s.nextFloat() * 0.1f + 0.5f);
            break;
        }
    }

    public static boolean windMillValidateAreaAroundBlock(aab world, int i2, int j2, int k, boolean bIAligned) {
        int kOffset;
        int iOffset;
        if (bIAligned) {
            iOffset = 0;
            kOffset = 1;
        } else {
            iOffset = 1;
            kOffset = 0;
        }
        for (int iHeightOffset = -6; iHeightOffset <= 6; ++iHeightOffset) {
            for (int iWidthOffset = -6; iWidthOffset <= 6; ++iWidthOffset) {
                int tempK;
                int tempJ;
                int tempI;
                if (iHeightOffset == 0 && iWidthOffset == 0 || WindMillEntity.isValidBlockForWindMillToOccupy(world, tempI = i2 + iOffset * iWidthOffset, tempJ = j2 + iHeightOffset, tempK = k + kOffset * iWidthOffset)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidBlockForWindMillToOccupy(aab world, int i2, int j2, int k) {
        return world.c(i2, j2, k);
    }
}

