/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mechanical.source;

import btw.entity.mechanical.source.MechanicalPowerSourceEntityHorizontal;
import btw.item.BTWItems;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class WaterWheelEntity
extends MechanicalPowerSourceEntityHorizontal {
    public static final float HEIGHT = 4.8f;
    public static final float WIDTH = 4.8f;
    public static final float DEPTH = 0.8f;
    public static final int MAX_DAMAGE = 160;
    public static final float ROTATION_PER_TICK = 0.25f;
    public static final int TICKS_PER_FULL_UPDATE = 20;

    public WaterWheelEntity(aab world) {
        super(world);
    }

    public WaterWheelEntity(aab world, double x2, double y2, double z2, boolean bIAligned) {
        super(world, x2, y2, z2, bIAligned);
    }

    @Override
    protected void a() {
        super.a();
    }

    @Override
    protected void b(bs nbttagcompound) {
        nbttagcompound.a("bWaterWheelIAligned", this.alignedToX);
        nbttagcompound.a("fRotation", this.rotation);
        nbttagcompound.a("bProvidingPower", this.providingPower);
    }

    @Override
    protected void a(bs nbttagcompound) {
        this.alignedToX = nbttagcompound.n("bWaterWheelIAligned");
        this.rotation = nbttagcompound.g("fRotation");
        this.providingPower = nbttagcompound.n("bProvidingPower");
        this.initBoundingBox();
    }

    @Override
    public ei getSpawnPacketForThisEntity() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            int bIAligned = 0;
            if (this.alignedToX) {
                bIAligned = 1;
            }
            dataStream.writeInt(2);
            dataStream.writeInt(this.k);
            dataStream.writeInt(kx.c(this.u * 32.0));
            dataStream.writeInt(kx.c(this.v * 32.0));
            dataStream.writeInt(kx.c(this.w * 32.0));
            dataStream.writeByte(bIAligned);
            dataStream.writeInt(this.getRotationSpeedScaled());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new dk("BTW|SE", byteStream.toByteArray());
    }

    @Override
    public float getWidth() {
        return 4.8f;
    }

    @Override
    public float getHeight() {
        return 4.8f;
    }

    @Override
    public float getDepth() {
        return 0.8f;
    }

    @Override
    public int getMaxDamage() {
        return 160;
    }

    @Override
    public int getTicksPerFullUpdate() {
        return 20;
    }

    @Override
    public void destroyWithDrop() {
        if (!this.q.I && !this.M) {
            this.a(BTWItems.waterWheel.cp, 1, 0.0f);
            this.w();
        }
    }

    @Override
    public boolean validateAreaAroundDevice() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        return WaterWheelEntity.waterWheelValidateAreaAroundBlock(this.q, iCenterI, iCenterJ, iCenterK, this.alignedToX);
    }

    @Override
    public float computeRotation() {
        ane fluidBlock;
        int kOffset;
        int iOffset;
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        float fRotationAmount = 0.0f;
        int iFlowJ = iCenterJ - 2;
        int iFlowBlockID = this.q.a(iCenterI, iFlowJ, iCenterK);
        if (iFlowBlockID == apa.E.cz || iFlowBlockID == apa.F.cz) {
            arc flowVector = this.getFlowVector(this.q, iCenterI, iFlowJ, iCenterK);
            if (this.alignedToX) {
                if (flowVector.e > (double)0.33f) {
                    fRotationAmount = -0.25f;
                } else if (flowVector.e < (double)-0.33f) {
                    fRotationAmount = 0.25f;
                }
            } else if (flowVector.c > (double)0.33f) {
                fRotationAmount = 0.25f;
            } else if (flowVector.c < (double)-0.33f) {
                fRotationAmount = -0.25f;
            }
        }
        if (this.alignedToX) {
            iOffset = 0;
            kOffset = 2;
        } else {
            iOffset = 2;
            kOffset = 0;
        }
        iFlowBlockID = this.q.a(iCenterI + iOffset, iCenterJ, iCenterK - kOffset);
        if (iFlowBlockID == apa.E.cz || iFlowBlockID == apa.F.cz) {
            fluidBlock = (ane)apa.r[iFlowBlockID];
            fRotationAmount -= 0.25f;
        }
        if ((iFlowBlockID = this.q.a(iCenterI - iOffset, iCenterJ, iCenterK + kOffset)) == apa.E.cz || iFlowBlockID == apa.F.cz) {
            fluidBlock = (ane)apa.r[iFlowBlockID];
            fRotationAmount += 0.25f;
        }
        if (fRotationAmount > 0.25f) {
            fRotationAmount = 0.25f;
        } else if (fRotationAmount <= -0.25f) {
            fRotationAmount = -0.25f;
        }
        return fRotationAmount;
    }

    public static boolean waterWheelValidateAreaAroundBlock(aab world, int i2, int j2, int k, boolean bIAligned) {
        int kOffset;
        int iOffset;
        if (bIAligned) {
            iOffset = 0;
            kOffset = 1;
        } else {
            iOffset = 1;
            kOffset = 0;
        }
        for (int iHeightOffset = -2; iHeightOffset <= 2; ++iHeightOffset) {
            for (int iWidthOffset = -2; iWidthOffset <= 2; ++iWidthOffset) {
                int tempK;
                int tempJ;
                int tempI;
                if (iHeightOffset == 0 && iWidthOffset == 0 || WaterWheelEntity.isValidBlockForWaterWheelToOccupy(world, tempI = i2 + iOffset * iWidthOffset, tempJ = j2 + iHeightOffset, tempK = k + kOffset * iWidthOffset)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidBlockForWaterWheelToOccupy(aab world, int i2, int j2, int k) {
        int iBlockID;
        return world.c(i2, j2, k) || (iBlockID = world.a(i2, j2, k)) == apa.E.cz || iBlockID == apa.F.cz;
    }

    private arc getFlowVector(aak par1IBlockAccess, int par2, int par3, int par4) {
        arc vec3 = par1IBlockAccess.U().a(0.0, 0.0, 0.0);
        int i2 = this.getEffectiveFlowDecay(par1IBlockAccess, par2, par3, par4);
        for (int j2 = 0; j2 < 4; ++j2) {
            int j1;
            int k = par2;
            int l2 = par3;
            int i1 = par4;
            if (j2 == 0) {
                --k;
            }
            if (j2 == 1) {
                --i1;
            }
            if (j2 == 2) {
                ++k;
            }
            if (j2 == 3) {
                ++i1;
            }
            if ((j1 = this.getEffectiveFlowDecay(par1IBlockAccess, k, l2, i1)) < 0) {
                if (par1IBlockAccess.g(k, l2, i1).c() || (j1 = this.getEffectiveFlowDecay(par1IBlockAccess, k, l2 - 1, i1)) < 0) continue;
                int k1 = j1 - (i2 - 8);
                vec3 = vec3.c((k - par2) * k1, (l2 - par3) * k1, (i1 - par4) * k1);
                continue;
            }
            if (j1 < 0) continue;
            int l1 = j1 - i2;
            vec3 = vec3.c((k - par2) * l1, (l2 - par3) * l1, (i1 - par4) * l1);
        }
        if (par1IBlockAccess.h(par2, par3, par4) >= 8) {
            boolean flag = false;
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3, par4 - 1, 2)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3, par4 + 1, 3)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 - 1, par3, par4, 4)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 + 1, par3, par4, 5)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3 + 1, par4 - 1, 2)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2, par3 + 1, par4 + 1, 3)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 - 1, par3 + 1, par4, 4)) {
                flag = true;
            }
            if (flag || this.isBlockSolid(par1IBlockAccess, par2 + 1, par3 + 1, par4, 5)) {
                flag = true;
            }
            if (flag) {
                vec3 = vec3.a().c(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.a();
        return vec3;
    }

    private boolean isBlockSolid(aak par1IBlockAccess, int par2, int par3, int par4, int par5) {
        aif material = par1IBlockAccess.g(par2, par3, par4);
        if (material == apa.E.cO) {
            return false;
        }
        if (par5 == 1) {
            return true;
        }
        if (material == aif.v) {
            return false;
        }
        return par1IBlockAccess.g(par2, par3, par4).a();
    }

    private int getEffectiveFlowDecay(aak iblockaccess, int i2, int j2, int k) {
        if (iblockaccess.g(i2, j2, k) != apa.E.cO) {
            return -1;
        }
        int l2 = iblockaccess.h(i2, j2, k);
        if (l2 >= 8) {
            l2 = 0;
        }
        return l2;
    }
}

