/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mechanical.source;

import btw.block.BTWBlocks;
import btw.block.blocks.AxleBlock;
import btw.block.util.MechPowerUtils;
import btw.entity.mechanical.source.MechanicalPowerSourceEntity;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;

public class VerticalWindMillEntity
extends MechanicalPowerSourceEntity {
    public static final float HEIGHT = 6.8f;
    public static final float WIDTH = 8.8f;
    private static final int MAX_DAMAGE = 160;
    private static final float ROTATION_PER_TICK = -0.12f;
    private static final float ROTATION_PER_TICK_IN_STORM = -2.0f;
    private static final float ROTATION_PER_TICK_IN_HELL = -0.07f;
    private static final int TICKS_PER_FULL_UPDATE = 20;
    private static final int UPDATES_TO_OVERPOWER = 30;
    private static final int BLADE_COLOR_0_DATA_WATCHER_ID = 23;
    private static final int BLADE_COLOR_1_DATA_WATCHER_ID = 24;
    private static final int BLADE_COLOR_2_DATA_WATCHER_ID = 25;
    private static final int BLADE_COLOR_3_DATA_WATCHER_ID = 26;
    private static final int BLADE_COLOR_4_DATA_WATCHER_ID = 27;
    private static final int BLADE_COLOR_5_DATA_WATCHER_ID = 28;
    private static final int BLADE_COLOR_6_DATA_WATCHER_ID = 29;
    private static final int BLADE_COLOR_7_DATA_WATCHER_ID = 30;
    private int currentBladeColoringIndex;
    protected int overpowerTimer;

    public VerticalWindMillEntity(aab world) {
        super(world);
        this.currentBladeColoringIndex = 0;
    }

    public VerticalWindMillEntity(aab world, double x2, double y2, double z2) {
        super(world, x2, y2, z2);
    }

    @Override
    protected void a() {
        super.a();
        this.ah.a(23, new Byte(0));
        this.ah.a(24, new Byte(0));
        this.ah.a(25, new Byte(0));
        this.ah.a(26, new Byte(0));
        this.ah.a(27, new Byte(0));
        this.ah.a(28, new Byte(0));
        this.ah.a(29, new Byte(0));
        this.ah.a(30, new Byte(0));
    }

    public int getBladeColor(int iBladeIndex) {
        return this.ah.a(23 + iBladeIndex);
    }

    public void setBladeColor(int iBladeIndex, int iColor) {
        this.ah.b(23 + iBladeIndex, (byte)iColor);
    }

    @Override
    protected void b(bs nbttagcompound) {
        nbttagcompound.a("fRotation", this.rotation);
        nbttagcompound.a("bProvidingPower", this.providingPower);
        nbttagcompound.a("iOverpowerTimer", this.overpowerTimer);
        nbttagcompound.a("iBladeColors0", this.getBladeColor(0));
        nbttagcompound.a("iBladeColors1", this.getBladeColor(1));
        nbttagcompound.a("iBladeColors2", this.getBladeColor(2));
        nbttagcompound.a("iBladeColors3", this.getBladeColor(3));
        nbttagcompound.a("iBladeColors4", this.getBladeColor(4));
        nbttagcompound.a("iBladeColors5", this.getBladeColor(5));
        nbttagcompound.a("iBladeColors6", this.getBladeColor(6));
        nbttagcompound.a("iBladeColors7", this.getBladeColor(7));
    }

    @Override
    protected void a(bs nbttagcompound) {
        this.rotation = nbttagcompound.g("fRotation");
        this.providingPower = nbttagcompound.n("bProvidingPower");
        this.overpowerTimer = nbttagcompound.e("iOverpowerTimer");
        this.setBladeColor(0, nbttagcompound.e("iBladeColors0"));
        this.setBladeColor(1, nbttagcompound.e("iBladeColors1"));
        this.setBladeColor(2, nbttagcompound.e("iBladeColors2"));
        this.setBladeColor(3, nbttagcompound.e("iBladeColors3"));
        this.setBladeColor(4, nbttagcompound.e("iBladeColors4"));
        this.setBladeColor(5, nbttagcompound.e("iBladeColors5"));
        this.setBladeColor(6, nbttagcompound.e("iBladeColors6"));
        this.setBladeColor(7, nbttagcompound.e("iBladeColors7"));
        this.initBoundingBox();
    }

    @Override
    public boolean a_(sq player) {
        wm itemstack = player.bK.h();
        if (itemstack != null && (itemstack.c == wk.aX.cp || itemstack.c == BTWItems.dung.cp)) {
            if (!this.q.I) {
                int iColor = 0;
                iColor = itemstack.c == wk.aX.cp ? alp.g_(itemstack.k()) : 12;
                this.setBladeColor(this.currentBladeColoringIndex, iColor);
                ++this.currentBladeColoringIndex;
                if (this.currentBladeColoringIndex >= 8) {
                    this.currentBladeColoringIndex = 0;
                }
            }
            --itemstack.a;
            if (itemstack.a == 0) {
                player.bK.a(player.bK.c, null);
            }
            return true;
        }
        return super.a_(player);
    }

    @Override
    public void w() {
        if (this.providingPower) {
            int iAxisAlignment;
            int iTempBlockID;
            int iTempJ;
            boolean[] m_bAxlesPresent = new boolean[7];
            for (int iTempIndex = 0; iTempIndex < 7; ++iTempIndex) {
                m_bAxlesPresent[iTempIndex] = false;
            }
            int iCenterI = kx.c(this.u);
            int iCenterJ = kx.c(this.v);
            int iCenterK = kx.c(this.w);
            AxleBlock blockAxle = (AxleBlock)BTWBlocks.axlePowerSource;
            for (iTempJ = iCenterJ - 2; iTempJ <= iCenterJ + 2; ++iTempJ) {
                iTempBlockID = this.q.a(iCenterI, iTempJ, iCenterK);
                if (iTempBlockID != BTWBlocks.axlePowerSource.cz || (iAxisAlignment = blockAxle.getAxisAlignment(this.q, iCenterI, iTempJ, iCenterK)) != 0) continue;
                int iAxleIndex = iTempJ - iCenterJ + 3;
                m_bAxlesPresent[iAxleIndex] = true;
                this.q.f(iCenterI, iTempJ, iCenterK, BTWBlocks.axle.cz, 0, 2);
            }
            for (iTempJ = iCenterJ - 3; iTempJ <= iCenterJ + 3; iTempJ += 6) {
                iTempBlockID = this.q.a(iCenterI, iTempJ, iCenterK);
                if (iTempBlockID != BTWBlocks.axlePowerSource.cz || (iAxisAlignment = blockAxle.getAxisAlignment(this.q, iCenterI, iTempJ, iCenterK)) != 0) continue;
                this.q.f(iCenterI, iTempJ, iCenterK, BTWBlocks.axle.cz, 0, 3);
            }
        }
        super.w();
    }

    @Override
    public void a(re par1EntityLightningBolt) {
        if (this.q.N().b("doFireTick")) {
            this.w();
        }
    }

    @Override
    public float getWidth() {
        return 8.8f;
    }

    @Override
    public float getHeight() {
        return 6.8f;
    }

    @Override
    public float getDepth() {
        return 8.8f;
    }

    @Override
    public int getMaxDamage() {
        return 160;
    }

    @Override
    public int getTicksPerFullUpdate() {
        return 20;
    }

    @Override
    protected void onFullUpdateServer() {
        super.onFullUpdateServer();
        if (this.overpowerTimer >= 0) {
            if (this.overpowerTimer > 0) {
                --this.overpowerTimer;
            }
            if (this.overpowerTimer <= 0) {
                int iCenterI = kx.c(this.u);
                int iCenterJ = kx.c(this.v);
                int iCenterK = kx.c(this.w);
                ((AxleBlock)BTWBlocks.axle).overpower(this.q, iCenterI, iCenterJ, iCenterK);
            }
        }
    }

    @Override
    public void destroyWithDrop() {
        if (!this.q.I && !this.M) {
            this.a(BTWItems.verticalWindMill.cp, 1, 0.0f);
            this.w();
        }
    }

    @Override
    public boolean validateAreaAroundDevice() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        return VerticalWindMillEntity.windMillValidateAreaAroundBlock(this.q, iCenterI, iCenterJ, iCenterK);
    }

    @Override
    public float computeRotation() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        float fRotationAmount = 0.0f;
        if (this.q.t.h == -1) {
            fRotationAmount = -0.07f;
            this.overpowerTimer = -1;
        } else if (this.q.t.h != 1 && this.canSeeSky()) {
            if (this.q.O() && this.isBeingPrecipitatedOn()) {
                fRotationAmount = -2.0f;
                if (this.overpowerTimer < 0) {
                    this.overpowerTimer = 30;
                }
            } else {
                fRotationAmount = -0.12f;
                this.overpowerTimer = -1;
            }
        } else {
            this.overpowerTimer = -1;
        }
        return fRotationAmount;
    }

    @Override
    protected boolean validateConnectedAxles() {
        int iTempBlockID;
        int iTempJ;
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        for (iTempJ = iCenterJ - 3; iTempJ <= iCenterJ + 3; ++iTempJ) {
            iTempBlockID = this.q.a(iCenterI, iTempJ, iCenterK);
            if (MechPowerUtils.isBlockIDAxle(iTempBlockID)) {
                int iAxisAlignment = ((AxleBlock)apa.r[iTempBlockID]).getAxisAlignment(this.q, iCenterI, iTempJ, iCenterK);
                if (iAxisAlignment == 0) continue;
                return false;
            }
            return false;
        }
        if (!this.providingPower) {
            for (iTempJ = iCenterJ - 3; iTempJ <= iCenterJ + 3; ++iTempJ) {
                iTempBlockID = this.q.a(iCenterI, iTempJ, iCenterK);
                if (((AxleBlock)apa.r[iTempBlockID]).getPowerLevel(this.q, iCenterI, iTempJ, iCenterK) <= 0) continue;
                return false;
            }
        } else {
            for (iTempJ = iCenterJ - 3; iTempJ <= iCenterJ + 3; ++iTempJ) {
                iTempBlockID = this.q.a(iCenterI, iTempJ, iCenterK);
                if (iTempBlockID == BTWBlocks.axlePowerSource.cz) continue;
                this.powerAxleColumn();
                break;
            }
        }
        return true;
    }

    @Override
    public void transferPowerStateToConnectedAxles() {
        if (this.providingPower) {
            this.powerAxleColumn();
        } else {
            this.depowerAxleColumn();
        }
    }

    @Override
    protected void onClientRotationOctantChange() {
        int iCenterK;
        int iCenterJ;
        int iCenterI;
        int iCenterBlockID;
        float fSpeed = this.getRotationSpeed();
        if (fSpeed < -0.12f && (iCenterBlockID = this.q.a(iCenterI = kx.c(this.u), iCenterJ = kx.c(this.v), iCenterK = kx.c(this.w))) == BTWBlocks.axlePowerSource.cz) {
            int iAxleAlignment = ((AxleBlock)BTWBlocks.axlePowerSource).getAxisAlignment(this.q, iCenterI, iCenterJ, iCenterK);
            this.clientNotifyGearboxOfOverpoweredOctantChangeInDirection(iCenterI, iCenterJ, iCenterK, iAxleAlignment << 1);
            this.clientNotifyGearboxOfOverpoweredOctantChangeInDirection(iCenterI, iCenterJ, iCenterK, (iAxleAlignment << 1) + 1);
        }
    }

    @Override
    public ei getSpawnPacketForThisEntity() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeInt(9);
            dataStream.writeInt(this.k);
            dataStream.writeInt(kx.c(this.u * 32.0));
            dataStream.writeInt(kx.c(this.v * 32.0));
            dataStream.writeInt(kx.c(this.w * 32.0));
            dataStream.writeInt(this.getRotationSpeedScaled());
            dataStream.writeByte((byte)this.getBladeColor(0));
            dataStream.writeByte((byte)this.getBladeColor(1));
            dataStream.writeByte((byte)this.getBladeColor(2));
            dataStream.writeByte((byte)this.getBladeColor(3));
            dataStream.writeByte((byte)this.getBladeColor(4));
            dataStream.writeByte((byte)this.getBladeColor(5));
            dataStream.writeByte((byte)this.getBladeColor(6));
            dataStream.writeByte((byte)this.getBladeColor(7));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new dk("BTW|SE", byteStream.toByteArray());
    }

    private void powerAxleColumn() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        for (int iTempJ = iCenterJ - 2; iTempJ <= iCenterJ + 2; ++iTempJ) {
            this.q.f(iCenterI, iTempJ, iCenterK, BTWBlocks.axlePowerSource.cz, 0, 2);
        }
        this.q.f(iCenterI, iCenterJ + 3, iCenterK, BTWBlocks.axlePowerSource.cz, 0, 3);
        this.q.f(iCenterI, iCenterJ + -3, iCenterK, BTWBlocks.axlePowerSource.cz, 0, 3);
    }

    private void depowerAxleColumn() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        for (int iTempJ = iCenterJ - 2; iTempJ <= iCenterJ + 2; ++iTempJ) {
            this.q.f(iCenterI, iTempJ, iCenterK, BTWBlocks.axle.cz, 0, 2);
        }
        this.q.f(iCenterI, iCenterJ + 3, iCenterK, BTWBlocks.axle.cz, 0, 3);
        this.q.f(iCenterI, iCenterJ + -3, iCenterK, BTWBlocks.axle.cz, 0, 3);
    }

    protected void clientNotifyGearboxOfOverpoweredOctantChangeInDirection(int iCenterI, int iCenterJ, int iCenterK, int iFacing) {
        BlockPos tempPos = new BlockPos(iCenterI, iCenterJ, iCenterK);
        for (int iTempCount = 0; iTempCount < 10; ++iTempCount) {
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = this.q.a(tempPos.x, tempPos.y, tempPos.z);
            if (iTempBlockID == BTWBlocks.axle.cz || iTempBlockID == BTWBlocks.axlePowerSource.cz) {
                if (!((AxleBlock)apa.r[iTempBlockID]).isAxleOrientedTowardsFacing(this.q, tempPos.x, tempPos.y, tempPos.z, iFacing)) break;
                continue;
            }
            if (!MechPowerUtils.isPoweredGearBox(this.q, tempPos.x, tempPos.y, tempPos.z)) break;
            this.q.playSound((double)tempPos.x + 0.5, (double)tempPos.y + 0.5, (double)tempPos.z + 0.5, "random.chestclosed", 1.5f, this.q.s.nextFloat() * 0.1f + 0.5f);
            break;
        }
    }

    public static boolean windMillValidateAreaAroundBlock(aab world, int i2, int j2, int k) {
        for (int iTempI = i2 - 4; iTempI <= i2 + 4; ++iTempI) {
            for (int iTempJ = j2 - 3; iTempJ <= j2 + 3; ++iTempJ) {
                for (int iTempK = k - 4; iTempK <= k + 4; ++iTempK) {
                    if (iTempI == i2 && iTempK == k || VerticalWindMillEntity.isValidBlockForWindMillToOccupy(world, iTempI, iTempJ, iTempK)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isValidBlockForWindMillToOccupy(aab world, int i2, int j2, int k) {
        return world.c(i2, j2, k);
    }

    @Override
    public void initBoundingBox() {
        this.E.b(this.u - (double)(this.getWidth() * 0.5f), this.v - (double)(this.getHeight() * 0.5f), this.w - (double)(this.getWidth() * 0.5f), this.u + (double)(this.getWidth() * 0.5f), this.v + (double)(this.getHeight() * 0.5f), this.w + (double)(this.getWidth() * 0.5f));
    }

    private boolean canSeeSky() {
        int iCenterI = kx.c(this.u);
        int iCenterJ = kx.c(this.v);
        int iCenterK = kx.c(this.w);
        for (int iTempI = iCenterI - 4; iTempI <= iCenterI + 4; ++iTempI) {
            for (int iTempK = iCenterK - 4; iTempK <= iCenterK + 4; ++iTempK) {
                if (!this.q.l(iTempI, iCenterJ, iTempK)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBeingPrecipitatedOn() {
        if (this.q.P()) {
            int iCenterI = kx.c(this.u);
            int iCenterJ = kx.c(this.v);
            int iCenterK = kx.c(this.w);
            for (int iTempI = iCenterI - 4; iTempI <= iCenterI + 4; ++iTempI) {
                for (int iTempK = iCenterK - 4; iTempK <= iCenterK + 4; ++iTempK) {
                    if (!this.q.isPrecipitatingAtPos(iTempI, iTempK)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public aqx getDeviceBounds() {
        return aqx.a().a(this.u - (double)(this.getWidth() * 0.5f), this.v - (double)(this.getHeight() * 0.5f), this.w - (double)(this.getWidth() * 0.5f), this.u + (double)(this.getWidth() * 0.5f), this.v + (double)(this.getHeight() * 0.5f), this.w + (double)(this.getWidth() * 0.5f));
    }
}

