/*
 * Decompiled with CFR 0.152.
 */
package btw.entity.mechanical.platform;

import btw.block.BTWBlocks;
import btw.block.blocks.AnchorBlock;
import btw.block.blocks.RopeBlock;
import btw.block.tileentity.PulleyTileEntity;
import btw.entity.EntityWithCustomPacket;
import btw.entity.IgnoreServerValidationEntity;
import btw.entity.mechanical.source.MechanicalPowerSourceEntity;
import btw.item.BTWItems;
import btw.item.util.ItemUtils;
import btw.world.util.BlockPos;
import btw.world.util.WorldUtils;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class MovingAnchorEntity
extends mp
implements EntityWithCustomPacket,
IgnoreServerValidationEntity {
    public static final float MOVEMENT_SPEED = 0.05f;
    private static final int Y_MOTION_DATA_WATCHER_ID = 22;
    private static final int VEHICLE_SPAWN_PACKET_TYPE = 102;
    private BlockPos associatedPulleyPos = new BlockPos();
    private int associatedPulleyRopeStateCounter;
    private int oldBottomY;

    public MovingAnchorEntity(aab world) {
        super(world);
        this.m = true;
        this.a(0.98f, 1.98f);
        this.N = 0.5f;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.associatedPulleyRopeStateCounter = -1;
        this.oldBottomY = 0;
    }

    public MovingAnchorEntity(aab world, double x2, double y2, double z2) {
        this(world);
        this.b(x2, y2, z2);
        this.U = this.r = x2;
        this.V = this.s = y2;
        this.W = this.t = z2;
        this.oldBottomY = kx.c(this.v - (double)this.N);
    }

    public MovingAnchorEntity(aab world, double x2, double y2, double z2, BlockPos pulleyPos, int iMovementDirection) {
        this(world);
        PulleyTileEntity tileEntityPulley;
        this.associatedPulleyPos.x = pulleyPos.x;
        this.associatedPulleyPos.y = pulleyPos.y;
        this.associatedPulleyPos.z = pulleyPos.z;
        this.y = iMovementDirection > 0 ? (double)0.05f : (double)-0.05f;
        this.b(x2, y2, z2);
        this.U = this.r = x2;
        this.V = this.s = y2;
        this.W = this.t = z2;
        int associatedPulleyBlockID = this.q.a(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
        if (associatedPulleyBlockID == BTWBlocks.pulley.cz && (tileEntityPulley = (PulleyTileEntity)this.q.r(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z)) != null) {
            this.associatedPulleyRopeStateCounter = tileEntityPulley.updateRopeStateCounter;
        }
        this.oldBottomY = kx.c(this.v - (double)this.N);
    }

    @Override
    protected void a() {
        this.ah.a(22, new Integer(0));
    }

    @Override
    protected void b(bs nbttagcompound) {
        nbttagcompound.a("associatedPulleyPosI", this.associatedPulleyPos.x);
        nbttagcompound.a("associatedPulleyPosJ", this.associatedPulleyPos.y);
        nbttagcompound.a("associatedPulleyPosK", this.associatedPulleyPos.z);
        nbttagcompound.a("m_iAssociatedPulleyRopeStateCounter", this.associatedPulleyRopeStateCounter);
        nbttagcompound.a("m_iOldBottomJ", this.oldBottomY);
    }

    @Override
    protected void a(bs nbttagcompound) {
        this.associatedPulleyPos.x = nbttagcompound.e("associatedPulleyPosI");
        this.associatedPulleyPos.y = nbttagcompound.e("associatedPulleyPosJ");
        this.associatedPulleyPos.z = nbttagcompound.e("associatedPulleyPosK");
        if (nbttagcompound.b("m_iAssociatedPulleyRopeStateCounter")) {
            this.associatedPulleyRopeStateCounter = nbttagcompound.e("m_iAssociatedPulleyRopeStateCounter");
        }
        this.oldBottomY = nbttagcompound.b("m_iOldBottomJ") ? nbttagcompound.e("m_iOldBottomJ") : kx.c(this.v - (double)this.N);
    }

    @Override
    protected boolean f_() {
        return false;
    }

    @Override
    public aqx g(mp entity) {
        return entity.E;
    }

    @Override
    public aqx D() {
        return aqx.a(this.E.a, this.E.b, this.E.c, this.E.d, this.E.b + AnchorBlock.anchorBaseHeight, this.E.f);
    }

    @Override
    public boolean L() {
        return false;
    }

    @Override
    public boolean K() {
        return !this.M;
    }

    @Override
    public void l_() {
        int k;
        int checkChunksRange;
        int i2;
        if (this.M) {
            return;
        }
        if (this.q.I) {
            this.y = this.getCorseYMotion();
        }
        if (!this.q.e((i2 = kx.c(this.u)) - (checkChunksRange = 35), 0, (k = kx.c(this.w)) - checkChunksRange, i2 + checkChunksRange, 0, k + checkChunksRange)) {
            return;
        }
        PulleyTileEntity tileEntityPulley = null;
        int iBlockAboveID = this.q.a(i2, this.oldBottomY + 1, k);
        boolean bForceValidation = false;
        if (!this.q.I) {
            int associatedPulleyBlockID = this.q.a(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
            int i2BlockAboveID = this.q.a(i2, this.oldBottomY + 2, k);
            boolean bPauseMotion = false;
            if (associatedPulleyBlockID == BTWBlocks.pulley.cz) {
                if (iBlockAboveID == BTWBlocks.pulley.cz || iBlockAboveID == BTWBlocks.ropeBlock.cz || i2BlockAboveID == BTWBlocks.pulley.cz || i2BlockAboveID == BTWBlocks.ropeBlock.cz) {
                    tileEntityPulley = (PulleyTileEntity)this.q.r(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
                    if (this.associatedPulleyRopeStateCounter != tileEntityPulley.updateRopeStateCounter) {
                        if (this.y > 0.0) {
                            if (tileEntityPulley.isLowering()) {
                                this.y = -this.y;
                                bForceValidation = true;
                            }
                        } else if (tileEntityPulley.isRaising()) {
                            this.y = -this.y;
                            bForceValidation = true;
                        }
                        this.associatedPulleyRopeStateCounter = tileEntityPulley.updateRopeStateCounter;
                    } else {
                        return;
                    }
                }
                this.setCorseYMotion(this.y);
            }
            if (this.y <= 0.01 && this.y >= -0.01) {
                this.convertToBlock(i2, this.oldBottomY, k);
                return;
            }
        }
        this.moveEntityInternal(this.x, this.y, this.z);
        double newPosY = this.v;
        int newBottomJ = kx.c(newPosY - (double)this.N);
        List list = this.q.b((mp)this, this.D().b(0.0, 0.15, 0.0));
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                mp entity = (mp)list.get(j1);
                if (entity.L() || entity instanceof rh || entity instanceof nc) {
                    this.pushEntity(entity);
                    continue;
                }
                if (entity.M || !(entity instanceof MechanicalPowerSourceEntity)) continue;
                MechanicalPowerSourceEntity entityDevice = (MechanicalPowerSourceEntity)entity;
                entityDevice.destroyWithDrop();
            }
        }
        if (!this.q.I && (this.oldBottomY != newBottomJ || bForceValidation)) {
            if (this.y > 0.0) {
                int iTargetBlockID;
                if (this.q.a(i2, newBottomJ, k) == BTWBlocks.ropeBlock.cz) {
                    tileEntityPulley.attemptToRetractRope();
                }
                if ((iTargetBlockID = this.q.a(i2, newBottomJ + 1, k)) != BTWBlocks.ropeBlock.cz || tileEntityPulley == null || !tileEntityPulley.isRaising() || newBottomJ + 1 >= this.associatedPulleyPos.y) {
                    this.convertToBlock(i2, newBottomJ, k);
                    return;
                }
            } else {
                boolean bEnoughRope = false;
                if (tileEntityPulley != null) {
                    int iRopeRequiredToDescend = 2;
                    if (iBlockAboveID == BTWBlocks.pulley.cz || iBlockAboveID == BTWBlocks.ropeBlock.cz) {
                        iRopeRequiredToDescend = 1;
                        int iOldBlockID = this.q.a(i2, this.oldBottomY, k);
                        if (iOldBlockID == BTWBlocks.pulley.cz || iOldBlockID == BTWBlocks.ropeBlock.cz) {
                            iRopeRequiredToDescend = 0;
                        }
                    }
                    bEnoughRope = tileEntityPulley.getContainedRopeCount() >= iRopeRequiredToDescend;
                }
                int iTargetBlockID = this.q.a(i2, newBottomJ, k);
                boolean bStop = false;
                if (tileEntityPulley == null || !tileEntityPulley.isLowering() || !bEnoughRope) {
                    bStop = true;
                } else if (!WorldUtils.isReplaceableBlock(this.q, i2, newBottomJ, k)) {
                    if (!apa.r[iTargetBlockID].cO.a() || iTargetBlockID == apa.aa.cz || iTargetBlockID == BTWBlocks.web.cz) {
                        int iTargetMetadata = this.q.h(i2, newBottomJ, k);
                        if (iTargetBlockID == BTWBlocks.ropeBlock.cz) {
                            if (!this.returnRopeToPulley()) {
                                apa.r[iTargetBlockID].c(this.q, i2, newBottomJ, k, iTargetMetadata, 0);
                            }
                        } else {
                            this.q.e(2252, i2, newBottomJ, k, iTargetBlockID + (iTargetMetadata << 12));
                            apa.r[iTargetBlockID].c(this.q, i2, newBottomJ, k, iTargetMetadata, 0);
                        }
                        this.q.setBlockWithNotify(i2, newBottomJ, k, 0);
                    } else {
                        bStop = true;
                    }
                }
                if (bStop) {
                    this.convertToBlock(i2, this.oldBottomY, k);
                    return;
                }
                if (tileEntityPulley != null && this.q.a(i2, newBottomJ + 1, k) != BTWBlocks.ropeBlock.cz && this.q.a(i2, newBottomJ + 1, k) != BTWBlocks.pulley.cz) {
                    tileEntityPulley.attemptToDispenseRope();
                }
            }
            this.oldBottomY = newBottomJ;
        }
    }

    @Override
    public void d(double deltaX, double deltaY, double deltaZ) {
        this.notifyAssociatedPulleyOfLossOfAnchorEntity();
        this.destroyAnchorWithDrop();
    }

    @Override
    protected boolean shouldSetPositionOnLoad() {
        return false;
    }

    @Override
    public ei getSpawnPacketForThisEntity() {
        return new cn((mp)this, MovingAnchorEntity.getVehicleSpawnPacketType(), 0);
    }

    @Override
    public int getTrackerViewDistance() {
        return 160;
    }

    @Override
    public int getTrackerUpdateFrequency() {
        return 3;
    }

    @Override
    public boolean getTrackMotion() {
        return false;
    }

    @Override
    public boolean shouldServerTreatAsOversized() {
        return false;
    }

    private double getCorseYMotion() {
        return (double)this.ah.c(22) / 100.0;
    }

    private void setCorseYMotion(double yMotion) {
        this.ah.b(22, (int)(yMotion * 100.0));
    }

    public static int getVehicleSpawnPacketType() {
        return 102;
    }

    public void destroyAnchorWithDrop() {
        int i2 = kx.c(this.u);
        int j2 = kx.c(this.v);
        int k = kx.c(this.w);
        wm anchorStack = new wm(BTWBlocks.anchor);
        ItemUtils.ejectStackWithRandomOffset(this.q, i2, j2, k, anchorStack);
        this.w();
    }

    private void moveEntityInternal(double deltaX, double deltaY, double deltaZ) {
        double newPosX = this.u + deltaX;
        double newPosY = this.v + deltaY;
        double newPosZ = this.w + deltaZ;
        this.r = this.u;
        this.s = this.v;
        this.t = this.w;
        this.b(newPosX, newPosY, newPosZ);
        this.testForBlockCollisions();
    }

    private void testForBlockCollisions() {
        int i4;
        int l3;
        int k3;
        int i2;
        int k1;
        int i1 = kx.c(this.D().a + 0.001);
        if (this.q.e(i1, k1 = kx.c(this.D().b + 0.001), i2 = kx.c(this.D().c + 0.001), k3 = kx.c(this.D().d - 0.001), l3 = kx.c(this.D().e - 0.001), i4 = kx.c(this.D().f - 0.001))) {
            for (int j4 = i1; j4 <= k3; ++j4) {
                for (int k4 = k1; k4 <= l3; ++k4) {
                    for (int l4 = i2; l4 <= i4; ++l4) {
                        int i5 = this.q.a(j4, k4, l4);
                        if (i5 <= 0) continue;
                        apa.r[i5].a(this.q, j4, k4, l4, this);
                    }
                }
            }
        }
    }

    private void pushEntity(mp entity) {
        aqx collisionBox = this.D();
        double entityMinY = entity.E.b;
        double testZoneMaxY = collisionBox.e + 0.075;
        if (entityMinY < testZoneMaxY) {
            double entityMaxY;
            if (entityMinY > collisionBox.e - 0.25) {
                if (entity instanceof sq) {
                    if (this.q.I) {
                        this.clientPushPlayer(entity);
                    }
                } else {
                    double entityYOffset = collisionBox.e + 0.01 - entityMinY;
                    entity.b(entity.u, entity.v + entityYOffset, entity.w);
                    if (entity.n != null) {
                        entity.n.b(entity.n.u, entity.n.v + entityYOffset, entity.n.w);
                    }
                }
            } else if (entity instanceof ng && this.y < 0.0 && collisionBox.b < (entityMaxY = entity.E.e) - 0.25 && testZoneMaxY > entityMaxY) {
                entity.a(mg.d, 1);
            }
        }
    }

    public void forceStopByPlatform() {
        int k;
        int jAbove;
        int i2;
        int iBlockAboveID;
        if (this.M) {
            return;
        }
        if (this.y > 0.0 && (iBlockAboveID = this.q.a(i2 = kx.c(this.u), jAbove = kx.c(this.v) + 1, k = kx.c(this.w))) == BTWBlocks.ropeBlock.cz) {
            ((RopeBlock)BTWBlocks.ropeBlock).breakRope(this.q, i2, jAbove, k);
        }
        i2 = kx.c(this.u);
        int j2 = kx.c(this.v);
        k = kx.c(this.w);
        this.convertToBlock(i2, j2, k);
    }

    private void convertToBlock(int i2, int j2, int k) {
        boolean bCanPlace = true;
        int iTargetBlockID = this.q.a(i2, j2, k);
        if (!WorldUtils.isReplaceableBlock(this.q, i2, j2, k)) {
            if (iTargetBlockID == BTWBlocks.ropeBlock.cz) {
                if (!this.returnRopeToPulley()) {
                    ItemUtils.ejectSingleItemWithRandomOffset(this.q, i2, j2, k, BTWItems.rope.cp, 0);
                }
            } else if (!apa.r[iTargetBlockID].cO.a() || iTargetBlockID == apa.aa.cz || iTargetBlockID == BTWBlocks.web.cz) {
                int iTargetMetadata = this.q.h(i2, j2, k);
                apa.r[iTargetBlockID].c(this.q, i2, j2, k, iTargetMetadata, 0);
                this.q.e(2252, i2, j2, k, iTargetBlockID + (iTargetMetadata << 12));
            } else {
                bCanPlace = false;
            }
        }
        if (bCanPlace) {
            this.q.setBlockWithNotify(i2, j2, k, BTWBlocks.anchor.cz);
            ((AnchorBlock)BTWBlocks.anchor).setFacing(this.q, i2, j2, k, 1);
        } else {
            ItemUtils.ejectSingleItemWithRandomOffset(this.q, i2, j2, k, BTWBlocks.anchor.cz, 0);
        }
        this.notifyAssociatedPulleyOfLossOfAnchorEntity();
        this.w();
    }

    public boolean returnRopeToPulley() {
        PulleyTileEntity tileEntityPulley;
        int associatedPulleyBlockID = this.q.a(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
        if (associatedPulleyBlockID == BTWBlocks.pulley.cz && (tileEntityPulley = (PulleyTileEntity)this.q.r(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z)) != null) {
            tileEntityPulley.addRopeToInventory();
            return true;
        }
        return false;
    }

    private void notifyAssociatedPulleyOfLossOfAnchorEntity() {
        int associatedPulleyBlockID = this.q.a(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
        if (associatedPulleyBlockID == BTWBlocks.pulley.cz) {
            PulleyTileEntity tileEntityPulley = (PulleyTileEntity)this.q.r(this.associatedPulleyPos.x, this.associatedPulleyPos.y, this.associatedPulleyPos.z);
            tileEntityPulley.notifyOfLossOfAnchorEntity();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float Q() {
        return 0.0f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.b(par1, par3, par5);
    }

    @Environment(value=EnvType.CLIENT)
    private void clientPushPlayer(mp entity) {
        double entityMinY = entity.E.b;
        aqx collisionBox = this.D();
        double entityYOffset = collisionBox.e + 0.01 - entityMinY;
        entity.b(entity.u, entity.v + entityYOffset, entity.w);
        entity.cx = (int)(entity.u * 32.0);
        entity.cy = (int)(entity.v * 32.0);
        entity.cz = (int)(entity.w * 32.0);
        if (entity.n != null) {
            entity.n.b(entity.n.u, entity.n.v + entityYOffset, entity.n.w);
        }
        entity.F = true;
    }
}

