/*
 * Decompiled with CFR 0.152.
 */
package btw.entity;

import btw.block.BTWBlocks;
import btw.entity.EntityWithCustomPacket;
import btw.entity.mob.SnowmanEntity;
import btw.entity.mob.WitherEntityPersistent;
import btw.item.BTWItems;
import btw.world.util.BlockPos;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UrnEntity
extends tb
implements EntityWithCustomPacket {
    public static final double CUBIC_RANGE = 4.0;
    public int itemShiftedIndex;

    public UrnEntity(aab world) {
        super(world);
        this.itemShiftedIndex = 0;
    }

    public UrnEntity(aab world, int iItemShiftedIndex) {
        this(world);
        this.itemShiftedIndex = iItemShiftedIndex;
    }

    public UrnEntity(aab world, ng throwingEntity, int iItemShiftedIndex) {
        super(world, throwingEntity);
        this.itemShiftedIndex = iItemShiftedIndex;
    }

    public UrnEntity(aab world, double d2, double d1, double d22, int iItemShiftedIndex) {
        super(world, d2, d1, d22);
        this.itemShiftedIndex = iItemShiftedIndex;
    }

    @Override
    public void b(bs nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("m_iItemShiftedIndex", this.itemShiftedIndex);
    }

    @Override
    public void a(bs nbttagcompound) {
        super.a(nbttagcompound);
        this.itemShiftedIndex = nbttagcompound.e("m_iItemShiftedIndex");
    }

    @Override
    protected void a(ara impactPosition) {
        this.w();
        if (this.q.I) {
            return;
        }
        if (this.itemShiftedIndex == BTWItems.soulUrn.cp) {
            boolean looseSoul = true;
            if (impactPosition.g != null) {
                impactPosition.g.a(mg.a(this, (mp)this.h()), 0);
                if (impactPosition.g instanceof nr) {
                    looseSoul = !((nr)impactPosition.g).canSoulAffectEntity(this);
                }
            } else if (UrnEntity.attemptToCreateGolemOrWither(this.q, impactPosition.b, impactPosition.c, impactPosition.d)) {
                looseSoul = false;
            } else {
                apa impactBlock = apa.r[this.q.a(impactPosition.b, impactPosition.c, impactPosition.d)];
                if (impactBlock != null && impactBlock.attemptToAffectBlockWithSoul(this.q, impactPosition.b, impactPosition.c, impactPosition.d)) {
                    looseSoul = false;
                }
            }
            if (looseSoul) {
                this.looseSoulEffects(this.q, impactPosition.f.c, impactPosition.f.d, impactPosition.f.e);
            }
            this.q.e(2248, (int)Math.round(this.u), (int)Math.round(this.v), (int)Math.round(this.w), 0);
        }
    }

    public void looseSoulEffects(aab worldObj, double xCoord, double yCoord, double zCoord) {
        aqx possessionBox = aqx.a().a(xCoord - 4.0, yCoord - 4.0, zCoord - 4.0, xCoord + 4.0, yCoord + 4.0, zCoord + 4.0);
        List nearbyCreatures = worldObj.a(nr.class, possessionBox);
        for (Object nearbyCreature : nearbyCreatures) {
            nr tempCreature = (nr)nearbyCreature;
            if (!tempCreature.canSoulAffectEntity(this)) continue;
            tempCreature.a(mg.a(this, (mp)this.h()), 0);
            return;
        }
        int range = 2;
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        int i2 = (int)xCoord - range;
        while ((double)i2 <= xCoord + (double)range) {
            int n = (int)yCoord - range;
            while ((double)n <= yCoord + (double)range) {
                int k = (int)zCoord - range;
                while ((double)k <= zCoord + (double)range) {
                    blockPositions.add(new BlockPos(i2, n, k));
                    ++k;
                }
                ++n;
            }
            ++i2;
        }
        Collections.shuffle(blockPositions, this.ab);
        for (Object e2 : blockPositions) {
            BlockPos tempPos = (BlockPos)e2;
            if (UrnEntity.attemptToCreateGolemOrWither(worldObj, tempPos.x, tempPos.y, tempPos.z)) {
                return;
            }
            apa tempBlock = apa.r[worldObj.a(tempPos.x, tempPos.y, tempPos.z)];
            if (tempBlock == null || !tempBlock.attemptToAffectBlockWithSoul(worldObj, tempPos.x, tempPos.y, tempPos.z)) continue;
            return;
        }
    }

    @Override
    public int getTrackerViewDistance() {
        return 64;
    }

    @Override
    public int getTrackerUpdateFrequency() {
        return 10;
    }

    @Override
    public boolean getTrackMotion() {
        return true;
    }

    @Override
    public boolean shouldServerTreatAsOversized() {
        return false;
    }

    @Override
    public ei getSpawnPacketForThisEntity() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeInt(7);
            dataStream.writeInt(this.k);
            dataStream.writeInt(kx.c(this.u * 32.0));
            dataStream.writeInt(kx.c(this.v * 32.0));
            dataStream.writeInt(kx.c(this.w * 32.0));
            dataStream.writeInt(this.itemShiftedIndex);
            dataStream.writeByte((byte)(this.x * 128.0));
            dataStream.writeByte((byte)(this.y * 128.0));
            dataStream.writeByte((byte)(this.z * 128.0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new dk("BTW|SE", byteStream.toByteArray());
    }

    public static boolean attemptToCreateGolemOrWither(aab world, int x2, int y2, int z2) {
        int j2;
        for (j2 = y2; j2 <= y2 + 2; ++j2) {
            if (UrnEntity.isGolemHeadBlock(world, x2, j2, z2)) {
                return UrnEntity.attemptToCreateSnowOrIronGolem(world, x2, j2, z2);
            }
            if (UrnEntity.isWitherHeadBlock(world, x2, j2, z2)) {
                return UrnEntity.attemptToCreateWither(world, x2, j2, z2);
            }
            if (!UrnEntity.isValidBodyBlockForSnowGolem(world, x2, j2, z2) && !UrnEntity.isValidBodyBlockForIronGolem(world, x2, j2, z2) && !UrnEntity.isWitherBodyBlock(world, x2, j2, z2)) break;
        }
        if (UrnEntity.isValidBodyBlockForIronGolem(world, x2, y2, z2)) {
            j2 = y2 + 1;
            for (int i2 = x2 - 1; i2 <= x2 + 1; ++i2) {
                for (int k = z2 - 1; k <= z2 + 1; ++k) {
                    if (!UrnEntity.isGolemHeadBlock(world, i2, j2, k)) continue;
                    return UrnEntity.attemptToCreateSnowOrIronGolem(world, i2, j2, k);
                }
            }
        }
        return false;
    }

    private static boolean isGolemHeadBlock(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == apa.be.cz || iBlockID == apa.bj.cz;
    }

    private static boolean isWitherHeadBlock(aab world, int i2, int j2, int k) {
        aqp tileEntity;
        int iBlockID = world.a(i2, j2, k);
        if (iBlockID == apa.ck.cz && (tileEntity = world.r(i2, j2, k)) != null && tileEntity instanceof aqn) {
            return ((aqn)tileEntity).a() == 5;
        }
        return false;
    }

    private static boolean isValidBodyBlockForSnowGolem(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == apa.aY.cz || iBlockID == BTWBlocks.looseSnow.cz || iBlockID == BTWBlocks.solidSnow.cz;
    }

    private static boolean isValidBodyBlockForIronGolem(aab world, int i2, int j2, int k) {
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == apa.am.cz;
    }

    private static boolean isWitherBodyBlock(aab world, int i2, int j2, int k) {
        int iSubtype;
        int iBlockID = world.a(i2, j2, k);
        return iBlockID == BTWBlocks.aestheticOpaque.cz && (iSubtype = world.h(i2, j2, k)) == 15;
    }

    private static boolean attemptToCreateSnowOrIronGolem(aab world, int i2, int j2, int k) {
        if (UrnEntity.isValidBodyBlockForSnowGolem(world, i2, j2 - 1, k) && UrnEntity.isValidBodyBlockForSnowGolem(world, i2, j2 - 2, k)) {
            world.c(i2, j2, k, 0);
            world.c(i2, j2 - 1, k, 0);
            world.c(i2, j2 - 2, k, 0);
            world.d(i2, j2, k, 0);
            world.d(i2, j2 - 1, k, 0);
            world.d(i2, j2 - 2, k, 0);
            SnowmanEntity snowGolem = (SnowmanEntity)((Object)mv.createEntityOfType(SnowmanEntity.class, world));
            snowGolem.b((double)i2 + 0.5, (double)j2 - 1.95, (double)k + 0.5, 0.0f, 0.0f);
            world.d((mp)((Object)snowGolem));
            world.e(2263, i2, j2, k, 0);
            return true;
        }
        if (UrnEntity.isValidBodyBlockForIronGolem(world, i2, j2 - 1, k) && UrnEntity.isValidBodyBlockForIronGolem(world, i2, j2 - 2, k)) {
            boolean bIronAlongKAxis;
            boolean bIronAlongIAxis = UrnEntity.isValidBodyBlockForIronGolem(world, i2 - 1, j2 - 1, k) && UrnEntity.isValidBodyBlockForIronGolem(world, i2 + 1, j2 - 1, k);
            boolean bl = bIronAlongKAxis = UrnEntity.isValidBodyBlockForIronGolem(world, i2, j2 - 1, k - 1) && UrnEntity.isValidBodyBlockForIronGolem(world, i2, j2 - 1, k + 1);
            if (bIronAlongIAxis || bIronAlongKAxis) {
                world.c(i2, j2, k, 0);
                world.c(i2, j2 - 1, k, 0);
                world.c(i2, j2 - 2, k, 0);
                if (bIronAlongIAxis) {
                    world.c(i2 - 1, j2 - 1, k, 0);
                    world.c(i2 + 1, j2 - 1, k, 0);
                } else {
                    world.c(i2, j2 - 1, k - 1, 0);
                    world.c(i2, j2 - 1, k + 1, 0);
                }
                world.d(i2, j2, k, 0);
                world.d(i2, j2 - 1, k, 0);
                world.d(i2, j2 - 2, k, 0);
                if (bIronAlongIAxis) {
                    world.d(i2 - 1, j2 - 1, k, 0);
                    world.d(i2 + 1, j2 - 1, k, 0);
                } else {
                    world.d(i2, j2 - 1, k - 1, 0);
                    world.d(i2, j2 - 1, k + 1, 0);
                }
                qs ironGolem = (qs)((Object)mv.createEntityOfType(qs.class, world));
                ironGolem.i(true);
                ironGolem.b((double)i2 + 0.5, (double)j2 - 1.95, (double)k + 0.5, 0.0f, 0.0f);
                world.d((mp)((Object)ironGolem));
                world.e(2264, i2, j2, k, 0);
            }
            return true;
        }
        return false;
    }

    private static boolean attemptToCreateWither(aab world, int i2, int j2, int k) {
        if (j2 >= 2 && world.t.h == 0) {
            for (int iTempKOffset = -2; iTempKOffset <= 0; ++iTempKOffset) {
                if (!UrnEntity.isWitherBodyBlock(world, i2, j2 - 1, k + iTempKOffset) || !UrnEntity.isWitherBodyBlock(world, i2, j2 - 1, k + iTempKOffset + 1) || !UrnEntity.isWitherBodyBlock(world, i2, j2 - 2, k + iTempKOffset + 1) || !UrnEntity.isWitherBodyBlock(world, i2, j2 - 1, k + iTempKOffset + 2) || !UrnEntity.isWitherHeadBlock(world, i2, j2, k + iTempKOffset) || !UrnEntity.isWitherHeadBlock(world, i2, j2, k + iTempKOffset + 1) || !UrnEntity.isWitherHeadBlock(world, i2, j2, k + iTempKOffset + 2)) continue;
                world.SetBlockMetadataWithNotify(i2, j2, k + iTempKOffset, 8, 2);
                world.SetBlockMetadataWithNotify(i2, j2, k + iTempKOffset + 1, 8, 2);
                world.SetBlockMetadataWithNotify(i2, j2, k + iTempKOffset + 2, 8, 2);
                world.f(i2, j2, k + iTempKOffset, 0, 0, 2);
                world.f(i2, j2, k + iTempKOffset + 1, 0, 0, 2);
                world.f(i2, j2, k + iTempKOffset + 2, 0, 0, 2);
                world.f(i2, j2 - 1, k + iTempKOffset, 0, 0, 2);
                world.f(i2, j2 - 1, k + iTempKOffset + 1, 0, 0, 2);
                world.f(i2, j2 - 1, k + iTempKOffset + 2, 0, 0, 2);
                world.f(i2, j2 - 2, k + iTempKOffset + 1, 0, 0, 2);
                WitherEntityPersistent.summonWitherAtLocation(world, i2, j2, k + iTempKOffset + 1);
                world.d(i2, j2, k + iTempKOffset, 0);
                world.d(i2, j2, k + iTempKOffset + 1, 0);
                world.d(i2, j2, k + iTempKOffset + 2, 0);
                world.d(i2, j2 - 1, k + iTempKOffset, 0);
                world.d(i2, j2 - 1, k + iTempKOffset + 1, 0);
                world.d(i2, j2 - 1, k + iTempKOffset + 2, 0);
                world.d(i2, j2 - 2, k + iTempKOffset + 1, 0);
                return true;
            }
            for (int iTempIOffset = -2; iTempIOffset <= 0; ++iTempIOffset) {
                if (!UrnEntity.isWitherBodyBlock(world, i2 + iTempIOffset, j2 - 1, k) || !UrnEntity.isWitherBodyBlock(world, i2 + iTempIOffset + 1, j2 - 1, k) || !UrnEntity.isWitherBodyBlock(world, i2 + iTempIOffset + 1, j2 - 2, k) || !UrnEntity.isWitherBodyBlock(world, i2 + iTempIOffset + 2, j2 - 1, k) || !UrnEntity.isWitherHeadBlock(world, i2 + iTempIOffset, j2, k) || !UrnEntity.isWitherHeadBlock(world, i2 + iTempIOffset + 1, j2, k) || !UrnEntity.isWitherHeadBlock(world, i2 + iTempIOffset + 2, j2, k)) continue;
                world.SetBlockMetadataWithNotify(i2 + iTempIOffset, j2, k, 8, 2);
                world.SetBlockMetadataWithNotify(i2 + iTempIOffset + 1, j2, k, 8, 2);
                world.SetBlockMetadataWithNotify(i2 + iTempIOffset + 2, j2, k, 8, 2);
                world.f(i2 + iTempIOffset, j2, k, 0, 0, 2);
                world.f(i2 + iTempIOffset + 1, j2, k, 0, 0, 2);
                world.f(i2 + iTempIOffset + 2, j2, k, 0, 0, 2);
                world.f(i2 + iTempIOffset, j2 - 1, k, 0, 0, 2);
                world.f(i2 + iTempIOffset + 1, j2 - 1, k, 0, 0, 2);
                world.f(i2 + iTempIOffset + 2, j2 - 1, k, 0, 0, 2);
                world.f(i2 + iTempIOffset + 1, j2 - 2, k, 0, 0, 2);
                WitherEntityPersistent.summonWitherAtLocation(world, i2 + iTempIOffset + 1, j2, k);
                world.d(i2 + iTempIOffset, j2, k, 0);
                world.d(i2 + iTempIOffset + 1, j2, k, 0);
                world.d(i2 + iTempIOffset + 2, j2, k, 0);
                world.d(i2 + iTempIOffset, j2 - 1, k, 0);
                world.d(i2 + iTempIOffset + 1, j2 - 1, k, 0);
                world.d(i2 + iTempIOffset + 2, j2 - 1, k, 0);
                world.d(i2 + iTempIOffset + 1, j2 - 2, k, 0);
                return true;
            }
        }
        return false;
    }
}

