/*
 * Decompiled with CFR 0.152.
 */
package btw.entity;

import btw.entity.MiningChargeEntity;
import btw.world.util.BlockPos;
import java.util.List;

public class MiningChargeExplosion {
    public static final float EXPLOSION_STRENGTH = 20.0f;
    private aab worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public int facing;

    public MiningChargeExplosion(aab world, double dXPos, double dYPos, double dZPos, int iFacing) {
        this.worldObj = world;
        this.explosionX = dXPos;
        this.explosionY = dYPos;
        this.explosionZ = dZPos;
        this.facing = iFacing;
    }

    public void doExplosion() {
        this.damageEntities();
        this.destroyBlocks();
        this.worldObj.e(2229, kx.c(this.explosionX), kx.c(this.explosionY), kx.c(this.explosionZ), 0);
    }

    private void destroyBlocks() {
        int iKSource;
        int iJSource;
        int iISource = kx.c(this.explosionX);
        int iSourceBlockID = this.worldObj.a(iISource, iJSource = kx.c(this.explosionY), iKSource = kx.c(this.explosionZ));
        if (iSourceBlockID > 0 && apa.r[iSourceBlockID].getExplosionResistance(null, this.worldObj, iISource, iJSource, iKSource) >= 20.0f) {
            return;
        }
        BlockPos targetPos = new BlockPos(iISource, iJSource, iKSource);
        targetPos.addFacingAsOffset(this.facing);
        int iTargetBlockID = this.worldObj.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID > 0 && apa.r[iTargetBlockID].getExplosionResistance(null, this.worldObj, targetPos.x, targetPos.y, targetPos.z) >= 20.0f) {
            targetPos = new BlockPos(iISource, iJSource, iKSource);
        }
        this.destroyCentralBlocks(targetPos.x, targetPos.y, targetPos.z);
        targetPos.addFacingAsOffset(this.facing);
        iTargetBlockID = this.worldObj.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID > 0 && apa.r[iTargetBlockID].getExplosionResistance(null, this.worldObj, targetPos.x, targetPos.y, targetPos.z) >= 20.0f) {
            return;
        }
        targetPos.addFacingAsOffset(this.facing);
        iTargetBlockID = this.worldObj.a(targetPos.x, targetPos.y, targetPos.z);
        if (iTargetBlockID > 0 && apa.r[iTargetBlockID].getExplosionResistance(null, this.worldObj, targetPos.x, targetPos.y, targetPos.z) < 20.0f) {
            this.destroyBlock(targetPos.x, targetPos.y, targetPos.z);
        }
    }

    private void destroyCentralBlocks(int iICenter, int iJCenter, int iKCenter) {
        for (int iTempI = iICenter - 1; iTempI <= iICenter + 1; ++iTempI) {
            for (int iTempJ = iJCenter - 1; iTempJ <= iJCenter + 1; ++iTempJ) {
                for (int iTempK = iKCenter - 1; iTempK <= iKCenter + 1; ++iTempK) {
                    int iTempBlockID = this.worldObj.a(iTempI, iTempJ, iTempK);
                    if (iTempBlockID <= 0 || !(apa.r[iTempBlockID].getExplosionResistance(null, this.worldObj, iTempI, iTempJ, iTempK) < 20.0f)) continue;
                    this.destroyBlock(iTempI, iTempJ, iTempK);
                }
            }
        }
    }

    private void damageEntities() {
        float explosionSize = 6.0f;
        int k = kx.c(this.explosionX - (double)explosionSize - 1.0);
        int i1 = kx.c(this.explosionX + (double)explosionSize + 1.0);
        int k1 = kx.c(this.explosionY - (double)explosionSize - 1.0);
        int l1 = kx.c(this.explosionY + (double)explosionSize + 1.0);
        int i2 = kx.c(this.explosionZ - (double)explosionSize - 1.0);
        int j2 = kx.c(this.explosionZ + (double)explosionSize + 1.0);
        List list = this.worldObj.b(null, aqx.a().a(k, k1, i2, i1, l1, j2));
        arc vec3d = arc.a(this.explosionX, this.explosionY, this.explosionZ);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            mp entity = (mp)list.get(k2);
            double d4 = entity.f(this.explosionX, this.explosionY, this.explosionZ) / (double)explosionSize;
            if (!(d4 <= 1.0)) continue;
            double d6 = entity.u - this.explosionX;
            double d8 = entity.v - this.explosionY;
            double d10 = entity.w - this.explosionZ;
            double d11 = kx.a(d6 * d6 + d8 * d8 + d10 * d10);
            d6 /= d11;
            d8 /= d11;
            d10 /= d11;
            double d12 = this.worldObj.a(vec3d, entity.E);
            double d13 = (1.0 - d4) * d12;
            if (entity instanceof rh) {
                rh entityItem = (rh)entity;
                int iItemID = entityItem.d().c;
                if (iItemID != wk.n.cp && iItemID != wk.aD.cp && iItemID != wk.aX.cp && iItemID != wk.aq.cp && iItemID != apa.K.cz && iItemID != apa.L.cz) {
                    int iItemDamage = (int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)explosionSize + 1.0);
                    if (iItemDamage > 2) {
                        iItemDamage = 3;
                    }
                    entity.a(mg.a(null), iItemDamage);
                }
            } else {
                entity.a(mg.a(null), (int)((d13 * d13 + d13) / 2.0 * 8.0 * (double)explosionSize + 1.0));
            }
            if (entity instanceof MiningChargeEntity) continue;
            double d14 = d13;
            entity.x += d6 * d14;
            entity.y += d8 * d14;
            entity.z += d10 * d14;
        }
    }

    private void destroyBlock(int x2, int y2, int z2) {
        int blockID = this.worldObj.a(x2, y2, z2);
        int meta = this.worldObj.h(x2, y2, z2);
        if (blockID > 0) {
            apa destroyedBlock = apa.r[blockID];
            destroyedBlock.dropItemsOnDestroyedByMiningCharge(this.worldObj, x2, y2, z2, meta);
            destroyedBlock.onBlockDestroyedByMiningCharge(this.worldObj, x2, y2, z2);
            this.worldObj.setBlockWithNotify(x2, y2, z2, 0);
            destroyedBlock.postBlockDestroyedByMiningCharge(this.worldObj, x2, y2, z2);
        }
    }
}

