/*
 * Decompiled with CFR 0.152.
 */
package btw.crafting.recipe.types;

import java.util.Arrays;

public class TurntableRecipe {
    private final apa output;
    private final int outputMetadata;
    private final wm[] itemsEjected;
    private final apa block;
    private final int[] metadatas;
    private final int rotationsToCraft;
    private TurntableEffect effect;
    private TurntableEffect completionEffect;

    public TurntableRecipe(apa output, int outputMetadata, wm[] itemsEjected, apa block, int[] metadatas, int rotationsToCraft) {
        this.output = output;
        this.outputMetadata = outputMetadata;
        this.itemsEjected = itemsEjected;
        this.block = block;
        this.metadatas = metadatas;
        this.rotationsToCraft = rotationsToCraft;
    }

    public boolean ignoreMetadata() {
        return this.metadatas.length == 1 && this.metadatas[0] == Short.MAX_VALUE;
    }

    public boolean matchesRecipe(TurntableRecipe recipe) {
        if (this.block == recipe.block && (Arrays.equals(this.metadatas, recipe.metadatas) || this.ignoreMetadata() && this.ignoreMetadata())) {
            return this.output.cz == recipe.output.cz;
        }
        return false;
    }

    public boolean matchesInputs(apa block, int metadata) {
        boolean containsGivenMetadata = false;
        for (int i2 : this.metadatas) {
            if (i2 != metadata) continue;
            containsGivenMetadata = true;
            break;
        }
        return this.block.cz == block.cz && (containsGivenMetadata || this.ignoreMetadata());
    }

    public boolean matchesInputs(apa block, int[] metadatas) {
        return this.block.cz == block.cz && (Arrays.equals(this.metadatas, metadatas) || this.ignoreMetadata());
    }

    public apa getInputblock() {
        return this.block;
    }

    public int[] getInputMetadata() {
        return this.metadatas;
    }

    public apa getOutputBlock() {
        return this.output;
    }

    public int getOutputMetadata() {
        return this.outputMetadata;
    }

    public wm[] getItemsEjected() {
        return this.itemsEjected;
    }

    public int getRotationsToCraft() {
        return this.rotationsToCraft;
    }

    public TurntableRecipe setEffect(TurntableEffect effect) {
        this.effect = effect;
        return this;
    }

    public TurntableRecipe setCompletionEffect(TurntableEffect effect) {
        this.completionEffect = effect;
        return this;
    }

    public void playEffect(aab world, int x2, int y2, int z2) {
        if (this.effect != null) {
            this.effect.playEffect(world, x2, y2, z2);
        }
    }

    public void playCompletionEffect(aab world, int x2, int y2, int z2) {
        if (this.completionEffect != null) {
            this.completionEffect.playEffect(world, x2, y2, z2);
        } else if (this.effect != null) {
            this.effect.playEffect(world, x2, y2, z2);
        }
    }

    public static interface TurntableEffect {
        public void playEffect(aab var1, int var2, int var3, int var4);
    }
}

