/*
 * Decompiled with CFR 0.152.
 */
package btw.crafting.recipe.types;

import btw.inventory.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;

public class BulkRecipe {
    private final List<wm> recipeOutputStacks;
    private final List<wm> recipeInputStacks;
    private final boolean metadataExclusive;

    public BulkRecipe(wm recipeOutputStack, List<wm> recipeInputStacks) {
        this(recipeOutputStack, recipeInputStacks, false);
    }

    public BulkRecipe(wm recipeOutputStack, List<wm> recipeInputStacks, boolean bMetaDataExclusive) {
        ArrayList<wm> outputArrayList = new ArrayList<wm>();
        outputArrayList.add(recipeOutputStack.m());
        this.recipeOutputStacks = outputArrayList;
        this.recipeInputStacks = recipeInputStacks;
        this.metadataExclusive = bMetaDataExclusive;
    }

    public BulkRecipe(List<wm> recipeOutputStacks, List<wm> recipeInputStacks, boolean bMetaDataExclusive) {
        this.recipeOutputStacks = recipeOutputStacks;
        this.recipeInputStacks = recipeInputStacks;
        this.metadataExclusive = bMetaDataExclusive;
    }

    public List<wm> getCraftingOutputList() {
        return this.recipeOutputStacks;
    }

    public List<wm> getCraftingIngrediantList() {
        return this.recipeInputStacks;
    }

    public wm getFirstIngredient() {
        if (this.recipeInputStacks != null && this.recipeInputStacks.size() > 0) {
            return this.recipeInputStacks.get(0);
        }
        return null;
    }

    public boolean doesInventoryContainIngredients(lt inventory) {
        if (this.recipeInputStacks != null && this.recipeInputStacks.size() > 0) {
            for (int listIndex = 0; listIndex < this.recipeInputStacks.size(); ++listIndex) {
                wm tempStack = this.recipeInputStacks.get(listIndex);
                if (tempStack == null || InventoryUtils.countItemsInInventory(inventory, tempStack.b().cp, tempStack.k(), this.metadataExclusive) >= tempStack.a) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean doesStackSatisfyIngredients(wm stack) {
        if (this.recipeInputStacks != null && this.recipeInputStacks.size() == 1) {
            wm recipeStack = this.recipeInputStacks.get(0);
            int recipeItemDamage = recipeStack.k();
            if (stack.c == recipeStack.c && stack.a >= recipeStack.a && (recipeItemDamage == Short.MAX_VALUE || !this.metadataExclusive && stack.k() == recipeItemDamage || this.metadataExclusive && stack.k() != recipeItemDamage)) {
                return true;
            }
        }
        return false;
    }

    public boolean consumeInventoryIngredients(lt inventory) {
        boolean bSuccessful = true;
        if (this.recipeInputStacks != null && this.recipeInputStacks.size() > 0) {
            for (int listIndex = 0; listIndex < this.recipeInputStacks.size(); ++listIndex) {
                wm tempStack = this.recipeInputStacks.get(listIndex);
                if (tempStack == null || InventoryUtils.consumeItemsInInventory(inventory, tempStack.b().cp, tempStack.k(), tempStack.a, this.metadataExclusive)) continue;
                bSuccessful = false;
            }
        }
        return bSuccessful;
    }

    public boolean matches(BulkRecipe recipe) {
        if (this.metadataExclusive == recipe.metadataExclusive && this.recipeInputStacks.size() == recipe.recipeInputStacks.size() && this.recipeOutputStacks.size() == recipe.recipeOutputStacks.size()) {
            int iListIndex;
            for (iListIndex = 0; iListIndex < this.recipeInputStacks.size(); ++iListIndex) {
                if (this.doStacksMatch(this.recipeInputStacks.get(iListIndex), recipe.recipeInputStacks.get(iListIndex))) continue;
                return false;
            }
            for (iListIndex = 0; iListIndex < this.recipeOutputStacks.size(); ++iListIndex) {
                if (this.doStacksMatch(this.recipeOutputStacks.get(iListIndex), recipe.recipeOutputStacks.get(iListIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean doStacksMatch(wm stack1, wm stack2) {
        return stack1.b().cp == stack2.b().cp && stack1.a == stack2.a && stack1.k() == stack2.k();
    }
}

