/*
 * Decompiled with CFR 0.152.
 */
package btw.crafting.recipe;

import btw.block.BTWBlocks;
import btw.crafting.recipe.RecipeManager;
import btw.crafting.recipe.types.customcrafting.FishingRodBaitingRecipe;
import btw.crafting.recipe.types.customcrafting.KnittingRecipe;
import btw.crafting.recipe.types.customcrafting.WoolArmorRecipe;
import btw.crafting.recipe.types.customcrafting.WoolBlockRecipe;
import btw.item.BTWItems;
import btw.item.blockitems.WoodMouldingDecorativeStubBlockItem;
import btw.item.blockitems.WoodSidingDecorativeStubBlockItem;
import btw.util.ColorUtils;

public abstract class CraftingRecipeList {
    public static void addRecipes() {
        CraftingRecipeList.removeVanillaRecipes();
        CraftingRecipeList.addClusteredRecipes();
        CraftingRecipeList.addBlockRecipes();
        CraftingRecipeList.addItemRecipes();
        CraftingRecipeList.addDyeRecipes();
        CraftingRecipeList.addAlternateVanillaRecipes();
        CraftingRecipeList.addConversionRecipes();
        CraftingRecipeList.addLogChoppingRecipes();
        CraftingRecipeList.addTuningForkRecipes();
        CraftingRecipeList.addSubBlockRecipes();
        CraftingRecipeList.addLegacyConversionRecipes();
        CraftingRecipeList.addCustomRecipeClasses();
        CraftingRecipeList.addDebugRecipes();
    }

    private static void addClusteredRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.rottenFleshSlab, 6), new Object[]{"###", Character.valueOf('#'), BTWBlocks.rottenFleshBlock});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.rottenFleshBlock), new Object[]{new wm(BTWBlocks.rottenFleshSlab), new wm(BTWBlocks.rottenFleshSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.bn, 9), new Object[]{new wm(BTWBlocks.rottenFleshBlock)});
        RecipeManager.addShapelessRecipe(new wm(wk.bn, 4), new Object[]{new wm(BTWBlocks.rottenFleshSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.boneSlab, 6), new Object[]{"###", Character.valueOf('#'), new wm(BTWBlocks.aestheticOpaque, 1, 15)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 15), new Object[]{new wm(BTWBlocks.boneSlab), new wm(BTWBlocks.boneSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.aY, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 15)});
        RecipeManager.addShapelessRecipe(new wm(wk.aY, 4), new Object[]{new wm(BTWBlocks.boneSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.creeperOysterSlab, 6), new Object[]{"###", Character.valueOf('#'), BTWBlocks.creeperOysterBlock});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.creeperOysterBlock), new Object[]{new wm(BTWBlocks.creeperOysterSlab), new wm(BTWBlocks.creeperOysterSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.creeperOysters, 16), new Object[]{new wm(BTWBlocks.creeperOysterBlock)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.creeperOysters, 8), new Object[]{new wm(BTWBlocks.creeperOysterSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.spiderEyeSlab, 6), new Object[]{"###", Character.valueOf('#'), BTWBlocks.spiderEyeBlock});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.spiderEyeBlock), new Object[]{new wm(BTWBlocks.spiderEyeSlab), new wm(BTWBlocks.spiderEyeSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.bv, 16), new Object[]{new wm(BTWBlocks.spiderEyeBlock)});
        RecipeManager.addShapelessRecipe(new wm(wk.bv, 8), new Object[]{new wm(BTWBlocks.spiderEyeSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.stoneStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.x, 1, 0)});
        RecipeManager.addRecipe(new wm(BTWBlocks.midStrataStoneStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.x, 1, 1)});
        RecipeManager.addRecipe(new wm(BTWBlocks.deepStrataStoneStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.x, 1, 2)});
        RecipeManager.addRecipe(new wm(BTWBlocks.bloodWoodStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 4)});
        RecipeManager.addRecipe(new wm(BTWBlocks.bloodWoodStairs, 1), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, 4)});
        RecipeManager.addRecipe(new wm(apa.bS, 6, 4), new Object[]{"###", Character.valueOf('#'), new wm(apa.B, 1, 4)});
        CraftingRecipeList.addEarlyGameRecipes();
        CraftingRecipeList.addToolRecipes();
        CraftingRecipeList.addLooseStoneRecipes();
        CraftingRecipeList.addLooseBrickRecipes();
        CraftingRecipeList.addLooseStoneBrickRecipes();
        CraftingRecipeList.addLooseNetherBrickRecipes();
        CraftingRecipeList.addTorchRecipes();
        CraftingRecipeList.addWickerRecipes();
        CraftingRecipeList.addStairRecipes();
        CraftingRecipeList.addWoolAndKnittingRecipes();
        CraftingRecipeList.addSawDustRecipes();
        CraftingRecipeList.addMeatCuringRecipes();
        CraftingRecipeList.addPaneRecipes();
        CraftingRecipeList.addSnowRecipes();
        CraftingRecipeList.addChickenFeedRecipes();
        CraftingRecipeList.addFishingRecipes();
        CraftingRecipeList.addDirtRecipes();
        CraftingRecipeList.addGravelRecipes();
        CraftingRecipeList.addSandRecipes();
        CraftingRecipeList.addMechanicalRecipes();
        CraftingRecipeList.addOreRecipes();
        CraftingRecipeList.addPastryRecipes();
    }

    private static void addEarlyGameRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.pointyStick), new Object[]{new wm(wk.E)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sharpStone), new Object[]{new wm(BTWItems.stone, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWItems.ironChisel), new Object[]{"XX", "XX", Character.valueOf('X'), BTWItems.ironNugget});
        RecipeManager.addRecipe(new wm(BTWItems.diamondChisel), new Object[]{"X", Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(BTWItems.diamondShears), new Object[]{"X ", " X", Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(BTWItems.woodenClub), new Object[]{"X", "X", Character.valueOf('X'), wk.E});
        RecipeManager.addRecipe(new wm(BTWItems.boneClub), new Object[]{"X", "X", Character.valueOf('X'), wk.aY});
        RecipeManager.addRecipe(new wm(BTWItems.firePlough), new Object[]{"XX", Character.valueOf('X'), wk.E});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bowDrill), new Object[]{new wm(wk.E), new wm(wk.E), new wm(wk.L)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bowDrill), new Object[]{new wm(wk.E), new wm(wk.E), new wm(BTWItems.hempFibers)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bowDrill), new Object[]{new wm(wk.E), new wm(wk.E), new wm(BTWItems.sinew)});
        RecipeManager.addRecipe(new wm((apa)((Object)BTWBlocks.unlitCampfire)), new Object[]{"XX", "XX", Character.valueOf('X'), wk.E});
        RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(wk.E), new wm(wk.L), new Object[]{new wm(wk.l, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.idleOven), new Object[]{"XX", "XX", Character.valueOf('X'), BTWBlocks.looseBrickSlab});
        RecipeManager.addShapelessRecipe(new wm(wk.n), new Object[]{new wm(BTWItems.coalDust), new wm(BTWItems.coalDust)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ), new Object[]{new wm(BTWItems.clayPile), new wm(BTWItems.clayPile)});
        RecipeManager.addRecipe(new wm(BTWBlocks.ladder, 2), new Object[]{"#S#", "###", "#S#", Character.valueOf('#'), wk.E, Character.valueOf('S'), wk.L});
        RecipeManager.addRecipe(new wm(BTWBlocks.ladder, 2), new Object[]{"#S#", "###", "#S#", Character.valueOf('#'), wk.E, Character.valueOf('S'), BTWItems.hempFibers});
        RecipeManager.addRecipe(new wm(BTWBlocks.ladder, 2), new Object[]{"#S#", "###", "#S#", Character.valueOf('#'), wk.E, Character.valueOf('S'), BTWItems.sinew});
        RecipeManager.addShapelessRecipe(new wm(wk.m, 2), new Object[]{new wm(wk.M), new wm(wk.E), new wm(wk.L), new wm(wk.aq)});
        RecipeManager.addShapelessRecipe(new wm(wk.m, 2), new Object[]{new wm(wk.M), new wm(wk.E), new wm(BTWItems.hempFibers), new wm(wk.aq)});
        RecipeManager.addShapelessRecipe(new wm(wk.m, 2), new Object[]{new wm(wk.M), new wm(wk.E), new wm(BTWItems.sinew), new wm(wk.aq)});
        RecipeManager.addLogChoppingRecipe(new wm(BTWItems.mashedMelon, 2), null, new wm(apa.bv));
        RecipeManager.addShapelessRecipe(new wm(wk.bi, 2), new Object[]{new wm(BTWItems.mashedMelon)});
    }

    private static void addToolRecipes() {
        CraftingRecipeList.addStoneToolRecipes();
        RecipeManager.addRecipe(new wm(wk.Q), new Object[]{"X#", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.p});
        RecipeManager.addRecipe(new wm(wk.R), new Object[]{"X#", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(wk.S), new Object[]{"X#", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.q});
        RecipeManager.addRecipe(new wm(BTWItems.diamondArmorPlate, 1), new Object[]{"#X#", " Y ", Character.valueOf('#'), BTWItems.leatherStrap, Character.valueOf('X'), BTWItems.diamondIngot, Character.valueOf('Y'), BTWItems.padding});
        RecipeManager.addRecipe(new wm(BTWItems.steelArmorPlate, 1), new Object[]{"#X#", " Y ", Character.valueOf('#'), BTWItems.leatherStrap, Character.valueOf('X'), BTWItems.soulforgedSteelIngot, Character.valueOf('Y'), BTWItems.padding});
    }

    private static void addStoneToolRecipes() {
        RecipeManager.addShapelessRecipe(new wm(wk.x), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), wk.L});
        RecipeManager.addShapelessRecipe(new wm(wk.x), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), BTWItems.hempFibers});
        RecipeManager.addShapelessRecipe(new wm(wk.x), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), BTWItems.sinew});
        RecipeManager.addShapelessRecipe(new wm(wk.z), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), new wm(BTWItems.stone, 1, Short.MAX_VALUE), wk.L});
        RecipeManager.addShapelessRecipe(new wm(wk.z), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), new wm(BTWItems.stone, 1, Short.MAX_VALUE), BTWItems.hempFibers});
        RecipeManager.addShapelessRecipe(new wm(wk.z), new Object[]{wk.E, new wm(BTWItems.stone, 1, Short.MAX_VALUE), new wm(BTWItems.stone, 1, Short.MAX_VALUE), BTWItems.sinew});
        RecipeManager.addRecipe(new wm(wk.y), new Object[]{"XXX", " #S", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), new wm(BTWItems.stone, 1, Short.MAX_VALUE), Character.valueOf('S'), wk.L});
        RecipeManager.addRecipe(new wm(wk.y), new Object[]{"XXX", " #S", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), new wm(BTWItems.stone, 1, Short.MAX_VALUE), Character.valueOf('S'), BTWItems.hempFibers});
        RecipeManager.addRecipe(new wm(wk.y), new Object[]{"XXX", " #S", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), new wm(BTWItems.stone, 1, Short.MAX_VALUE), Character.valueOf('S'), BTWItems.sinew});
    }

    private static void addLooseStoneRecipes() {
        int altBitStrata = 0;
        apa stairsType = BTWBlocks.looseCobblestoneStairs;
        for (int strata = 0; strata < 3; ++strata) {
            altBitStrata = strata << 2;
            if (strata == 1) {
                stairsType = BTWBlocks.looseMidStrataCobblestoneStairs;
            } else if (strata == 2) {
                stairsType = BTWBlocks.looseDeepStrataCobblestoneStairs;
            }
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseCobblestone, 1, altBitStrata), new Object[]{new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseCobblestoneSlab, 1, altBitStrata), new Object[]{new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata), new wm(BTWItems.stone, 1, strata)});
            RecipeManager.addRecipe(new wm(stairsType, 1), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWItems.stone, 1, strata)});
            RecipeManager.addRecipe(new wm(stairsType, 8), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.looseCobblestone, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(stairsType, 4), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseCobblestone, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(stairsType, 2), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseCobblestoneSlab, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.looseCobblestone, 1, altBitStrata), new Object[]{"X", "X", Character.valueOf('X'), new wm(BTWBlocks.looseCobblestoneSlab, 4, altBitStrata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.looseCobblestoneSlab, 4, altBitStrata), new Object[]{"XX", Character.valueOf('X'), new wm(BTWBlocks.looseCobblestone, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stone, 8, strata), new Object[]{new wm(BTWBlocks.looseCobblestone, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stone, 4, strata), new Object[]{new wm(BTWBlocks.looseCobblestoneSlab, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stone, 6, strata), new Object[]{new wm(stairsType, 1)});
        }
    }

    private static void addLooseBrickRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.unfiredBrick), new Object[]{new wm(wk.aJ)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseBrick), new Object[]{new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseBrickSlab), new Object[]{new wm(wk.aI), new wm(wk.aI), new wm(wk.aI), new wm(wk.aI)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrickStairs), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(wk.aI)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrickStairs, 8), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.looseBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrickStairs, 4), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrickStairs, 2), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseBrickSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrick), new Object[]{"X", "X", Character.valueOf('X'), BTWBlocks.looseBrickSlab});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseBrickSlab, 4), new Object[]{"XX", Character.valueOf('X'), BTWBlocks.looseBrick});
        RecipeManager.addShapelessRecipe(new wm(wk.aI, 8), new Object[]{new wm(BTWBlocks.looseBrick)});
        RecipeManager.addShapelessRecipe(new wm(wk.aI, 4), new Object[]{new wm(BTWBlocks.looseBrickSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.aI, 6), new Object[]{new wm(BTWBlocks.looseBrickStairs)});
    }

    private static void addLooseStoneBrickRecipes() {
        int altBitStrata = 0;
        apa stairsType = BTWBlocks.looseStoneBrickStairs;
        for (int strata = 0; strata < 3; ++strata) {
            altBitStrata = strata << 2;
            if (strata == 1) {
                stairsType = BTWBlocks.looseMidStrataStoneBrickStairs;
            } else if (strata == 2) {
                stairsType = BTWBlocks.looseDeepStrataStoneBrickStairs;
            }
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata), new Object[]{new wm(BTWItems.stoneBrick, 1, strata), new wm(BTWItems.stoneBrick, 1, strata), new wm(BTWItems.stoneBrick, 1, strata), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseStoneBrickSlab, 1, altBitStrata), new Object[]{new wm(BTWItems.stoneBrick, 1, strata), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addRecipe(new wm(stairsType, 2), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addRecipe(new wm(stairsType, 8), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(stairsType), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addRecipe(new wm(stairsType, 4), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(stairsType, 2), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseStoneBrickSlab, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata), new Object[]{"X", "X", Character.valueOf('X'), new wm(BTWBlocks.looseStoneBrickSlab, 1, altBitStrata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.looseStoneBrickSlab, 4, altBitStrata), new Object[]{"XX", Character.valueOf('X'), new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stoneBrick, 4, strata), new Object[]{new wm(BTWBlocks.looseStoneBrick, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stoneBrick, 2, strata), new Object[]{new wm(BTWBlocks.looseStoneBrickSlab, 1, altBitStrata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stoneBrick, 3, strata), new Object[]{new wm(stairsType)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stone, 2, strata), new Object[]{new wm(BTWItems.ironChisel, 1, Short.MAX_VALUE), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(BTWItems.stoneBrick, 4, strata), new wm(BTWItems.gravelPile), new Object[]{new wm(BTWItems.ironChisel, 1, Short.MAX_VALUE), new wm(apa.x, 1, strata)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.stone, 2, strata), new Object[]{new wm(BTWItems.diamondChisel, 1, Short.MAX_VALUE), new wm(BTWItems.stoneBrick, 1, strata)});
            RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(BTWItems.stoneBrick, 4, strata), new wm(BTWItems.gravelPile), new Object[]{new wm(BTWItems.diamondChisel, 1, Short.MAX_VALUE), new wm(apa.x, 1, strata)});
        }
    }

    private static void addLooseNetherBrickRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.unfiredNetherBrick), new Object[]{new wm(BTWItems.netherSludge)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseNetherBrick), new Object[]{new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseNetherBrickSlab), new Object[]{new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick), new wm(BTWItems.netherBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNEtherBrickStairs), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWItems.netherBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNEtherBrickStairs, 8), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.looseNetherBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNEtherBrickStairs, 4), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseNetherBrick)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNEtherBrickStairs, 2), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.looseNetherBrickSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNetherBrick), new Object[]{"X", "X", Character.valueOf('X'), BTWBlocks.looseNetherBrickSlab});
        RecipeManager.addRecipe(new wm(BTWBlocks.looseNetherBrickSlab, 4), new Object[]{"XX", Character.valueOf('X'), BTWBlocks.looseNetherBrick});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.netherBrick, 8), new Object[]{new wm(BTWBlocks.looseNetherBrick)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.netherBrick, 4), new Object[]{new wm(BTWBlocks.looseNetherBrickSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.netherBrick, 6), new Object[]{new wm(BTWBlocks.looseNEtherBrickStairs)});
    }

    private static void addTorchRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.infiniteUnlitTorch, 1), new Object[]{"#", "X", Character.valueOf('#'), BTWItems.nethercoal, Character.valueOf('X'), wk.E});
        RecipeManager.addRecipe(new wm(BTWBlocks.finiteUnlitTorch), new Object[]{"#", "X", Character.valueOf('#'), new wm(wk.n, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.E});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.infiniteBurningTorch), new Object[]{new wm(apa.au)});
    }

    private static void addWickerRecipes() {
        RecipeManager.addRecipe(new wm(BTWItems.wickerWeaving, 1, 299), new Object[]{"##", "##", Character.valueOf('#'), wk.aK});
        RecipeManager.addRecipe(new wm((apa)((Object)BTWBlocks.wickerBasket)), new Object[]{"##", "##", Character.valueOf('#'), BTWItems.wickerPane});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.wickerPane, 4), new Object[]{new wm((apa)((Object)BTWBlocks.wickerBasket))});
        RecipeManager.addRecipe(new wm((apa)((Object)BTWBlocks.hamper)), new Object[]{"###", "#P#", "###", Character.valueOf('#'), BTWItems.wickerPane, Character.valueOf('P'), apa.B});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerPane), new Object[]{new wm(BTWBlocks.gratePane), new wm(BTWItems.wickerPane)});
        RecipeManager.addRecipe(new wm(BTWBlocks.wickerBlock), new Object[]{"##", "##", Character.valueOf('#'), BTWBlocks.wickerPane});
        RecipeManager.addRecipe(new wm(BTWBlocks.wickerSlab), new Object[]{"##", Character.valueOf('#'), BTWBlocks.wickerPane});
        RecipeManager.addRecipe(new wm(BTWBlocks.wickerSlab, 4), new Object[]{"##", Character.valueOf('#'), BTWBlocks.wickerBlock});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerPane, 4), new Object[]{new wm(BTWBlocks.wickerBlock)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerPane, 2), new Object[]{new wm(BTWBlocks.wickerSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerBlock), new Object[]{new wm(BTWBlocks.wickerSlab), new wm(BTWBlocks.wickerSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerBlock), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerSlab), new Object[]{new wm(BTWBlocks.aestheticNonOpaque, 1, 5)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.wickerPane), new Object[]{new wm(BTWItems.legacyWickerPane)});
        RecipeManager.addRecipe(new wm(wk.bS, 1), new Object[]{"# ", " X", Character.valueOf('#'), wk.aS, Character.valueOf('X'), BTWItems.carrot});
    }

    private static void addStairRecipes() {
        RecipeManager.addRecipe(new wm(apa.ax, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 0)});
        RecipeManager.addRecipe(new wm(apa.cb, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 2)});
        RecipeManager.addRecipe(new wm(apa.ca, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 1)});
        RecipeManager.addRecipe(new wm(apa.cc, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 3)});
        RecipeManager.addRecipe(new wm(apa.bA, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.ap)});
        RecipeManager.addRecipe(new wm(apa.aL, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.A, 1, 0)});
        RecipeManager.addRecipe(new wm(BTWBlocks.midStrataCobblestoneStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.A, 1, 1)});
        RecipeManager.addRecipe(new wm(BTWBlocks.deepStrataCobblestoneStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.A, 1, 2)});
        RecipeManager.addRecipe(new wm(apa.bG, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bE)});
        RecipeManager.addRecipe(new wm(apa.cw, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.cv)});
        RecipeManager.addRecipe(new wm(apa.bU, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.U)});
        RecipeManager.addRecipe(new wm(apa.bB, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bq, 1, 0)});
        RecipeManager.addRecipe(new wm(BTWBlocks.deepStrataStoneBrickStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bq, 1, 2)});
        RecipeManager.addRecipe(new wm(BTWBlocks.deepStrataStoneBrickStairs, 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bq, 1, 2)});
    }

    private static void addWoolAndKnittingRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.knittingNeedles), new Object[]{new wm(BTWItems.pointyStick, 1, 0), new wm(BTWItems.pointyStick, 1, 0)});
        RecipeManager.addShapedRecipeWithCustomClass(WoolArmorRecipe.class, new wm(BTWItems.woolHelmet), new Object[]{"##", Character.valueOf('#'), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE)});
        RecipeManager.addShapedRecipeWithCustomClass(WoolArmorRecipe.class, new wm(BTWItems.woolChest), new Object[]{"##", "##", Character.valueOf('#'), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE)});
        RecipeManager.addShapedRecipeWithCustomClass(WoolArmorRecipe.class, new wm(BTWItems.woolLeggings), new Object[]{"##", "# ", Character.valueOf('#'), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE)});
        RecipeManager.addShapedRecipeWithCustomClass(WoolArmorRecipe.class, new wm(BTWItems.woolLeggings), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE)});
        RecipeManager.addShapedRecipeWithCustomClass(WoolBlockRecipe.class, new wm(apa.af), new Object[]{" # ", "#W#", " # ", Character.valueOf('#'), new wm(BTWItems.wool, 1, Short.MAX_VALUE), Character.valueOf('W'), new wm(BTWBlocks.wickerBlock)});
        for (int iTempColor = 0; iTempColor < 16; ++iTempColor) {
            RecipeManager.addRecipe(new wm(BTWBlocks.woolSlab, 6, iTempColor), new Object[]{"###", Character.valueOf('#'), new wm(apa.af, 1, iTempColor)});
            RecipeManager.addShapelessRecipe(new wm(apa.af, 1, iTempColor), new Object[]{new wm(BTWBlocks.woolSlab, 1, iTempColor), new wm(BTWBlocks.woolSlab, 1, iTempColor)});
        }
    }

    private static void addSawDustRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sawDust, 2), new Object[]{new wm(BTWItems.firePlough, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sawDust, 2), new Object[]{new wm(BTWItems.bowDrill, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sawDust, 2), new Object[]{new wm(BTWItems.knittingNeedles, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sawDust, 4), new Object[]{new wm(BTWItems.knitting, 1, Short.MAX_VALUE)});
    }

    private static void addMeatCuringRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(BTWItems.rawMutton), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(wk.bl), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(wk.bj), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(wk.aV), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(wk.ar), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(BTWItems.rawWolfChop), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(BTWItems.rawMysteryMeat), new wm(BTWItems.nitre)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.curedMeat), new Object[]{new wm(BTWItems.rawLiver), new wm(BTWItems.nitre)});
    }

    private static void addPaneRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.gratePane, 1), new Object[]{"S#S", "###", "S#S", Character.valueOf('#'), new wm(wk.E), Character.valueOf('S'), new wm(wk.L)});
        RecipeManager.addRecipe(new wm(BTWBlocks.gratePane, 1), new Object[]{"S#S", "###", "S#S", Character.valueOf('#'), new wm(wk.E), Character.valueOf('S'), new wm(BTWItems.hempFibers)});
        RecipeManager.addRecipe(new wm(BTWBlocks.gratePane, 1), new Object[]{"S#S", "###", "S#S", Character.valueOf('#'), new wm(wk.E), Character.valueOf('S'), new wm(BTWItems.sinew)});
        RecipeManager.addRecipe(new wm(BTWBlocks.slatsPane, 1), new Object[]{"##", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.gratePane), new Object[]{new wm(BTWItems.legacyGrate)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.slatsPane), new Object[]{new wm(BTWItems.legacySlats)});
    }

    private static void addSnowRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseSnowSlab), new Object[]{new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE)});
        RecipeManager.addShapelessRecipe(new wm(wk.aE, 4), new Object[]{new wm(BTWBlocks.looseSnowSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.aE, 4), new Object[]{new wm(BTWBlocks.solidSnowSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseSnow), new Object[]{new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE), new wm(wk.aE)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseSnow), new Object[]{new wm(BTWBlocks.looseSnowSlab), new wm(BTWBlocks.looseSnowSlab)});
        RecipeManager.addShapelessRecipe(new wm(wk.aE, 8), new Object[]{new wm(BTWBlocks.looseSnow)});
        RecipeManager.addShapelessRecipe(new wm(wk.aE, 8), new Object[]{new wm(BTWBlocks.solidSnow)});
    }

    private static void addChickenFeedRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(wk.T)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(BTWItems.wheatSeeds)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(BTWItems.hempSeeds)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(wk.bh)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(wk.bi)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.chickenFeed), new Object[]{new wm(wk.aX, 1, 15), new wm(BTWItems.carrotSeeds)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(wk.T)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(BTWItems.wheatSeeds)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(BTWItems.hempSeeds)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(wk.bh)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(wk.bi)});
        RecipeManager.addCauldronRecipe(new wm(BTWItems.chickenFeed), new wm[]{new wm(wk.aX, 1, 15), new wm(BTWItems.carrotSeeds)});
    }

    private static void addFishingRecipes() {
        RecipeManager.addShapelessRecipe(new wm(wk.aS), new Object[]{new wm(wk.E), new wm(wk.L), new wm(wk.L), new wm(BTWItems.ironNugget)});
        RecipeManager.addShapelessRecipe(new wm(wk.aS), new Object[]{new wm(wk.E), new wm(wk.L), new wm(wk.L), new wm(BTWItems.boneFishHook)});
        RecipeManager.addShapelessRecipe(new wm(wk.aS), new Object[]{new wm(wk.E), new wm(BTWItems.sinew), new wm(BTWItems.sinew), new wm(BTWItems.ironNugget)});
        RecipeManager.addShapelessRecipe(new wm(wk.aS), new Object[]{new wm(wk.E), new wm(BTWItems.sinew), new wm(BTWItems.sinew), new wm(BTWItems.boneFishHook)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.boneCarving, 1, 599), new Object[]{new wm(wk.aY)});
    }

    private static void addDirtRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.looseDirtSlab, 4), new Object[]{"##", Character.valueOf('#'), new wm(BTWBlocks.looseDirt)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseDirtSlab, 1), new Object[]{new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseDirt, 1), new Object[]{new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile), new wm(BTWItems.dirtPile)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseDirt), new Object[]{new wm(BTWBlocks.looseDirtSlab), new wm(BTWBlocks.looseDirtSlab)});
        RecipeManager.addRecipe(new wm(BTWBlocks.dirtSlab, 4), new Object[]{"##", Character.valueOf('#'), new wm(apa.z)});
        RecipeManager.addRecipe(new wm(BTWBlocks.dirtSlab, 4, 3), new Object[]{"EE", Character.valueOf('E'), new wm(BTWBlocks.aestheticEarth, 1, 6)});
        RecipeManager.addShapelessRecipe(new wm(apa.z), new Object[]{new wm(BTWBlocks.dirtSlab), new wm(BTWBlocks.dirtSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseDirt, 2), new Object[]{new wm(BTWBlocks.aestheticEarth, 1, 6)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.aestheticEarth, 1, 6), new Object[]{new wm(BTWBlocks.dirtSlab, 1, 3), new wm(BTWBlocks.dirtSlab, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.looseDirt, 1), new Object[]{new wm(BTWBlocks.dirtSlab, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.dirtPile, 8), new Object[]{new wm(apa.z, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.dirtPile, 8), new Object[]{new wm(BTWBlocks.looseDirt, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.dirtPile, 4), new Object[]{new wm(BTWBlocks.dirtSlab)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.dirtPile, 4), new Object[]{new wm(BTWBlocks.looseDirtSlab, 1)});
    }

    private static void addGravelRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.sandAndGravelSlab, 1, 0), new Object[]{new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile)});
        RecipeManager.addShapelessRecipe(new wm(apa.J), new Object[]{new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile), new wm(BTWItems.gravelPile)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.gravelPile, 8), new Object[]{new wm(apa.J)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.gravelPile, 4), new Object[]{new wm(BTWBlocks.sandAndGravelSlab, 1, 0)});
        RecipeManager.addRecipe(new wm(BTWBlocks.sandAndGravelSlab, 4, 0), new Object[]{"##", Character.valueOf('#'), new wm(apa.J)});
        RecipeManager.addShapelessRecipe(new wm(apa.J), new Object[]{new wm(BTWBlocks.sandAndGravelSlab, 1, 0), new wm(BTWBlocks.sandAndGravelSlab, 1, 0)});
    }

    private static void addSandRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.sandAndGravelSlab, 1, 1), new Object[]{new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile)});
        RecipeManager.addShapelessRecipe(new wm(apa.I), new Object[]{new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile), new wm(BTWItems.sandPile)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sandPile, 4), new Object[]{new wm(BTWBlocks.sandAndGravelSlab, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sandPile, 8), new Object[]{new wm(apa.I)});
        RecipeManager.addRecipe(new wm(BTWBlocks.sandAndGravelSlab, 4, 1), new Object[]{"##", Character.valueOf('#'), new wm(apa.I)});
        RecipeManager.addShapelessRecipe(new wm(apa.I), new Object[]{new wm(BTWBlocks.sandAndGravelSlab, 1, 1), new wm(BTWBlocks.sandAndGravelSlab, 1, 1)});
    }

    private static void addMechanicalRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.axle), new Object[]{"#X#", Character.valueOf('#'), apa.B, Character.valueOf('X'), BTWItems.rope});
        RecipeManager.addRecipe(new wm(BTWBlocks.axle), new Object[]{"#X#", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.rope});
        RecipeManager.addRecipe(new wm(BTWBlocks.gearBox), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), apa.B, Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), BTWBlocks.axle});
        RecipeManager.addRecipe(new wm(BTWBlocks.gearBox), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), BTWBlocks.axle});
        RecipeManager.addRecipe(new wm(BTWBlocks.redstoneClutch), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), apa.B, Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(BTWBlocks.redstoneClutch), new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(BTWBlocks.handCrank), new Object[]{"  Y", " Y ", "#X#", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), wk.E});
        RecipeManager.addRecipe(new wm(BTWBlocks.millstone), new Object[]{"YYY", "YYY", "YXY", Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.turntable), new Object[]{"###", "ZXZ", "ZYZ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.aT, Character.valueOf('Y'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Z'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.bellows), new Object[]{"###", "XXX", "YZY", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.tannedLeather, Character.valueOf('Y'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Z'), BTWItems.belt});
        RecipeManager.addRecipe(new wm(BTWBlocks.bellows), new Object[]{"###", "XXX", "YZY", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.cutTannedLeather, Character.valueOf('Y'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Z'), BTWItems.belt});
    }

    private static void addOreRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.ironOreChunk), new Object[]{new wm(BTWItems.ironOrePile), new wm(BTWItems.ironOrePile)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.ironOreChunk), new Object[]{new wm(apa.L)});
        RecipeManager.addRecipe(new wm(BTWBlocks.ironOreChunkStorage), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.ironOreChunk});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.ironOreChunk, 9), new Object[]{new wm(BTWBlocks.ironOreChunkStorage)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.goldOreChunk), new Object[]{new wm(BTWItems.goldOrePile), new wm(BTWItems.goldOrePile)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.goldOreChunk), new Object[]{new wm(apa.K)});
        RecipeManager.addRecipe(new wm(BTWBlocks.goldOreChunkStorage), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.goldOreChunk});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.goldOreChunk, 9), new Object[]{new wm(BTWBlocks.goldOreChunkStorage)});
    }

    private static void addPastryRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.breadDough), new Object[]{new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.flour)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.unbakedCookies, 1), new Object[]{new wm(BTWItems.chocolate), new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.flour)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.unbakedPumpkinPie, 1), new Object[]{new wm(wk.aZ), new wm(BTWBlocks.freshPumpkin), new wm(BTWItems.rawEgg), new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.flour)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.unbakedCake, 1), new Object[]{new wm(wk.aZ), new wm(wk.aZ), new wm(wk.aZ), new wm(wk.aH), new wm(wk.aH), new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.flour), new wm(BTWItems.rawEgg)});
    }

    private static void addBlockRecipes() {
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticEarth, 1, 7), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.dung});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.concentratedHellfire});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 4), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.padding});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 5), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.soap});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 6), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.rope});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 7), new Object[]{"###", "###", "###", Character.valueOf('#'), wk.aq});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 1, 14), new Object[]{"###", "###", "###", Character.valueOf('#'), wk.bo});
        RecipeManager.addRecipe(new wm(BTWBlocks.miningCharge, 3), new Object[]{"XYX", "###", "###", Character.valueOf('#'), BTWItems.dynamite, Character.valueOf('X'), BTWItems.rope, Character.valueOf('Y'), wk.aN});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticVegetation, 1, 0), new Object[]{"###", Character.valueOf('#'), apa.by});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.soulforge, 1), new Object[]{new wm(wk.bT), new wm(BTWItems.soulFlux), new wm(BTWBlocks.dormandSoulforge)});
        RecipeManager.addRecipe(new wm(BTWBlocks.lightBlockOff, 1), new Object[]{" # ", "#X#", " Y ", Character.valueOf('#'), apa.bu, Character.valueOf('X'), BTWItems.filament, Character.valueOf('Y'), wk.aD});
        RecipeManager.addRecipe(new wm(BTWBlocks.hibachi), new Object[]{"XXX", "#Z#", "#Y#", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.concentratedHellfire, Character.valueOf('Y'), wk.aD, Character.valueOf('Z'), BTWItems.element});
        RecipeManager.addRecipe(new wm(BTWBlocks.hopper), new Object[]{"# #", "XYX", " Z ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), apa.aQ, Character.valueOf('Z'), new wm(BTWItems.woodCornerStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.saw), new Object[]{"YYY", "XZX", "#X#", Character.valueOf('#'), apa.B, Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), wk.p, Character.valueOf('Z'), BTWItems.belt});
        RecipeManager.addRecipe(new wm(BTWBlocks.saw), new Object[]{"YYY", "XZX", "#X#", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), wk.p, Character.valueOf('Z'), BTWItems.belt});
        RecipeManager.addRecipe(new wm(BTWBlocks.platform), new Object[]{"#X#", " # ", "#X#", Character.valueOf('#'), apa.B, Character.valueOf('X'), BTWBlocks.wickerPane});
        RecipeManager.addRecipe(new wm(BTWBlocks.platform), new Object[]{"X#X", " X ", "X#X", Character.valueOf('#'), BTWBlocks.wickerPane, Character.valueOf('X'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.pulley), new Object[]{"#Y#", "XZX", "#Y#", Character.valueOf('#'), apa.B, Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), wk.p, Character.valueOf('Z'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(BTWBlocks.pulley), new Object[]{"#Y#", "XZX", "#Y#", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('Y'), wk.p, Character.valueOf('Z'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(BTWBlocks.cauldron), new Object[]{"#Y#", "#X#", "###", Character.valueOf('#'), wk.p, Character.valueOf('X'), wk.ay, Character.valueOf('Y'), wk.aY});
        RecipeManager.addRecipe(new wm(apa.aK, 12), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), BTWItems.ironNugget, Character.valueOf('S'), wk.E});
        RecipeManager.addRecipe(new wm(apa.X, 6), new Object[]{"X X", "XSX", "XRX", Character.valueOf('X'), BTWItems.ironNugget, Character.valueOf('S'), wk.E, Character.valueOf('R'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(BTWBlocks.woodenDetectorRail, 6), new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), BTWItems.ironNugget, Character.valueOf('R'), wk.aD, Character.valueOf('#'), apa.aQ});
        RecipeManager.addRecipe(new wm(apa.Y, 6), new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), BTWItems.ironNugget, Character.valueOf('R'), wk.aD, Character.valueOf('#'), apa.aO});
        RecipeManager.addRecipe(new wm(BTWBlocks.steelDetectorRail, 6), new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), BTWItems.ironNugget, Character.valueOf('R'), wk.aD, Character.valueOf('#'), BTWBlocks.steelPressurePlate});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.planterWithSoil), new Object[]{new wm(BTWBlocks.planter), new wm(BTWBlocks.looseDirt)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.planterWithSoil), new Object[]{new wm(BTWBlocks.planter, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.planterWithSoil), new Object[]{new wm(BTWBlocks.planter, 1, 2)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.planter, 1, 8), new Object[]{new wm(BTWBlocks.planter), new wm(apa.bg)});
        RecipeManager.addRecipe(new wm(BTWBlocks.screwPump), new Object[]{"XGX", "WSW", "WgW", Character.valueOf('W'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('g'), new wm(BTWItems.gear, 1, Short.MAX_VALUE), Character.valueOf('S'), BTWItems.screw, Character.valueOf('G'), BTWBlocks.gratePane, Character.valueOf('X'), BTWItems.glue});
        RecipeManager.addRecipe(new wm(BTWBlocks.lens), new Object[]{"GDG", "G G", "G#G", Character.valueOf('#'), apa.Q, Character.valueOf('G'), wk.q, Character.valueOf('D'), wk.o});
        RecipeManager.addRecipe(new wm(BTWBlocks.lens), new Object[]{"G#G", "G G", "GDG", Character.valueOf('#'), apa.Q, Character.valueOf('G'), wk.q, Character.valueOf('D'), wk.o});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticOpaque, 2, 11), new Object[]{"###", "#X#", "###", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.glue});
        RecipeManager.addRecipe(new wm(BTWBlocks.whiteStoneStairs, 6, 0), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.aestheticOpaque, 1, 9)});
        RecipeManager.addRecipe(new wm(BTWBlocks.whiteStoneStairs, 6, 8), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(BTWBlocks.aestheticOpaque, 1, 10)});
        RecipeManager.addRecipe(new wm(BTWBlocks.aestheticNonOpaque, 6, 10), new Object[]{"###", Character.valueOf('#'), new wm(BTWBlocks.aestheticOpaque, 1, 10)});
        RecipeManager.addShapelessRecipe(new wm(wk.bR.cp, 1, 5), new Object[]{new wm(BTWItems.soulUrn), new wm(BTWItems.soulFlux), new wm(wk.bR.cp, 1, 1)});
        RecipeManager.addRecipe(new wm(BTWBlocks.pistonShovel), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), wk.p});
        RecipeManager.addRecipe(new wm(BTWBlocks.ironSpike), new Object[]{"n", "n", "I", Character.valueOf('n'), BTWItems.ironNugget, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWBlocks.lightningRod), new Object[]{"n", "n", "I", Character.valueOf('n'), wk.br, Character.valueOf('I'), wk.q});
    }

    private static void addItemRecipes() {
        RecipeManager.addRecipe(new wm(BTWItems.gear, 2), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), apa.B, Character.valueOf('X'), wk.E});
        RecipeManager.addRecipe(new wm(BTWItems.rope, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), BTWItems.hempFibers});
        RecipeManager.addRecipe(new wm(BTWBlocks.anchor), new Object[]{" X ", "###", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.waterWheel), new Object[]{"###", "# #", "###", Character.valueOf('#'), BTWItems.woodenBlade});
        RecipeManager.addRecipe(new wm(BTWItems.windMillBlade), new Object[]{"###", "XXX", Character.valueOf('#'), BTWItems.fabric, Character.valueOf('X'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWItems.windMillBlade), new Object[]{"###", "XXX", Character.valueOf('#'), BTWItems.fabric, Character.valueOf('X'), apa.B});
        RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(BTWItems.windMillBlade), new wm(BTWItems.windMillBlade, 3), new Object[]{new wm(BTWItems.windMill)});
        RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(BTWItems.windMillBlade), new wm(BTWItems.windMillBlade, 7), new Object[]{new wm(BTWItems.verticalWindMill)});
        RecipeManager.addRecipe(new wm(BTWItems.windMill), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), BTWItems.windMillBlade});
        RecipeManager.addRecipe(new wm(BTWItems.fabric, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), BTWItems.hempFibers});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.dung, 9), new Object[]{new wm(BTWBlocks.aestheticEarth, 1, 7)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.concentratedHellfire, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.padding, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 4)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.soap, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 5)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rope, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 6)});
        RecipeManager.addShapelessRecipe(new wm(wk.aq, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 7)});
        RecipeManager.addShapelessRecipe(new wm(wk.bo, 9), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 14)});
        RecipeManager.addRecipe(new wm(BTWItems.belt, 1), new Object[]{" # ", "# #", " # ", Character.valueOf('#'), BTWItems.leatherStrap});
        RecipeManager.addRecipe(new wm(BTWItems.woodenBlade, 1), new Object[]{"#  ", "#X#", "#  ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.glue});
        RecipeManager.addRecipe(new wm(BTWItems.haft, 1), new Object[]{"Y", "X", "#", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.glue, Character.valueOf('Y'), BTWItems.leatherStrap});
        RecipeManager.addRecipe(new wm(wk.l, 1), new Object[]{"ST ", "S T", "ST ", Character.valueOf('S'), BTWItems.sinew, Character.valueOf('T'), wk.E});
        RecipeManager.addRecipe(new wm(BTWItems.compositeBow, 1), new Object[]{"X#Y", "ZX#", "X#Y", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.aY, Character.valueOf('Y'), BTWItems.glue, Character.valueOf('Z'), wk.L});
        RecipeManager.addRecipe(new wm(BTWItems.compositeBow, 1), new Object[]{"X#Y", "ZX#", "X#Y", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.aY, Character.valueOf('Y'), BTWItems.glue, Character.valueOf('Z'), BTWItems.sinew});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.broadheadArrow, 4), new Object[]{new wm(wk.M), new wm(wk.E), new wm(wk.L), new wm(BTWItems.broadheadArrowHead)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.broadheadArrow, 4), new Object[]{new wm(wk.M), new wm(wk.E), new wm(BTWItems.hempFibers), new wm(BTWItems.broadheadArrowHead)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.broadheadArrow, 4), new Object[]{new wm(wk.M), new wm(wk.E), new wm(BTWItems.sinew), new wm(BTWItems.broadheadArrowHead)});
        RecipeManager.addRecipe(new wm(BTWItems.gimpHelmet), new Object[]{"###", "#I#", Character.valueOf('#'), BTWItems.tannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpChest), new Object[]{"# #", "I#I", "###", Character.valueOf('#'), BTWItems.tannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpLeggings), new Object[]{"#I#", "# #", "# #", Character.valueOf('#'), BTWItems.tannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpBoots), new Object[]{"# #", "I I", Character.valueOf('#'), BTWItems.tannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpHelmet), new Object[]{"###", "#I#", Character.valueOf('#'), BTWItems.cutTannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpChest), new Object[]{"# #", "I#I", "###", Character.valueOf('#'), BTWItems.cutTannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpLeggings), new Object[]{"#I#", "# #", "# #", Character.valueOf('#'), BTWItems.cutTannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.gimpBoots), new Object[]{"# #", "I I", Character.valueOf('#'), BTWItems.cutTannedLeather, Character.valueOf('I'), wk.p});
        RecipeManager.addRecipe(new wm(BTWItems.padding), new Object[]{"C", "W", "C", Character.valueOf('C'), BTWItems.fabric, Character.valueOf('W'), new wm(BTWItems.wool, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWItems.dynamite, 2), new Object[]{"PF", "PN", "PS", Character.valueOf('P'), wk.aL, Character.valueOf('F'), BTWItems.fuse, Character.valueOf('N'), BTWItems.blastingOil, Character.valueOf('S'), BTWItems.sawDust});
        RecipeManager.addRecipe(new wm(BTWItems.dynamite, 2), new Object[]{"PF", "PN", "PS", Character.valueOf('P'), wk.aL, Character.valueOf('F'), BTWItems.fuse, Character.valueOf('N'), BTWItems.blastingOil, Character.valueOf('S'), BTWItems.soulDust});
        RecipeManager.addRecipe(new wm(BTWItems.breedingHarness), new Object[]{"SLS", "LLL", "SLS", Character.valueOf('S'), BTWItems.leatherStrap, Character.valueOf('L'), BTWItems.tannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.breedingHarness), new Object[]{"SLS", "LLL", "SLS", Character.valueOf('S'), BTWItems.leatherStrap, Character.valueOf('L'), BTWItems.cutTannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.candle, 4, 16), new Object[]{"H", "T", Character.valueOf('H'), BTWItems.hempFibers, Character.valueOf('T'), BTWItems.tallow});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.candle, 4, 16), new Object[]{new wm(BTWItems.legacyCandle)});
        RecipeManager.addRecipe(new wm(BTWItems.screw), new Object[]{"n# ", " #n", "n# ", Character.valueOf('#'), new wm(wk.p), Character.valueOf('n'), new wm(BTWItems.ironNugget)});
        RecipeManager.addRecipe(new wm(BTWItems.ocularOfEnder, 1, 0), new Object[]{"ggg", "gEg", "ggg", Character.valueOf('g'), wk.br, Character.valueOf('E'), wk.bo});
        RecipeManager.addRecipe(new wm(BTWItems.enderSpectacles), new Object[]{"OSO", Character.valueOf('S'), BTWItems.leatherStrap, Character.valueOf('O'), BTWItems.ocularOfEnder});
        RecipeManager.addRecipe(new wm(BTWItems.stake, 2), new Object[]{"S", "M", Character.valueOf('M'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('S'), new wm(wk.L)});
        RecipeManager.addRecipe(new wm(BTWItems.verticalWindMill), new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), BTWItems.windMillBlade});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(wk.bk)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(wk.as)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(wk.bm)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(wk.aW)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(BTWItems.cookedWolfChop)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(BTWItems.cookedMutton)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tastySandwich, 2), new Object[]{new wm(wk.V), new wm(BTWItems.cookedMysteryMeat)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.steakAndPotatoes, 2), new Object[]{new wm(wk.bN), new wm(wk.bk)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.steakAndPotatoes, 2), new Object[]{new wm(BTWItems.boiledPotato), new wm(wk.bk)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.hamAndEggs, 2), new Object[]{new wm(BTWItems.hardBoiledEgg), new wm(wk.as)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.hamAndEggs, 2), new Object[]{new wm(BTWItems.friedEgg), new wm(wk.as)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.steakDinner, 3), new Object[]{new wm(BTWItems.boiledPotato), new wm(BTWItems.cookedCarrot), new wm(wk.bk)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.steakDinner, 3), new Object[]{new wm(wk.bN), new wm(BTWItems.cookedCarrot), new wm(wk.bk)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.porkDinner, 3), new Object[]{new wm(BTWItems.boiledPotato), new wm(BTWItems.cookedCarrot), new wm(wk.as)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.porkDinner, 3), new Object[]{new wm(wk.bN), new wm(BTWItems.cookedCarrot), new wm(wk.as)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.wolfDinner, 3), new Object[]{new wm(BTWItems.boiledPotato), new wm(BTWItems.cookedCarrot), new wm(BTWItems.cookedWolfChop)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.wolfDinner, 3), new Object[]{new wm(wk.bN), new wm(BTWItems.cookedCarrot), new wm(BTWItems.cookedWolfChop)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rawKebab, 3), new Object[]{new wm(BTWItems.brownMushroom), new wm(BTWItems.carrot), new wm(BTWItems.rawMutton), new wm(wk.E)});
        RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(apa.be), new wm(wk.bh, 4), new Object[]{new wm(BTWBlocks.freshPumpkin)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rawMushroomOmelet, 2), new Object[]{new wm(BTWItems.brownMushroom), new wm(BTWItems.brownMushroom), new wm(BTWItems.brownMushroom), new wm(BTWItems.rawEgg)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rawScrambledEggs, 2), new Object[]{new wm(BTWItems.rawEgg), new wm(wk.aH)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rawScrambledEggs, 2), new Object[]{new wm(BTWItems.hardBoiledEgg), new wm(wk.aH)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.rawScrambledEggs, 2), new Object[]{new wm(BTWItems.friedEgg), new wm(wk.aH)});
        RecipeManager.addRecipe(new wm(wk.aa), new Object[]{"###", "# #", Character.valueOf('#'), BTWItems.mail});
        RecipeManager.addRecipe(new wm(wk.ab), new Object[]{"# #", "###", "###", Character.valueOf('#'), BTWItems.mail});
        RecipeManager.addRecipe(new wm(wk.ac), new Object[]{"###", "# #", "# #", Character.valueOf('#'), BTWItems.mail});
        RecipeManager.addRecipe(new wm(wk.ad), new Object[]{"# #", "# #", Character.valueOf('#'), BTWItems.mail});
        RecipeManager.addRecipe(new wm(BTWItems.paddedHelmet), new Object[]{"###", "# #", Character.valueOf('#'), BTWItems.padding});
        RecipeManager.addRecipe(new wm(BTWItems.paddedChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), BTWItems.padding});
        RecipeManager.addRecipe(new wm(BTWItems.paddedLeggings), new Object[]{"###", "# #", "# #", Character.valueOf('#'), BTWItems.padding});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherHelmet), new Object[]{"###", "# #", Character.valueOf('#'), BTWItems.tannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), BTWItems.tannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherLeggings), new Object[]{"###", "# #", "# #", Character.valueOf('#'), BTWItems.tannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherBoots), new Object[]{"# #", "# #", Character.valueOf('#'), BTWItems.tannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherHelmet), new Object[]{"###", "# #", Character.valueOf('#'), BTWItems.cutTannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), BTWItems.cutTannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherLeggings), new Object[]{"###", "# #", "# #", Character.valueOf('#'), BTWItems.cutTannedLeather});
        RecipeManager.addRecipe(new wm(BTWItems.tannedLeatherBoots), new Object[]{"# #", "# #", Character.valueOf('#'), BTWItems.cutTannedLeather});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.diamondIngot), new Object[]{new wm(wk.p), new wm(wk.o), new wm(BTWItems.creeperOysters)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutLeather, 2), new Object[]{new wm(wk.bf, 1, Short.MAX_VALUE), new wm(wk.aG)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutTannedLeather, 2), new Object[]{new wm(wk.bf, 1, Short.MAX_VALUE), new wm(BTWItems.tannedLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutScouredLeather, 2), new Object[]{new wm(wk.bf, 1, Short.MAX_VALUE), new wm(BTWItems.scouredLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.leatherStrap, 4), new Object[]{new wm(wk.bf, 1, Short.MAX_VALUE), new wm(BTWItems.cutTannedLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(wk.aG)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutTannedLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.tannedLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutScouredLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.scouredLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.leatherStrap, 4), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.cutTannedLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(wk.aG)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutTannedLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.tannedLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.cutScouredLeather, 2), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.scouredLeather)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.leatherStrap, 4), new Object[]{new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE), new wm(BTWItems.cutTannedLeather)});
        RecipeManager.addRecipe(new wm(BTWItems.goldenDung), new Object[]{"ggg", "gDg", "ggg", Character.valueOf('D'), BTWItems.dung, Character.valueOf('g'), wk.br});
        RecipeManager.addRecipe(new wm(BTWItems.redstoneLatch), new Object[]{"ggg", " r ", Character.valueOf('g'), wk.br, Character.valueOf('r'), wk.aD});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.milkChocolateBucket), new Object[]{new wm(wk.aH), new wm(wk.aX, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.stumpRemover, 2), new Object[]{new wm(BTWItems.creeperOysters), new wm(BTWItems.redMushroom), new wm(wk.bn)});
        RecipeManager.addRecipe(new wm(BTWItems.redstoneEye, 2), new Object[]{"###", "GGG", " R ", Character.valueOf('#'), new wm(wk.aX, 1, 4), Character.valueOf('G'), wk.br, Character.valueOf('R'), wk.aD});
        RecipeManager.addRecipe(new wm(wk.bY), new Object[]{" R ", "RER", "SSS", Character.valueOf('E'), BTWItems.redstoneEye, Character.valueOf('S'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('R'), apa.aU});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.corpseEye, 1), new Object[]{new wm(BTWItems.soulUrn), new wm(wk.bo), new wm(BTWItems.rawMysteryMeat)});
    }

    private static void addDyeRecipes() {
        int i2;
        for (i2 = 0; i2 < 15; ++i2) {
            RecipeManager.addShapelessRecipe(new wm(BTWItems.wool, 1, i2), new Object[]{new wm(wk.aX, 1, i2), new wm(BTWItems.wool, 1, 15)});
        }
        RecipeManager.addShapelessRecipe(new wm(BTWItems.candle, 1, 3), new Object[]{new wm(BTWItems.dung), new wm(BTWItems.candle, 1, 16)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.wool, 1, 3), new Object[]{new wm(BTWItems.dung), new wm(BTWItems.wool, 1, 15)});
        for (i2 = 0; i2 < 15; ++i2) {
            RecipeManager.addShapelessRecipe(new wm(BTWItems.candle, 1, i2), new Object[]{new wm(wk.aX, 1, i2), new wm(BTWItems.candle, 1, 16)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.vase, 1, alp.g_(i2)), new Object[]{new wm(wk.aX, 1, i2), new wm(wk.f[BTWBlocks.vase.cz], 1, 0)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.woolSlab, 1, alp.g_(i2)), new Object[]{new wm(wk.aX, 1, i2), new wm(wk.f[BTWBlocks.woolSlab.cz], 1, 0)});
        }
        RecipeManager.addShapelessRecipe(new wm(BTWItems.candle, 1, ColorUtils.WHITE.colorID), new Object[]{new wm(wk.aX, 1, ColorUtils.WHITE.colorID), new wm(BTWItems.candle, 1, 16)});
        RecipeManager.addShapelessRecipe(new wm(apa.af, 1, 12), new Object[]{new wm(BTWItems.dung), new wm(wk.f[apa.af.cz], 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.vase, 1, 12), new Object[]{new wm(BTWItems.dung), new wm(wk.f[BTWBlocks.vase.cz], 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.woolSlab, 1, 12), new Object[]{new wm(BTWItems.dung), new wm(wk.f[BTWBlocks.woolSlab.cz], 1, 0)});
    }

    private static void addAlternateVanillaRecipes() {
        RecipeManager.addRecipe(new wm(apa.ad, 1), new Object[]{"#I#", "XYX", "XZX", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('I'), wk.p, Character.valueOf('X'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('Y'), BTWItems.soulUrn, Character.valueOf('Z'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(apa.bz, 1), new Object[]{"#X#", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(apa.ax, 1), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, 0)});
        RecipeManager.addRecipe(new wm(apa.ca, 1), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, 1)});
        RecipeManager.addRecipe(new wm(apa.cb, 1), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, 2)});
        RecipeManager.addRecipe(new wm(apa.cc, 1), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, 3)});
        RecipeManager.addRecipe(new wm(apa.bB), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.stoneBrickMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(BTWBlocks.midStrataStoneBrickStairs), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.midStrataStoneBrickMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(BTWBlocks.deepStrataStoneBrickStairs), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.deepStrataStoneBrickMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(BTWBlocks.whiteStoneStairs), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.whiteStoneMouldingAndDecroative)});
        RecipeManager.addRecipe(new wm(apa.bG), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.netherBrickMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(apa.bA), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.brickMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(apa.bU), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.sandstoneMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(apa.cw), new Object[]{"# ", "##", Character.valueOf('#'), new wm(BTWBlocks.blackStoneMouldingAndDecorative)});
        RecipeManager.addRecipe(new wm(wk.av, 3), new Object[]{"#", "X", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(wk.aw, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(apa.bo, 1), new Object[]{"WW#", "WW#", Character.valueOf('#'), wk.E, Character.valueOf('W'), apa.B});
        RecipeManager.addRecipe(new wm(apa.bo, 2), new Object[]{"WW#", "WW#", Character.valueOf('#'), wk.E, Character.valueOf('W'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(wk.aF, 1), new Object[]{"# #", "###", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(apa.ar), new Object[]{"###", "XXX", "###", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.aM});
        RecipeManager.addRecipe(new wm(BTWBlocks.chest), new Object[]{"###", "# #", "###", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(wk.aO, 1), new Object[]{"A", "B", Character.valueOf('A'), BTWBlocks.chest, Character.valueOf('B'), wk.aA});
        RecipeManager.addRecipe(new wm(wk.bc, 1), new Object[]{"#X#", "III", Character.valueOf('#'), apa.aU, Character.valueOf('X'), wk.aT, Character.valueOf('I'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.infernalEnchanter), new Object[]{"CBC", "SES", "SSS", Character.valueOf('S'), BTWItems.soulforgedSteelIngot, Character.valueOf('C'), new wm(BTWItems.candle, 1, 0), Character.valueOf('E'), apa.bI, Character.valueOf('B'), wk.aY});
        RecipeManager.addShapelessRecipe(new wm(wk.E), new Object[]{new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(apa.bc, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.o});
        RecipeManager.addRecipe(new wm(apa.V, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('X'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(apa.aq, 1), new Object[]{"GFG", "GBG", "GGG", Character.valueOf('B'), new wm(BTWBlocks.aestheticOpaque, 1, 11), Character.valueOf('G'), wk.N, Character.valueOf('F'), BTWItems.fuse});
        RecipeManager.addShapelessRecipe(new wm(wk.N), new Object[]{new wm(BTWItems.nitre), new wm(BTWItems.brimstone), new wm(BTWItems.coalDust)});
        RecipeManager.addRecipe(new wm(apa.cl, 1), new Object[]{"iii", " i ", "iii", Character.valueOf('i'), wk.p});
        for (int strata = 0; strata < 3; ++strata) {
            RecipeManager.addSoulforgeRecipe(new wm(apa.bq, 12, 3 + (strata << 2)), new Object[]{"####", "#  #", "#  #", "####", Character.valueOf('#'), new wm(apa.bq, 1, strata << 2)});
        }
        RecipeManager.addRecipe(new wm(wk.F, 6), new Object[]{"# #", " # ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(wk.aR, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), BTWItems.ironNugget, Character.valueOf('X'), wk.aD});
        RecipeManager.addRecipe(new wm(wk.aT, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), wk.br, Character.valueOf('X'), wk.ca});
        RecipeManager.addShapelessRecipe(new wm(wk.j, 1), new Object[]{new wm(BTWItems.ironNugget), new wm(wk.aq)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 9), new Object[]{new wm(BTWBlocks.unfiredClay)});
        RecipeManager.addRecipe(new wm(wk.ax, 1), new Object[]{"# #", "# #", "###", Character.valueOf('#'), BTWItems.ironNugget});
        RecipeManager.addShapelessRecipe(new wm(wk.L, 2), new Object[]{new wm(BTWBlocks.web)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.webUntangling, 1, 599), new Object[]{new wm(BTWItems.tangledWeb), new wm(BTWItems.sharpStone)});
        RecipeManager.addShapelessRecipe(new wm(wk.L, 2), new Object[]{new wm(BTWItems.tangledWeb), new wm(wk.bf, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(wk.L, 2), new Object[]{new wm(BTWItems.tangledWeb), new wm(BTWItems.diamondShears, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sinewExtractingBeef, 1, 600), new Object[]{new wm(wk.bj), new wm(wk.bj), new wm(BTWItems.sharpStone)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sinewExtractingBeef, 1, 600), new Object[]{new wm(wk.bk), new wm(wk.bk), new wm(BTWItems.sharpStone)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sinewExtractingWolf, 1, 600), new Object[]{new wm(BTWItems.rawWolfChop), new wm(BTWItems.rawWolfChop), new wm(BTWItems.sharpStone)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.sinewExtractingWolf, 1, 600), new Object[]{new wm(BTWItems.cookedWolfChop), new wm(BTWItems.cookedWolfChop), new wm(BTWItems.sharpStone)});
        RecipeManager.addRecipe(new wm(wk.W), new Object[]{"###", "# #", Character.valueOf('#'), BTWItems.cutLeather});
        RecipeManager.addRecipe(new wm(wk.X), new Object[]{"# #", "###", "###", Character.valueOf('#'), BTWItems.cutLeather});
        RecipeManager.addRecipe(new wm(wk.Y), new Object[]{"###", "# #", "# #", Character.valueOf('#'), BTWItems.cutLeather});
        RecipeManager.addRecipe(new wm(wk.Z), new Object[]{"# #", "# #", Character.valueOf('#'), BTWItems.cutLeather});
        RecipeManager.addShapelessRecipe(new wm(wk.bG, 1), new Object[]{wk.aL, wk.aL, wk.aL, BTWItems.cutLeather, new wm(wk.aX, 1, 0), wk.M});
        RecipeManager.addShapelessRecipe(new wm(wk.bG, 1), new Object[]{wk.aL, wk.aL, wk.aL, wk.aG, new wm(wk.aX, 1, 0), wk.M});
        RecipeManager.addRecipe(new wm(wk.bJ, 1), new Object[]{"mmm", "mlm", "mmm", Character.valueOf('m'), new wm(BTWItems.woodMouldingStubID, 1, Short.MAX_VALUE), Character.valueOf('l'), BTWItems.cutLeather});
        RecipeManager.addRecipe(new wm(wk.bJ, 1), new Object[]{"mmm", "mlm", "mmm", Character.valueOf('m'), wk.E, Character.valueOf('l'), BTWItems.cutLeather});
        RecipeManager.addRecipe(new wm(wk.ai), new Object[]{"XXX", "XYX", Character.valueOf('X'), BTWItems.diamondIngot, Character.valueOf('Y'), BTWItems.diamondArmorPlate});
        RecipeManager.addRecipe(new wm(wk.aj), new Object[]{"Y Y", "XXX", "XXX", Character.valueOf('X'), BTWItems.diamondIngot, Character.valueOf('Y'), BTWItems.diamondArmorPlate});
        RecipeManager.addRecipe(new wm(wk.ak), new Object[]{"XXX", "Y Y", "Y Y", Character.valueOf('X'), BTWItems.diamondIngot, Character.valueOf('Y'), BTWItems.diamondArmorPlate});
        RecipeManager.addRecipe(new wm(wk.al), new Object[]{"X X", "X X", Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(wk.A), new Object[]{"X", "X", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(wk.C), new Object[]{"XXX", " # ", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(wk.B), new Object[]{"X", "#", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addRecipe(new wm(apa.aN, 1), new Object[]{"X", "#", "r", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.E, Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aV, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.stoneSidingAndCorner.cz], 1, 1), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aV, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.midStrataStoneSidingAndCorner.cz], 1, 1), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aV, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.deepStrataStoneSidingAndCorner.cz], 1, 1), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.cj, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(BTWItems.woodCornerStubID, 1, Short.MAX_VALUE), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aO, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.stoneSidingAndCorner.cz], 1, 0), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aO, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.midStrataStoneSidingAndCorner.cz], 1, 0), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aO, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(wk.f[BTWBlocks.deepStrataStoneSidingAndCorner.cz], 1, 0), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(apa.aQ, 1), new Object[]{"#", "r", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE), Character.valueOf('r'), wk.aD});
        RecipeManager.addRecipe(new wm(wk.aC, 1), new Object[]{"##r", "## ", "##r", Character.valueOf('#'), wk.p, Character.valueOf('r'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(apa.T, 1), new Object[]{"###", "#X#", "#R#", Character.valueOf('#'), new wm(BTWItems.stoneBrick, 1, Short.MAX_VALUE), Character.valueOf('X'), wk.l, Character.valueOf('R'), BTWItems.redstoneLatch});
        RecipeManager.addRecipe(new wm(apa.V, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), apa.B, Character.valueOf('X'), BTWItems.redstoneLatch});
        RecipeManager.addShapelessRecipe(new wm(apa.bj, 1), new Object[]{new wm(apa.be), new wm(BTWItems.candle, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(BTWBlocks.unfiredClay, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), wk.aJ});
        RecipeManager.addRecipe(new wm(wk.i), new Object[]{"X ", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.p});
        RecipeManager.addRecipe(new wm(wk.K), new Object[]{"X ", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.q});
        RecipeManager.addRecipe(new wm(wk.D), new Object[]{"X ", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), BTWItems.diamondIngot});
        RecipeManager.addShapelessRecipe(new wm(wk.E, 2), new Object[]{new wm(apa.B, 1, Short.MAX_VALUE)});
        RecipeManager.addRecipe(new wm(wk.bb), new Object[]{"###", "XXX", Character.valueOf('#'), BTWItems.padding, Character.valueOf('X'), new wm(BTWItems.woodSidingStubID, 1, Short.MAX_VALUE)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bedroll), new Object[]{new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(wk.L)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bedroll), new Object[]{new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(BTWItems.hempFibers)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.bedroll), new Object[]{new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(BTWItems.woolKnit, 1, Short.MAX_VALUE), new wm(BTWItems.sinew)});
        RecipeManager.addRecipe(new wm((wk)wk.bP, 1), new Object[]{"#S#", "#X#", "#S#", Character.valueOf('#'), wk.aL, Character.valueOf('X'), wk.aR, Character.valueOf('S'), BTWItems.soulUrn});
        RecipeManager.addRecipe(new wm((wk)wk.bP, 1, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), wk.aL, Character.valueOf('X'), new wm((wk)wk.bP, 1, 0)});
        RecipeManager.addRecipe(new wm((wk)wk.bP, 1, 2), new Object[]{"###", "#X#", "###", Character.valueOf('#'), wk.aL, Character.valueOf('X'), new wm((wk)wk.bP, 1, 1)});
        RecipeManager.addRecipe(new wm((wk)wk.bP, 1, 3), new Object[]{"###", "#X#", "###", Character.valueOf('#'), wk.aL, Character.valueOf('X'), new wm((wk)wk.bP, 1, 2)});
        RecipeManager.addRecipe(new wm((wk)wk.bP, 1, 4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), wk.aL, Character.valueOf('X'), new wm((wk)wk.bP, 1, 3)});
    }

    private static void addConversionRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.hempFibers, 9), new Object[]{new wm(BTWItems.fabric)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.hempFibers, 6), new Object[]{new wm(BTWItems.rope)});
        RecipeManager.addShapelessRecipe(new wm(apa.A), new Object[]{new wm(apa.ao, 1, 3), new wm(apa.ao, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(apa.ap), new Object[]{new wm(apa.ao, 1, 4), new wm(apa.ao, 1, 4)});
        RecipeManager.addShapelessRecipe(new wm(apa.bq), new Object[]{new wm(apa.ao, 1, 5), new wm(apa.ao, 1, 5)});
        RecipeManager.addShapelessRecipe(new wm(apa.bE), new Object[]{new wm(apa.ao, 1, 6), new wm(apa.ao, 1, 6)});
        RecipeManager.removeVanillaRecipe(new wm(apa.ao, 6, 3), new Object[]{"###", Character.valueOf('#'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(apa.ao, 6, 5), new Object[]{"###", Character.valueOf('#'), apa.bq});
        RecipeManager.removeVanillaRecipe(new wm(apa.ao, 6, 0), new Object[]{"###", Character.valueOf('#'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(apa.cf, 6, 0), new Object[]{"###", "###", Character.valueOf('#'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(apa.cf, 6, 1), new Object[]{"###", "###", Character.valueOf('#'), apa.as});
        for (int strata = 0; strata < 3; ++strata) {
            RecipeManager.addRecipe(new wm(BTWBlocks.cobblestoneSlab, 6, strata), new Object[]{"###", Character.valueOf('#'), new wm(apa.A, 1, strata)});
            RecipeManager.addShapelessRecipe(new wm(apa.A, 1, strata), new Object[]{new wm(BTWBlocks.cobblestoneSlab, 1, strata), new wm(BTWBlocks.cobblestoneSlab, 1, strata)});
            RecipeManager.addRecipe(new wm(apa.cf, 6, strata << 2), new Object[]{"###", "###", Character.valueOf('#'), new wm(apa.A, 1, strata)});
            RecipeManager.addRecipe(new wm(apa.cf, 6, (strata << 2) + 1), new Object[]{"###", "###", Character.valueOf('#'), new wm(apa.as, 1, strata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.stoneSlab, 6, strata), new Object[]{"###", Character.valueOf('#'), new wm(apa.x, 1, strata)});
            RecipeManager.addRecipe(new wm(BTWBlocks.stoneBrickSlab, 6, strata), new Object[]{"###", Character.valueOf('#'), new wm(apa.bq, 1, strata << 2)});
            RecipeManager.addShapelessRecipe(new wm(apa.bq, 1, strata << 2), new Object[]{new wm(BTWBlocks.stoneBrickSlab, 1, strata), new wm(BTWBlocks.stoneBrickSlab, 1, strata)});
        }
        for (int iTempWoodType = 0; iTempWoodType < 5; ++iTempWoodType) {
            RecipeManager.addShapelessRecipe(new wm(apa.B, 1, iTempWoodType), new Object[]{new wm(apa.bS, 1, iTempWoodType), new wm(apa.bS, 1, iTempWoodType)});
        }
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 8), new Object[]{new wm(BTWBlocks.unfiredPottery, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 6), new Object[]{new wm(BTWBlocks.unfiredPottery, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 4), new Object[]{new wm(BTWBlocks.unfiredPottery, 1, 2)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 2), new Object[]{new wm(BTWBlocks.unfiredPottery, 1, 3)});
        RecipeManager.addShapelessRecipe(new wm(wk.aJ, 1), new Object[]{new wm(BTWBlocks.unfiredPottery, 1, 4)});
        RecipeManager.addRecipe(new wm(wk.p, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), new wm(BTWItems.ironNugget)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.ironNugget, 9), new Object[]{new wm(wk.p)});
        RecipeManager.addRecipe(new wm(BTWItems.soulforgedSteelIngot, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), new wm(BTWItems.steelNugget)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.steelNugget, 9), new Object[]{new wm(BTWItems.soulforgedSteelIngot)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.soulSandPile, 4), new Object[]{new wm(apa.bg, 1)});
        RecipeManager.addShapelessRecipe(new wm(apa.bg, 1), new Object[]{new wm(BTWItems.soulSandPile), new wm(BTWItems.soulSandPile), new wm(BTWItems.soulSandPile), new wm(BTWItems.soulSandPile)});
        RecipeManager.addShapelessRecipe(new wm(wk.aM, 3), new Object[]{new wm(apa.ar)});
        RecipeManager.addShapelessRecipeWithSecondaryOutputIndicator(new wm(BTWItems.wheatSeeds, 2), new wm(BTWItems.straw), new Object[]{new wm(BTWItems.wheat)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.wheatSeeds), new Object[]{new wm(wk.T)});
    }

    private static void addLogChoppingRecipes() {
        for (int i2 = 0; i2 < 4; ++i2) {
            RecipeManager.addLogChoppingRecipe(new wm(apa.B, 2, i2), new wm[]{new wm(BTWItems.bark, 1, i2), new wm(BTWItems.sawDust, 2, 0)}, new wm(wk.E, 2), new wm[]{new wm(BTWItems.bark, 1, i2), new wm(BTWItems.sawDust, 4, 0)}, new wm(apa.N, 1, i2));
        }
        RecipeManager.addLogChoppingRecipe(new wm(apa.B, 2, 4), new wm[]{new wm(BTWItems.bark, 1, 4), new wm(BTWItems.sawDust, 1, 0), new wm(BTWItems.soulDust, 1, 0)}, new wm(wk.E, 2), new wm[]{new wm(BTWItems.bark, 1, 4), new wm(BTWItems.sawDust, 3, 0), new wm(BTWItems.soulDust, 1, 0)}, new wm(BTWBlocks.bloodWoodLog, 1, 0));
    }

    private static void addTuningForkRecipes() {
        for (int iTempDamage = 0; iTempDamage < 24; ++iTempDamage) {
            RecipeManager.addShapelessRecipe(new wm(BTWItems.tuningFork, 1, iTempDamage + 1), new Object[]{new wm(BTWItems.tuningFork, 1, iTempDamage)});
        }
        RecipeManager.addShapelessRecipe(new wm(BTWItems.tuningFork, 1, 0), new Object[]{new wm(BTWItems.tuningFork, 1, 24)});
    }

    private static void addSubBlockRecipes() {
        CraftingRecipeList.addWoodSubBlockRecipes();
        CraftingRecipeList.addSubBlockRecipesOfType(apa.x, 0, BTWBlocks.stoneSidingAndCorner, BTWBlocks.stoneMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.x, 1, BTWBlocks.midStrataStoneSidingAndCorner, BTWBlocks.midStrataStoneMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.x, 2, BTWBlocks.deepStrataStoneSidingAndCorner, BTWBlocks.deepStrataStoneMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.bq, 0, BTWBlocks.stoneBrickSidingAndCorner, BTWBlocks.stoneBrickMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.bq, 4, BTWBlocks.midStrataStoneBrickSidingAndCorner, BTWBlocks.midStrataStoneBrickMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.bq, 8, BTWBlocks.deepStrataStoneBrickSidingAndCorner, BTWBlocks.deepStrataStoneBrickMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(BTWBlocks.aestheticOpaque, 9, BTWBlocks.whiteStoneSidingAndCorner, BTWBlocks.whiteStoneMouldingAndDecroative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.bE, 0, BTWBlocks.netherBrickSidingAndCorner, BTWBlocks.netherBrickMouldingAndDecorative, false);
        RecipeManager.addRecipe(new wm(apa.bF, 2), new Object[]{"###", Character.valueOf('#'), new wm(BTWBlocks.netherBrickMouldingAndDecorative, 1, 0)});
        CraftingRecipeList.addSubBlockRecipesOfType(apa.ap, 0, BTWBlocks.brickSidingAndCorner, BTWBlocks.brickMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.U, Short.MAX_VALUE, 0, BTWBlocks.sandstoneSidingAndCorner, BTWBlocks.sandstoneMouldingAndDecorative, true);
        CraftingRecipeList.addSubBlockRecipesOfType(apa.cv, 0, BTWBlocks.blackStoneSidingAndCorner, BTWBlocks.blackStoneMouldingAndDecorative, true);
    }

    public static void addSubBlockRecipesOfType(apa fullBlock, int iFullBlockMetadata, apa sidingAndCornerBlock, apa mouldingBlock, boolean bIncludeFence) {
        CraftingRecipeList.addSubBlockRecipesOfType(fullBlock, iFullBlockMetadata, iFullBlockMetadata, sidingAndCornerBlock, mouldingBlock, bIncludeFence);
    }

    public static void addSubBlockRecipesOfType(apa fullBlock, int iFullBlockInputMetadata, int iFullBlockOutputMetadata, apa sidingAndCornerBlock, apa mouldingBlock, boolean bIncludeFence) {
        RecipeManager.addSoulforgeRecipe(new wm(sidingAndCornerBlock, 8, 0), new Object[]{"####", Character.valueOf('#'), new wm(fullBlock, 1, iFullBlockInputMetadata)});
        RecipeManager.addSoulforgeRecipe(new wm(mouldingBlock, 8, 0), new Object[]{"####", Character.valueOf('#'), new wm(sidingAndCornerBlock, 1, 0)});
        RecipeManager.addSoulforgeRecipe(new wm(sidingAndCornerBlock, 8, 1), new Object[]{"####", Character.valueOf('#'), new wm(mouldingBlock, 1, 0)});
        RecipeManager.addRecipe(new wm(mouldingBlock, 1, 12), new Object[]{"M", "M", "M", Character.valueOf('M'), new wm(mouldingBlock, 1, 0)});
        RecipeManager.addRecipe(new wm(mouldingBlock, 6, 13), new Object[]{" S ", "###", "###", Character.valueOf('#'), new wm(fullBlock, 1, iFullBlockInputMetadata), Character.valueOf('S'), new wm(sidingAndCornerBlock, 8, 0)});
        RecipeManager.addRecipe(new wm(mouldingBlock, 4, 15), new Object[]{"###", " X ", " X ", Character.valueOf('#'), new wm(sidingAndCornerBlock, 1, 0), Character.valueOf('X'), new wm(mouldingBlock, 1, 0)});
        RecipeManager.addRecipe(new wm(sidingAndCornerBlock, 4, 12), new Object[]{"###", " X ", Character.valueOf('#'), new wm(sidingAndCornerBlock, 1, 0), Character.valueOf('X'), new wm(mouldingBlock, 1, 0)});
        if (bIncludeFence) {
            RecipeManager.addRecipe(new wm(sidingAndCornerBlock, 6, 14), new Object[]{"###", "###", Character.valueOf('#'), new wm(fullBlock, 1, iFullBlockInputMetadata)});
            RecipeManager.addRecipe(new wm(sidingAndCornerBlock, 2, 14), new Object[]{"###", Character.valueOf('#'), new wm(mouldingBlock, 1, 0)});
        }
        RecipeManager.addShapelessRecipe(new wm(fullBlock, 1, iFullBlockOutputMetadata), new Object[]{new wm(sidingAndCornerBlock, 1, 0), new wm(sidingAndCornerBlock, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(sidingAndCornerBlock, 1, 0), new Object[]{new wm(mouldingBlock, 1, 0), new wm(mouldingBlock, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(mouldingBlock, 1, 0), new Object[]{new wm(sidingAndCornerBlock, 1, 1), new wm(sidingAndCornerBlock, 1, 1)});
    }

    private static void addLegacyConversionRecipes() {
        RecipeManager.addShapelessRecipe(new wm(BTWItems.woodMouldingDecorativeStubID, 1, 8), new Object[]{new wm(BTWBlocks.aestheticNonOpaque, 1, 4)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.stoneMouldingAndDecorative, 1, 13), new Object[]{new wm(BTWBlocks.aestheticNonOpaque, 1, 2)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.stoneMouldingAndDecorative, 1, 12), new Object[]{new wm(BTWBlocks.aestheticNonOpaque, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.woodMouldingStubID, 1, 0), new Object[]{new wm(BTWBlocks.oakWoodMouldingAndDecorative)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.stoneSidingAndCorner, 1, 1), new Object[]{new wm(BTWBlocks.legacyStoneAndOakCorner, 1, 8)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.woodCornerStubID, 1, 0), new Object[]{new wm(BTWBlocks.legacyStoneAndOakCorner, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.stoneSidingAndCorner, 1, 0), new Object[]{new wm(BTWBlocks.legacyStoneAndOakSiding, 1, 0)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.woodSidingStubID, 1, 0), new Object[]{new wm(BTWBlocks.legacyStoneAndOakSiding, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.aestheticEarth, 1, 7), new Object[]{new wm(BTWBlocks.aestheticOpaque, 1, 1)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.brownMushroom), new Object[]{new wm(apa.aj)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.redMushroom), new Object[]{new wm(apa.ak)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.workbench), new Object[]{new wm(apa.aC)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.chest), new Object[]{new wm((apa)((Object)apa.ay))});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.web), new Object[]{new wm(apa.aa)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.ladder), new Object[]{new wm(apa.aJ)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.solidSnow), new Object[]{new wm(apa.aY)});
        RecipeManager.addShapelessRecipe(new wm(BTWItems.carrot), new Object[]{new wm(wk.bL)});
        RecipeManager.addShapelessRecipe(new wm(BTWBlocks.grassSlab), new Object[]{new wm(BTWBlocks.dirtSlab, 1, 1)});
        for (int i2 = 0; i2 < 4; ++i2) {
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.oakSapling), new Object[]{new wm(apa.C, 1, i2 << 2)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.spruceSapling), new Object[]{new wm(apa.C, 1, 1 | i2 << 2)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.birchSapling), new Object[]{new wm(apa.C, 1, 2 | i2 << 2)});
            RecipeManager.addShapelessRecipe(new wm(BTWBlocks.jungleSapling), new Object[]{new wm(apa.C, 1, 3 | i2 << 2)});
        }
    }

    private static void addCustomRecipeClasses() {
        yk.a().b().add(new FishingRodBaitingRecipe());
        yk.a().b().add(new KnittingRecipe());
    }

    private static void addWoodSubBlockRecipes() {
        for (int iWoodType = 0; iWoodType <= 4; ++iWoodType) {
            RecipeManager.addRecipe(new wm(BTWItems.woodMouldingDecorativeStubID, 6, WoodMouldingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 1)), new Object[]{" S ", "###", "###", Character.valueOf('#'), new wm(apa.B, 1, iWoodType), Character.valueOf('S'), new wm(BTWItems.woodSidingStubID, 1, iWoodType)});
            RecipeManager.addRecipe(new wm(BTWItems.woodMouldingDecorativeStubID, 1, WoodMouldingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 0)), new Object[]{"M", "M", "M", Character.valueOf('M'), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            RecipeManager.addRecipe(new wm(BTWItems.woodMouldingDecorativeStubID, 4, WoodMouldingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 2)), new Object[]{"###", " X ", " X ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, iWoodType), Character.valueOf('X'), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            RecipeManager.addRecipe(new wm(BTWItems.woodSidingDecorativeStubID, 4, WoodSidingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 0)), new Object[]{"###", " X ", Character.valueOf('#'), new wm(BTWItems.woodSidingStubID, 1, iWoodType), Character.valueOf('X'), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            if (iWoodType == 0) {
                RecipeManager.addRecipe(new wm(apa.bd, 6), new Object[]{"###", "###", Character.valueOf('#'), new wm(apa.B, 1, iWoodType)});
                RecipeManager.addRecipe(new wm(apa.bd, 2), new Object[]{"###", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            } else {
                RecipeManager.addRecipe(new wm(BTWItems.woodSidingDecorativeStubID, 6, WoodSidingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 1)), new Object[]{"###", "###", Character.valueOf('#'), new wm(apa.B, 1, iWoodType)});
                RecipeManager.addRecipe(new wm(BTWItems.woodSidingDecorativeStubID, 2, WoodSidingDecorativeStubBlockItem.getItemDamageForType(iWoodType, 1)), new Object[]{"###", Character.valueOf('#'), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            }
            RecipeManager.addShapelessRecipe(new wm(apa.B, 1, iWoodType), new Object[]{new wm(BTWItems.woodSidingStubID, 1, iWoodType), new wm(BTWItems.woodSidingStubID, 1, iWoodType)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.woodSidingStubID, 1, iWoodType), new Object[]{new wm(BTWItems.woodMouldingStubID, 1, iWoodType), new wm(BTWItems.woodMouldingStubID, 1, iWoodType)});
            RecipeManager.addShapelessRecipe(new wm(BTWItems.woodMouldingStubID, 1, iWoodType), new Object[]{new wm(BTWItems.woodCornerStubID, 1, iWoodType), new wm(BTWItems.woodCornerStubID, 1, iWoodType)});
        }
    }

    private static void removeVanillaRecipes() {
        RecipeManager.removeVanillaRecipe(new wm(wk.V, 1), new Object[]{"###", Character.valueOf('#'), wk.U});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.aX, 3, 15), new Object[]{wk.aY});
        RecipeManager.removeVanillaRecipe(new wm(wk.aZ, 1), new Object[]{"#", Character.valueOf('#'), wk.aK});
        RecipeManager.removeVanillaRecipe(new wm(wk.ba, 1), new Object[]{"AAA", "BEB", "CCC", Character.valueOf('A'), wk.aH, Character.valueOf('B'), wk.aZ, Character.valueOf('C'), wk.U, Character.valueOf('E'), wk.aQ});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.aX, 2, 11), new Object[]{apa.ah});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.aX, 2, 1), new Object[]{apa.ai});
        RecipeManager.removeVanillaRecipe(new wm(apa.aq, 1), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('X'), wk.N, Character.valueOf('#'), apa.I});
        RecipeManager.removeVanillaRecipe(new wm(wk.bd, 8), new Object[]{"#X#", Character.valueOf('X'), new wm(wk.aX, 1, 3), Character.valueOf('#'), wk.U});
        RecipeManager.removeVanillaRecipe(new wm(apa.cl, 1), new Object[]{"III", " i ", "iii", Character.valueOf('I'), apa.am, Character.valueOf('i'), wk.p});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.G), new Object[]{apa.aj, apa.ak, wk.F});
        RecipeManager.removeVanillaRecipe(new wm(apa.bv), new Object[]{"MMM", "MMM", "MMM", Character.valueOf('M'), wk.bg});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.bU), new Object[]{apa.be, wk.aZ, wk.aQ});
        RecipeManager.removeVanillaRecipe(new wm(wk.bh, 4), new Object[]{"M", Character.valueOf('M'), apa.be});
        RecipeManager.removeVanillaRecipe(new wm(wk.aR, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), wk.p, Character.valueOf('X'), wk.aD});
        RecipeManager.removeVanillaRecipe(new wm(wk.aT, 1), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), wk.q, Character.valueOf('X'), wk.aD});
        RecipeManager.removeVanillaRecipe(new wm(wk.j, 1), new Object[]{"A ", " B", Character.valueOf('A'), wk.p, Character.valueOf('B'), wk.aq});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.bw), new Object[]{wk.bv, apa.aj, wk.aZ});
        RecipeManager.removeVanillaRecipe(new wm(apa.au, 4), new Object[]{"X", "#", Character.valueOf('X'), wk.n, Character.valueOf('#'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.au, 4), new Object[]{"X", "#", Character.valueOf('X'), new wm(wk.n, 1, 1), Character.valueOf('#'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(wk.ax, 1), new Object[]{"# #", " # ", Character.valueOf('#'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm(wk.bc, 1), new Object[]{"#X#", "III", Character.valueOf('#'), apa.aU, Character.valueOf('X'), wk.aD, Character.valueOf('I'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(apa.aW, 6), new Object[]{"###", Character.valueOf('#'), apa.aY});
        RecipeManager.removeVanillaRecipe(new wm(apa.cy, 1), new Object[]{"###", "# #", "#R#", Character.valueOf('#'), apa.A, Character.valueOf('R'), wk.aD});
        RecipeManager.removeVanillaRecipe(new wm(apa.aV, 1), new Object[]{"#", Character.valueOf('#'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(apa.cj, 1), new Object[]{"#", Character.valueOf('#'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(apa.aO, 1), new Object[]{"##", Character.valueOf('#'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(apa.aQ, 1), new Object[]{"##", Character.valueOf('#'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(apa.co, 1), new Object[]{"##", Character.valueOf('#'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm(apa.cn, 1), new Object[]{"##", Character.valueOf('#'), wk.q});
        RecipeManager.removeVanillaRecipe(new wm((apa)((Object)apa.cr)), new Object[]{"GGG", "QQQ", "WWW", Character.valueOf('G'), apa.Q, Character.valueOf('Q'), wk.ca, Character.valueOf('W'), apa.bS});
        RecipeManager.removeVanillaRecipe(new wm((apa)((Object)apa.cu)), new Object[]{"I I", "ICI", " I ", Character.valueOf('I'), wk.p, Character.valueOf('C'), apa.ay});
        RecipeManager.removeVanillaRecipe(new wm(apa.aK, 16), new Object[]{"X X", "XSX", "X X", Character.valueOf('X'), wk.p, Character.valueOf('S'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.X, 6), new Object[]{"X X", "XSX", "XRX", Character.valueOf('X'), wk.q, Character.valueOf('R'), wk.aD, Character.valueOf('S'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.Y, 6), new Object[]{"X X", "XSX", "XRX", Character.valueOf('X'), wk.p, Character.valueOf('R'), wk.aD, Character.valueOf('S'), apa.aO});
        RecipeManager.removeVanillaRecipe(new wm(apa.cx, 6), new Object[]{"XSX", "X#X", "XSX", Character.valueOf('X'), wk.p, Character.valueOf('#'), apa.aU, Character.valueOf('S'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(wk.bY, 1), new Object[]{" # ", "#X#", "III", Character.valueOf('#'), apa.aU, Character.valueOf('X'), wk.ca, Character.valueOf('I'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(wk.cb, 1), new Object[]{"A", "B", Character.valueOf('A'), apa.aq, Character.valueOf('B'), wk.aA});
        RecipeManager.removeVanillaRecipe(new wm(wk.cc, 1), new Object[]{"A", "B", Character.valueOf('A'), apa.cu, Character.valueOf('B'), wk.aA});
        RecipeManager.removeVanillaRecipe(new wm(apa.cm), new Object[]{"#-", Character.valueOf('#'), apa.ay, Character.valueOf('-'), apa.bX});
        RecipeManager.removeVanillaRecipe(new wm(wk.ai), new Object[]{"XXX", "X X", Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.aj), new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.ak), new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.al), new Object[]{"X X", "X X", Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.A), new Object[]{"X", "X", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.C), new Object[]{"XXX", " # ", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.B), new Object[]{"X", "#", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.R), new Object[]{"XX", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.aS, 1), new Object[]{"  #", " #X", "# X", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.L});
        RecipeManager.removeVanillaRecipe(new wm(apa.af, 1), new Object[]{"##", "##", Character.valueOf('#'), wk.L});
        RecipeManager.removeVanillaRecipe(new wm(apa.B, 4, 0), new Object[]{"#", Character.valueOf('#'), new wm(apa.N, 1, 0)});
        RecipeManager.removeVanillaRecipe(new wm(apa.B, 4, 1), new Object[]{"#", Character.valueOf('#'), new wm(apa.N, 1, 1)});
        RecipeManager.removeVanillaRecipe(new wm(apa.B, 4, 2), new Object[]{"#", Character.valueOf('#'), new wm(apa.N, 1, 2)});
        RecipeManager.removeVanillaRecipe(new wm(apa.B, 4, 3), new Object[]{"#", Character.valueOf('#'), new wm(apa.N, 1, 3)});
        RecipeManager.removeVanillaRecipe(new wm(apa.aN, 1), new Object[]{"X", "#", Character.valueOf('#'), apa.A, Character.valueOf('X'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(wk.aC, 1), new Object[]{"##", "##", "##", Character.valueOf('#'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm((apa)apa.bX, 2), new Object[]{"I", "S", "#", Character.valueOf('#'), apa.B, Character.valueOf('S'), wk.E, Character.valueOf('I'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm(apa.T, 1), new Object[]{"###", "#X#", "#R#", Character.valueOf('#'), apa.A, Character.valueOf('X'), wk.l, Character.valueOf('R'), wk.aD});
        RecipeManager.removeVanillaRecipe(new wm(apa.V, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), apa.B, Character.valueOf('X'), wk.aD});
        RecipeManager.removeVanillaRecipe(new wm(apa.bI, 1), new Object[]{" B ", "D#D", "###", Character.valueOf('#'), apa.at, Character.valueOf('B'), wk.aM, Character.valueOf('D'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.s), new Object[]{"X", "X", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.v), new Object[]{"XX", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.u), new Object[]{"XXX", " # ", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.t), new Object[]{"X", "#", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.O), new Object[]{"XX", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.w), new Object[]{"X", "X", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(wk.z), new Object[]{"XX", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(wk.y), new Object[]{"XXX", " # ", " # ", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(wk.x), new Object[]{"X", "#", "#", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(wk.P), new Object[]{"XX", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(wk.i), new Object[]{"XX", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm(wk.Q), new Object[]{"XX", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.p});
        RecipeManager.removeVanillaRecipe(new wm(wk.K), new Object[]{"XX", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.q});
        RecipeManager.removeVanillaRecipe(new wm(wk.S), new Object[]{"XX", " #", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.q});
        RecipeManager.removeVanillaRecipe(new wm(wk.D), new Object[]{"XX", "X#", " #", Character.valueOf('#'), wk.E, Character.valueOf('X'), wk.o});
        RecipeManager.removeVanillaRecipe(new wm(wk.m, 4), new Object[]{"X", "#", "Y", Character.valueOf('Y'), wk.M, Character.valueOf('X'), wk.aq, Character.valueOf('#'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.ad, 1), new Object[]{"TTT", "#X#", "#R#", Character.valueOf('#'), apa.A, Character.valueOf('X'), wk.p, Character.valueOf('R'), wk.aD, Character.valueOf('T'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(wk.bz, 1), new Object[]{" B ", "###", Character.valueOf('#'), apa.A, Character.valueOf('B'), wk.bp});
        RecipeManager.removeVanillaRecipe(new wm((wk)wk.bP, 1), new Object[]{"###", "#X#", "###", Character.valueOf('#'), wk.aL, Character.valueOf('X'), wk.aR});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.bB, 1), new Object[]{wk.bo, wk.bx});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.bx, 2), new Object[]{wk.bp});
        RecipeManager.removeVanillaRecipe(new wm(wk.bb, 1), new Object[]{"###", "XXX", Character.valueOf('#'), apa.af, Character.valueOf('X'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(apa.bd, 2), new Object[]{"###", "###", Character.valueOf('#'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.bo, 2), new Object[]{"###", "###", Character.valueOf('#'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm(apa.bj, 1), new Object[]{"A", "B", Character.valueOf('A'), apa.be, Character.valueOf('B'), apa.au});
        RecipeManager.removeVanillaRecipe(new wm(apa.ba, 1), new Object[]{"##", "##", Character.valueOf('#'), wk.aJ});
        RecipeManager.removeVanillaRecipe(new wm(apa.ap, 1), new Object[]{"##", "##", Character.valueOf('#'), wk.aI});
        RecipeManager.removeVanillaRecipe(new wm(apa.aJ, 3), new Object[]{"# #", "###", "# #", Character.valueOf('#'), wk.E});
        RecipeManager.removeVanillaRecipe(new wm(apa.aF), new Object[]{"###", "# #", "###", Character.valueOf('#'), apa.A});
        RecipeManager.removeVanillaRecipe(new wm(apa.U), new Object[]{"##", "##", Character.valueOf('#'), apa.I});
        RecipeManager.removeVanillaRecipe(new wm(apa.aY, 1), new Object[]{"##", "##", Character.valueOf('#'), wk.aE});
        RecipeManager.removeVanillaRecipe(new wm(apa.ax, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 0)});
        RecipeManager.removeVanillaRecipe(new wm(apa.cb, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 2)});
        RecipeManager.removeVanillaRecipe(new wm(apa.ca, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 1)});
        RecipeManager.removeVanillaRecipe(new wm(apa.cc, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.B, 1, 3)});
        RecipeManager.removeVanillaRecipe(new wm(apa.bA, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.ap)});
        RecipeManager.removeVanillaRecipe(new wm(apa.aL, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.A)});
        RecipeManager.removeVanillaRecipe(new wm(apa.bG, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bE)});
        RecipeManager.removeVanillaRecipe(new wm(apa.cw, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.cv)});
        RecipeManager.removeVanillaRecipe(new wm(apa.bU, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.U)});
        RecipeManager.removeVanillaRecipe(new wm(apa.bB, 4), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), new wm(apa.bq)});
        RecipeManager.removeVanillaRecipe(new wm(apa.aC), new Object[]{"##", "##", Character.valueOf('#'), apa.B});
        RecipeManager.removeVanillaRecipe(new wm((apa)((Object)apa.ay)), new Object[]{"###", "# #", "###", Character.valueOf('#'), apa.B});
        RecipeManager.removeVanillaShapelessRecipe(new wm(wk.aM, 1), new Object[]{wk.aL, wk.aL, wk.aL, wk.aG});
        RecipeManager.removeVanillaRecipe(new wm(apa.bq, 4), new Object[]{"##", "##", Character.valueOf('#'), apa.x});
        RecipeManager.removeVanillaRecipe(new wm(wk.bS, 1), new Object[]{"# ", " X", Character.valueOf('#'), wk.aS, Character.valueOf('X'), wk.bL});
    }

    private static void addDebugRecipes() {
    }
}

