/*
 * Decompiled with CFR 0.152.
 */
package btw.crafting.manager;

import btw.crafting.recipe.types.BulkRecipe;
import java.util.ArrayList;
import java.util.List;

public abstract class BulkCraftingManager {
    private List<BulkRecipe> recipes = new ArrayList<BulkRecipe>();

    protected BulkCraftingManager() {
    }

    public void addRecipe(wm outputStack, wm[] inputStacks) {
        this.addRecipe(outputStack, inputStacks, false);
    }

    public void addRecipe(wm outputStack, wm inputStack) {
        this.addRecipe(outputStack, inputStack, false);
    }

    public void addRecipe(wm[] outputStacks, wm[] inputStacks) {
        this.addRecipe(outputStacks, inputStacks, false);
    }

    public void addRecipe(wm outputStack, wm[] inputStacks, boolean bMetadataExclusive) {
        wm[] outputStacks = new wm[]{outputStack.m()};
        this.addRecipe(outputStacks, inputStacks, bMetadataExclusive);
    }

    public void addRecipe(wm outputStack, wm inputStack, boolean bMetadataExclusive) {
        wm[] outputStacks = new wm[]{outputStack.m()};
        wm[] inputStacks = new wm[]{inputStack.m()};
        this.addRecipe(outputStacks, inputStacks, bMetadataExclusive);
    }

    public void addRecipe(wm[] outputStacks, wm[] inputStacks, boolean bMetadataExclusive) {
        BulkRecipe recipe = this.createRecipe(outputStacks, inputStacks, bMetadataExclusive);
        this.recipes.add(recipe);
    }

    public boolean removeRecipe(wm outputStack, wm[] inputStacks) {
        return this.removeRecipe(outputStack, inputStacks, false);
    }

    public boolean removeRecipe(wm outputStack, wm inputStack) {
        return this.removeRecipe(outputStack, inputStack, false);
    }

    public boolean removeRecipe(wm[] outputStacks, wm[] inputStacks) {
        return this.removeRecipe(outputStacks, inputStacks, false);
    }

    public boolean removeRecipe(wm outputStack, wm[] inputStacks, boolean bMetadataExclusive) {
        wm[] outputStacks = new wm[]{outputStack.m()};
        return this.removeRecipe(outputStacks, inputStacks, bMetadataExclusive);
    }

    public boolean removeRecipe(wm outputStack, wm inputStack, boolean bMetadataExclusive) {
        wm[] outputStacks = new wm[]{outputStack.m()};
        wm[] inputStacks = new wm[]{inputStack.m()};
        return this.removeRecipe(outputStacks, inputStacks, bMetadataExclusive);
    }

    public boolean removeRecipe(wm[] outputStacks, wm[] inputStacks, boolean bMetadataExclusive) {
        BulkRecipe recipe = this.createRecipe(outputStacks, inputStacks, bMetadataExclusive);
        int iMatchingIndex = this.getMatchingRecipeIndex(recipe);
        if (iMatchingIndex >= 0) {
            this.recipes.remove(iMatchingIndex);
            return true;
        }
        return false;
    }

    public List<wm> getCraftingResult(lt inventory) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            BulkRecipe tempRecipe = this.recipes.get(i2);
            if (!tempRecipe.doesInventoryContainIngredients(inventory)) continue;
            return tempRecipe.getCraftingOutputList();
        }
        return null;
    }

    public List<wm> getCraftingResult(wm inputStack) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            BulkRecipe tempRecipe = this.recipes.get(i2);
            if (!tempRecipe.doesStackSatisfyIngredients(inputStack)) continue;
            return tempRecipe.getCraftingOutputList();
        }
        return null;
    }

    public List<wm> getValidCraftingIngrediants(lt inventory) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            BulkRecipe tempRecipe = this.recipes.get(i2);
            if (!tempRecipe.doesInventoryContainIngredients(inventory)) continue;
            return tempRecipe.getCraftingIngrediantList();
        }
        return null;
    }

    public wm getValidSingleIngredient(wm inputStack) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            BulkRecipe tempRecipe = this.recipes.get(i2);
            if (!tempRecipe.doesStackSatisfyIngredients(inputStack)) continue;
            return tempRecipe.getFirstIngredient();
        }
        return null;
    }

    public boolean hasRecipeForSingleIngredient(wm inputStack) {
        return this.getValidSingleIngredient(inputStack) != null;
    }

    public List<wm> consumeIngredientsAndReturnResult(lt inventory) {
        for (int i2 = 0; i2 < this.recipes.size(); ++i2) {
            BulkRecipe tempRecipe = this.recipes.get(i2);
            if (!tempRecipe.doesInventoryContainIngredients(inventory)) continue;
            tempRecipe.consumeInventoryIngredients(inventory);
            return tempRecipe.getCraftingOutputList();
        }
        return null;
    }

    private BulkRecipe createRecipe(wm[] outputStacks, wm[] inputStacks, boolean bMetadataExclusive) {
        ArrayList<wm> inputArrayList = new ArrayList<wm>();
        int iInputStacksArrayLength = inputStacks.length;
        for (int iTempIndex = 0; iTempIndex < iInputStacksArrayLength; ++iTempIndex) {
            inputArrayList.add(inputStacks[iTempIndex].m());
        }
        ArrayList<wm> outputArrayList = new ArrayList<wm>();
        int iOutputStacksArrayLength = outputStacks.length;
        for (int iTempIndex = 0; iTempIndex < iOutputStacksArrayLength; ++iTempIndex) {
            outputArrayList.add(outputStacks[iTempIndex].m());
        }
        return new BulkRecipe(outputArrayList, inputArrayList, bMetadataExclusive);
    }

    private int getMatchingRecipeIndex(BulkRecipe recipe) {
        int iMatchingRecipeIndex = -1;
        for (int iIndex = 0; iIndex < this.recipes.size(); ++iIndex) {
            BulkRecipe tempRecipe = this.recipes.get(iIndex);
            if (!tempRecipe.matches(recipe)) continue;
            return iIndex;
        }
        return -1;
    }
}

