/*
 * Decompiled with CFR 0.152.
 */
package btw.client.texture;

import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FireAnimation {
    public static FireAnimation[] instanceArray = new FireAnimation[]{null, null};
    public int width;
    public int height;
    public int textureHeight;
    public int size;
    protected float[] previousIntensities;
    protected float[] currentIntensities;
    private float intensityDecayFactor;
    private float intensityDecayFactorTop;
    private double distanceFromCenterIntensityModifier;
    private int centerRow;
    public static final float COLOR_SHIFT_SEPARATOR_BLUE_TO_WHITE = 0.39f;
    public static final float COLOR_SHIFT_SEPARATOR_WHITE_TO_RED = 0.66f;
    public static final float INVISIBLE_PIXEL_THRESHOLD_TOP = 0.87f;
    public static final float INVISIBLE_PIXEL_THRESHOLD_BOTTOM = 0.001f;

    public FireAnimation(int iInstanceIndex, int iTextureWidth, int iTextureHeight) {
        this.width = iTextureWidth;
        this.height = iTextureHeight * 2;
        this.textureHeight = iTextureHeight;
        this.size = this.width * this.height;
        this.previousIntensities = new float[this.size];
        this.currentIntensities = new float[this.size];
        for (int iTempIndex = 0; iTempIndex < this.size; ++iTempIndex) {
            this.previousIntensities[iTempIndex] = 0.0f;
            this.currentIntensities[iTempIndex] = 0.0f;
        }
        this.intensityDecayFactor = 1.0f + 0.08f * (16.0f / (float)this.textureHeight);
        this.intensityDecayFactorTop = 1.0f + 0.07f * (16.0f / (float)this.textureHeight);
        this.distanceFromCenterIntensityModifier = 0.123 * (16.0 / (double)this.width);
        this.centerRow = this.width / 2;
        FireAnimation.instanceArray[iInstanceIndex] = this;
    }

    public void update() {
        this.driftFireUpwards();
        this.generateNewBottomRow();
        this.previousIntensities = this.currentIntensities;
    }

    private void generateNewBottomRow() {
        for (int i2 = 0; i2 < this.width; ++i2) {
            double dDistFromCenter = this.centerRow - Math.abs(i2 - (this.centerRow - 1));
            double dBaseIntensity = Math.random() * Math.random() * Math.random() * 4.0 + Math.random() * (double)0.1f + 0.2;
            double dDistanceFromCenterModifier = dDistFromCenter * this.distanceFromCenterIntensityModifier;
            dDistanceFromCenterModifier *= dDistanceFromCenterModifier;
            this.currentIntensities[i2 + (this.height - 1) * this.width] = (float)(dBaseIntensity + dDistanceFromCenterModifier);
        }
    }

    private void driftFireUpwards() {
        for (int i2 = 0; i2 < this.width; ++i2) {
            for (int j2 = 0; j2 < this.height - 1; ++j2) {
                int iTotalWeight = 18;
                float fNewIntensity = this.previousIntensities[i2 + (j2 + 1) * this.width] * (float)iTotalWeight;
                for (int iTempI = i2 - 1; iTempI <= i2 + 1; ++iTempI) {
                    for (int iTempJ = j2; iTempJ <= j2 + 1; ++iTempJ) {
                        if (iTempI >= 0 && iTempJ >= 0 && iTempI < this.width && iTempJ < this.height) {
                            fNewIntensity += this.previousIntensities[iTempI + iTempJ * this.width];
                        }
                        ++iTotalWeight;
                    }
                }
                fNewIntensity = j2 < this.textureHeight ? (fNewIntensity /= (float)iTotalWeight * this.intensityDecayFactorTop) : (fNewIntensity /= (float)iTotalWeight * this.intensityDecayFactor);
                this.currentIntensities[i2 + j2 * this.width] = fNewIntensity;
            }
        }
    }

    public void copyRegularFireFrameToByteBuffer(ByteBuffer m_frameBuffer, int m_iBufferPixelSize) {
        for (int iPixelIndex = 0; iPixelIndex < m_iBufferPixelSize; ++iPixelIndex) {
            float iPixelIntensity = this.currentIntensities[iPixelIndex];
            if (iPixelIntensity > 1.0f) {
                iPixelIntensity = 1.0f;
            } else if (iPixelIntensity < 0.0f) {
                iPixelIntensity = 0.0f;
            }
            float fColorMultiplier = 1.0f - iPixelIntensity;
            int iRed = 0;
            int iGreen = 0;
            int iBlue = 0;
            int cAlpha = 255;
            if (fColorMultiplier > 0.87f || fColorMultiplier < 0.001f) {
                cAlpha = 0;
            } else if (fColorMultiplier < 0.39f) {
                float fFactor = fColorMultiplier / 0.39f;
                float fFactorSquared = fFactor * fFactor;
                iRed = (int)(fFactorSquared * 255.0f);
                iGreen = (int)(fFactorSquared * 255.0f);
                iBlue = (int)(fFactor * 100.0f) + 155;
            } else if (fColorMultiplier < 0.66f) {
                iRed = 255;
                iGreen = 255;
                iBlue = 255;
            } else {
                float fDelta = 1.0f - (fColorMultiplier - 0.66f) / 0.33999997f;
                iRed = (int)(fDelta * 120.0f) + 135;
                float fDeltaSquared = fDelta * fDelta;
                iGreen = (int)(fDeltaSquared * 225.0f) + 30;
                float fBlueMultiplier = fDeltaSquared * fDeltaSquared;
                fBlueMultiplier *= fBlueMultiplier;
                iBlue = (int)(fBlueMultiplier * 255.0f);
            }
            m_frameBuffer.put(iPixelIndex * 4 + 0, (byte)iRed);
            m_frameBuffer.put(iPixelIndex * 4 + 1, (byte)iGreen);
            m_frameBuffer.put(iPixelIndex * 4 + 2, (byte)iBlue);
            m_frameBuffer.put(iPixelIndex * 4 + 3, (byte)cAlpha);
        }
    }

    public void copyStokedFireFrameToByteBuffer(ByteBuffer m_frameBuffer, int m_iBufferPixelSize) {
        for (int iPixelIndex = 0; iPixelIndex < m_iBufferPixelSize; ++iPixelIndex) {
            float iPixelIntensity = this.currentIntensities[iPixelIndex + this.textureHeight * this.width];
            if (iPixelIntensity > 1.0f) {
                iPixelIntensity = 1.0f;
            } else if (iPixelIntensity < 0.0f) {
                iPixelIntensity = 0.0f;
            }
            float fColorMultiplier = 1.0f - iPixelIntensity;
            int iRed = 0;
            int iGreen = 0;
            int iBlue = 0;
            int cAlpha = 255;
            if (fColorMultiplier > 0.87f || fColorMultiplier < 0.001f) {
                cAlpha = 0;
            } else if (fColorMultiplier < 0.39f) {
                float fFactor = fColorMultiplier / 0.39f;
                float fFactorSquared = fFactor * fFactor;
                iRed = (int)(fFactorSquared * 255.0f);
                iGreen = (int)(fFactorSquared * 255.0f);
                iBlue = (int)(fFactor * 100.0f) + 155;
            } else if (fColorMultiplier < 0.66f) {
                iRed = 255;
                iGreen = 255;
                iBlue = 255;
            } else {
                float fDelta = 1.0f - (fColorMultiplier - 0.66f) / 0.33999997f;
                iRed = (int)(fDelta * 120.0f) + 135;
                float fDeltaSquared = fDelta * fDelta;
                iGreen = (int)(fDeltaSquared * 225.0f) + 30;
                float fBlueMultiplier = fDeltaSquared * fDeltaSquared;
                fBlueMultiplier *= fBlueMultiplier;
                iBlue = (int)(fBlueMultiplier * 255.0f);
            }
            m_frameBuffer.put(iPixelIndex * 4 + 0, (byte)iRed);
            m_frameBuffer.put(iPixelIndex * 4 + 1, (byte)iGreen);
            m_frameBuffer.put(iPixelIndex * 4 + 2, (byte)iBlue);
            m_frameBuffer.put(iPixelIndex * 4 + 3, (byte)cAlpha);
        }
    }

    public static void updateInstances() {
        for (int iTempIndex = 0; iTempIndex < 2; ++iTempIndex) {
            if (instanceArray[iTempIndex] == null) continue;
            instanceArray[iTempIndex].update();
        }
    }
}

