/*
 * Decompiled with CFR 0.152.
 */
package btw.client.texture;

import java.nio.ByteBuffer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ArcaneVesselXPTexture
extends bil {
    ByteBuffer frameBuffer;
    float colorMultiplierRed;
    float colorMultiplierGreen;
    float colorMultiplierBlue;
    int bufferWidth;
    int bufferHeight;
    int bufferPixelSize;

    public ArcaneVesselXPTexture(String sName) {
        super(sName);
    }

    @Override
    public void a(bio par1Texture, List par2List, int par3, int par4, int par5, int par6, boolean par7) {
        super.a(par1Texture, par2List, par3, par4, par5, par6, par7);
        this.colorMultiplierRed = 0.0f;
        this.colorMultiplierGreen = 0.0f;
        this.colorMultiplierBlue = 0.0f;
        this.bufferWidth = ((bio)this.b.get(0)).d();
        this.bufferHeight = ((bio)this.b.get(0)).e();
        this.bufferPixelSize = this.bufferWidth * this.bufferHeight;
        this.frameBuffer = ByteBuffer.allocateDirect(this.bufferPixelSize * 4);
    }

    @Override
    public void l() {
        ++this.f;
        float fRedAngle = (float)(this.f % 360) * (float)Math.PI / 180.0f;
        this.colorMultiplierRed = (kx.a(fRedAngle) * 0.5f + 0.5f) * 0.75f + 0.25f;
        this.copyFrameToBufferWithColorMultiplier(this.frameBuffer, this.bufferPixelSize);
        this.a.uploadByteBufferToGPU(this.d, this.e, this.frameBuffer, this.bufferWidth, this.bufferHeight);
    }

    private void copyFrameToBufferWithColorMultiplier(ByteBuffer m_frameBuffer, int m_iBufferPixelSize) {
        ByteBuffer sourceBuffer = ((bio)this.b.get(0)).h();
        for (int iPixelIndex = 0; iPixelIndex < m_iBufferPixelSize; ++iPixelIndex) {
            int iSourceRed = sourceBuffer.get(iPixelIndex * 4 + 0) & 0xFF;
            int iSourceGreen = sourceBuffer.get(iPixelIndex * 4 + 1) & 0xFF;
            int iSourceBlue = sourceBuffer.get(iPixelIndex * 4 + 2) & 0xFF;
            int iPixelRed = (int)((float)iSourceRed * this.colorMultiplierRed);
            int iPixelGreen = (int)((float)iSourceGreen * this.colorMultiplierGreen);
            int iPixelBlue = (int)((float)iSourceBlue * this.colorMultiplierBlue);
            byte iPixelAlpha = sourceBuffer.get(iPixelIndex * 4 + 3);
            if (iPixelRed > 255 || iPixelGreen > 255 || iPixelBlue > 255 || iPixelRed < 0 || iPixelGreen < 0 || iPixelBlue < 0) {
                boolean bl = true;
            }
            m_frameBuffer.put(iPixelIndex * 4 + 0, (byte)iPixelRed);
            m_frameBuffer.put(iPixelIndex * 4 + 1, (byte)iPixelGreen);
            m_frameBuffer.put(iPixelIndex * 4 + 2, (byte)iPixelBlue);
            m_frameBuffer.put(iPixelIndex * 4 + 3, iPixelAlpha);
        }
    }

    @Override
    public boolean isProcedurallyAnimated() {
        return true;
    }
}

