/*
 * Decompiled with CFR 0.152.
 */
package btw.client.render.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    public static void renderStandardBlockWithTexture(bgf renderBlocks, apa block, int i2, int j2, int k, lx texture) {
        boolean bHasOverride = renderBlocks.b();
        if (!bHasOverride) {
            renderBlocks.a(texture);
        }
        renderBlocks.p(block, i2, j2, k);
        if (!bHasOverride) {
            renderBlocks.a();
        }
    }

    public static void renderBlockWithBoundsAndTextureRotation(bgf renderBlocks, apa block, int i2, int j2, int k, int iFacing, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        RenderUtils.setRenderBoundsToBlockFacing(renderBlocks, iFacing, minX, minY, minZ, maxX, maxY, maxZ);
        RenderUtils.renderBlockWithTextureRotation(renderBlocks, block, i2, j2, k, iFacing);
    }

    public static void setRenderBoundsWithAxisAlignment(bgf renderBlocks, float fMinMinor, float fMinY, float fMinMajor, float fMaxMinor, float fMaxY, float fMaxMajor, boolean bIAligned) {
        if (!bIAligned) {
            renderBlocks.a(fMinMinor, fMinY, (double)fMinMajor, (double)fMaxMinor, (double)fMaxY, (double)fMaxMajor);
        } else {
            renderBlocks.a(fMinMajor, fMinY, (double)fMinMinor, (double)fMaxMajor, (double)fMaxY, (double)fMaxMinor);
        }
    }

    public static void setRenderBoundsToBlockFacing(bgf renderBlocks, int iBlockFacing, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float newMinX = minX;
        float newMinY = minY;
        float newMinZ = minZ;
        float newMaxX = maxX;
        float newMaxY = maxY;
        float newMaxZ = maxZ;
        switch (iBlockFacing) {
            case 0: {
                newMinY = 1.0f - maxY;
                newMaxY = 1.0f - minY;
                break;
            }
            case 2: {
                newMinZ = 1.0f - maxY;
                newMaxZ = 1.0f - minY;
                newMinY = minZ;
                newMaxY = maxZ;
                break;
            }
            case 3: {
                newMinZ = minY;
                newMaxZ = maxY;
                newMinY = 1.0f - maxZ;
                newMaxY = 1.0f - minZ;
                break;
            }
            case 4: {
                newMinX = 1.0f - maxY;
                newMaxX = 1.0f - minY;
                newMinY = minX;
                newMaxY = maxX;
                break;
            }
            case 5: {
                newMinX = minY;
                newMaxX = maxY;
                newMinY = 1.0f - maxX;
                newMaxY = 1.0f - minX;
            }
        }
        renderBlocks.a(newMinX, newMinY, (double)newMinZ, (double)newMaxX, (double)newMaxY, (double)newMaxZ);
    }

    public static void renderBlockWithTextureRotation(bgf renderBlocks, apa block, int i2, int j2, int k, int iBlockFacing) {
        RenderUtils.setTextureRotationBasedOnBlockFacing(renderBlocks, iBlockFacing);
        renderBlocks.p(block, i2, j2, k);
        renderBlocks.clearUVRotation();
    }

    public static void setTextureRotationBasedOnBlockFacing(bgf renderBlocks, int iBlockFacing) {
        switch (iBlockFacing) {
            case 0: {
                renderBlocks.setUVRotateEast(3);
                renderBlocks.setUVRotateWest(3);
                renderBlocks.setUVRotateSouth(3);
                renderBlocks.setUVRotateNorth(3);
                break;
            }
            case 2: {
                renderBlocks.setUVRotateSouth(1);
                renderBlocks.setUVRotateNorth(2);
                renderBlocks.setUVRotateEast(3);
                renderBlocks.setUVRotateWest(3);
                break;
            }
            case 3: {
                renderBlocks.setUVRotateSouth(2);
                renderBlocks.setUVRotateNorth(1);
                renderBlocks.setUVRotateTop(3);
                renderBlocks.setUVRotateBottom(3);
                break;
            }
            case 4: {
                renderBlocks.setUVRotateEast(1);
                renderBlocks.setUVRotateWest(2);
                renderBlocks.setUVRotateTop(2);
                renderBlocks.setUVRotateBottom(1);
                renderBlocks.setUVRotateNorth(2);
                renderBlocks.setUVRotateSouth(1);
                break;
            }
            case 5: {
                renderBlocks.setUVRotateEast(2);
                renderBlocks.setUVRotateWest(1);
                renderBlocks.setUVRotateTop(1);
                renderBlocks.setUVRotateBottom(2);
                renderBlocks.setUVRotateSouth(1);
                renderBlocks.setUVRotateNorth(2);
            }
        }
    }

    public static void renderBlockInteriorWithBoundsAndTextureRotation(bgf renderBlocks, apa block, int i2, int j2, int k, int iFacing, float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        RenderUtils.setRenderBoundsToBlockFacing(renderBlocks, iFacing, minX, minY, minZ, maxX, maxY, maxZ);
        RenderUtils.setTextureRotationBasedOnBlockFacing(renderBlocks, iFacing);
        RenderUtils.renderBlockWithTextureRotation(renderBlocks, block, i2, j2, k, iFacing);
        renderBlocks.clearUVRotation();
    }

    public static void renderMovingBlockWithTexture(bgf renderBlocks, apa block, aab world, int i2, int j2, int k, lx texture) {
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        bgd tessellator = bgd.a;
        tessellator.b();
        tessellator.c(block.e(world, i2, j2, k));
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f2 * f5, f2 * f5, f2 * f5);
        renderBlocks.a(block, -0.5, -0.5, -0.5, texture);
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f1 * f5, f1 * f5, f1 * f5);
        renderBlocks.b(block, -0.5, -0.5, -0.5, texture);
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f22 * f5, f22 * f5, f22 * f5);
        renderBlocks.c(block, -0.5, -0.5, -0.5, texture);
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f22 * f5, f22 * f5, f22 * f5);
        renderBlocks.d(block, -0.5, -0.5, -0.5, texture);
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f3 * f5, f3 * f5, f3 * f5);
        renderBlocks.e(block, -0.5, -0.5, -0.5, texture);
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f3 * f5, f3 * f5, f3 * f5);
        renderBlocks.f(block, -0.5, -0.5, -0.5, texture);
        tessellator.a();
    }

    public static void renderMovingBlock(bgf renderBlocks, apa block, aab world, int i2, int j2, int k) {
        RenderUtils.renderMovingBlockWithMetadata(renderBlocks, block, world, i2, j2, k, 0);
    }

    public static void renderMovingBlockWithMetadata(bgf renderBlocks, apa block, aak blockAccess, int i2, int j2, int k, int iMetadata) {
        float f2 = 0.5f;
        float f1 = 1.0f;
        float f22 = 0.8f;
        float f3 = 0.6f;
        bgd tessellator = bgd.a;
        tessellator.b();
        tessellator.c(block.e(blockAccess, i2, j2, k));
        float f4 = 1.0f;
        float f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f2 * f5, f2 * f5, f2 * f5);
        renderBlocks.a(block, -0.5, -0.5, -0.5, block.a(0, iMetadata));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f1 * f5, f1 * f5, f1 * f5);
        renderBlocks.b(block, -0.5, -0.5, -0.5, block.a(1, iMetadata));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f22 * f5, f22 * f5, f22 * f5);
        renderBlocks.c(block, -0.5, -0.5, -0.5, block.a(2, iMetadata));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f22 * f5, f22 * f5, f22 * f5);
        renderBlocks.d(block, -0.5, -0.5, -0.5, block.a(3, iMetadata));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f3 * f5, f3 * f5, f3 * f5);
        renderBlocks.e(block, -0.5, -0.5, -0.5, block.a(4, iMetadata));
        f5 = 1.0f;
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.a(f3 * f5, f3 * f5, f3 * f5);
        renderBlocks.f(block, -0.5, -0.5, -0.5, block.a(5, iMetadata));
        tessellator.a();
    }

    public static void renderInvBlockWithTexture(bgf renderBlocks, apa block, float fXOffset, float fYOffset, float fZOffset, lx texture) {
        bgd tessellator = bgd.a;
        GL11.glTranslatef((float)fXOffset, (float)fYOffset, (float)fZOffset);
        tessellator.b();
        tessellator.b(0.0f, -1.0f, 0.0f);
        renderBlocks.a(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderBlocks.b(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderBlocks.c(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderBlocks.d(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderBlocks.e(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderBlocks.f(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        GL11.glTranslatef((float)(-fXOffset), (float)(-fYOffset), (float)(-fZOffset));
    }

    public static void renderInvBlockWithMetadata(bgf renderBlocks, apa block, float fXOffset, float fYOffset, float fZOffset, int iMetaData) {
        bgd tessellator = bgd.a;
        GL11.glTranslatef((float)fXOffset, (float)fYOffset, (float)fZOffset);
        tessellator.b();
        tessellator.b(0.0f, -1.0f, 0.0f);
        renderBlocks.a(block, 0.0, 0.0, 0.0, block.a(0, iMetaData));
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 1.0f, 0.0f);
        renderBlocks.b(block, 0.0, 0.0, 0.0, block.a(1, iMetaData));
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, -1.0f);
        renderBlocks.c(block, 0.0, 0.0, 0.0, block.a(2, iMetaData));
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, 1.0f);
        renderBlocks.d(block, 0.0, 0.0, 0.0, block.a(3, iMetaData));
        tessellator.a();
        tessellator.b();
        tessellator.b(-1.0f, 0.0f, 0.0f);
        renderBlocks.e(block, 0.0, 0.0, 0.0, block.a(4, iMetaData));
        tessellator.a();
        tessellator.b();
        tessellator.b(1.0f, 0.0f, 0.0f);
        renderBlocks.f(block, 0.0, 0.0, 0.0, block.a(5, iMetaData));
        tessellator.a();
        GL11.glTranslatef((float)(-fXOffset), (float)(-fYOffset), (float)(-fZOffset));
    }

    public static boolean renderBlockFullBrightWithTexture(bgf renderBlocks, aak blockAccess, int i2, int j2, int k, lx texture) {
        bgd tessellator = bgd.a;
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.a(null, (double)i2, (double)j2, (double)k, texture);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.b(null, (double)i2, (double)j2, (double)k, texture);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.c(null, (double)i2, (double)j2, (double)k, texture);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.d(null, i2, j2, k, texture);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.e(null, i2, j2, k, texture);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(blockAccess.h(i2, j2, k, 15));
        renderBlocks.f(null, i2, j2, k, texture);
        return true;
    }

    public static void renderInvBlockFullBrightWithTexture(bgf renderBlocks, apa block, float fXOffset, float fYOffset, float fZOffset, lx texture) {
        aak blockAccess = renderBlocks.a;
        bgd tessellator = bgd.a;
        GL11.glTranslatef((float)fXOffset, (float)fYOffset, (float)fZOffset);
        tessellator.b();
        tessellator.b(0.0f, -1.0f, 0.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.a(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 1.0f, 0.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.b(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, -1.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.c(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(0.0f, 0.0f, 1.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.d(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(-1.0f, 0.0f, 0.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.e(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        tessellator.b();
        tessellator.b(1.0f, 0.0f, 0.0f);
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.c(240);
        renderBlocks.f(block, 0.0, 0.0, 0.0, texture);
        tessellator.a();
        GL11.glTranslatef((float)(-fXOffset), (float)(-fYOffset), (float)(-fZOffset));
    }

    public static boolean shouldRenderNeighborFullFaceSide(aak blockAccess, int i2, int j2, int k, int iNeighborSide) {
        apa block = apa.r[blockAccess.a(i2, j2, k)];
        if (block != null) {
            return block.shouldRenderNeighborFullFaceSide(blockAccess, i2, j2, k, iNeighborSide);
        }
        return true;
    }

    public static boolean shouldRenderNeighborHalfSlabSide(aak blockAccess, int i2, int j2, int k, int iNeighborSlabSide, boolean bNeighborUpsideDown) {
        apa block = apa.r[blockAccess.a(i2, j2, k)];
        if (block != null) {
            return block.shouldRenderNeighborHalfSlabSide(blockAccess, i2, j2, k, iNeighborSlabSide, bNeighborUpsideDown);
        }
        return true;
    }

    public static void drawSecondaryCraftingOutputIndicator(Minecraft mc2, int iDisplayX, int iDisplayY) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        String sIndicator = "+";
        mc2.q.b(sIndicator, iDisplayX + 1, iDisplayY, 0);
        mc2.q.b(sIndicator, iDisplayX - 1, iDisplayY, 0);
        mc2.q.b(sIndicator, iDisplayX, iDisplayY + 1, 0);
        mc2.q.b(sIndicator, iDisplayX, iDisplayY - 1, 0);
        mc2.q.b(sIndicator, iDisplayX, iDisplayY, 8453920);
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }
}

