/*
 * Decompiled with CFR 0.152.
 */
package btw.client.render.tileentity;

import btw.block.BTWBlocks;
import btw.block.tileentity.WickerBasketTileEntity;
import btw.client.render.tileentity.BasketRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class WickerBasketRenderer
extends BasketRenderer {
    private final float storageItemMaxHeight = 0.25f;

    @Override
    public void a(aqp tileEntity, double xCoord, double yCoord, double zCoord, float fPartialTickCount) {
        super.a(tileEntity, xCoord, yCoord, zCoord, fPartialTickCount);
        WickerBasketTileEntity basket = (WickerBasketTileEntity)tileEntity;
        this.renderStorageStack(basket, xCoord, yCoord, zCoord, fPartialTickCount);
    }

    private void renderStorageStack(WickerBasketTileEntity basket, double xCoord, double yCoord, double zCoord, float fPartialTickCount) {
        wm stack = basket.getStorageStack();
        if (stack != null && basket.lidOpenRatio > 0.01f) {
            int iMetadata = basket.k.h(basket.l, basket.m, basket.n);
            rh entity = (rh)mv.createEntityOfType(rh.class, basket.k, 0.0, 0.0, 0.0, stack);
            entity.c = 0.0f;
            GL11.glPushMatrix();
            float fCurrentItemHeight = 0.25f * this.getCurrentOpenRatio(basket, fPartialTickCount);
            GL11.glTranslatef((float)((float)xCoord + 0.5f), (float)((float)yCoord + fCurrentItemHeight), (float)((float)zCoord + 0.5f));
            if (bgy.a.l.j) {
                float fYaw = this.convertFacingToYaw(BTWBlocks.wickerBasket.getFacing(iMetadata));
                GL11.glRotatef((float)fYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.doesStackRenderAsBlock(stack) && stack.a > 4) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
            }
            bgy.a.a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
    }

    private float convertFacingToYaw(int iFacing) {
        float fYaw = 0.0f;
        if (iFacing == 3) {
            fYaw = 180.0f;
        } else if (iFacing == 4) {
            fYaw = 90.0f;
        } else if (iFacing == 5) {
            fYaw = 270.0f;
        }
        return fYaw;
    }

    private boolean doesStackRenderAsBlock(wm stack) {
        return stack.d() == 0 && apa.r[stack.c] != null && apa.r[stack.c].doesItemRenderAsBlock(stack.k());
    }
}

