/*
 * Decompiled with CFR 0.152.
 */
package btw.block.util;

import btw.util.MathUtils;
import btw.util.PrimitiveQuad;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RayTraceUtils {
    private aab world;
    private int blockX;
    private int blockY;
    private int blockZ;
    private arc startRay;
    private arc endRay;
    List<ara> intersectionPointList = new ArrayList<ara>();

    public RayTraceUtils(aab world, int i2, int j2, int k, arc startRay, arc endRay) {
        this.world = world;
        this.blockX = i2;
        this.blockY = j2;
        this.blockZ = k;
        this.startRay = arc.a(startRay.c, startRay.d, startRay.e);
        this.endRay = arc.a(endRay.c, endRay.d, endRay.e);
    }

    public void addBoxWithLocalCoordsToIntersectionList(aqx box) {
        this.addBoxWithLocalCoordsToIntersectionList(box.a, box.b, box.c, box.d, box.e, box.f);
    }

    public void addBoxWithLocalCoordsToIntersectionList(double fMinX, double fMinY, double fMinZ, double fMaxX, double fMaxY, double fMaxZ) {
        arc startRay = this.startRay.c(-this.blockX, -this.blockY, -this.blockZ);
        arc endRay = this.endRay.c(-this.blockX, -this.blockY, -this.blockZ);
        arc boxMin = arc.a(fMinX, fMinY, fMinZ);
        arc boxMax = arc.a(fMaxX, fMaxY, fMaxZ);
        arc vec3 = startRay.b(endRay, boxMin.c);
        arc vec3_1 = startRay.b(endRay, boxMax.c);
        arc vec3_2 = startRay.c(endRay, boxMin.d);
        arc vec3_3 = startRay.c(endRay, boxMax.d);
        arc vec3_4 = startRay.d(endRay, boxMin.e);
        arc vec3_5 = startRay.d(endRay, boxMax.e);
        if (!this.isVecInsideYZBounds(vec3, boxMin, boxMax)) {
            vec3 = null;
        }
        if (!this.isVecInsideYZBounds(vec3_1, boxMin, boxMax)) {
            vec3_1 = null;
        }
        if (!this.isVecInsideXZBounds(vec3_2, boxMin, boxMax)) {
            vec3_2 = null;
        }
        if (!this.isVecInsideXZBounds(vec3_3, boxMin, boxMax)) {
            vec3_3 = null;
        }
        if (!this.isVecInsideXYBounds(vec3_4, boxMin, boxMax)) {
            vec3_4 = null;
        }
        if (!this.isVecInsideXYBounds(vec3_5, boxMin, boxMax)) {
            vec3_5 = null;
        }
        arc vec3_6 = null;
        if (vec3 != null && (vec3_6 == null || startRay.e(vec3) < startRay.e(vec3_6))) {
            vec3_6 = vec3;
        }
        if (vec3_1 != null && (vec3_6 == null || startRay.e(vec3_1) < startRay.e(vec3_6))) {
            vec3_6 = vec3_1;
        }
        if (vec3_2 != null && (vec3_6 == null || startRay.e(vec3_2) < startRay.e(vec3_6))) {
            vec3_6 = vec3_2;
        }
        if (vec3_3 != null && (vec3_6 == null || startRay.e(vec3_3) < startRay.e(vec3_6))) {
            vec3_6 = vec3_3;
        }
        if (vec3_4 != null && (vec3_6 == null || startRay.e(vec3_4) < startRay.e(vec3_6))) {
            vec3_6 = vec3_4;
        }
        if (vec3_5 != null && (vec3_6 == null || startRay.e(vec3_5) < startRay.e(vec3_6))) {
            vec3_6 = vec3_5;
        }
        if (vec3_6 != null) {
            int byte0 = -1;
            if (vec3_6 == vec3) {
                byte0 = 4;
            }
            if (vec3_6 == vec3_1) {
                byte0 = 5;
            }
            if (vec3_6 == vec3_2) {
                byte0 = 0;
            }
            if (vec3_6 == vec3_3) {
                byte0 = 1;
            }
            if (vec3_6 == vec3_4) {
                byte0 = 2;
            }
            if (vec3_6 == vec3_5) {
                byte0 = 3;
            }
            this.intersectionPointList.add(new ara(this.blockX, this.blockY, this.blockZ, byte0, vec3_6.c(this.blockX, this.blockY, this.blockZ)));
        }
    }

    public void addQuadWithLocalCoordsToIntersectionList(PrimitiveQuad quad, arc pointOnQuad) {
        double dLineScalar;
        arc intersection;
        arc p0Minusl0;
        double dNumeratorDot;
        arc lineDir = this.endRay.subtractFrom(this.startRay);
        arc pointOnLine = this.startRay.c(-this.blockX, -this.blockY, -this.blockZ);
        arc planeNormal = quad.computeNormal();
        double lDotn = planeNormal.b(lineDir);
        if (lDotn != 0.0 && (dNumeratorDot = planeNormal.b(p0Minusl0 = pointOnLine.subtractFrom(pointOnQuad))) != 0.0 && quad.isPointOnPlaneWithinBounds(intersection = arc.a((dLineScalar = dNumeratorDot / lDotn) * lineDir.c, dLineScalar * lineDir.d, dLineScalar * lineDir.e).addVector(pointOnLine))) {
            int iFacingClicked = this.convertVectorToApproximateBlockFacing(planeNormal);
            if (lDotn < 0.0) {
                iFacingClicked = apa.getOppositeFacing(iFacingClicked);
            }
            this.intersectionPointList.add(new ara(this.blockX, this.blockY, this.blockZ, iFacingClicked, intersection.c(this.blockX, this.blockY, this.blockZ)));
        }
    }

    public int convertVectorToApproximateBlockFacing(arc vec) {
        double dAbsX = MathUtils.absDouble(vec.c);
        double dAbsY = MathUtils.absDouble(vec.d);
        double dAbsZ = MathUtils.absDouble(vec.e);
        if (dAbsX >= dAbsZ && dAbsX >= dAbsY) {
            if (vec.c < 0.0) {
                return 4;
            }
            return 5;
        }
        if (dAbsZ >= dAbsY) {
            if (vec.e < 0.0) {
                return 2;
            }
            return 3;
        }
        if (vec.d < 0.0) {
            return 0;
        }
        return 1;
    }

    public ara getFirstIntersection() {
        ara firstIntersect = null;
        Iterator<ara> iterator = this.intersectionPointList.iterator();
        double dMaxDistance = 0.0;
        while (iterator.hasNext()) {
            ara tempPos = iterator.next();
            double dCurrentIntersectDistance = tempPos.f.e(this.endRay);
            if (!(dCurrentIntersectDistance > dMaxDistance)) continue;
            firstIntersect = tempPos;
            dMaxDistance = dCurrentIntersectDistance;
        }
        return firstIntersect;
    }

    private boolean isVecInsideYZBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.d >= min.d && par1Vec3.d <= max.d && par1Vec3.e >= min.e && par1Vec3.e <= max.e;
    }

    private boolean isVecInsideXZBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.c >= min.c && par1Vec3.c <= max.c && par1Vec3.e >= min.e && par1Vec3.e <= max.e;
    }

    private boolean isVecInsideXYBounds(arc par1Vec3, arc min, arc max) {
        if (par1Vec3 == null) {
            return false;
        }
        return par1Vec3.c >= min.c && par1Vec3.c <= max.c && par1Vec3.d >= min.d && par1Vec3.d <= max.d;
    }
}

