/*
 * Decompiled with CFR 0.152.
 */
package btw.block.util;

import btw.block.BTWBlocks;
import btw.block.MechanicalBlock;
import btw.block.blocks.AxleBlock;
import btw.block.blocks.GearBoxBlock;
import btw.world.util.BlockPos;

public class MechPowerUtils {
    public static boolean isBlockPoweredByAxleToSide(aab world, int i2, int j2, int k, int iSide) {
        AxleBlock axleBlock;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iSide);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        return MechPowerUtils.isBlockIDAxle(iTargetBlockID) && (axleBlock = (AxleBlock)apa.r[iTargetBlockID]).isAxleOrientedTowardsFacing(world, targetPos.x, targetPos.y, targetPos.z, iSide) && axleBlock.getPowerLevel(world, targetPos.x, targetPos.y, targetPos.z) > 0;
    }

    public static boolean isBlockIDAxle(int iBlockID) {
        return iBlockID == BTWBlocks.axle.cz || iBlockID == BTWBlocks.axlePowerSource.cz;
    }

    public static boolean doesBlockHaveFacingAxleToSide(aak blockAccess, int i2, int j2, int k, int iSide) {
        AxleBlock axleBlock;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iSide);
        int iTargetBlockID = blockAccess.a(targetPos.x, targetPos.y, targetPos.z);
        return MechPowerUtils.isBlockIDAxle(iTargetBlockID) && (axleBlock = (AxleBlock)apa.r[iTargetBlockID]).isAxleOrientedTowardsFacing(blockAccess, targetPos.x, targetPos.y, targetPos.z, iSide);
    }

    public static boolean doesBlockHaveAnyFacingAxles(aak blockAccess, int i2, int j2, int k) {
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            if (!MechPowerUtils.doesBlockHaveFacingAxleToSide(blockAccess, i2, j2, k, iFacing)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockPoweredByHandCrank(aab world, int i2, int j2, int k) {
        for (int iFacing = 1; iFacing <= 5; ++iFacing) {
            if (!MechPowerUtils.isBlockPoweredByHandCrankToSide(world, i2, j2, k, iFacing)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlockPoweredByHandCrankToSide(aab world, int i2, int j2, int k, int iSide) {
        apa targetBlock;
        MechanicalBlock device;
        BlockPos targetPos = new BlockPos(i2, j2, k);
        targetPos.addFacingAsOffset(iSide);
        int iTargetBlockID = world.a(targetPos.x, targetPos.y, targetPos.z);
        return iTargetBlockID == BTWBlocks.handCrank.cz && (device = (MechanicalBlock)((Object)(targetBlock = apa.r[iTargetBlockID]))).isOutputtingMechanicalPower(world, targetPos.x, targetPos.y, targetPos.z);
    }

    public static boolean isBlockPoweredByAxle(aab world, int i2, int j2, int k, MechanicalBlock block) {
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            if (!block.canInputAxlePowerToFacing(world, i2, j2, k, iFacing) || !MechPowerUtils.isBlockPoweredByAxleToSide(world, i2, j2, k, iFacing)) continue;
            return true;
        }
        return false;
    }

    public static void destroyHorizontallyAttachedAxles(aab world, int i2, int j2, int k) {
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            AxleBlock axleBlock;
            BlockPos tempPos = new BlockPos(i2, j2, k);
            tempPos.addFacingAsOffset(iFacing);
            int iTempBlockID = world.a(tempPos.x, tempPos.y, tempPos.z);
            if (!MechPowerUtils.isBlockIDAxle(iTempBlockID) || !(axleBlock = (AxleBlock)apa.r[iTempBlockID]).isAxleOrientedTowardsFacing(world, tempPos.x, tempPos.y, tempPos.z, iFacing)) continue;
            axleBlock.breakAxle(world, tempPos.x, tempPos.y, tempPos.z);
        }
    }

    public static boolean isPoweredGearBox(aak blockAccess, int i2, int j2, int k) {
        int iTempBlockID = blockAccess.a(i2, j2, k);
        if (iTempBlockID == BTWBlocks.redstoneClutch.cz || iTempBlockID == BTWBlocks.gearBox.cz) {
            GearBoxBlock gearBlock = (GearBoxBlock)apa.r[iTempBlockID];
            return gearBlock.isGearBoxOn(blockAccess, i2, j2, k);
        }
        return false;
    }
}

