/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.BTWBlocks;
import btw.block.tileentity.beacon.BeaconEffect;
import btw.block.tileentity.beacon.BeaconTileEntity;

public class SpawnAnchorBeaconEffect
extends BeaconEffect {
    private static final int SOULFORGED_BEACON_BLIGHT_SPREAD_FREQUENCY = 10000;
    public static final int[] soulforgedBeaconBlightSpreadRange = new int[]{0, 8, 16, 32, 64};

    @Override
    public void onUpdate(BeaconTileEntity beacon) {
        if (!beacon.k.I) {
            this.checkForBlightSpread(beacon);
            this.checkPlayerSpawnedAtBeacon(beacon);
        } else {
            this.playSoundEffect(beacon);
        }
    }

    public void checkPlayerSpawnedAtBeacon(BeaconTileEntity beacon) {
        if (beacon.playerRespawnedAtBeacon) {
            beacon.playerRespawnedAtBeacon = false;
            beacon.k.e(2225, beacon.l, beacon.m, beacon.n, 1);
            beacon.k.a((double)beacon.l + 0.5, (double)beacon.m + 0.5, (double)beacon.n + 0.5, "mob.wither.spawn", 1.0f + beacon.k.s.nextFloat() * 0.1f, 1.0f + beacon.k.s.nextFloat() * 0.1f);
        }
    }

    @Override
    public void onPowerOn(BeaconTileEntity beacon) {
        super.onPowerOn(beacon);
        if (beacon.k.I) {
            beacon.k.playSound((double)beacon.l + 0.5, (double)beacon.m + 0.5, (double)beacon.n + 0.5, "mob.ghast.scream", 1.0f, beacon.k.s.nextFloat() * 0.4f + 0.25f);
        }
    }

    public void playSoundEffect(BeaconTileEntity beacon) {
        int level = beacon.l();
        if (beacon.k.s.nextInt(60) <= level) {
            int iLevelOfSound = beacon.k.s.nextInt(level) + 1;
            int offsetX = beacon.k.s.nextInt(level * 2 + 1) - level;
            int offsetZ = beacon.k.s.nextInt(level * 2 + 1) - level;
            beacon.k.playSound(beacon.l + offsetX, beacon.m - level, beacon.n + offsetZ, "mob.ghast.moan", 0.5f, beacon.k.s.nextFloat() * 0.4f + 0.25f);
        }
    }

    private void checkForBlightSpread(BeaconTileEntity beacon) {
        int z2;
        int y2;
        int level;
        int range;
        int x2;
        int blockID;
        if (beacon.k.s.nextInt(10000) == 0 && (blockID = beacon.k.a(x2 = beacon.l + beacon.k.s.nextInt((range = soulforgedBeaconBlightSpreadRange[level = beacon.l()]) * 2 + 1) - range, y2 = beacon.k.s.nextInt(256), z2 = beacon.n + beacon.k.s.nextInt(range * 2 + 1) - range)) == apa.y.cz) {
            beacon.k.setBlockAndMetadataWithNotify(x2, y2, z2, BTWBlocks.aestheticEarth.cz, 0);
        }
    }

    @Override
    protected int getMagneticFieldLevel(int powerlevel) {
        return powerlevel * 2;
    }
}

