/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.MagneticPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MagneticPointList {
    public List magneticPoints = new ArrayList();

    public void loadFromNBT(ca tagList) {
        this.magneticPoints.clear();
        for (int iTempCount = 0; iTempCount < tagList.c(); ++iTempCount) {
            bs tempCompound = (bs)tagList.b(iTempCount);
            MagneticPoint newPoint = new MagneticPoint(tempCompound);
            this.magneticPoints.add(newPoint);
        }
    }

    public ca saveToNBT() {
        ca tagList = new ca("MagneticPoints");
        Iterator tempIterator = this.magneticPoints.iterator();
        while (tempIterator.hasNext()) {
            bs tempTagCompound = new bs();
            MagneticPoint tempPoint = (MagneticPoint)tempIterator.next();
            tempPoint.writeToNBT(tempTagCompound);
            tagList.a((cf)tempTagCompound);
        }
        return tagList;
    }

    public void removePointAt(int iIPos, int iJPos, int iKPos) {
        Iterator tempIterator = this.magneticPoints.iterator();
        while (tempIterator.hasNext()) {
            MagneticPoint tempPoint = (MagneticPoint)tempIterator.next();
            if (tempPoint.posX != iIPos || tempPoint.posZ != iKPos || tempPoint.posY != iJPos) continue;
            tempIterator.remove();
            return;
        }
    }

    public void addPoint(int iIPos, int iJPos, int iKPos, int iPowerLevel) {
        MagneticPoint newPoint = new MagneticPoint(iIPos, iJPos, iKPos, iPowerLevel);
        this.magneticPoints.add(newPoint);
    }

    public void changePowerLevelOfPointAt(int iIPos, int iJPos, int iKPos, int iPowerLevel) {
        MagneticPoint point = this.getMagneticPointAtLocation(iIPos, iJPos, iKPos);
        if (point != null) {
            point.fieldLevel = iPowerLevel;
        }
    }

    public MagneticPoint getMagneticPointAtLocation(int iIPos, int iJPos, int iKPos) {
        for (MagneticPoint tempPoint : this.magneticPoints) {
            if (tempPoint.posX != iIPos || tempPoint.posZ != iKPos || tempPoint.posY != iJPos) continue;
            return tempPoint;
        }
        return null;
    }
}

