/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

public class MagneticPoint {
    private static double[] fieldStrengthMultipliersByLevel = new double[]{0.0, 1.0, 8.0, 27.0, 64.0, 125.0, 216.0, 343.0, 4096.0};
    private static double[] maxRangeSquaredForLevelWithNoise = new double[]{0.0, 100.0, 400.0, 1600.0, 6400.0, 25600.0, 102400.0, 409600.0, Double.POSITIVE_INFINITY};
    public int posX;
    public int posY;
    public int posZ;
    public int fieldLevel;

    public MagneticPoint() {
        this.posX = 0;
        this.posY = 0;
        this.posZ = 0;
        this.fieldLevel = 0;
    }

    public MagneticPoint(int iIPos, int iJPos, int iKPos, int iFieldLevel) {
        this.posX = iIPos;
        this.posY = iJPos;
        this.posZ = iKPos;
        this.fieldLevel = iFieldLevel;
    }

    public MagneticPoint(bs tagCompound) {
        this.loadFromNBT(tagCompound);
    }

    public void loadFromNBT(bs tagCompound) {
        this.posX = tagCompound.e("IPos");
        this.posY = tagCompound.d("JPos");
        this.posZ = tagCompound.e("KPos");
        this.fieldLevel = tagCompound.c("Lvl");
    }

    public bs writeToNBT(bs tagCompound) {
        tagCompound.a("IPos", this.posX);
        tagCompound.a("JPos", (short)this.posY);
        tagCompound.a("KPos", this.posZ);
        tagCompound.a("Lvl", (byte)this.fieldLevel);
        return tagCompound;
    }

    public double getFieldStrengthRelativeToPosition(double dRelativeX, double dRelativeZ) {
        double dDeltaX = (double)this.posX - dRelativeX;
        double dDeltaZ = (double)this.posZ - dRelativeZ;
        double dDistanceSq = dDeltaX * dDeltaX + dDeltaZ * dDeltaZ;
        return fieldStrengthMultipliersByLevel[this.fieldLevel] / dDistanceSq;
    }

    public double getFieldStrengthRelativeToPositionWithBackgroundNoise(double dRelativeX, double dRelativeZ) {
        double dDeltaX = (double)this.posX - dRelativeX;
        double dDeltaZ = (double)this.posZ - dRelativeZ;
        double dDistanceSq = dDeltaX * dDeltaX + dDeltaZ * dDeltaZ;
        if (dDistanceSq <= maxRangeSquaredForLevelWithNoise[this.fieldLevel]) {
            return fieldStrengthMultipliersByLevel[this.fieldLevel] / dDistanceSq;
        }
        return -1.0;
    }
}

