/*
 * Decompiled with CFR 0.152.
 */
package btw.block.tileentity.beacon;

import btw.block.tileentity.beacon.BeaconEffect;
import btw.block.tileentity.beacon.BeaconTileEntity;
import btw.entity.mob.EndermanEntity;

public class EnderAntennaBeaconEffect
extends BeaconEffect {
    public static final int[] enderAntennaBeaconSpawnRange = new int[]{0, 8, 16, 32, 64};
    private static final int ENDERMAN_SPAWN_FREQUENCY = 1200;
    public static final int[] endermanSpawnChancePerLevel = new int[]{0, 1, 8, 27, 64};
    private static final int SILVERFISH_SPAWN_FREQUENCY = 1200;
    public static final int[] silverfishSpawnChancePerLevel = new int[]{0, 1, 8, 27, 64};

    @Override
    public void onUpdate(BeaconTileEntity beacon) {
        if (!beacon.k.I) {
            if (beacon.k.t.h != 1) {
                this.checkForEndermanSpawn(beacon);
            } else {
                this.checkForSilverfishSpawn(beacon);
            }
        }
    }

    private void checkForEndermanSpawn(BeaconTileEntity beacon) {
        nn creatureType = nn.a;
        int mobCount = beacon.k.countEntitiesThatApplyToSpawnCap(creatureType.a());
        int maxMobCount = creatureType.b();
        if (mobCount < (maxMobCount += maxMobCount >> 2)) {
            int beaconLevel = beacon.l();
            if (beacon.k.s.nextInt(1200) < endermanSpawnChancePerLevel[beaconLevel]) {
                int z2;
                int range = enderAntennaBeaconSpawnRange[beaconLevel];
                int x2 = beacon.l + beacon.k.s.nextInt(range * 2 + 1) - range;
                abw chunk = beacon.k.d(x2, z2 = beacon.n + beacon.k.s.nextInt(range * 2 + 1) - range);
                int y2 = chunk == null ? beacon.k.s.nextInt(beacon.k.R()) : beacon.k.s.nextInt(chunk.h() + 16 - 1);
                aif targetMaterial = beacon.k.g(x2, y2, z2);
                apa blockBelow = apa.r[beacon.k.a(x2, y2 - 1, z2)];
                if (!targetMaterial.a() && !targetMaterial.d() && blockBelow != null && blockBelow.canMobsSpawnOn(beacon.k, x2, y2 - 1, z2)) {
                    EndermanEntity enderman = (EndermanEntity)mv.createEntityOfType(EndermanEntity.class, beacon.k);
                    enderman.preInitCreature();
                    double spawnOffset = blockBelow.mobSpawnOnVerticalOffset(beacon.k, x2, y2 - 1, z2);
                    enderman.b((double)x2 + 0.5, (double)y2 + spawnOffset, (double)z2 + 0.5, beacon.k.s.nextFloat() * 360.0f, 0.0f);
                    if (beacon.k.b(enderman.E) && beacon.k.a((mp)enderman, enderman.E).isEmpty() && !beacon.k.d(enderman.E)) {
                        beacon.k.d(enderman);
                        enderman.bJ();
                        beacon.k.e(2247, x2, y2, z2, 0);
                    }
                }
            }
        }
    }

    private void checkForSilverfishSpawn(BeaconTileEntity beacon) {
        nn creatureType = nn.a;
        int mobCount = beacon.k.countEntitiesThatApplyToSpawnCap(creatureType.a());
        int maxMobCount = creatureType.b();
        if (mobCount < (maxMobCount += maxMobCount >> 2)) {
            int beaconLevel = beacon.l();
            if (beacon.k.s.nextInt(1200) < silverfishSpawnChancePerLevel[beaconLevel]) {
                int z2;
                int range = enderAntennaBeaconSpawnRange[beaconLevel];
                int x2 = beacon.l + beacon.k.s.nextInt(range * 2 + 1) - range;
                abw chunk = beacon.k.d(x2, z2 = beacon.n + beacon.k.s.nextInt(range * 2 + 1) - range);
                int y2 = chunk == null ? beacon.k.s.nextInt(beacon.k.R()) : beacon.k.s.nextInt(chunk.h() + 16 - 1);
                aif targetMaterial = beacon.k.g(x2, y2, z2);
                apa blockBelow = apa.r[beacon.k.a(x2, y2 - 1, z2)];
                if (!targetMaterial.a() && !targetMaterial.d() && blockBelow != null && blockBelow.canMobsSpawnOn(beacon.k, x2, y2 - 1, z2)) {
                    se silverfish = (se)mv.createEntityOfType(se.class, beacon.k);
                    silverfish.preInitCreature();
                    double spawnOffset = blockBelow.mobSpawnOnVerticalOffset(beacon.k, x2, y2 - 1, z2);
                    silverfish.b((double)x2 + 0.5, (double)y2 + spawnOffset, (double)z2 + 0.5, beacon.k.s.nextFloat() * 360.0f, 0.0f);
                    if (beacon.k.b(silverfish.E) && beacon.k.a((mp)silverfish, silverfish.E).isEmpty() && !beacon.k.d(silverfish.E)) {
                        beacon.k.d(silverfish);
                        silverfish.bJ();
                        beacon.k.e(2247, x2, y2, z2, 0);
                    }
                }
            }
        }
    }
}

